//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the result of the background uniformity check.
class BackgroundUniformity {
  final Pointer<id3FaceBackgroundUniformity> _handle;

  static final Finalizer<Pointer<id3FaceBackgroundUniformity>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FaceBackgroundUniformity> get handle => _handle;

  id3FaceBackgroundUniformity get struct => _handle.ref;

  /// Initializes a new instance of the BackgroundUniformity class from its members.
  BackgroundUniformity(this._handle);

  /// Create a new instance of the BackgroundUniformity.
  BackgroundUniformity.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the BackgroundUniformity from the native struct
  BackgroundUniformity.createFromStruct(id3FaceBackgroundUniformity value) : _handle = calloc() {
    _handle.ref.ColorUniformity = value.ColorUniformity;
    _handle.ref.StructureUniformity = value.StructureUniformity;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Color uniformity score, in the range [0:100].
  /// Hint: Recommended threshold is 80.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get colorUniformity => _handle.ref.ColorUniformity;
  set colorUniformity(int value) => _handle.ref.ColorUniformity = value;

  /// 
  /// Structure uniformity score, in the range [0:100].
  /// Hint: Recommended threshold is 80.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get structureUniformity => _handle.ref.StructureUniformity;
  set structureUniformity(int value) => _handle.ref.StructureUniformity = value;


  Map<String, dynamic> toMap() {
    return {
        'colorUniformity': colorUniformity,
        'structureUniformity': structureUniformity,
    };
  }
}
