//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the result of the color-based PAD method.
class ColorBasedPadResult {
  final Pointer<id3FaceColorBasedPadResult> _handle;

  static final Finalizer<Pointer<id3FaceColorBasedPadResult>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FaceColorBasedPadResult> get handle => _handle;

  id3FaceColorBasedPadResult get struct => _handle.ref;

  /// Initializes a new instance of the ColorBasedPadResult class from its members.
  ColorBasedPadResult(this._handle);

  /// Create a new instance of the ColorBasedPadResult.
  ColorBasedPadResult.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the ColorBasedPadResult from the native struct
  ColorBasedPadResult.createFromStruct(id3FaceColorBasedPadResult value) : _handle = calloc() {
    _handle.ref.Score = value.Score;
    _handle.ref.Confidence = value.Confidence;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Color-based PAD score, in the range [0:100].
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get score => _handle.ref.Score;
  set score(int value) => _handle.ref.Score = value;

  /// 
  /// Confidence score of the color-based PAD algorithm, in the range [0:100].
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get confidence => _handle.ref.Confidence;
  set confidence(int value) => _handle.ref.Confidence = value;


  Map<String, dynamic> toMap() {
    return {
        'score': score,
        'confidence': confidence,
    };
  }
}
