//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the result of the attack support detection.
class DetectedFaceAttackSupport {
  final Pointer<id3DetectedFaceAttackSupport> _handle;

  static final Finalizer<Pointer<id3DetectedFaceAttackSupport>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3DetectedFaceAttackSupport> get handle => _handle;

  id3DetectedFaceAttackSupport get struct => _handle.ref;

  /// Initializes a new instance of the DetectedFaceAttackSupport class from its members.
  DetectedFaceAttackSupport(this._handle);

  /// Create a new instance of the DetectedFaceAttackSupport.
  DetectedFaceAttackSupport.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the DetectedFaceAttackSupport from the native struct
  DetectedFaceAttackSupport.createFromStruct(id3DetectedFaceAttackSupport value) : _handle = calloc() {
    _handle.ref.AttackSupport = value.AttackSupport;
    _handle.ref.Score = value.Score;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Attack support type.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get attackSupport => _handle.ref.AttackSupport;
  set attackSupport(int value) => _handle.ref.AttackSupport = value;

  /// 
  /// Confidence score of the detected attack support, in the range [0:100].
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get score => _handle.ref.Score;
  set score(int value) => _handle.ref.Score = value;


  Map<String, dynamic> toMap() {
    return {
        'attackSupport': attackSupport,
        'score': score,
    };
  }
}
