//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the eye gaze.
class EyeGaze {
  final Pointer<id3FaceEyeGaze> _handle;

  static final Finalizer<Pointer<id3FaceEyeGaze>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FaceEyeGaze> get handle => _handle;

  id3FaceEyeGaze get struct => _handle.ref;

  /// Initializes a new instance of the EyeGaze class from its members.
  EyeGaze(this._handle);

  /// Create a new instance of the EyeGaze.
  EyeGaze.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the EyeGaze from the native struct
  EyeGaze.createFromStruct(id3FaceEyeGaze value) : _handle = calloc() {
    _handle.ref.LeftEyeXGaze = value.LeftEyeXGaze;
    _handle.ref.LeftEyeYGaze = value.LeftEyeYGaze;
    _handle.ref.RightEyeXGaze = value.RightEyeXGaze;
    _handle.ref.RightEyeYGaze = value.RightEyeYGaze;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Value indicating the gaze alongside the x-axis of the left eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  double get leftEyeXGaze => _handle.ref.LeftEyeXGaze;
  set leftEyeXGaze(double value) => _handle.ref.LeftEyeXGaze = value;

  /// 
  /// Value indicating the gaze alongside the y-axis of the left eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  double get leftEyeYGaze => _handle.ref.LeftEyeYGaze;
  set leftEyeYGaze(double value) => _handle.ref.LeftEyeYGaze = value;

  /// 
  /// Value indicating the gaze alongside the x-axis of the right eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  double get rightEyeXGaze => _handle.ref.RightEyeXGaze;
  set rightEyeXGaze(double value) => _handle.ref.RightEyeXGaze = value;

  /// 
  /// Value indicating the gaze alongside the y-axis of the right eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  double get rightEyeYGaze => _handle.ref.RightEyeYGaze;
  set rightEyeYGaze(double value) => _handle.ref.RightEyeYGaze = value;


  Map<String, dynamic> toMap() {
    return {
        'leftEyeXGaze': leftEyeXGaze,
        'leftEyeYGaze': leftEyeYGaze,
        'rightEyeXGaze': rightEyeXGaze,
        'rightEyeYGaze': rightEyeYGaze,
    };
  }
}
