//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the face attributes.
class FaceAttributes {
  final Pointer<id3FaceAttributes> _handle;

  static final Finalizer<Pointer<id3FaceAttributes>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FaceAttributes> get handle => _handle;

  id3FaceAttributes get struct => _handle.ref;

  /// Initializes a new instance of the FaceAttributes class from its members.
  FaceAttributes(this._handle);

  /// Create a new instance of the FaceAttributes.
  FaceAttributes.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the FaceAttributes from the native struct
  FaceAttributes.createFromStruct(id3FaceAttributes value) : _handle = calloc() {
    _handle.ref.Glasses = value.Glasses;
    _handle.ref.Hat = value.Hat;
    _handle.ref.MakeUp = value.MakeUp;
    _handle.ref.Male = value.Male;
    _handle.ref.MouthOpen = value.MouthOpen;
    _handle.ref.Smile = value.Smile;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Value, from 0 to 100, indicating whether the subject is wearing glasses or not.
  /// Hint: The recommended threshold is 10.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get glasses => _handle.ref.Glasses;
  set glasses(int value) => _handle.ref.Glasses = value;

  /// 
  /// Value, from 0 to 100, indicating whether the subject is wearing a hat or not.
  /// Hint: The recommended value is less than 10.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get hat => _handle.ref.Hat;
  set hat(int value) => _handle.ref.Hat = value;

  /// 
  /// Value, from 0 to 100, indicating whether the subject is wearing makeup or not.
  /// Hint: The recommended value is less than 50.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get makeUp => _handle.ref.MakeUp;
  set makeUp(int value) => _handle.ref.MakeUp = value;

  /// 
  /// Value, from 0 to 100, indicating the estimated gender of the subject.
  /// A value near 0 suggests that the subject is estimated to be female.
  /// A value near 100 suggests that the subject is estimated to be male.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get male => _handle.ref.Male;
  set male(int value) => _handle.ref.Male = value;

  /// 
  /// Value, from 0 to 100, indicating whether the subject's mouth is open or not.
  /// Hint: The recommended value is less than 35.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get mouthOpen => _handle.ref.MouthOpen;
  set mouthOpen(int value) => _handle.ref.MouthOpen = value;

  /// 
  /// Value, from 0 to 100, indicating whether the subject is smiling or not.
  /// Hint: The recommended value is less than 75.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get smile => _handle.ref.Smile;
  set smile(int value) => _handle.ref.Smile = value;


  Map<String, dynamic> toMap() {
    return {
        'glasses': glasses,
        'hat': hat,
        'makeUp': makeUp,
        'male': male,
        'mouthOpen': mouthOpen,
        'smile': smile,
    };
  }
}
