//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';
import 'face_native.dart';

import '../id3_face.dart';

final _finalizer = NativeFinalizer(faceSDK.addresses.id3FaceCandidateList_Dispose.cast());

/// Represents a candidate list in a one-to-many search.
class FaceCandidateList extends Object with IterableMixin<FaceCandidate> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3FaceCandidateList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3FaceCandidateList> get handle => _pHandle.value;

  /// Creates a new instance of the FaceCandidateList class.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  FaceCandidateList() {
    _pHandle = calloc();
    try {
      var err = faceSDK.id3FaceCandidateList_Initialize(_pHandle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the FaceCandidateList class.
  ///
  /// param handle     Handle to the FaceCandidateList.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceCandidateList.fromHandle(Pointer<id3FaceCandidateList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this FaceCandidateList.
  void dispose() {
    if (_disposable) {
      faceSDK.id3FaceCandidateList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the FaceCandidateList object.
  ///
  /// return The newly created FaceCandidateList object.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceCandidateList clone() {
    FaceCandidateList clone = FaceCandidateList();
    var err = faceSDK.id3FaceCandidateList_CopyTo(_pHandle.value, clone.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);
  operator []=(int key, FaceCandidate item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<FaceCandidate> get iterator => FaceCandidateListIterator(this);

  // Public methods
  /// Clears the FaceCandidateList object.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  void clear() {
    var err = faceSDK.id3FaceCandidateList_Clear(_pHandle.value);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Adds an item to the FaceCandidateList object.
  ///
  /// param faceCandidateItem FaceCandidate item to add.
  /// throws FaceException An error has occurred during Face Library execution.
  void add(FaceCandidate faceCandidateItem) {
    var err = faceSDK.id3FaceCandidateList_Add(_pHandle.value, faceCandidateItem.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets an item of the FaceCandidateList object.
  ///
  /// param index Index of the FaceCandidate item to get.
  /// return FaceCandidate item to get.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceCandidate get(int index) {
    FaceCandidate faceCandidateItem = FaceCandidate();
    var err = faceSDK.id3FaceCandidateList_Get(_pHandle.value, index, faceCandidateItem.handle);
    if (err != FaceError.success.value) {
      faceCandidateItem.dispose();
      throw FaceException(err);
    }
    return faceCandidateItem;
  }

  /// Sets an item of the FaceCandidateList object.
  ///
  /// param index Index of the FaceCandidate item to set.
  /// param faceCandidateItem FaceCandidate item to set.
  /// throws FaceException An error has occurred during Face Library execution.
  void set(int index, FaceCandidate faceCandidateItem) {
    var err = faceSDK.id3FaceCandidateList_Set(_pHandle.value, index, faceCandidateItem.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the number of elements in the FaceCandidateList object.
  ///
  /// return Number of elements in the FaceCandidate object.
  /// throws FaceException An error has occurred during Face Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = faceSDK.id3FaceCandidateList_GetCount(_pHandle.value, pCount);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Removes an element of the FaceCandidateList object.
  ///
  /// param index Index of the FaceCandidate item to remove.
  /// throws FaceException An error has occurred during Face Library execution.
  void removeAt(int index) {
    var err = faceSDK.id3FaceCandidateList_RemoveAt(_pHandle.value, index);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// FaceCandidateList object.
  ///
  /// param newSize FaceCandidate object.
  /// throws FaceException An error has occurred during Face Library execution.
  void resize(int newSize) {
    var err = faceSDK.id3FaceCandidateList_Resize(_pHandle.value, newSize);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

}

class FaceCandidateListIterator implements Iterator<FaceCandidate> {
  FaceCandidateListIterator(this._list) : _count = _list.getCount();
  final FaceCandidateList _list;
  final int _count;
  int _index = -1;

  @override
  FaceCandidate get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
