import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_native.dart';

class FaceException implements Exception {
  final int _errorCode;
	
  FaceException(this._errorCode);

  int get errorCode => _errorCode;

  String get message {
    final Pointer<Utf8> messagePtr = faceSDK.id3Face_GetFaceErrorMessage(_errorCode) as Pointer<Utf8>;
    if (messagePtr.address == 0) {
      return "Undefined error";
    }
    return messagePtr.toDartString();
  }
}
