//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the result of face occlusion detection.
class FaceOcclusionScores {
  final Pointer<id3FaceOcclusionScores> _handle;

  static final Finalizer<Pointer<id3FaceOcclusionScores>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FaceOcclusionScores> get handle => _handle;

  id3FaceOcclusionScores get struct => _handle.ref;

  /// Initializes a new instance of the FaceOcclusionScores class from its members.
  FaceOcclusionScores(this._handle);

  /// Create a new instance of the FaceOcclusionScores.
  FaceOcclusionScores.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the FaceOcclusionScores from the native struct
  FaceOcclusionScores.createFromStruct(id3FaceOcclusionScores value) : _handle = calloc() {
    _handle.ref.LeftEyeOcclusionScore = value.LeftEyeOcclusionScore;
    _handle.ref.MouthOcclusionScore = value.MouthOcclusionScore;
    _handle.ref.NoseOcclusionScore = value.NoseOcclusionScore;
    _handle.ref.RightEyeOcclusionScore = value.RightEyeOcclusionScore;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Value, from 0 to 100, indicating whether the left eye is occluded or not.
  /// 100 means that the left eye is definitely occluded.
  /// Hint: The recommended threshold is 50.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get leftEyeOcclusionScore => _handle.ref.LeftEyeOcclusionScore;
  set leftEyeOcclusionScore(int value) => _handle.ref.LeftEyeOcclusionScore = value;

  /// 
  /// Value, from 0 to 100, indicating whether the mouth is occluded or not.
  /// 100 means that the mouth is definitely occluded.
  /// Hint: The recommended threshold is 30.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get mouthOcclusionScore => _handle.ref.MouthOcclusionScore;
  set mouthOcclusionScore(int value) => _handle.ref.MouthOcclusionScore = value;

  /// 
  /// Value, from 0 to 100, indicating whether the nose is occluded or not.
  /// 100 means that the nose is definitely occluded.
  /// Hint: The recommended threshold is 50.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noseOcclusionScore => _handle.ref.NoseOcclusionScore;
  set noseOcclusionScore(int value) => _handle.ref.NoseOcclusionScore = value;

  /// 
  /// Value, from 0 to 100, indicating whether the right eye is occluded or not.
  /// 100 means that the right eye is definitely occluded.
  /// Hint: The recommended threshold is 50.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get rightEyeOcclusionScore => _handle.ref.RightEyeOcclusionScore;
  set rightEyeOcclusionScore(int value) => _handle.ref.RightEyeOcclusionScore = value;


  Map<String, dynamic> toMap() {
    return {
        'leftEyeOcclusionScore': leftEyeOcclusionScore,
        'mouthOcclusionScore': mouthOcclusionScore,
        'noseOcclusionScore': noseOcclusionScore,
        'rightEyeOcclusionScore': rightEyeOcclusionScore,
    };
  }
}
