//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the face pose (yaw, pitch, roll).
class FacePose {
  final Pointer<id3FacePose> _handle;

  static final Finalizer<Pointer<id3FacePose>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FacePose> get handle => _handle;

  id3FacePose get struct => _handle.ref;

  /// Initializes a new instance of the FacePose class from its members.
  FacePose(this._handle);

  /// Create a new instance of the FacePose.
  FacePose.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the FacePose from the native struct
  FacePose.createFromStruct(id3FacePose value) : _handle = calloc() {
    _handle.ref.Pitch = value.Pitch;
    _handle.ref.Roll = value.Roll;
    _handle.ref.Yaw = value.Yaw;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Pitch angle in degrees.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  double get pitch => _handle.ref.Pitch;
  set pitch(double value) => _handle.ref.Pitch = value;

  /// 
  /// Roll angle in degrees.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  double get roll => _handle.ref.Roll;
  set roll(double value) => _handle.ref.Roll = value;

  /// 
  /// Yaw angle in degrees.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  double get yaw => _handle.ref.Yaw;
  set yaw(double value) => _handle.ref.Yaw = value;


  Map<String, dynamic> toMap() {
    return {
        'pitch': pitch,
        'roll': roll,
        'yaw': yaw,
    };
  }
}
