// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;

class FaceSDK {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  FaceSDK(ffi.DynamicLibrary dynamicLibrary) : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  FaceSDK.fromLookup(
      ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
          lookup)
      : _lookup = lookup;

  /// @brief Initializes a PointList object.
  /// @param phPointList [in] Handle to the PointList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_Initialize(
    ffi.Pointer<ID3_FACE_POINT_LIST> phPointList,
  ) {
    return _id3FacePointList_Initialize(
      phPointList,
    );
  }

  late final _id3FacePointList_InitializePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_POINT_LIST>)>>(
      'id3FacePointList_Initialize');
  late final _id3FacePointList_Initialize = _id3FacePointList_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_POINT_LIST>)>();

  /// @brief Releases the memory allocated for a PointList.
  /// @param phPointList [in] Handle to the PointList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_Dispose(
    ffi.Pointer<ID3_FACE_POINT_LIST> phPointList,
  ) {
    return _id3FacePointList_Dispose(
      phPointList,
    );
  }

  late final _id3FacePointList_DisposePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_POINT_LIST>)>>(
      'id3FacePointList_Dispose');
  late final _id3FacePointList_Dispose = _id3FacePointList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_POINT_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hPointList [in] Handle to the PointList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_CheckHandle(
    ID3_FACE_POINT_LIST hPointList,
  ) {
    return _id3FacePointList_CheckHandle(
      hPointList,
    );
  }

  late final _id3FacePointList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_POINT_LIST)>>(
          'id3FacePointList_CheckHandle');
  late final _id3FacePointList_CheckHandle = _id3FacePointList_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_POINT_LIST)>();

  /// @brief Copies an instance of PointList object to another.
  /// @param hPointListSrc [in] Handle to the source PointList object.
  /// @param hPointListDst [in] Handle to the destination PointList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_CopyTo(
    ID3_FACE_POINT_LIST hPointListSrc,
    ID3_FACE_POINT_LIST hPointListDst,
  ) {
    return _id3FacePointList_CopyTo(
      hPointListSrc,
      hPointListDst,
    );
  }

  late final _id3FacePointList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_POINT_LIST,
              ID3_FACE_POINT_LIST)>>('id3FacePointList_CopyTo');
  late final _id3FacePointList_CopyTo = _id3FacePointList_CopyToPtr
      .asFunction<int Function(ID3_FACE_POINT_LIST, ID3_FACE_POINT_LIST)>();

  /// Clears the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_Clear(
    ID3_FACE_POINT_LIST hPointList,
  ) {
    return _id3FacePointList_Clear(
      hPointList,
    );
  }

  late final _id3FacePointList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_POINT_LIST)>>(
          'id3FacePointList_Clear');
  late final _id3FacePointList_Clear = _id3FacePointList_ClearPtr
      .asFunction<int Function(ID3_FACE_POINT_LIST)>();

  /// Adds an item to the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param sPointItem [in] Point item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_Add(
    ID3_FACE_POINT_LIST hPointList,
    ffi.Pointer<id3FacePoint> sPointItem,
  ) {
    return _id3FacePointList_Add(
      hPointList,
      sPointItem,
    );
  }

  late final _id3FacePointList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_POINT_LIST,
              ffi.Pointer<id3FacePoint>)>>('id3FacePointList_Add');
  late final _id3FacePointList_Add = _id3FacePointList_AddPtr.asFunction<
      int Function(ID3_FACE_POINT_LIST, ffi.Pointer<id3FacePoint>)>();

  /// Gets an item of the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param index [in] Index of the Point item to get.
  /// @param sPointItem [out] Point item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_Get(
    ID3_FACE_POINT_LIST hPointList,
    int index,
    ffi.Pointer<id3FacePoint> sPointItem,
  ) {
    return _id3FacePointList_Get(
      hPointList,
      index,
      sPointItem,
    );
  }

  late final _id3FacePointList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_POINT_LIST, ffi.Int,
              ffi.Pointer<id3FacePoint>)>>('id3FacePointList_Get');
  late final _id3FacePointList_Get = _id3FacePointList_GetPtr.asFunction<
      int Function(ID3_FACE_POINT_LIST, int, ffi.Pointer<id3FacePoint>)>();

  /// Sets an item of the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param index [in] Index of the Point item to set.
  /// @param sPointItem [in] Point item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_Set(
    ID3_FACE_POINT_LIST hPointList,
    int index,
    ffi.Pointer<id3FacePoint> sPointItem,
  ) {
    return _id3FacePointList_Set(
      hPointList,
      index,
      sPointItem,
    );
  }

  late final _id3FacePointList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_POINT_LIST, ffi.Int,
              ffi.Pointer<id3FacePoint>)>>('id3FacePointList_Set');
  late final _id3FacePointList_Set = _id3FacePointList_SetPtr.asFunction<
      int Function(ID3_FACE_POINT_LIST, int, ffi.Pointer<id3FacePoint>)>();

  /// Gets the number of elements in the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param count [out] Number of elements in the Point object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_GetCount(
    ID3_FACE_POINT_LIST hPointList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FacePointList_GetCount(
      hPointList,
      count,
    );
  }

  late final _id3FacePointList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_POINT_LIST,
              ffi.Pointer<ffi.Int>)>>('id3FacePointList_GetCount');
  late final _id3FacePointList_GetCount = _id3FacePointList_GetCountPtr
      .asFunction<int Function(ID3_FACE_POINT_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param index [in] Index of the Point item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_RemoveAt(
    ID3_FACE_POINT_LIST hPointList,
    int index,
  ) {
    return _id3FacePointList_RemoveAt(
      hPointList,
      index,
    );
  }

  late final _id3FacePointList_RemoveAtPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_POINT_LIST, ffi.Int)>>(
      'id3FacePointList_RemoveAt');
  late final _id3FacePointList_RemoveAt = _id3FacePointList_RemoveAtPtr
      .asFunction<int Function(ID3_FACE_POINT_LIST, int)>();

  /// PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param newSize [in] Point object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePointList_Resize(
    ID3_FACE_POINT_LIST hPointList,
    int newSize,
  ) {
    return _id3FacePointList_Resize(
      hPointList,
      newSize,
    );
  }

  late final _id3FacePointList_ResizePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_POINT_LIST, ffi.Int)>>(
      'id3FacePointList_Resize');
  late final _id3FacePointList_Resize = _id3FacePointList_ResizePtr
      .asFunction<int Function(ID3_FACE_POINT_LIST, int)>();

  ffi.Pointer<ffi.Char> id3Face_GetPixelFormatString(
    int value,
  ) {
    return _id3Face_GetPixelFormatString(
      value,
    );
  }

  late final _id3Face_GetPixelFormatStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetPixelFormatString');
  late final _id3Face_GetPixelFormatString = _id3Face_GetPixelFormatStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetImageFormatString(
    int value,
  ) {
    return _id3Face_GetImageFormatString(
      value,
    );
  }

  late final _id3Face_GetImageFormatStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetImageFormatString');
  late final _id3Face_GetImageFormatString = _id3Face_GetImageFormatStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a ImageBuffer object.
  /// @param phImageBuffer [in] Handle to the ImageBuffer object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageBuffer_Initialize(
    ffi.Pointer<ID3_FACE_IMAGE_BUFFER> phImageBuffer,
  ) {
    return _id3FaceImageBuffer_Initialize(
      phImageBuffer,
    );
  }

  late final _id3FaceImageBuffer_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_BUFFER>)>>(
      'id3FaceImageBuffer_Initialize');
  late final _id3FaceImageBuffer_Initialize = _id3FaceImageBuffer_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE_BUFFER>)>();

  /// @brief Releases the memory allocated for a ImageBuffer.
  /// @param phImageBuffer [in] Handle to the ImageBuffer object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageBuffer_Dispose(
    ffi.Pointer<ID3_FACE_IMAGE_BUFFER> phImageBuffer,
  ) {
    return _id3FaceImageBuffer_Dispose(
      phImageBuffer,
    );
  }

  late final _id3FaceImageBuffer_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_BUFFER>)>>(
      'id3FaceImageBuffer_Dispose');
  late final _id3FaceImageBuffer_Dispose = _id3FaceImageBuffer_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE_BUFFER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hImageBuffer [in] Handle to the ImageBuffer object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageBuffer_CheckHandle(
    ID3_FACE_IMAGE_BUFFER hImageBuffer,
  ) {
    return _id3FaceImageBuffer_CheckHandle(
      hImageBuffer,
    );
  }

  late final _id3FaceImageBuffer_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE_BUFFER)>>(
          'id3FaceImageBuffer_CheckHandle');
  late final _id3FaceImageBuffer_CheckHandle =
      _id3FaceImageBuffer_CheckHandlePtr
          .asFunction<int Function(ID3_FACE_IMAGE_BUFFER)>();

  /// @brief Copies an instance of ImageBuffer object to another.
  /// @param hImageBufferSrc [in] Handle to the source ImageBuffer object.
  /// @param hImageBufferDst [in] Handle to the destination ImageBuffer object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageBuffer_CopyTo(
    ID3_FACE_IMAGE_BUFFER hImageBufferSrc,
    ID3_FACE_IMAGE_BUFFER hImageBufferDst,
  ) {
    return _id3FaceImageBuffer_CopyTo(
      hImageBufferSrc,
      hImageBufferDst,
    );
  }

  late final _id3FaceImageBuffer_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_BUFFER,
              ID3_FACE_IMAGE_BUFFER)>>('id3FaceImageBuffer_CopyTo');
  late final _id3FaceImageBuffer_CopyTo = _id3FaceImageBuffer_CopyToPtr
      .asFunction<int Function(ID3_FACE_IMAGE_BUFFER, ID3_FACE_IMAGE_BUFFER)>();

  /// Gets the image buffer data.
  /// @param hImageBuffer [in] Handle to the ImageBuffer object.
  /// @param data [out] Data of the image buffer object.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageBuffer_GetData(
    ID3_FACE_IMAGE_BUFFER hImageBuffer,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3FaceImageBuffer_GetData(
      hImageBuffer,
      data,
      dataSize,
    );
  }

  late final _id3FaceImageBuffer_GetDataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_BUFFER, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceImageBuffer_GetData');
  late final _id3FaceImageBuffer_GetData =
      _id3FaceImageBuffer_GetDataPtr.asFunction<
          int Function(ID3_FACE_IMAGE_BUFFER, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets a pointer to the pixels of the image. Unsafe! The user must handle the pixels pointer carefully.
  /// @param hImageBuffer [in] Handle to the ImageBuffer object.
  /// @param pixels [out] Pointer to the pixels of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageBuffer_GetPixels(
    ID3_FACE_IMAGE_BUFFER hImageBuffer,
    ffi.Pointer<ffi.Pointer<ffi.Void>> pixels,
  ) {
    return _id3FaceImageBuffer_GetPixels(
      hImageBuffer,
      pixels,
    );
  }

  late final _id3FaceImageBuffer_GetPixelsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_IMAGE_BUFFER, ffi.Pointer<ffi.Pointer<ffi.Void>>)>>(
      'id3FaceImageBuffer_GetPixels');
  late final _id3FaceImageBuffer_GetPixels =
      _id3FaceImageBuffer_GetPixelsPtr.asFunction<
          int Function(
              ID3_FACE_IMAGE_BUFFER, ffi.Pointer<ffi.Pointer<ffi.Void>>)>();

  /// @brief Initializes a Image object.
  /// @param phImage [in] Handle to the Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Initialize(
    ffi.Pointer<ID3_FACE_IMAGE> phImage,
  ) {
    return _id3FaceImage_Initialize(
      phImage,
    );
  }

  late final _id3FaceImage_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE>)>>(
      'id3FaceImage_Initialize');
  late final _id3FaceImage_Initialize = _id3FaceImage_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE>)>();

  /// @brief Releases the memory allocated for a Image.
  /// @param phImage [in] Handle to the Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Dispose(
    ffi.Pointer<ID3_FACE_IMAGE> phImage,
  ) {
    return _id3FaceImage_Dispose(
      phImage,
    );
  }

  late final _id3FaceImage_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE>)>>(
      'id3FaceImage_Dispose');
  late final _id3FaceImage_Dispose = _id3FaceImage_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hImage [in] Handle to the Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_CheckHandle(
    ID3_FACE_IMAGE hImage,
  ) {
    return _id3FaceImage_CheckHandle(
      hImage,
    );
  }

  late final _id3FaceImage_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE)>>(
          'id3FaceImage_CheckHandle');
  late final _id3FaceImage_CheckHandle =
      _id3FaceImage_CheckHandlePtr.asFunction<int Function(ID3_FACE_IMAGE)>();

  /// @brief Copies an instance of Image object to another.
  /// @param hImageSrc [in] Handle to the source Image object.
  /// @param hImageDst [in] Handle to the destination Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_CopyTo(
    ID3_FACE_IMAGE hImageSrc,
    ID3_FACE_IMAGE hImageDst,
  ) {
    return _id3FaceImage_CopyTo(
      hImageSrc,
      hImageDst,
    );
  }

  late final _id3FaceImage_CopyToPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE, ID3_FACE_IMAGE)>>(
      'id3FaceImage_CopyTo');
  late final _id3FaceImage_CopyTo = _id3FaceImage_CopyToPtr
      .asFunction<int Function(ID3_FACE_IMAGE, ID3_FACE_IMAGE)>();

  /// Gets the raw data buffer of the image.
  /// @param hImage [in] Handle to the Image object.
  /// @param data [out] Raw data buffer of the image.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_GetData(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3FaceImage_GetData(
      hImage,
      data,
      dataSize,
    );
  }

  late final _id3FaceImage_GetDataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceImage_GetData');
  late final _id3FaceImage_GetData = _id3FaceImage_GetDataPtr.asFunction<
      int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<ffi.Int>)>();

  /// Gets the height in pixels.
  /// @param hImage [in] Handle to the Image object.
  /// @param height [out] Height in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_GetHeight(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Int> height,
  ) {
    return _id3FaceImage_GetHeight(
      hImage,
      height,
    );
  }

  late final _id3FaceImage_GetHeightPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>>('id3FaceImage_GetHeight');
  late final _id3FaceImage_GetHeight = _id3FaceImage_GetHeightPtr
      .asFunction<int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the pixel depth.
  /// @param hImage [in] Handle to the Image object.
  /// @param pixelDepth [out] Pixel depth.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_GetPixelDepth(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Int> pixelDepth,
  ) {
    return _id3FaceImage_GetPixelDepth(
      hImage,
      pixelDepth,
    );
  }

  late final _id3FaceImage_GetPixelDepthPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3FaceImage_GetPixelDepth');
  late final _id3FaceImage_GetPixelDepth = _id3FaceImage_GetPixelDepthPtr
      .asFunction<int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the pixel format.
  /// @param hImage [in] Handle to the Image object.
  /// @param ePixelFormat [out] Pixel format.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_GetPixelFormat(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Int32> ePixelFormat,
  ) {
    return _id3FaceImage_GetPixelFormat(
      hImage,
      ePixelFormat,
    );
  }

  late final _id3FaceImage_GetPixelFormatPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Int32>)>>('id3FaceImage_GetPixelFormat');
  late final _id3FaceImage_GetPixelFormat = _id3FaceImage_GetPixelFormatPtr
      .asFunction<int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Int32>)>();

  /// Gets the stride in bytes.
  /// @param hImage [in] Handle to the Image object.
  /// @param stride [out] Stride in bytes.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_GetStride(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Int> stride,
  ) {
    return _id3FaceImage_GetStride(
      hImage,
      stride,
    );
  }

  late final _id3FaceImage_GetStridePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>>('id3FaceImage_GetStride');
  late final _id3FaceImage_GetStride = _id3FaceImage_GetStridePtr
      .asFunction<int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the width in pixels.
  /// @param hImage [in] Handle to the Image object.
  /// @param width [out] Width in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_GetWidth(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Int> width,
  ) {
    return _id3FaceImage_GetWidth(
      hImage,
      width,
    );
  }

  late final _id3FaceImage_GetWidthPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>>('id3FaceImage_GetWidth');
  late final _id3FaceImage_GetWidth = _id3FaceImage_GetWidthPtr
      .asFunction<int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Computes the difference with another image.
  /// @param hImage [in] Handle to the Image object.
  /// @param hCmpImage [in] The image to compare.
  /// @param result [out] Comparison result in percent (0% is same, 100% is full different).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Compare(
    ID3_FACE_IMAGE hImage,
    ID3_FACE_IMAGE hCmpImage,
    ffi.Pointer<ffi.Float> result,
  ) {
    return _id3FaceImage_Compare(
      hImage,
      hCmpImage,
      result,
    );
  }

  late final _id3FaceImage_ComparePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Float>)>>('id3FaceImage_Compare');
  late final _id3FaceImage_Compare = _id3FaceImage_ComparePtr.asFunction<
      int Function(ID3_FACE_IMAGE, ID3_FACE_IMAGE, ffi.Pointer<ffi.Float>)>();

  /// Applies a gamma correction to the image.
  /// @param hImage [in] Handle to the Image object.
  /// @param contrast [in] Contrast coefficient, from -255 to 255, to be applied to the image.
  /// @param brightness [in] Brightness coefficient, from -255 to 255, to be applid to the image.
  /// @param gamma [in] Gamma coefficient, from 0.25 to 2.50, to be applied to the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_CorrectGamma(
    ID3_FACE_IMAGE hImage,
    int contrast,
    int brightness,
    double gamma,
  ) {
    return _id3FaceImage_CorrectGamma(
      hImage,
      contrast,
      brightness,
      gamma,
    );
  }

  late final _id3FaceImage_CorrectGammaPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int, ffi.Int,
              ffi.Float)>>('id3FaceImage_CorrectGamma');
  late final _id3FaceImage_CorrectGamma = _id3FaceImage_CorrectGammaPtr
      .asFunction<int Function(ID3_FACE_IMAGE, int, int, double)>();

  /// Crop a rectangular region of interest in the image according to the given bounds.
  /// @param hImage [in] Handle to the Image object.
  /// @param left [in] Left bound of the crop to extract.
  /// @param top [in] Top bound of the crop to extract.
  /// @param width [in] Width of the crop to extract.
  /// @param height [in] Height of the crop to extract.
  /// @param hImageCrop [out] The extracted region of interest.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Crop(
    ID3_FACE_IMAGE hImage,
    int left,
    int top,
    int width,
    int height,
    ID3_FACE_IMAGE hImageCrop,
  ) {
    return _id3FaceImage_Crop(
      hImage,
      left,
      top,
      width,
      height,
      hImageCrop,
    );
  }

  late final _id3FaceImage_CropPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int, ffi.Int, ffi.Int, ffi.Int,
              ID3_FACE_IMAGE)>>('id3FaceImage_Crop');
  late final _id3FaceImage_Crop = _id3FaceImage_CropPtr.asFunction<
      int Function(ID3_FACE_IMAGE, int, int, int, int, ID3_FACE_IMAGE)>();

  /// Downscales the image in-place so that its maximum dimension is equal to the given maximum size, while preserving the aspect ratio.
  /// Note: If the maximum dimension is already smaller than the given maximum size, the function does nothing and the scaling ration returned is 1.
  /// @param hImage [in] Handle to the Image object.
  /// @param maxSize [in] Maximum image size, in pixels. The value must be greater than 0.
  /// @param scaleRatio [out] The scaling ratio applied to the image. Range is ]0:1].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Downscale(
    ID3_FACE_IMAGE hImage,
    int maxSize,
    ffi.Pointer<ffi.Float> scaleRatio,
  ) {
    return _id3FaceImage_Downscale(
      hImage,
      maxSize,
      scaleRatio,
    );
  }

  late final _id3FaceImage_DownscalePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int,
              ffi.Pointer<ffi.Float>)>>('id3FaceImage_Downscale');
  late final _id3FaceImage_Downscale = _id3FaceImage_DownscalePtr
      .asFunction<int Function(ID3_FACE_IMAGE, int, ffi.Pointer<ffi.Float>)>();

  /// Downscales the image so that its maximum dimension equals the given maximum size, while preserving the aspect ratio.
  /// Note: If the maximum dimension is already smaller than the given maximum size, the function does nothing and the returned scale ratio is 1.
  /// @param hImage [in] Handle to the Image object.
  /// @param hDstImage [in] Destination image.
  /// @param maxSize [in] Maximum image size, in pixels. The value must be greater than 0.
  /// @param scaleRatio [out] The scaling ratio applied to the image. Range is ]0:1].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_DownscaleTo(
    ID3_FACE_IMAGE hImage,
    ID3_FACE_IMAGE hDstImage,
    int maxSize,
    ffi.Pointer<ffi.Float> scaleRatio,
  ) {
    return _id3FaceImage_DownscaleTo(
      hImage,
      hDstImage,
      maxSize,
      scaleRatio,
    );
  }

  late final _id3FaceImage_DownscaleToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ID3_FACE_IMAGE, ffi.Int,
              ffi.Pointer<ffi.Float>)>>('id3FaceImage_DownscaleTo');
  late final _id3FaceImage_DownscaleTo =
      _id3FaceImage_DownscaleToPtr.asFunction<
          int Function(
              ID3_FACE_IMAGE, ID3_FACE_IMAGE, int, ffi.Pointer<ffi.Float>)>();

  /// Extracts a region of interest in the image according to the given bounds.
  /// @param hImage [in] Handle to the Image object.
  /// @param sBounds [in] Bounds of the crop to extract.
  /// @param hImageRoi [out] The extracted region of interest.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_ExtractRoi(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<id3FaceRectangle> sBounds,
    ID3_FACE_IMAGE hImageRoi,
  ) {
    return _id3FaceImage_ExtractRoi(
      hImage,
      sBounds,
      hImageRoi,
    );
  }

  late final _id3FaceImage_ExtractRoiPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Pointer<id3FaceRectangle>,
              ID3_FACE_IMAGE)>>('id3FaceImage_ExtractRoi');
  late final _id3FaceImage_ExtractRoi = _id3FaceImage_ExtractRoiPtr.asFunction<
      int Function(
          ID3_FACE_IMAGE, ffi.Pointer<id3FaceRectangle>, ID3_FACE_IMAGE)>();

  /// Extracts a region of interest in the image according to the given bounds.
  /// @param hImage [in] Handle to the Image object.
  /// @param sBounds [in] Bounds of the crop to extract.
  /// @param colorRed [in] Background color red (from 0 to 255)
  /// @param colorGreen [in] Background color green (from 0 to 255)
  /// @param colorBlue [in] Background color blue (from 0 to 255)
  /// @param hImageRoi [out] The extracted region of interest.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_ExtractRoiWithColor(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<id3FaceRectangle> sBounds,
    int colorRed,
    int colorGreen,
    int colorBlue,
    ID3_FACE_IMAGE hImageRoi,
  ) {
    return _id3FaceImage_ExtractRoiWithColor(
      hImage,
      sBounds,
      colorRed,
      colorGreen,
      colorBlue,
      hImageRoi,
    );
  }

  late final _id3FaceImage_ExtractRoiWithColorPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE,
              ffi.Pointer<id3FaceRectangle>,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ID3_FACE_IMAGE)>>('id3FaceImage_ExtractRoiWithColor');
  late final _id3FaceImage_ExtractRoiWithColor =
      _id3FaceImage_ExtractRoiWithColorPtr.asFunction<
          int Function(ID3_FACE_IMAGE, ffi.Pointer<id3FaceRectangle>, int, int,
              int, ID3_FACE_IMAGE)>();

  /// Flips the image in-place.
  /// @param hImage [in] Handle to the Image object.
  /// @param flipHorizontally [in] Value indicating whether the image should be flipped horizontally.
  /// @param flipVertically [in] Value indicating whether the image should be flipped vertically.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Flip(
    ID3_FACE_IMAGE hImage,
    bool flipHorizontally,
    bool flipVertically,
  ) {
    return _id3FaceImage_Flip(
      hImage,
      flipHorizontally,
      flipVertically,
    );
  }

  late final _id3FaceImage_FlipPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE, ffi.Bool, ffi.Bool)>>('id3FaceImage_Flip');
  late final _id3FaceImage_Flip = _id3FaceImage_FlipPtr
      .asFunction<int Function(ID3_FACE_IMAGE, bool, bool)>();

  /// Flips the image.
  /// @param hImage [in] Handle to the Image object.
  /// @param flipHorizontally [in] Value indicating whether the image should be flipped horizontally.
  /// @param flipVertically [in] Value indicating whether the image should be flipped vertically.
  /// @param hDstImage [in] The destination Image object that receives the flipped image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_FlipTo(
    ID3_FACE_IMAGE hImage,
    bool flipHorizontally,
    bool flipVertically,
    ID3_FACE_IMAGE hDstImage,
  ) {
    return _id3FaceImage_FlipTo(
      hImage,
      flipHorizontally,
      flipVertically,
      hDstImage,
    );
  }

  late final _id3FaceImage_FlipToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Bool, ffi.Bool,
              ID3_FACE_IMAGE)>>('id3FaceImage_FlipTo');
  late final _id3FaceImage_FlipTo = _id3FaceImage_FlipToPtr
      .asFunction<int Function(ID3_FACE_IMAGE, bool, bool, ID3_FACE_IMAGE)>();

  /// Creates an Image from the specified data buffer.
  /// @param hImage [in] Handle to the Image object.
  /// @param data [in] A buffer that contains the image data.
  /// @param dataSize [in] Size of the 'data' buffer.
  /// @param ePixelFormat [in] The destination pixel format to convert the input to.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_FromBuffer(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.UnsignedChar> data,
    int dataSize,
    int ePixelFormat,
  ) {
    return _id3FaceImage_FromBuffer(
      hImage,
      data,
      dataSize,
      ePixelFormat,
    );
  }

  late final _id3FaceImage_FromBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int, ffi.Int32)>>('id3FaceImage_FromBuffer');
  late final _id3FaceImage_FromBuffer = _id3FaceImage_FromBufferPtr.asFunction<
      int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.UnsignedChar>, int, int)>();

  /// Creates an Image from the specified file.
  /// @param hImage [in] Handle to the Image object.
  /// @param filepath [in] A string that contains the name of the file from which to create the Image.
  /// @param ePixelFormat [in] The pixel format into which to convert the input image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_FromFile(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Char> filepath,
    int ePixelFormat,
  ) {
    return _id3FaceImage_FromFile(
      hImage,
      filepath,
      ePixelFormat,
    );
  }

  late final _id3FaceImage_FromFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Char>,
              ffi.Int32)>>('id3FaceImage_FromFile');
  late final _id3FaceImage_FromFile = _id3FaceImage_FromFilePtr
      .asFunction<int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Char>, int)>();

  /// Creates an Image from the specified raw data buffer.
  /// @param hImage [in] Handle to the Image object.
  /// @param pixels [in] A buffer that contains image pixels.
  /// @param pixelsSize [in] Size of the 'pixels' buffer.
  /// @param width [in] The width, in pixels, of the image.
  /// @param height [in] The height, in pixels, of the image.
  /// @param stride [in] The stride, in pixels, of the image.
  /// @param eSrcPixelFormat [in] The pixel format of the input image.
  /// @param eDstPixelFormat [in] The pixel format into which to convert the input image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_FromRawBuffer(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.UnsignedChar> pixels,
    int pixelsSize,
    int width,
    int height,
    int stride,
    int eSrcPixelFormat,
    int eDstPixelFormat,
  ) {
    return _id3FaceImage_FromRawBuffer(
      hImage,
      pixels,
      pixelsSize,
      width,
      height,
      stride,
      eSrcPixelFormat,
      eDstPixelFormat,
    );
  }

  late final _id3FaceImage_FromRawBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int32,
              ffi.Int32)>>('id3FaceImage_FromRawBuffer');
  late final _id3FaceImage_FromRawBuffer =
      _id3FaceImage_FromRawBufferPtr.asFunction<
          int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.UnsignedChar>, int, int,
              int, int, int, int)>();

  /// Creates an Image from the specified YUV planes.
  /// @param hImage [in] Handle to the Image object.
  /// @param yPlane [in] A buffer that contains the Y plane.
  /// @param yPlaneSize [in] Size of the 'yPlane' buffer.
  /// @param uPlane [in] A buffer that contains the U plane.
  /// @param uPlaneSize [in] Size of the 'uPlane' buffer.
  /// @param vPlane [in] A buffer that contains the V plane.
  /// @param vPlaneSize [in] Size of the 'vPlane' buffer.
  /// @param yWidth [in] The width, in pixels, of the Y plane.
  /// @param yHeight [in] The height, in pixels, of the Y plane.
  /// @param uvPixelStride [in] The pixel-level stride, in pixels, of the U and V planes.
  /// @param uvRowStride [in] The row-level stride, in pixels, of the U and V planes.
  /// @param eDstPixelFormat [in] The pixel format into which to convert the input image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_FromYuvPlanes(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.UnsignedChar> yPlane,
    int yPlaneSize,
    ffi.Pointer<ffi.UnsignedChar> uPlane,
    int uPlaneSize,
    ffi.Pointer<ffi.UnsignedChar> vPlane,
    int vPlaneSize,
    int yWidth,
    int yHeight,
    int uvPixelStride,
    int uvRowStride,
    int eDstPixelFormat,
  ) {
    return _id3FaceImage_FromYuvPlanes(
      hImage,
      yPlane,
      yPlaneSize,
      uPlane,
      uPlaneSize,
      vPlane,
      vPlaneSize,
      yWidth,
      yHeight,
      uvPixelStride,
      uvRowStride,
      eDstPixelFormat,
    );
  }

  late final _id3FaceImage_FromYuvPlanesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int32)>>('id3FaceImage_FromYuvPlanes');
  late final _id3FaceImage_FromYuvPlanes =
      _id3FaceImage_FromYuvPlanesPtr.asFunction<
          int Function(
              ID3_FACE_IMAGE,
              ffi.Pointer<ffi.UnsignedChar>,
              int,
              ffi.Pointer<ffi.UnsignedChar>,
              int,
              ffi.Pointer<ffi.UnsignedChar>,
              int,
              int,
              int,
              int,
              int,
              int)>();

  /// Gets a pointer to the image pixels.
  /// Warning: This method is unsafe! The user must handle the pixels pointer carefully.
  /// @param hImage [in] Handle to the Image object.
  /// @param pixels [out] Pointer to the image pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_GetPixels(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Pointer<ffi.Void>> pixels,
  ) {
    return _id3FaceImage_GetPixels(
      hImage,
      pixels,
    );
  }

  late final _id3FaceImage_GetPixelsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Pointer<ffi.Void>>)>>('id3FaceImage_GetPixels');
  late final _id3FaceImage_GetPixels = _id3FaceImage_GetPixelsPtr.asFunction<
      int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Pointer<ffi.Void>>)>();

  /// Add padding around the image
  /// Only works for BGR 24 bits, RGB 24 bits and Grayscale 8bits images.
  /// For grayscale image, the padding color is the red component.
  /// @param hImage [in] Handle to the Image object.
  /// @param top [in] Padding on top.
  /// @param left [in] Padding on left.
  /// @param bottom [in] Padding on bottom.
  /// @param right [in] Padding on right.
  /// @param colorRed [in] Padding color red (from 0 to 255)
  /// @param colorGreen [in] Padding color green (from 0 to 255)
  /// @param colorBlue [in] Padding color blue (from 0 to 255)
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Pad(
    ID3_FACE_IMAGE hImage,
    int top,
    int left,
    int bottom,
    int right,
    int colorRed,
    int colorGreen,
    int colorBlue,
  ) {
    return _id3FaceImage_Pad(
      hImage,
      top,
      left,
      bottom,
      right,
      colorRed,
      colorGreen,
      colorBlue,
    );
  }

  late final _id3FaceImage_PadPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int, ffi.Int, ffi.Int, ffi.Int,
              ffi.Int, ffi.Int, ffi.Int)>>('id3FaceImage_Pad');
  late final _id3FaceImage_Pad = _id3FaceImage_PadPtr.asFunction<
      int Function(ID3_FACE_IMAGE, int, int, int, int, int, int, int)>();

  /// Reallocates the internal memory of the Image from parameters.
  /// Note: If the given parameters are the same as the ones of the object, then there is nothing done in this function.
  /// @param hImage [in] Handle to the Image object.
  /// @param width [in] The new width, in pixels.
  /// @param height [in] The new height, in pixels.
  /// @param ePixelFormat [in] The new pixel format.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Reallocate(
    ID3_FACE_IMAGE hImage,
    int width,
    int height,
    int ePixelFormat,
  ) {
    return _id3FaceImage_Reallocate(
      hImage,
      width,
      height,
      ePixelFormat,
    );
  }

  late final _id3FaceImage_ReallocatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int, ffi.Int,
              ffi.Int32)>>('id3FaceImage_Reallocate');
  late final _id3FaceImage_Reallocate = _id3FaceImage_ReallocatePtr
      .asFunction<int Function(ID3_FACE_IMAGE, int, int, int)>();

  /// Resizes the image in-place to the required width and height.
  /// @param hImage [in] Handle to the Image object.
  /// @param width [in] The new width, in pixels.
  /// @param height [in] The new height, in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Resize(
    ID3_FACE_IMAGE hImage,
    int width,
    int height,
  ) {
    return _id3FaceImage_Resize(
      hImage,
      width,
      height,
    );
  }

  late final _id3FaceImage_ResizePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_FACE_IMAGE, ffi.Int, ffi.Int)>>(
      'id3FaceImage_Resize');
  late final _id3FaceImage_Resize = _id3FaceImage_ResizePtr
      .asFunction<int Function(ID3_FACE_IMAGE, int, int)>();

  /// Resizes the image to the specified width and height.
  /// @param hImage [in] Handle to the Image object.
  /// @param width [in] The new width, in pixels.
  /// @param height [in] The new height, in pixels.
  /// @param hDstImage [in] The destination image that receives the resized image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_ResizeTo(
    ID3_FACE_IMAGE hImage,
    int width,
    int height,
    ID3_FACE_IMAGE hDstImage,
  ) {
    return _id3FaceImage_ResizeTo(
      hImage,
      width,
      height,
      hDstImage,
    );
  }

  late final _id3FaceImage_ResizeToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int, ffi.Int,
              ID3_FACE_IMAGE)>>('id3FaceImage_ResizeTo');
  late final _id3FaceImage_ResizeTo = _id3FaceImage_ResizeToPtr
      .asFunction<int Function(ID3_FACE_IMAGE, int, int, ID3_FACE_IMAGE)>();

  /// Rotates the image in-place to the specified angle.
  /// Note: The rotation is performed counter-clockwise.
  /// @param hImage [in] Handle to the Image object.
  /// @param angle [in] The rotation angle, in degree. Supported values are [0, 90, 180, 270].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Rotate(
    ID3_FACE_IMAGE hImage,
    int angle,
  ) {
    return _id3FaceImage_Rotate(
      hImage,
      angle,
    );
  }

  late final _id3FaceImage_RotatePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE, ffi.Int)>>(
          'id3FaceImage_Rotate');
  late final _id3FaceImage_Rotate =
      _id3FaceImage_RotatePtr.asFunction<int Function(ID3_FACE_IMAGE, int)>();

  /// Rotates the image to the specified angle.
  /// Note: The rotation is performed counter-clockwise.
  /// @param hImage [in] Handle to the Image object.
  /// @param angle [in] The rotation angle, in degree. Supported values are [0, 90, 180, 270].
  /// @param hDstImage [in] The destination Image that receives the rotated image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_RotateTo(
    ID3_FACE_IMAGE hImage,
    int angle,
    ID3_FACE_IMAGE hDstImage,
  ) {
    return _id3FaceImage_RotateTo(
      hImage,
      angle,
      hDstImage,
    );
  }

  late final _id3FaceImage_RotateToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int,
              ID3_FACE_IMAGE)>>('id3FaceImage_RotateTo');
  late final _id3FaceImage_RotateTo = _id3FaceImage_RotateToPtr
      .asFunction<int Function(ID3_FACE_IMAGE, int, ID3_FACE_IMAGE)>();

  /// Sets the Image object fields.
  /// Warning: This function does not allocate any memory and is unsafe! The user must handle the pixels pointer carefully.
  /// @param hImage [in] Handle to the Image object.
  /// @param width [in] The width, in pixels, of the image.
  /// @param height [in] The height, in pixels, of the image.
  /// @param ePixelFormat [in] The pixel format of the image.
  /// @param pixels [in] A pointer to the image pixels of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Set(
    ID3_FACE_IMAGE hImage,
    int width,
    int height,
    int ePixelFormat,
    ffi.Pointer<ffi.Void> pixels,
  ) {
    return _id3FaceImage_Set(
      hImage,
      width,
      height,
      ePixelFormat,
      pixels,
    );
  }

  late final _id3FaceImage_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int, ffi.Int, ffi.Int32,
              ffi.Pointer<ffi.Void>)>>('id3FaceImage_Set');
  late final _id3FaceImage_Set = _id3FaceImage_SetPtr.asFunction<
      int Function(ID3_FACE_IMAGE, int, int, int, ffi.Pointer<ffi.Void>)>();

  /// Exports the image to a buffer.
  /// The compression level meaning depends on the algorithm used:
  /// - For JPEG compression, the value is the expected quality and may vary from 1 to 100.
  /// - For JPEG2000 compression, the value is the compression rate and may vary from 1 to 512.
  /// - For PNG compression, the value is the compression rate and may vary from 1 to 10.
  /// - For all other formats, the value is ignored.
  /// @param hImage [in] Handle to the Image object.
  /// @param eImageFormat [in] The image format to export the image to.
  /// @param compressionLevel [in] The compression level to be applied.
  /// @param data [out] Buffer that receives the image data.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_ToBuffer(
    ID3_FACE_IMAGE hImage,
    int eImageFormat,
    double compressionLevel,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3FaceImage_ToBuffer(
      hImage,
      eImageFormat,
      compressionLevel,
      data,
      dataSize,
    );
  }

  late final _id3FaceImage_ToBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE,
              ffi.Int32,
              ffi.Float,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceImage_ToBuffer');
  late final _id3FaceImage_ToBuffer = _id3FaceImage_ToBufferPtr.asFunction<
      int Function(ID3_FACE_IMAGE, int, double, ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<ffi.Int>)>();

  /// Copies the image to a buffer in the specified format.
  /// The compression level meaning depends on the algorithm used:
  /// - For JPEG compression, the value is the expected quality and may vary from 1 to 100.
  /// - For JPEG2000 compression, the value is the compression rate and may vary from 1 to 512.
  /// - For PNG compression, the value is the compression rate and may vary from 1 to 10.
  /// - For all other formats, the value is ignored.
  /// @param hImage [in] Handle to the Image object.
  /// @param eImageFormat [in] The output image format.
  /// @param compressionLevel [in] The compression level to be applied.
  /// @param hBuffer [in] The image buffer that receives the image data.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_ToBufferObject(
    ID3_FACE_IMAGE hImage,
    int eImageFormat,
    double compressionLevel,
    ID3_FACE_IMAGE_BUFFER hBuffer,
  ) {
    return _id3FaceImage_ToBufferObject(
      hImage,
      eImageFormat,
      compressionLevel,
      hBuffer,
    );
  }

  late final _id3FaceImage_ToBufferObjectPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int32, ffi.Float,
              ID3_FACE_IMAGE_BUFFER)>>('id3FaceImage_ToBufferObject');
  late final _id3FaceImage_ToBufferObject =
      _id3FaceImage_ToBufferObjectPtr.asFunction<
          int Function(ID3_FACE_IMAGE, int, double, ID3_FACE_IMAGE_BUFFER)>();

  /// Saves the image to the specified file.
  /// The compression level meaning depends on the algorithm used:
  /// - For JPEG compression, the value is the expected quality and may vary from 1 to 100.
  /// - For JPEG2000 compression, the value is the compression rate and may vary from 1 to 512.
  /// - For PNG compression, the value is the compression rate and may vary from 1 to 10.
  /// - For all other formats, the value is ignored.
  /// @param hImage [in] Handle to the Image object.
  /// @param filepath [in] A string that contains the name of the file to which to save the image.
  /// @param compressionLevel [in] The compression level to be applied.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_ToFile(
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Char> filepath,
    double compressionLevel,
  ) {
    return _id3FaceImage_ToFile(
      hImage,
      filepath,
      compressionLevel,
    );
  }

  late final _id3FaceImage_ToFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Char>,
              ffi.Float)>>('id3FaceImage_ToFile');
  late final _id3FaceImage_ToFile = _id3FaceImage_ToFilePtr.asFunction<
      int Function(ID3_FACE_IMAGE, ffi.Pointer<ffi.Char>, double)>();

  /// Copies image pixels in the specified format into a buffer.
  /// @param hImage [in] Handle to the Image object.
  /// @param ePixelFormat [in] The pixel format.
  /// @param hBuffer [in] Buffer that receives the raw image data.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_ToRawBuffer(
    ID3_FACE_IMAGE hImage,
    int ePixelFormat,
    ID3_FACE_IMAGE_BUFFER hBuffer,
  ) {
    return _id3FaceImage_ToRawBuffer(
      hImage,
      ePixelFormat,
      hBuffer,
    );
  }

  late final _id3FaceImage_ToRawBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE, ffi.Int32,
              ID3_FACE_IMAGE_BUFFER)>>('id3FaceImage_ToRawBuffer');
  late final _id3FaceImage_ToRawBuffer = _id3FaceImage_ToRawBufferPtr
      .asFunction<int Function(ID3_FACE_IMAGE, int, ID3_FACE_IMAGE_BUFFER)>();

  /// Transposes the image object.
  /// @param hImage [in] Handle to the Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImage_Transpose(
    ID3_FACE_IMAGE hImage,
  ) {
    return _id3FaceImage_Transpose(
      hImage,
    );
  }

  late final _id3FaceImage_TransposePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE)>>(
          'id3FaceImage_Transpose');
  late final _id3FaceImage_Transpose =
      _id3FaceImage_TransposePtr.asFunction<int Function(ID3_FACE_IMAGE)>();

  /// @brief Initializes a DetectedFace object.
  /// @param phDetectedFace [in] Handle to the DetectedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_Initialize(
    ffi.Pointer<ID3_DETECTED_FACE> phDetectedFace,
  ) {
    return _id3DetectedFace_Initialize(
      phDetectedFace,
    );
  }

  late final _id3DetectedFace_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DETECTED_FACE>)>>(
      'id3DetectedFace_Initialize');
  late final _id3DetectedFace_Initialize = _id3DetectedFace_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_DETECTED_FACE>)>();

  /// @brief Releases the memory allocated for a DetectedFace.
  /// @param phDetectedFace [in] Handle to the DetectedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_Dispose(
    ffi.Pointer<ID3_DETECTED_FACE> phDetectedFace,
  ) {
    return _id3DetectedFace_Dispose(
      phDetectedFace,
    );
  }

  late final _id3DetectedFace_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DETECTED_FACE>)>>(
      'id3DetectedFace_Dispose');
  late final _id3DetectedFace_Dispose = _id3DetectedFace_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DETECTED_FACE>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_CheckHandle(
    ID3_DETECTED_FACE hDetectedFace,
  ) {
    return _id3DetectedFace_CheckHandle(
      hDetectedFace,
    );
  }

  late final _id3DetectedFace_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DETECTED_FACE)>>(
          'id3DetectedFace_CheckHandle');
  late final _id3DetectedFace_CheckHandle = _id3DetectedFace_CheckHandlePtr
      .asFunction<int Function(ID3_DETECTED_FACE)>();

  /// @brief Copies an instance of DetectedFace object to another.
  /// @param hDetectedFaceSrc [in] Handle to the source DetectedFace object.
  /// @param hDetectedFaceDst [in] Handle to the destination DetectedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_CopyTo(
    ID3_DETECTED_FACE hDetectedFaceSrc,
    ID3_DETECTED_FACE hDetectedFaceDst,
  ) {
    return _id3DetectedFace_CopyTo(
      hDetectedFaceSrc,
      hDetectedFaceDst,
    );
  }

  late final _id3DetectedFace_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DETECTED_FACE, ID3_DETECTED_FACE)>>('id3DetectedFace_CopyTo');
  late final _id3DetectedFace_CopyTo = _id3DetectedFace_CopyToPtr
      .asFunction<int Function(ID3_DETECTED_FACE, ID3_DETECTED_FACE)>();

  /// Gets the bounds of the detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param sBounds [out] Bounds of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetBounds(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FaceRectangle> sBounds,
  ) {
    return _id3DetectedFace_GetBounds(
      hDetectedFace,
      sBounds,
    );
  }

  late final _id3DetectedFace_GetBoundsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ffi.Pointer<id3FaceRectangle>)>>('id3DetectedFace_GetBounds');
  late final _id3DetectedFace_GetBounds =
      _id3DetectedFace_GetBoundsPtr.asFunction<
          int Function(ID3_DETECTED_FACE, ffi.Pointer<id3FaceRectangle>)>();

  /// Sets the bounds of the detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param sBounds [in] Bounds of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_SetBounds(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FaceRectangle> sBounds,
  ) {
    return _id3DetectedFace_SetBounds(
      hDetectedFace,
      sBounds,
    );
  }

  late final _id3DetectedFace_SetBoundsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ffi.Pointer<id3FaceRectangle>)>>('id3DetectedFace_SetBounds');
  late final _id3DetectedFace_SetBounds =
      _id3DetectedFace_SetBoundsPtr.asFunction<
          int Function(ID3_DETECTED_FACE, ffi.Pointer<id3FaceRectangle>)>();

  /// Gets the confidence score of the detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param detectionScore [out] Confidence score of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetDetectionScore(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> detectionScore,
  ) {
    return _id3DetectedFace_GetDetectionScore(
      hDetectedFace,
      detectionScore,
    );
  }

  late final _id3DetectedFace_GetDetectionScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3DetectedFace_GetDetectionScore');
  late final _id3DetectedFace_GetDetectionScore =
      _id3DetectedFace_GetDetectionScorePtr
          .asFunction<int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.Int>)>();

  /// Gets the ID of the detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param id [out] ID of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetId(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> id,
  ) {
    return _id3DetectedFace_GetId(
      hDetectedFace,
      id,
    );
  }

  late final _id3DetectedFace_GetIdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3DetectedFace_GetId');
  late final _id3DetectedFace_GetId = _id3DetectedFace_GetIdPtr
      .asFunction<int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.Int>)>();

  /// Sets the ID of the detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param id [in] ID of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_SetId(
    ID3_DETECTED_FACE hDetectedFace,
    int id,
  ) {
    return _id3DetectedFace_SetId(
      hDetectedFace,
      id,
    );
  }

  late final _id3DetectedFace_SetIdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DETECTED_FACE, ffi.Int)>>(
          'id3DetectedFace_SetId');
  late final _id3DetectedFace_SetId = _id3DetectedFace_SetIdPtr
      .asFunction<int Function(ID3_DETECTED_FACE, int)>();

  /// Gets the landmarks (eyes, nose and mouth corners) of the detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param hLandmarks [out] Landmarks (eyes, nose and mouth corners) of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetLandmarks(
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3DetectedFace_GetLandmarks(
      hDetectedFace,
      hLandmarks,
    );
  }

  late final _id3DetectedFace_GetLandmarksPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST)>>('id3DetectedFace_GetLandmarks');
  late final _id3DetectedFace_GetLandmarks = _id3DetectedFace_GetLandmarksPtr
      .asFunction<int Function(ID3_DETECTED_FACE, ID3_FACE_POINT_LIST)>();

  /// Sets the landmarks (eyes, nose and mouth corners) of the detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param hLandmarks [in] Landmarks (eyes, nose and mouth corners) of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_SetLandmarks(
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3DetectedFace_SetLandmarks(
      hDetectedFace,
      hLandmarks,
    );
  }

  late final _id3DetectedFace_SetLandmarksPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST)>>('id3DetectedFace_SetLandmarks');
  late final _id3DetectedFace_SetLandmarks = _id3DetectedFace_SetLandmarksPtr
      .asFunction<int Function(ID3_DETECTED_FACE, ID3_FACE_POINT_LIST)>();

  /// Creates a detected face.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param sBounds [in] Bounds of the detected face.
  /// @param detectionScore [in] Confidence score of the detected face.
  /// @param id [in] ID of the detected face.
  /// @param hLandmarks [in] Landmarks (eyes, nose and mouth corners) of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_Create(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FaceRectangle> sBounds,
    int detectionScore,
    int id,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3DetectedFace_Create(
      hDetectedFace,
      sBounds,
      detectionScore,
      id,
      hLandmarks,
    );
  }

  late final _id3DetectedFace_CreatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DETECTED_FACE,
              ffi.Pointer<id3FaceRectangle>,
              ffi.Int,
              ffi.Int,
              ID3_FACE_POINT_LIST)>>('id3DetectedFace_Create');
  late final _id3DetectedFace_Create = _id3DetectedFace_CreatePtr.asFunction<
      int Function(ID3_DETECTED_FACE, ffi.Pointer<id3FaceRectangle>, int, int,
          ID3_FACE_POINT_LIST)>();

  /// Imports the face object from a buffer.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param data [in] Buffer to import the face object from.
  /// @param dataSize [in] Size of the 'data' buffer.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_FromBuffer(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.UnsignedChar> data,
    int dataSize,
  ) {
    return _id3DetectedFace_FromBuffer(
      hDetectedFace,
      data,
      dataSize,
    );
  }

  late final _id3DetectedFace_FromBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int)>>('id3DetectedFace_FromBuffer');
  late final _id3DetectedFace_FromBuffer =
      _id3DetectedFace_FromBufferPtr.asFunction<
          int Function(
              ID3_DETECTED_FACE, ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Imports the face object from a file.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param path [in] Path to the file to import the face object from.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_FromFile(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3DetectedFace_FromFile(
      hDetectedFace,
      path,
    );
  }

  late final _id3DetectedFace_FromFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Char>)>>('id3DetectedFace_FromFile');
  late final _id3DetectedFace_FromFile = _id3DetectedFace_FromFilePtr
      .asFunction<int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.Char>)>();

  /// Gets the distance between the detected face and the camera when using a depth map in pixels.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param hDepthImage [in] Depth image to process.
  /// @param distanceToCamera [out] The estimated distance to camera in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetDistanceToCamera(
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_IMAGE hDepthImage,
    ffi.Pointer<ffi.Int> distanceToCamera,
  ) {
    return _id3DetectedFace_GetDistanceToCamera(
      hDetectedFace,
      hDepthImage,
      distanceToCamera,
    );
  }

  late final _id3DetectedFace_GetDistanceToCameraPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE, ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3DetectedFace_GetDistanceToCamera');
  late final _id3DetectedFace_GetDistanceToCamera =
      _id3DetectedFace_GetDistanceToCameraPtr.asFunction<
          int Function(
              ID3_DETECTED_FACE, ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the bounding box around the detected face with specified aspect ratio and specified margin.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param aspectRatio [in] Aspect ratio of the bounding box. Default recommended value is 1.33 (4/3).
  /// @param margin [in] Relative margin around the detected face. Recommended value is 0.5.
  /// @param sPortraitBounds [out] The portrait bounds.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetExpandedBounds(
    ID3_DETECTED_FACE hDetectedFace,
    double aspectRatio,
    double margin,
    ffi.Pointer<id3FaceRectangle> sPortraitBounds,
  ) {
    return _id3DetectedFace_GetExpandedBounds(
      hDetectedFace,
      aspectRatio,
      margin,
      sPortraitBounds,
    );
  }

  late final _id3DetectedFace_GetExpandedBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DETECTED_FACE, ffi.Float, ffi.Float,
                  ffi.Pointer<id3FaceRectangle>)>>(
      'id3DetectedFace_GetExpandedBounds');
  late final _id3DetectedFace_GetExpandedBounds =
      _id3DetectedFace_GetExpandedBoundsPtr.asFunction<
          int Function(ID3_DETECTED_FACE, double, double,
              ffi.Pointer<id3FaceRectangle>)>();

  /// Gets the distance between the eyes (IOD) of the detected face in pixels.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param iod [out] The computed interocular distance (IOD) in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetInterocularDistance(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> iod,
  ) {
    return _id3DetectedFace_GetInterocularDistance(
      hDetectedFace,
      iod,
    );
  }

  late final _id3DetectedFace_GetInterocularDistancePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3DetectedFace_GetInterocularDistance');
  late final _id3DetectedFace_GetInterocularDistance =
      _id3DetectedFace_GetInterocularDistancePtr
          .asFunction<int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.Int>)>();

  /// Gets the bounding box of the detected face for ICAO portrait cropping.
  /// This method shall be used to ensure compliance with the ICAO standard.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param eyeImageWidthRatio [in] Ratio between eye distance and image width. Must be in the range ]0;1[. Default recommended value is 0.25.
  /// @param eyeImageHeightRatio [in] Ratio between eye distance to top and image height. Must be in the range ]0;1[. Default recommended value is 0.45.
  /// @param imageRatio [in] Ratio between image height and image width. Default recommended value is 1.33 (4/3).
  /// @param sPortraitBounds [out] The portrait bounds of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_GetPortraitBounds(
    ID3_DETECTED_FACE hDetectedFace,
    double eyeImageWidthRatio,
    double eyeImageHeightRatio,
    double imageRatio,
    ffi.Pointer<id3FaceRectangle> sPortraitBounds,
  ) {
    return _id3DetectedFace_GetPortraitBounds(
      hDetectedFace,
      eyeImageWidthRatio,
      eyeImageHeightRatio,
      imageRatio,
      sPortraitBounds,
    );
  }

  late final _id3DetectedFace_GetPortraitBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DETECTED_FACE, ffi.Float, ffi.Float,
                  ffi.Float, ffi.Pointer<id3FaceRectangle>)>>(
      'id3DetectedFace_GetPortraitBounds');
  late final _id3DetectedFace_GetPortraitBounds =
      _id3DetectedFace_GetPortraitBoundsPtr.asFunction<
          int Function(ID3_DETECTED_FACE, double, double, double,
              ffi.Pointer<id3FaceRectangle>)>();

  /// Rescales the detected face object bounding box and landmarks. This function can be useful if the image was downscaled to speed up detection, then you need to upscale the detected face to fit the source image size.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param scale [in] The multiplicative rescaling factor to apply to the face object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_Rescale(
    ID3_DETECTED_FACE hDetectedFace,
    double scale,
  ) {
    return _id3DetectedFace_Rescale(
      hDetectedFace,
      scale,
    );
  }

  late final _id3DetectedFace_RescalePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DETECTED_FACE, ffi.Float)>>(
      'id3DetectedFace_Rescale');
  late final _id3DetectedFace_Rescale = _id3DetectedFace_RescalePtr
      .asFunction<int Function(ID3_DETECTED_FACE, double)>();

  /// Rotates the face object by a given angle in degrees from a given center.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param angle [in] Angle of the rotation to apply to the face object.
  /// @param sCenter [in] Center of the rotation to apply to the face object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_Rotate(
    ID3_DETECTED_FACE hDetectedFace,
    int angle,
    ffi.Pointer<id3FacePoint> sCenter,
  ) {
    return _id3DetectedFace_Rotate(
      hDetectedFace,
      angle,
      sCenter,
    );
  }

  late final _id3DetectedFace_RotatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE, ffi.Int,
              ffi.Pointer<id3FacePoint>)>>('id3DetectedFace_Rotate');
  late final _id3DetectedFace_Rotate = _id3DetectedFace_RotatePtr.asFunction<
      int Function(ID3_DETECTED_FACE, int, ffi.Pointer<id3FacePoint>)>();

  /// Exports the face object to a buffer.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param data [out] The buffer to which the face object is exported.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_ToBuffer(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3DetectedFace_ToBuffer(
      hDetectedFace,
      data,
      dataSize,
    );
  }

  late final _id3DetectedFace_ToBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3DetectedFace_ToBuffer');
  late final _id3DetectedFace_ToBuffer =
      _id3DetectedFace_ToBufferPtr.asFunction<
          int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Saves the face object to a file.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param path [in] Path to the file to export the face object to.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_ToFile(
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3DetectedFace_ToFile(
      hDetectedFace,
      path,
    );
  }

  late final _id3DetectedFace_ToFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Char>)>>('id3DetectedFace_ToFile');
  late final _id3DetectedFace_ToFile = _id3DetectedFace_ToFilePtr
      .asFunction<int Function(ID3_DETECTED_FACE, ffi.Pointer<ffi.Char>)>();

  /// Translates the face object.
  /// @param hDetectedFace [in] Handle to the DetectedFace object.
  /// @param tx [in] Translation to apply to the face object alongside the x-axis.
  /// @param ty [in] Translation to apply to the face object alongside the y-axis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFace_Translate(
    ID3_DETECTED_FACE hDetectedFace,
    int tx,
    int ty,
  ) {
    return _id3DetectedFace_Translate(
      hDetectedFace,
      tx,
      ty,
    );
  }

  late final _id3DetectedFace_TranslatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE, ffi.Int,
              ffi.Int)>>('id3DetectedFace_Translate');
  late final _id3DetectedFace_Translate = _id3DetectedFace_TranslatePtr
      .asFunction<int Function(ID3_DETECTED_FACE, int, int)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceAttackSupportString(
    int value,
  ) {
    return _id3Face_GetFaceAttackSupportString(
      value,
    );
  }

  late final _id3Face_GetFaceAttackSupportStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceAttackSupportString');
  late final _id3Face_GetFaceAttackSupportString =
      _id3Face_GetFaceAttackSupportStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a DetectedFaceList object.
  /// @param phDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_Initialize(
    ffi.Pointer<ID3_DETECTED_FACE_LIST> phDetectedFaceList,
  ) {
    return _id3DetectedFaceList_Initialize(
      phDetectedFaceList,
    );
  }

  late final _id3DetectedFaceList_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DETECTED_FACE_LIST>)>>(
      'id3DetectedFaceList_Initialize');
  late final _id3DetectedFaceList_Initialize =
      _id3DetectedFaceList_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DETECTED_FACE_LIST>)>();

  /// @brief Releases the memory allocated for a DetectedFaceList.
  /// @param phDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_Dispose(
    ffi.Pointer<ID3_DETECTED_FACE_LIST> phDetectedFaceList,
  ) {
    return _id3DetectedFaceList_Dispose(
      phDetectedFaceList,
    );
  }

  late final _id3DetectedFaceList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DETECTED_FACE_LIST>)>>(
      'id3DetectedFaceList_Dispose');
  late final _id3DetectedFaceList_Dispose = _id3DetectedFaceList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DETECTED_FACE_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_CheckHandle(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
  ) {
    return _id3DetectedFaceList_CheckHandle(
      hDetectedFaceList,
    );
  }

  late final _id3DetectedFaceList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DETECTED_FACE_LIST)>>(
          'id3DetectedFaceList_CheckHandle');
  late final _id3DetectedFaceList_CheckHandle =
      _id3DetectedFaceList_CheckHandlePtr
          .asFunction<int Function(ID3_DETECTED_FACE_LIST)>();

  /// @brief Copies an instance of DetectedFaceList object to another.
  /// @param hDetectedFaceListSrc [in] Handle to the source DetectedFaceList object.
  /// @param hDetectedFaceListDst [in] Handle to the destination DetectedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_CopyTo(
    ID3_DETECTED_FACE_LIST hDetectedFaceListSrc,
    ID3_DETECTED_FACE_LIST hDetectedFaceListDst,
  ) {
    return _id3DetectedFaceList_CopyTo(
      hDetectedFaceListSrc,
      hDetectedFaceListDst,
    );
  }

  late final _id3DetectedFaceList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST,
              ID3_DETECTED_FACE_LIST)>>('id3DetectedFaceList_CopyTo');
  late final _id3DetectedFaceList_CopyTo =
      _id3DetectedFaceList_CopyToPtr.asFunction<
          int Function(ID3_DETECTED_FACE_LIST, ID3_DETECTED_FACE_LIST)>();

  /// Clears the DetectedFaceList object.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_Clear(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
  ) {
    return _id3DetectedFaceList_Clear(
      hDetectedFaceList,
    );
  }

  late final _id3DetectedFaceList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DETECTED_FACE_LIST)>>(
          'id3DetectedFaceList_Clear');
  late final _id3DetectedFaceList_Clear = _id3DetectedFaceList_ClearPtr
      .asFunction<int Function(ID3_DETECTED_FACE_LIST)>();

  /// Adds an item to the DetectedFaceList object.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param hDetectedFaceItem [in] DetectedFace item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_Add(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    ID3_DETECTED_FACE hDetectedFaceItem,
  ) {
    return _id3DetectedFaceList_Add(
      hDetectedFaceList,
      hDetectedFaceItem,
    );
  }

  late final _id3DetectedFaceList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST,
              ID3_DETECTED_FACE)>>('id3DetectedFaceList_Add');
  late final _id3DetectedFaceList_Add = _id3DetectedFaceList_AddPtr
      .asFunction<int Function(ID3_DETECTED_FACE_LIST, ID3_DETECTED_FACE)>();

  /// Gets an item of the DetectedFaceList object.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param index [in] Index of the DetectedFace item to get.
  /// @param hDetectedFaceItem [out] DetectedFace item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_Get(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    int index,
    ID3_DETECTED_FACE hDetectedFaceItem,
  ) {
    return _id3DetectedFaceList_Get(
      hDetectedFaceList,
      index,
      hDetectedFaceItem,
    );
  }

  late final _id3DetectedFaceList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST, ffi.Int,
              ID3_DETECTED_FACE)>>('id3DetectedFaceList_Get');
  late final _id3DetectedFaceList_Get = _id3DetectedFaceList_GetPtr.asFunction<
      int Function(ID3_DETECTED_FACE_LIST, int, ID3_DETECTED_FACE)>();

  /// Sets an item of the DetectedFaceList object.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param index [in] Index of the DetectedFace item to set.
  /// @param hDetectedFaceItem [in] DetectedFace item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_Set(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    int index,
    ID3_DETECTED_FACE hDetectedFaceItem,
  ) {
    return _id3DetectedFaceList_Set(
      hDetectedFaceList,
      index,
      hDetectedFaceItem,
    );
  }

  late final _id3DetectedFaceList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST, ffi.Int,
              ID3_DETECTED_FACE)>>('id3DetectedFaceList_Set');
  late final _id3DetectedFaceList_Set = _id3DetectedFaceList_SetPtr.asFunction<
      int Function(ID3_DETECTED_FACE_LIST, int, ID3_DETECTED_FACE)>();

  /// Gets the number of elements in the DetectedFaceList object.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param count [out] Number of elements in the DetectedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_GetCount(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DetectedFaceList_GetCount(
      hDetectedFaceList,
      count,
    );
  }

  late final _id3DetectedFaceList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST,
              ffi.Pointer<ffi.Int>)>>('id3DetectedFaceList_GetCount');
  late final _id3DetectedFaceList_GetCount = _id3DetectedFaceList_GetCountPtr
      .asFunction<int Function(ID3_DETECTED_FACE_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the DetectedFaceList object.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param index [in] Index of the DetectedFace item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_RemoveAt(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    int index,
  ) {
    return _id3DetectedFaceList_RemoveAt(
      hDetectedFaceList,
      index,
    );
  }

  late final _id3DetectedFaceList_RemoveAtPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DETECTED_FACE_LIST, ffi.Int)>>(
      'id3DetectedFaceList_RemoveAt');
  late final _id3DetectedFaceList_RemoveAt = _id3DetectedFaceList_RemoveAtPtr
      .asFunction<int Function(ID3_DETECTED_FACE_LIST, int)>();

  /// DetectedFaceList object.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param newSize [in] DetectedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_Resize(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    int newSize,
  ) {
    return _id3DetectedFaceList_Resize(
      hDetectedFaceList,
      newSize,
    );
  }

  late final _id3DetectedFaceList_ResizePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DETECTED_FACE_LIST, ffi.Int)>>(
      'id3DetectedFaceList_Resize');
  late final _id3DetectedFaceList_Resize = _id3DetectedFaceList_ResizePtr
      .asFunction<int Function(ID3_DETECTED_FACE_LIST, int)>();

  /// Finds a detected face by ID.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param id [in] ID of the detected face to find in the list.
  /// @param hDetectedFace [out] The found detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_FindDetectedFace(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    int id,
    ID3_DETECTED_FACE hDetectedFace,
  ) {
    return _id3DetectedFaceList_FindDetectedFace(
      hDetectedFaceList,
      id,
      hDetectedFace,
    );
  }

  late final _id3DetectedFaceList_FindDetectedFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST, ffi.Int,
              ID3_DETECTED_FACE)>>('id3DetectedFaceList_FindDetectedFace');
  late final _id3DetectedFaceList_FindDetectedFace =
      _id3DetectedFaceList_FindDetectedFacePtr.asFunction<
          int Function(ID3_DETECTED_FACE_LIST, int, ID3_DETECTED_FACE)>();

  /// Gets the list of IDs in the list.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param ids [out] The list of IDs in the list.
  /// @param idsSize [in,out] Size of the 'ids' buffer. Receives the number of elements in the 'ids' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_GetIdList(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    ffi.Pointer<ffi.Int> ids,
    ffi.Pointer<ffi.Int> idsSize,
  ) {
    return _id3DetectedFaceList_GetIdList(
      hDetectedFaceList,
      ids,
      idsSize,
    );
  }

  late final _id3DetectedFaceList_GetIdListPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>>('id3DetectedFaceList_GetIdList');
  late final _id3DetectedFaceList_GetIdList =
      _id3DetectedFaceList_GetIdListPtr.asFunction<
          int Function(ID3_DETECTED_FACE_LIST, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the largest face in the list.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param hLargestFace [out] The largest detected face in the list.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_GetLargestFace(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    ID3_DETECTED_FACE hLargestFace,
  ) {
    return _id3DetectedFaceList_GetLargestFace(
      hDetectedFaceList,
      hLargestFace,
    );
  }

  late final _id3DetectedFaceList_GetLargestFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_FACE_LIST,
              ID3_DETECTED_FACE)>>('id3DetectedFaceList_GetLargestFace');
  late final _id3DetectedFaceList_GetLargestFace =
      _id3DetectedFaceList_GetLargestFacePtr.asFunction<
          int Function(ID3_DETECTED_FACE_LIST, ID3_DETECTED_FACE)>();

  /// Rescales all detected faces in the list.
  /// @param hDetectedFaceList [in] Handle to the DetectedFaceList object.
  /// @param scale [in] Scale factor to apply. Range is [0;+inf[.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3DetectedFaceList_RescaleAll(
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
    double scale,
  ) {
    return _id3DetectedFaceList_RescaleAll(
      hDetectedFaceList,
      scale,
    );
  }

  late final _id3DetectedFaceList_RescaleAllPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DETECTED_FACE_LIST, ffi.Float)>>(
      'id3DetectedFaceList_RescaleAll');
  late final _id3DetectedFaceList_RescaleAll =
      _id3DetectedFaceList_RescaleAllPtr
          .asFunction<int Function(ID3_DETECTED_FACE_LIST, double)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceExpressionString(
    int value,
  ) {
    return _id3Face_GetFaceExpressionString(
      value,
    );
  }

  late final _id3Face_GetFaceExpressionStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceExpressionString');
  late final _id3Face_GetFaceExpressionString =
      _id3Face_GetFaceExpressionStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a FaceAnalyser object.
  /// @param phFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_Initialize(
    ffi.Pointer<ID3_FACE_ANALYSER> phFaceAnalyser,
  ) {
    return _id3FaceAnalyser_Initialize(
      phFaceAnalyser,
    );
  }

  late final _id3FaceAnalyser_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_ANALYSER>)>>(
      'id3FaceAnalyser_Initialize');
  late final _id3FaceAnalyser_Initialize = _id3FaceAnalyser_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_ANALYSER>)>();

  /// @brief Releases the memory allocated for a FaceAnalyser.
  /// @param phFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_Dispose(
    ffi.Pointer<ID3_FACE_ANALYSER> phFaceAnalyser,
  ) {
    return _id3FaceAnalyser_Dispose(
      phFaceAnalyser,
    );
  }

  late final _id3FaceAnalyser_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_ANALYSER>)>>(
      'id3FaceAnalyser_Dispose');
  late final _id3FaceAnalyser_Dispose = _id3FaceAnalyser_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_ANALYSER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_CheckHandle(
    ID3_FACE_ANALYSER hFaceAnalyser,
  ) {
    return _id3FaceAnalyser_CheckHandle(
      hFaceAnalyser,
    );
  }

  late final _id3FaceAnalyser_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ANALYSER)>>(
          'id3FaceAnalyser_CheckHandle');
  late final _id3FaceAnalyser_CheckHandle = _id3FaceAnalyser_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_ANALYSER)>();

  /// Gets the sensibility of the expression classifier.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be less likely to estimate neutral expression out of the detected face.
  /// Hint: Default value is 60.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param expressionSensibility [out] Sensibility of the expression classifier.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_GetExpressionSensibility(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ffi.Pointer<ffi.Int> expressionSensibility,
  ) {
    return _id3FaceAnalyser_GetExpressionSensibility(
      hFaceAnalyser,
      expressionSensibility,
    );
  }

  late final _id3FaceAnalyser_GetExpressionSensibilityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_ANALYSER, ffi.Pointer<ffi.Int>)>>(
      'id3FaceAnalyser_GetExpressionSensibility');
  late final _id3FaceAnalyser_GetExpressionSensibility =
      _id3FaceAnalyser_GetExpressionSensibilityPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, ffi.Pointer<ffi.Int>)>();

  /// Sets the sensibility of the expression classifier.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be less likely to estimate neutral expression out of the detected face.
  /// Hint: Default value is 60.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param expressionSensibility [in] Sensibility of the expression classifier.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_SetExpressionSensibility(
    ID3_FACE_ANALYSER hFaceAnalyser,
    int expressionSensibility,
  ) {
    return _id3FaceAnalyser_SetExpressionSensibility(
      hFaceAnalyser,
      expressionSensibility,
    );
  }

  late final _id3FaceAnalyser_SetExpressionSensibilityPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ANALYSER, ffi.Int)>>(
          'id3FaceAnalyser_SetExpressionSensibility');
  late final _id3FaceAnalyser_SetExpressionSensibility =
      _id3FaceAnalyser_SetExpressionSensibilityPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, int)>();

  /// Gets the sensibility of the over-exposure classifier, from 0 to 255.
  /// The lower the value, the more sensitive the algorithm will be, meaning that it will be more likely to estimate over-exposed face images.
  /// Hint: Default value is 188.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param overExposureSensibility [out] Sensibility of the over-exposure classifier, from 0 to 255.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_GetOverExposureSensibility(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ffi.Pointer<ffi.Int> overExposureSensibility,
  ) {
    return _id3FaceAnalyser_GetOverExposureSensibility(
      hFaceAnalyser,
      overExposureSensibility,
    );
  }

  late final _id3FaceAnalyser_GetOverExposureSensibilityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_ANALYSER, ffi.Pointer<ffi.Int>)>>(
      'id3FaceAnalyser_GetOverExposureSensibility');
  late final _id3FaceAnalyser_GetOverExposureSensibility =
      _id3FaceAnalyser_GetOverExposureSensibilityPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, ffi.Pointer<ffi.Int>)>();

  /// Sets the sensibility of the over-exposure classifier, from 0 to 255.
  /// The lower the value, the more sensitive the algorithm will be, meaning that it will be more likely to estimate over-exposed face images.
  /// Hint: Default value is 188.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param overExposureSensibility [in] Sensibility of the over-exposure classifier, from 0 to 255.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_SetOverExposureSensibility(
    ID3_FACE_ANALYSER hFaceAnalyser,
    int overExposureSensibility,
  ) {
    return _id3FaceAnalyser_SetOverExposureSensibility(
      hFaceAnalyser,
      overExposureSensibility,
    );
  }

  late final _id3FaceAnalyser_SetOverExposureSensibilityPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ANALYSER, ffi.Int)>>(
          'id3FaceAnalyser_SetOverExposureSensibility');
  late final _id3FaceAnalyser_SetOverExposureSensibility =
      _id3FaceAnalyser_SetOverExposureSensibilityPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, int)>();

  /// Gets the number of threads to be used for face analysis.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param threadCount [out] Number of threads to be used for face analysis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_GetThreadCount(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3FaceAnalyser_GetThreadCount(
      hFaceAnalyser,
      threadCount,
    );
  }

  late final _id3FaceAnalyser_GetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER,
              ffi.Pointer<ffi.Int>)>>('id3FaceAnalyser_GetThreadCount');
  late final _id3FaceAnalyser_GetThreadCount =
      _id3FaceAnalyser_GetThreadCountPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to be used for face analysis.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param threadCount [in] Number of threads to be used for face analysis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_SetThreadCount(
    ID3_FACE_ANALYSER hFaceAnalyser,
    int threadCount,
  ) {
    return _id3FaceAnalyser_SetThreadCount(
      hFaceAnalyser,
      threadCount,
    );
  }

  late final _id3FaceAnalyser_SetThreadCountPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ANALYSER, ffi.Int)>>(
          'id3FaceAnalyser_SetThreadCount');
  late final _id3FaceAnalyser_SetThreadCount =
      _id3FaceAnalyser_SetThreadCountPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, int)>();

  /// Gets the sensibility of the under-exposure classifier, from 0 to 255.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be more likely to estimate under-exposed face images.
  /// Hint: Default value is 66.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param underExposureSensibility [out] Sensibility of the under-exposure classifier, from 0 to 255.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_GetUnderExposureSensibility(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ffi.Pointer<ffi.Int> underExposureSensibility,
  ) {
    return _id3FaceAnalyser_GetUnderExposureSensibility(
      hFaceAnalyser,
      underExposureSensibility,
    );
  }

  late final _id3FaceAnalyser_GetUnderExposureSensibilityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_ANALYSER, ffi.Pointer<ffi.Int>)>>(
      'id3FaceAnalyser_GetUnderExposureSensibility');
  late final _id3FaceAnalyser_GetUnderExposureSensibility =
      _id3FaceAnalyser_GetUnderExposureSensibilityPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, ffi.Pointer<ffi.Int>)>();

  /// Sets the sensibility of the under-exposure classifier, from 0 to 255.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be more likely to estimate under-exposed face images.
  /// Hint: Default value is 66.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param underExposureSensibility [in] Sensibility of the under-exposure classifier, from 0 to 255.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_SetUnderExposureSensibility(
    ID3_FACE_ANALYSER hFaceAnalyser,
    int underExposureSensibility,
  ) {
    return _id3FaceAnalyser_SetUnderExposureSensibility(
      hFaceAnalyser,
      underExposureSensibility,
    );
  }

  late final _id3FaceAnalyser_SetUnderExposureSensibilityPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ANALYSER, ffi.Int)>>(
          'id3FaceAnalyser_SetUnderExposureSensibility');
  late final _id3FaceAnalyser_SetUnderExposureSensibility =
      _id3FaceAnalyser_SetUnderExposureSensibilityPtr
          .asFunction<int Function(ID3_FACE_ANALYSER, int)>();

  /// Applies an alpha mask to suppress the background and returns a 32-bit BGRA image.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hMask [in] Mask of segmented face.
  /// @param hSegmentedFace [out] The output image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ApplyAlphaMask(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_FACE_IMAGE hMask,
    ID3_FACE_IMAGE hSegmentedFace,
  ) {
    return _id3FaceAnalyser_ApplyAlphaMask(
      hFaceAnalyser,
      hImage,
      hMask,
      hSegmentedFace,
    );
  }

  late final _id3FaceAnalyser_ApplyAlphaMaskPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_FACE_IMAGE,
              ID3_FACE_IMAGE)>>('id3FaceAnalyser_ApplyAlphaMask');
  late final _id3FaceAnalyser_ApplyAlphaMask =
      _id3FaceAnalyser_ApplyAlphaMaskPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_FACE_IMAGE,
              ID3_FACE_IMAGE)>();

  /// Applies a mask to replace the background with the specified color and returns a 24-bit BGR image.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hMask [in] Mask to be applied. Must be a 8-bit greyscale image of same size as the input image.
  /// @param red [in] Green channel of the background color. Must be a value from 0 to 255.
  /// @param green [in] Red channel of the background color. Must be a value from 0 to 255.
  /// @param blue [in] Blue channel of the background color. Must be a value from 0 to 255.
  /// @param hSegmentedFace [out] The output image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ApplyMask(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_FACE_IMAGE hMask,
    int red,
    int green,
    int blue,
    ID3_FACE_IMAGE hSegmentedFace,
  ) {
    return _id3FaceAnalyser_ApplyMask(
      hFaceAnalyser,
      hImage,
      hMask,
      red,
      green,
      blue,
      hSegmentedFace,
    );
  }

  late final _id3FaceAnalyser_ApplyMaskPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_ANALYSER,
              ID3_FACE_IMAGE,
              ID3_FACE_IMAGE,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ID3_FACE_IMAGE)>>('id3FaceAnalyser_ApplyMask');
  late final _id3FaceAnalyser_ApplyMask =
      _id3FaceAnalyser_ApplyMaskPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_FACE_IMAGE, int,
              int, int, ID3_FACE_IMAGE)>();

  /// Verifies if an image is colorized or grayscale.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param isColorized [out] The boolean decision: True if colorized, False if grayscale.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_CheckColorizedImage(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Bool> isColorized,
  ) {
    return _id3FaceAnalyser_CheckColorizedImage(
      hFaceAnalyser,
      hImage,
      isColorized,
    );
  }

  late final _id3FaceAnalyser_CheckColorizedImagePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Bool>)>>('id3FaceAnalyser_CheckColorizedImage');
  late final _id3FaceAnalyser_CheckColorizedImage =
      _id3FaceAnalyser_CheckColorizedImagePtr.asFunction<
          int Function(
              ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ffi.Pointer<ffi.Bool>)>();

  /// Computes the age of a detected face.
  /// Important: Loading the ``FaceAgeEstimator`` model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param age [out] The estimated age of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeAge(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> age,
  ) {
    return _id3FaceAnalyser_ComputeAge(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      age,
    );
  }

  late final _id3FaceAnalyser_ComputeAgePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3FaceAnalyser_ComputeAge');
  late final _id3FaceAnalyser_ComputeAge =
      _id3FaceAnalyser_ComputeAgePtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>();

  /// Computes the attributes of a detected face.
  /// Important: Loading the model ``FaceAttributesClassifier`` is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param sAttributes [out] The estimated attributes of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeAttributes(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FaceAttributes> sAttributes,
  ) {
    return _id3FaceAnalyser_ComputeAttributes(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      sAttributes,
    );
  }

  late final _id3FaceAnalyser_ComputeAttributesPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE,
                  ID3_DETECTED_FACE, ffi.Pointer<id3FaceAttributes>)>>(
      'id3FaceAnalyser_ComputeAttributes');
  late final _id3FaceAnalyser_ComputeAttributes =
      _id3FaceAnalyser_ComputeAttributesPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<id3FaceAttributes>)>();

  /// Computes the background uniformity behind a detected face.
  /// This function must be used for a portrait image with only one face in it. A high uniformity score means that the background is uniform.
  /// Important: Loading the model ``FaceBackgroundUniformity`` is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param sBackgroundUniformity [out] The estimated background uniformity. Both color and texture scores are in the range [0:100]. The minimum recommended thresholds are respectively 80 for color and 80 for texture.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeBackgroundUniformity(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FaceBackgroundUniformity> sBackgroundUniformity,
  ) {
    return _id3FaceAnalyser_ComputeBackgroundUniformity(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      sBackgroundUniformity,
    );
  }

  late final _id3FaceAnalyser_ComputeBackgroundUniformityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_ANALYSER,
                  ID3_FACE_IMAGE,
                  ID3_DETECTED_FACE,
                  ffi.Pointer<id3FaceBackgroundUniformity>)>>(
      'id3FaceAnalyser_ComputeBackgroundUniformity');
  late final _id3FaceAnalyser_ComputeBackgroundUniformity =
      _id3FaceAnalyser_ComputeBackgroundUniformityPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<id3FaceBackgroundUniformity>)>();

  /// Computes the expression of a detected face.
  /// Important: Loading the ``FaceExpressionClassifier`` model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param eExpression [out] The estimated expression of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeExpression(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int32> eExpression,
  ) {
    return _id3FaceAnalyser_ComputeExpression(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      eExpression,
    );
  }

  late final _id3FaceAnalyser_ComputeExpressionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int32>)>>('id3FaceAnalyser_ComputeExpression');
  late final _id3FaceAnalyser_ComputeExpression =
      _id3FaceAnalyser_ComputeExpressionPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int32>)>();

  /// Computes the eye gaze of a detected face.
  /// Important: Loading the ``EyeGazeEstimator`` model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [in] Estimated landmarks of the detected face. Must be computed with the face analyser.
  /// @param sEyeGaze [out] The estimated gaze of left and right eyes of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeEyeGaze(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
    ffi.Pointer<id3FaceEyeGaze> sEyeGaze,
  ) {
    return _id3FaceAnalyser_ComputeEyeGaze(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      hLandmarks,
      sEyeGaze,
    );
  }

  late final _id3FaceAnalyser_ComputeEyeGazePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_ANALYSER,
              ID3_FACE_IMAGE,
              ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST,
              ffi.Pointer<id3FaceEyeGaze>)>>('id3FaceAnalyser_ComputeEyeGaze');
  late final _id3FaceAnalyser_ComputeEyeGaze =
      _id3FaceAnalyser_ComputeEyeGazePtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST, ffi.Pointer<id3FaceEyeGaze>)>();

  /// Computes the eye openness of a detected face.
  /// The minimum recommanded value for is 90.
  /// Important: Loading the ``EyeOpennessDetector`` model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [in] Estimated landmarks of the detected face. Must be computed with the face analyser.
  /// @param eyeOpennessScores [out] The estimated openness scores of left and right eyes of the detected face in this order.
  /// @param eyeOpennessScoresSize [in,out] Size of the 'eyeOpennessScores' buffer. Receives the number of elements in the 'eyeOpennessScores' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeEyeOpenness(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
    ffi.Pointer<ffi.Int> eyeOpennessScores,
    ffi.Pointer<ffi.Int> eyeOpennessScoresSize,
  ) {
    return _id3FaceAnalyser_ComputeEyeOpenness(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      hLandmarks,
      eyeOpennessScores,
      eyeOpennessScoresSize,
    );
  }

  late final _id3FaceAnalyser_ComputeEyeOpennessPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_ANALYSER,
              ID3_FACE_IMAGE,
              ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>>('id3FaceAnalyser_ComputeEyeOpenness');
  late final _id3FaceAnalyser_ComputeEyeOpenness =
      _id3FaceAnalyser_ComputeEyeOpennessPtr.asFunction<
          int Function(
              ID3_FACE_ANALYSER,
              ID3_FACE_IMAGE,
              ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>();

  /// Computes the eye redness of a detected face.
  /// The maximum recommanded value for an ICAO-compliant portrait is 10.
  /// Important: Loading the ``EyeRednessDetector`` model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [in] Estimated landmarks of the detected face. Must be computed with the face analyser.
  /// @param eyeRednessScores [out] The estimated redness scores of left and right eyes of the detected face in this order.
  /// @param eyeRednessScoresSize [in,out] Size of the 'eyeRednessScores' buffer. Receives the number of elements in the 'eyeRednessScores' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeEyeRedness(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
    ffi.Pointer<ffi.Int> eyeRednessScores,
    ffi.Pointer<ffi.Int> eyeRednessScoresSize,
  ) {
    return _id3FaceAnalyser_ComputeEyeRedness(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      hLandmarks,
      eyeRednessScores,
      eyeRednessScoresSize,
    );
  }

  late final _id3FaceAnalyser_ComputeEyeRednessPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_ANALYSER,
              ID3_FACE_IMAGE,
              ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>>('id3FaceAnalyser_ComputeEyeRedness');
  late final _id3FaceAnalyser_ComputeEyeRedness =
      _id3FaceAnalyser_ComputeEyeRednessPtr.asFunction<
          int Function(
              ID3_FACE_ANALYSER,
              ID3_FACE_IMAGE,
              ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>();

  /// Computes the geometric attributes of a detected face. This function must be used for a portrait image with only one face in it.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [in] Estimated landmarks of the detected face. Must be computed with the face analyser.
  /// @param sGeometricAttributes [out] The estimated geometric attributes of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeGeometricAttributes(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
    ffi.Pointer<id3FaceGeometricAttributes> sGeometricAttributes,
  ) {
    return _id3FaceAnalyser_ComputeGeometricAttributes(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      hLandmarks,
      sGeometricAttributes,
    );
  }

  late final _id3FaceAnalyser_ComputeGeometricAttributesPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_ANALYSER,
                  ID3_FACE_IMAGE,
                  ID3_DETECTED_FACE,
                  ID3_FACE_POINT_LIST,
                  ffi.Pointer<id3FaceGeometricAttributes>)>>(
      'id3FaceAnalyser_ComputeGeometricAttributes');
  late final _id3FaceAnalyser_ComputeGeometricAttributes =
      _id3FaceAnalyser_ComputeGeometricAttributesPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST, ffi.Pointer<id3FaceGeometricAttributes>)>();

  /// Computes the glasses attributes of a detected face. This function must be used for a portrait image with only one face in it.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [in] Estimated landmarks of the detected face. Must be computed with the face analyser.
  /// @param sGlassesAttributes [out] The estimated glasses attributes of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeGlassesAttributes(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
    ffi.Pointer<id3FaceGlassesAttributes> sGlassesAttributes,
  ) {
    return _id3FaceAnalyser_ComputeGlassesAttributes(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      hLandmarks,
      sGlassesAttributes,
    );
  }

  late final _id3FaceAnalyser_ComputeGlassesAttributesPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_ANALYSER,
                  ID3_FACE_IMAGE,
                  ID3_DETECTED_FACE,
                  ID3_FACE_POINT_LIST,
                  ffi.Pointer<id3FaceGlassesAttributes>)>>(
      'id3FaceAnalyser_ComputeGlassesAttributes');
  late final _id3FaceAnalyser_ComputeGlassesAttributes =
      _id3FaceAnalyser_ComputeGlassesAttributesPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST, ffi.Pointer<id3FaceGlassesAttributes>)>();

  /// Computes 68 landmarks of a detected face.
  /// Important: Loading the ``FaceLandmarksEstimator`` model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [out] The estimated landmarks of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeLandmarks(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3FaceAnalyser_ComputeLandmarks(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      hLandmarks,
    );
  }

  late final _id3FaceAnalyser_ComputeLandmarksPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST)>>('id3FaceAnalyser_ComputeLandmarks');
  late final _id3FaceAnalyser_ComputeLandmarks =
      _id3FaceAnalyser_ComputeLandmarksPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST)>();

  /// Measures the image noise.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param noiseScore [out] The estimated noise score. 0 means no noise, 100 means no signal.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputeNoise(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ffi.Pointer<ffi.Int> noiseScore,
  ) {
    return _id3FaceAnalyser_ComputeNoise(
      hFaceAnalyser,
      hImage,
      noiseScore,
    );
  }

  late final _id3FaceAnalyser_ComputeNoisePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3FaceAnalyser_ComputeNoise');
  late final _id3FaceAnalyser_ComputeNoise =
      _id3FaceAnalyser_ComputeNoisePtr.asFunction<
          int Function(
              ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Computes the photographic attributes of a detected face. This function must be used for a portrait image with only one face in it.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [in] Estimated landmarks of the detected face. Must be computed with the face analyser.
  /// @param sPhotographicAttributes [out] The estimated photographic attributes of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputePhotographicAttributes(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
    ffi.Pointer<id3FacePhotographicAttributes> sPhotographicAttributes,
  ) {
    return _id3FaceAnalyser_ComputePhotographicAttributes(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      hLandmarks,
      sPhotographicAttributes,
    );
  }

  late final _id3FaceAnalyser_ComputePhotographicAttributesPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_ANALYSER,
                  ID3_FACE_IMAGE,
                  ID3_DETECTED_FACE,
                  ID3_FACE_POINT_LIST,
                  ffi.Pointer<id3FacePhotographicAttributes>)>>(
      'id3FaceAnalyser_ComputePhotographicAttributes');
  late final _id3FaceAnalyser_ComputePhotographicAttributes =
      _id3FaceAnalyser_ComputePhotographicAttributesPtr.asFunction<
          int Function(
              ID3_FACE_ANALYSER,
              ID3_FACE_IMAGE,
              ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST,
              ffi.Pointer<id3FacePhotographicAttributes>)>();

  /// Computes the pose of a detected face.
  /// Important: Loading the ``FacePoseEstimator`` model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param sPose [out] The estimated pose of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputePose(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FacePose> sPose,
  ) {
    return _id3FaceAnalyser_ComputePose(
      hFaceAnalyser,
      hDetectedFace,
      sPose,
    );
  }

  late final _id3FaceAnalyser_ComputePosePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_DETECTED_FACE,
              ffi.Pointer<id3FacePose>)>>('id3FaceAnalyser_ComputePose');
  late final _id3FaceAnalyser_ComputePose =
      _id3FaceAnalyser_ComputePosePtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_DETECTED_FACE,
              ffi.Pointer<id3FacePose>)>();

  /// Computes the pose of a detected face using the specified 68-point landmarks.
  /// Loading the model ``FacePoseEstimator1A`` is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hLandmarks [in] Estimated landmarks of the detected face. Must be computed with the face analyser.
  /// @param sPose [out] The estimated pose of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_ComputePoseWithLandmarks(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_POINT_LIST hLandmarks,
    ffi.Pointer<id3FacePose> sPose,
  ) {
    return _id3FaceAnalyser_ComputePoseWithLandmarks(
      hFaceAnalyser,
      hDetectedFace,
      hLandmarks,
      sPose,
    );
  }

  late final _id3FaceAnalyser_ComputePoseWithLandmarksPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_ANALYSER, ID3_DETECTED_FACE,
                  ID3_FACE_POINT_LIST, ffi.Pointer<id3FacePose>)>>(
      'id3FaceAnalyser_ComputePoseWithLandmarks');
  late final _id3FaceAnalyser_ComputePoseWithLandmarks =
      _id3FaceAnalyser_ComputePoseWithLandmarksPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_DETECTED_FACE,
              ID3_FACE_POINT_LIST, ffi.Pointer<id3FacePose>)>();

  /// Detects the presence of a face mask on a detected face.
  /// A high score means that there is a high chance that the person is wearing a mask.
  /// The minimum recommended threshold is 15.
  /// Important: Loading the ``FaceMaskClassifier``, model is required to use this function.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param score [out] The face mask presence score of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_DetectFaceMask(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> score,
  ) {
    return _id3FaceAnalyser_DetectFaceMask(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      score,
    );
  }

  late final _id3FaceAnalyser_DetectFaceMaskPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3FaceAnalyser_DetectFaceMask');
  late final _id3FaceAnalyser_DetectFaceMask =
      _id3FaceAnalyser_DetectFaceMaskPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>();

  /// Detects occlusions on the subject's face.
  /// Important: This function requires the ``FaceOcclusionDetector`` model to be loaded.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param sScores [out] The occlusion scores of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_DetectOcclusions(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FaceOcclusionScores> sScores,
  ) {
    return _id3FaceAnalyser_DetectOcclusions(
      hFaceAnalyser,
      hImage,
      hDetectedFace,
      sScores,
    );
  }

  late final _id3FaceAnalyser_DetectOcclusionsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE,
                  ID3_DETECTED_FACE, ffi.Pointer<id3FaceOcclusionScores>)>>(
      'id3FaceAnalyser_DetectOcclusions');
  late final _id3FaceAnalyser_DetectOcclusions =
      _id3FaceAnalyser_DetectOcclusionsPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<id3FaceOcclusionScores>)>();

  /// Upscale and enhance the image of a face.
  /// Important: This methods requires the ``CompressionArtifactRemover`` model to be loaded.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hEnhancedImage [out] The enhanced face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_RemoveCompressionArtifacts(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_FACE_IMAGE hEnhancedImage,
  ) {
    return _id3FaceAnalyser_RemoveCompressionArtifacts(
      hFaceAnalyser,
      hImage,
      hEnhancedImage,
    );
  }

  late final _id3FaceAnalyser_RemoveCompressionArtifactsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE,
              ID3_FACE_IMAGE)>>('id3FaceAnalyser_RemoveCompressionArtifacts');
  late final _id3FaceAnalyser_RemoveCompressionArtifacts =
      _id3FaceAnalyser_RemoveCompressionArtifactsPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_FACE_IMAGE)>();

  /// Computes face segmentation mask for background removal.
  /// Important: This methods requires the ``FaceBackgroundSegmenter`` model to be loaded.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hSegmentationMask [out] The mask of segmented face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_SegmentBackground(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_FACE_IMAGE hSegmentationMask,
  ) {
    return _id3FaceAnalyser_SegmentBackground(
      hFaceAnalyser,
      hImage,
      hSegmentationMask,
    );
  }

  late final _id3FaceAnalyser_SegmentBackgroundPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE,
              ID3_FACE_IMAGE)>>('id3FaceAnalyser_SegmentBackground');
  late final _id3FaceAnalyser_SegmentBackground =
      _id3FaceAnalyser_SegmentBackgroundPtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_FACE_IMAGE)>();

  /// Computes a segmentation map of a face.
  /// Important: This methods requires the ``FaceSegmenter`` model to be loaded.
  /// @param hFaceAnalyser [in] Handle to the FaceAnalyser object.
  /// @param hImage [in] Source image to process.
  /// @param hSegmentationMap [out] The map of segmented face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceAnalyser_SegmentFace(
    ID3_FACE_ANALYSER hFaceAnalyser,
    ID3_FACE_IMAGE hImage,
    ID3_FACE_IMAGE hSegmentationMap,
  ) {
    return _id3FaceAnalyser_SegmentFace(
      hFaceAnalyser,
      hImage,
      hSegmentationMap,
    );
  }

  late final _id3FaceAnalyser_SegmentFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE,
              ID3_FACE_IMAGE)>>('id3FaceAnalyser_SegmentFace');
  late final _id3FaceAnalyser_SegmentFace =
      _id3FaceAnalyser_SegmentFacePtr.asFunction<
          int Function(ID3_FACE_ANALYSER, ID3_FACE_IMAGE, ID3_FACE_IMAGE)>();

  /// @brief Initializes a FaceCandidate object.
  /// @param phFaceCandidate [in] Handle to the FaceCandidate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidate_Initialize(
    ffi.Pointer<ID3_FACE_CANDIDATE> phFaceCandidate,
  ) {
    return _id3FaceCandidate_Initialize(
      phFaceCandidate,
    );
  }

  late final _id3FaceCandidate_InitializePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_CANDIDATE>)>>(
      'id3FaceCandidate_Initialize');
  late final _id3FaceCandidate_Initialize = _id3FaceCandidate_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_CANDIDATE>)>();

  /// @brief Releases the memory allocated for a FaceCandidate.
  /// @param phFaceCandidate [in] Handle to the FaceCandidate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidate_Dispose(
    ffi.Pointer<ID3_FACE_CANDIDATE> phFaceCandidate,
  ) {
    return _id3FaceCandidate_Dispose(
      phFaceCandidate,
    );
  }

  late final _id3FaceCandidate_DisposePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_CANDIDATE>)>>(
      'id3FaceCandidate_Dispose');
  late final _id3FaceCandidate_Dispose = _id3FaceCandidate_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_CANDIDATE>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceCandidate [in] Handle to the FaceCandidate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidate_CheckHandle(
    ID3_FACE_CANDIDATE hFaceCandidate,
  ) {
    return _id3FaceCandidate_CheckHandle(
      hFaceCandidate,
    );
  }

  late final _id3FaceCandidate_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_CANDIDATE)>>(
          'id3FaceCandidate_CheckHandle');
  late final _id3FaceCandidate_CheckHandle = _id3FaceCandidate_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_CANDIDATE)>();

  /// @brief Copies an instance of FaceCandidate object to another.
  /// @param hFaceCandidateSrc [in] Handle to the source FaceCandidate object.
  /// @param hFaceCandidateDst [in] Handle to the destination FaceCandidate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidate_CopyTo(
    ID3_FACE_CANDIDATE hFaceCandidateSrc,
    ID3_FACE_CANDIDATE hFaceCandidateDst,
  ) {
    return _id3FaceCandidate_CopyTo(
      hFaceCandidateSrc,
      hFaceCandidateDst,
    );
  }

  late final _id3FaceCandidate_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE,
              ID3_FACE_CANDIDATE)>>('id3FaceCandidate_CopyTo');
  late final _id3FaceCandidate_CopyTo = _id3FaceCandidate_CopyToPtr
      .asFunction<int Function(ID3_FACE_CANDIDATE, ID3_FACE_CANDIDATE)>();

  /// Gets the ID of the most similar face template as defined in the reference face template list used to perform the search.
  /// @param hFaceCandidate [in] Handle to the FaceCandidate object.
  /// @param id [out] ID of the most similar face template as defined in the reference face template list used to perform the search.
  /// @param idSize [in,out] Size of the 'id' buffer. Receives the minimum required buffer size to hold the 'id' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'id' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidate_GetId(
    ID3_FACE_CANDIDATE hFaceCandidate,
    ffi.Pointer<ffi.Char> id,
    ffi.Pointer<ffi.Int> idSize,
  ) {
    return _id3FaceCandidate_GetId(
      hFaceCandidate,
      id,
      idSize,
    );
  }

  late final _id3FaceCandidate_GetIdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceCandidate_GetId');
  late final _id3FaceCandidate_GetId = _id3FaceCandidate_GetIdPtr.asFunction<
      int Function(
          ID3_FACE_CANDIDATE, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Gets the match score between the face probe template and the most similar one in the reference face template list used to perform the search.
  /// @param hFaceCandidate [in] Handle to the FaceCandidate object.
  /// @param score [out] Match score between the face probe template and the most similar one in the reference face template list used to perform the search.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidate_GetScore(
    ID3_FACE_CANDIDATE hFaceCandidate,
    ffi.Pointer<ffi.Int> score,
  ) {
    return _id3FaceCandidate_GetScore(
      hFaceCandidate,
      score,
    );
  }

  late final _id3FaceCandidate_GetScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE,
              ffi.Pointer<ffi.Int>)>>('id3FaceCandidate_GetScore');
  late final _id3FaceCandidate_GetScore = _id3FaceCandidate_GetScorePtr
      .asFunction<int Function(ID3_FACE_CANDIDATE, ffi.Pointer<ffi.Int>)>();

  /// @brief Initializes a FaceCandidateList object.
  /// @param phFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_Initialize(
    ffi.Pointer<ID3_FACE_CANDIDATE_LIST> phFaceCandidateList,
  ) {
    return _id3FaceCandidateList_Initialize(
      phFaceCandidateList,
    );
  }

  late final _id3FaceCandidateList_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_CANDIDATE_LIST>)>>(
      'id3FaceCandidateList_Initialize');
  late final _id3FaceCandidateList_Initialize =
      _id3FaceCandidateList_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_FACE_CANDIDATE_LIST>)>();

  /// @brief Releases the memory allocated for a FaceCandidateList.
  /// @param phFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_Dispose(
    ffi.Pointer<ID3_FACE_CANDIDATE_LIST> phFaceCandidateList,
  ) {
    return _id3FaceCandidateList_Dispose(
      phFaceCandidateList,
    );
  }

  late final _id3FaceCandidateList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_CANDIDATE_LIST>)>>(
      'id3FaceCandidateList_Dispose');
  late final _id3FaceCandidateList_Dispose = _id3FaceCandidateList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_CANDIDATE_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_CheckHandle(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
  ) {
    return _id3FaceCandidateList_CheckHandle(
      hFaceCandidateList,
    );
  }

  late final _id3FaceCandidateList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_CANDIDATE_LIST)>>(
          'id3FaceCandidateList_CheckHandle');
  late final _id3FaceCandidateList_CheckHandle =
      _id3FaceCandidateList_CheckHandlePtr
          .asFunction<int Function(ID3_FACE_CANDIDATE_LIST)>();

  /// @brief Copies an instance of FaceCandidateList object to another.
  /// @param hFaceCandidateListSrc [in] Handle to the source FaceCandidateList object.
  /// @param hFaceCandidateListDst [in] Handle to the destination FaceCandidateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_CopyTo(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateListSrc,
    ID3_FACE_CANDIDATE_LIST hFaceCandidateListDst,
  ) {
    return _id3FaceCandidateList_CopyTo(
      hFaceCandidateListSrc,
      hFaceCandidateListDst,
    );
  }

  late final _id3FaceCandidateList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE_LIST,
              ID3_FACE_CANDIDATE_LIST)>>('id3FaceCandidateList_CopyTo');
  late final _id3FaceCandidateList_CopyTo =
      _id3FaceCandidateList_CopyToPtr.asFunction<
          int Function(ID3_FACE_CANDIDATE_LIST, ID3_FACE_CANDIDATE_LIST)>();

  /// Clears the FaceCandidateList object.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_Clear(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
  ) {
    return _id3FaceCandidateList_Clear(
      hFaceCandidateList,
    );
  }

  late final _id3FaceCandidateList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_CANDIDATE_LIST)>>(
          'id3FaceCandidateList_Clear');
  late final _id3FaceCandidateList_Clear = _id3FaceCandidateList_ClearPtr
      .asFunction<int Function(ID3_FACE_CANDIDATE_LIST)>();

  /// Adds an item to the FaceCandidateList object.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @param hFaceCandidateItem [in] FaceCandidate item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_Add(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
    ID3_FACE_CANDIDATE hFaceCandidateItem,
  ) {
    return _id3FaceCandidateList_Add(
      hFaceCandidateList,
      hFaceCandidateItem,
    );
  }

  late final _id3FaceCandidateList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE_LIST,
              ID3_FACE_CANDIDATE)>>('id3FaceCandidateList_Add');
  late final _id3FaceCandidateList_Add = _id3FaceCandidateList_AddPtr
      .asFunction<int Function(ID3_FACE_CANDIDATE_LIST, ID3_FACE_CANDIDATE)>();

  /// Gets an item of the FaceCandidateList object.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @param index [in] Index of the FaceCandidate item to get.
  /// @param hFaceCandidateItem [out] FaceCandidate item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_Get(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
    int index,
    ID3_FACE_CANDIDATE hFaceCandidateItem,
  ) {
    return _id3FaceCandidateList_Get(
      hFaceCandidateList,
      index,
      hFaceCandidateItem,
    );
  }

  late final _id3FaceCandidateList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE_LIST, ffi.Int,
              ID3_FACE_CANDIDATE)>>('id3FaceCandidateList_Get');
  late final _id3FaceCandidateList_Get =
      _id3FaceCandidateList_GetPtr.asFunction<
          int Function(ID3_FACE_CANDIDATE_LIST, int, ID3_FACE_CANDIDATE)>();

  /// Sets an item of the FaceCandidateList object.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @param index [in] Index of the FaceCandidate item to set.
  /// @param hFaceCandidateItem [in] FaceCandidate item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_Set(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
    int index,
    ID3_FACE_CANDIDATE hFaceCandidateItem,
  ) {
    return _id3FaceCandidateList_Set(
      hFaceCandidateList,
      index,
      hFaceCandidateItem,
    );
  }

  late final _id3FaceCandidateList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE_LIST, ffi.Int,
              ID3_FACE_CANDIDATE)>>('id3FaceCandidateList_Set');
  late final _id3FaceCandidateList_Set =
      _id3FaceCandidateList_SetPtr.asFunction<
          int Function(ID3_FACE_CANDIDATE_LIST, int, ID3_FACE_CANDIDATE)>();

  /// Gets the number of elements in the FaceCandidateList object.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @param count [out] Number of elements in the FaceCandidate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_GetCount(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FaceCandidateList_GetCount(
      hFaceCandidateList,
      count,
    );
  }

  late final _id3FaceCandidateList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_CANDIDATE_LIST,
              ffi.Pointer<ffi.Int>)>>('id3FaceCandidateList_GetCount');
  late final _id3FaceCandidateList_GetCount =
      _id3FaceCandidateList_GetCountPtr.asFunction<
          int Function(ID3_FACE_CANDIDATE_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the FaceCandidateList object.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @param index [in] Index of the FaceCandidate item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_RemoveAt(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
    int index,
  ) {
    return _id3FaceCandidateList_RemoveAt(
      hFaceCandidateList,
      index,
    );
  }

  late final _id3FaceCandidateList_RemoveAtPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_FACE_CANDIDATE_LIST, ffi.Int)>>(
      'id3FaceCandidateList_RemoveAt');
  late final _id3FaceCandidateList_RemoveAt = _id3FaceCandidateList_RemoveAtPtr
      .asFunction<int Function(ID3_FACE_CANDIDATE_LIST, int)>();

  /// FaceCandidateList object.
  /// @param hFaceCandidateList [in] Handle to the FaceCandidateList object.
  /// @param newSize [in] FaceCandidate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceCandidateList_Resize(
    ID3_FACE_CANDIDATE_LIST hFaceCandidateList,
    int newSize,
  ) {
    return _id3FaceCandidateList_Resize(
      hFaceCandidateList,
      newSize,
    );
  }

  late final _id3FaceCandidateList_ResizePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_FACE_CANDIDATE_LIST, ffi.Int)>>(
      'id3FaceCandidateList_Resize');
  late final _id3FaceCandidateList_Resize = _id3FaceCandidateList_ResizePtr
      .asFunction<int Function(ID3_FACE_CANDIDATE_LIST, int)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceModelString(
    int value,
  ) {
    return _id3Face_GetFaceModelString(
      value,
    );
  }

  late final _id3Face_GetFaceModelStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceModelString');
  late final _id3Face_GetFaceModelString = _id3Face_GetFaceModelStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetProcessingUnitString(
    int value,
  ) {
    return _id3Face_GetProcessingUnitString(
      value,
    );
  }

  late final _id3Face_GetProcessingUnitStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetProcessingUnitString');
  late final _id3Face_GetProcessingUnitString =
      _id3Face_GetProcessingUnitStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a FaceDetector object.
  /// @param phFaceDetector [in] Handle to the FaceDetector object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_Initialize(
    ffi.Pointer<ID3_FACE_DETECTOR> phFaceDetector,
  ) {
    return _id3FaceDetector_Initialize(
      phFaceDetector,
    );
  }

  late final _id3FaceDetector_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_DETECTOR>)>>(
      'id3FaceDetector_Initialize');
  late final _id3FaceDetector_Initialize = _id3FaceDetector_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_DETECTOR>)>();

  /// @brief Releases the memory allocated for a FaceDetector.
  /// @param phFaceDetector [in] Handle to the FaceDetector object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_Dispose(
    ffi.Pointer<ID3_FACE_DETECTOR> phFaceDetector,
  ) {
    return _id3FaceDetector_Dispose(
      phFaceDetector,
    );
  }

  late final _id3FaceDetector_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_DETECTOR>)>>(
      'id3FaceDetector_Dispose');
  late final _id3FaceDetector_Dispose = _id3FaceDetector_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_DETECTOR>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_CheckHandle(
    ID3_FACE_DETECTOR hFaceDetector,
  ) {
    return _id3FaceDetector_CheckHandle(
      hFaceDetector,
    );
  }

  late final _id3FaceDetector_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_DETECTOR)>>(
          'id3FaceDetector_CheckHandle');
  late final _id3FaceDetector_CheckHandle = _id3FaceDetector_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_DETECTOR)>();

  /// Gets the confidence threshold, in the range [0;100].
  /// Hint: Default value is 50.
  /// Note: Setting a high threshold reduces false detection but can increase the number of undetected faces.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param confidenceThreshold [out] Confidence threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_GetConfidenceThreshold(
    ID3_FACE_DETECTOR hFaceDetector,
    ffi.Pointer<ffi.Int> confidenceThreshold,
  ) {
    return _id3FaceDetector_GetConfidenceThreshold(
      hFaceDetector,
      confidenceThreshold,
    );
  }

  late final _id3FaceDetector_GetConfidenceThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_DETECTOR,
              ffi.Pointer<ffi.Int>)>>('id3FaceDetector_GetConfidenceThreshold');
  late final _id3FaceDetector_GetConfidenceThreshold =
      _id3FaceDetector_GetConfidenceThresholdPtr
          .asFunction<int Function(ID3_FACE_DETECTOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the confidence threshold, in the range [0;100].
  /// Hint: Default value is 50.
  /// Note: Setting a high threshold reduces false detection but can increase the number of undetected faces.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param confidenceThreshold [in] Confidence threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_SetConfidenceThreshold(
    ID3_FACE_DETECTOR hFaceDetector,
    int confidenceThreshold,
  ) {
    return _id3FaceDetector_SetConfidenceThreshold(
      hFaceDetector,
      confidenceThreshold,
    );
  }

  late final _id3FaceDetector_SetConfidenceThresholdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_DETECTOR, ffi.Int)>>(
          'id3FaceDetector_SetConfidenceThreshold');
  late final _id3FaceDetector_SetConfidenceThreshold =
      _id3FaceDetector_SetConfidenceThresholdPtr
          .asFunction<int Function(ID3_FACE_DETECTOR, int)>();

  /// Gets the model used to detect and track faces.
  /// Hint: Default value is FaceDetector4A which is the best available algorithm in this SDK in terms of accuracy. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param eModel [out] Model used to detect and track faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_GetModel(
    ID3_FACE_DETECTOR hFaceDetector,
    ffi.Pointer<ffi.Int32> eModel,
  ) {
    return _id3FaceDetector_GetModel(
      hFaceDetector,
      eModel,
    );
  }

  late final _id3FaceDetector_GetModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_DETECTOR,
              ffi.Pointer<ffi.Int32>)>>('id3FaceDetector_GetModel');
  late final _id3FaceDetector_GetModel = _id3FaceDetector_GetModelPtr
      .asFunction<int Function(ID3_FACE_DETECTOR, ffi.Pointer<ffi.Int32>)>();

  /// Sets the model used to detect and track faces.
  /// Hint: Default value is FaceDetector4A which is the best available algorithm in this SDK in terms of accuracy. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param eModel [in] Model used to detect and track faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_SetModel(
    ID3_FACE_DETECTOR hFaceDetector,
    int eModel,
  ) {
    return _id3FaceDetector_SetModel(
      hFaceDetector,
      eModel,
    );
  }

  late final _id3FaceDetector_SetModelPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_DETECTOR, ffi.Int32)>>(
      'id3FaceDetector_SetModel');
  late final _id3FaceDetector_SetModel = _id3FaceDetector_SetModelPtr
      .asFunction<int Function(ID3_FACE_DETECTOR, int)>();

  /// Gets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// Hint: Default value is 40.
  /// Note: Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param nmsIouThreshold [out] Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_GetNmsIouThreshold(
    ID3_FACE_DETECTOR hFaceDetector,
    ffi.Pointer<ffi.Int> nmsIouThreshold,
  ) {
    return _id3FaceDetector_GetNmsIouThreshold(
      hFaceDetector,
      nmsIouThreshold,
    );
  }

  late final _id3FaceDetector_GetNmsIouThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_DETECTOR,
              ffi.Pointer<ffi.Int>)>>('id3FaceDetector_GetNmsIouThreshold');
  late final _id3FaceDetector_GetNmsIouThreshold =
      _id3FaceDetector_GetNmsIouThresholdPtr
          .asFunction<int Function(ID3_FACE_DETECTOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// Hint: Default value is 40.
  /// Note: Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param nmsIouThreshold [in] Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_SetNmsIouThreshold(
    ID3_FACE_DETECTOR hFaceDetector,
    int nmsIouThreshold,
  ) {
    return _id3FaceDetector_SetNmsIouThreshold(
      hFaceDetector,
      nmsIouThreshold,
    );
  }

  late final _id3FaceDetector_SetNmsIouThresholdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_DETECTOR, ffi.Int)>>(
          'id3FaceDetector_SetNmsIouThreshold');
  late final _id3FaceDetector_SetNmsIouThreshold =
      _id3FaceDetector_SetNmsIouThresholdPtr
          .asFunction<int Function(ID3_FACE_DETECTOR, int)>();

  /// Gets the processing unit where to run the detection process.
  /// Hint: Default value is CPU.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param eProcessingUnit [out] Processing unit where to run the detection process.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_GetProcessingUnit(
    ID3_FACE_DETECTOR hFaceDetector,
    ffi.Pointer<ffi.Int32> eProcessingUnit,
  ) {
    return _id3FaceDetector_GetProcessingUnit(
      hFaceDetector,
      eProcessingUnit,
    );
  }

  late final _id3FaceDetector_GetProcessingUnitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_DETECTOR,
              ffi.Pointer<ffi.Int32>)>>('id3FaceDetector_GetProcessingUnit');
  late final _id3FaceDetector_GetProcessingUnit =
      _id3FaceDetector_GetProcessingUnitPtr.asFunction<
          int Function(ID3_FACE_DETECTOR, ffi.Pointer<ffi.Int32>)>();

  /// Sets the processing unit where to run the detection process.
  /// Hint: Default value is CPU.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param eProcessingUnit [in] Processing unit where to run the detection process.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_SetProcessingUnit(
    ID3_FACE_DETECTOR hFaceDetector,
    int eProcessingUnit,
  ) {
    return _id3FaceDetector_SetProcessingUnit(
      hFaceDetector,
      eProcessingUnit,
    );
  }

  late final _id3FaceDetector_SetProcessingUnitPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_DETECTOR, ffi.Int32)>>(
      'id3FaceDetector_SetProcessingUnit');
  late final _id3FaceDetector_SetProcessingUnit =
      _id3FaceDetector_SetProcessingUnitPtr
          .asFunction<int Function(ID3_FACE_DETECTOR, int)>();

  /// Gets the number of threads to be used for face detection.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param threadCount [out] Number of threads to be used for face detection.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_GetThreadCount(
    ID3_FACE_DETECTOR hFaceDetector,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3FaceDetector_GetThreadCount(
      hFaceDetector,
      threadCount,
    );
  }

  late final _id3FaceDetector_GetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_DETECTOR,
              ffi.Pointer<ffi.Int>)>>('id3FaceDetector_GetThreadCount');
  late final _id3FaceDetector_GetThreadCount =
      _id3FaceDetector_GetThreadCountPtr
          .asFunction<int Function(ID3_FACE_DETECTOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to be used for face detection.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param threadCount [in] Number of threads to be used for face detection.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_SetThreadCount(
    ID3_FACE_DETECTOR hFaceDetector,
    int threadCount,
  ) {
    return _id3FaceDetector_SetThreadCount(
      hFaceDetector,
      threadCount,
    );
  }

  late final _id3FaceDetector_SetThreadCountPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_DETECTOR, ffi.Int)>>(
          'id3FaceDetector_SetThreadCount');
  late final _id3FaceDetector_SetThreadCount =
      _id3FaceDetector_SetThreadCountPtr
          .asFunction<int Function(ID3_FACE_DETECTOR, int)>();

  /// Detects faces in an image and store their info in a DetectedFaceList object.
  /// Note: The algorithm searches for faces in the range [16px;512px]. If the image is too large to fit this range, one must resize it before the detection process.
  /// Important: Loading a ``FaceDetector`` model is required to use this function.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFaceList [out] The list of detected faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_DetectFaces(
    ID3_FACE_DETECTOR hFaceDetector,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
  ) {
    return _id3FaceDetector_DetectFaces(
      hFaceDetector,
      hImage,
      hDetectedFaceList,
    );
  }

  late final _id3FaceDetector_DetectFacesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_DETECTOR, ID3_FACE_IMAGE,
              ID3_DETECTED_FACE_LIST)>>('id3FaceDetector_DetectFaces');
  late final _id3FaceDetector_DetectFaces =
      _id3FaceDetector_DetectFacesPtr.asFunction<
          int Function(
              ID3_FACE_DETECTOR, ID3_FACE_IMAGE, ID3_DETECTED_FACE_LIST)>();

  /// Tracks faces in an image and update their info in a DetectedFaceList object.
  /// In a realtime process, one must use this function instead of DetectFaces() to keep the face IDs stable in time.
  /// Note: The algorithm searches for faces in the range [16px;512px]. If the image is too large to fit this range, one must resize it before the detection process.
  /// Important: Loading a ``FaceDetector`` model is required to use this function.
  /// Warning: This function is deprecated: use the FaceTracker module instead.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFaceList [in] List of detected faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_TrackFaces(
    ID3_FACE_DETECTOR hFaceDetector,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE_LIST hDetectedFaceList,
  ) {
    return _id3FaceDetector_TrackFaces(
      hFaceDetector,
      hImage,
      hDetectedFaceList,
    );
  }

  late final _id3FaceDetector_TrackFacesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_DETECTOR, ID3_FACE_IMAGE,
              ID3_DETECTED_FACE_LIST)>>('id3FaceDetector_TrackFaces');
  late final _id3FaceDetector_TrackFaces =
      _id3FaceDetector_TrackFacesPtr.asFunction<
          int Function(
              ID3_FACE_DETECTOR, ID3_FACE_IMAGE, ID3_DETECTED_FACE_LIST)>();

  /// Gets the face detector module ready to work on a specific image size by initializing all its internal memory layout.
  /// This function can be called after setting all the parameters of the face detector module if the image size is fixed, for example using frames from a video stream.
  /// Calling this function is not mandatory as the internal memory layout is automatically initialized in the first call to detectFaces() or trackFaces() if missing.
  /// Important: Loading a ``FaceDetector`` model is required to use this function.
  /// @param hFaceDetector [in] Handle to the FaceDetector object.
  /// @param imageWidth [in] Width of the expected image size.
  /// @param imageHeight [in] Height of expected image size.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceDetector_WarmUp(
    ID3_FACE_DETECTOR hFaceDetector,
    int imageWidth,
    int imageHeight,
  ) {
    return _id3FaceDetector_WarmUp(
      hFaceDetector,
      imageWidth,
      imageHeight,
    );
  }

  late final _id3FaceDetector_WarmUpPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_DETECTOR, ffi.Int, ffi.Int)>>('id3FaceDetector_WarmUp');
  late final _id3FaceDetector_WarmUp = _id3FaceDetector_WarmUpPtr
      .asFunction<int Function(ID3_FACE_DETECTOR, int, int)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceTemplateFormatString(
    int value,
  ) {
    return _id3Face_GetFaceTemplateFormatString(
      value,
    );
  }

  late final _id3Face_GetFaceTemplateFormatStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceTemplateFormatString');
  late final _id3Face_GetFaceTemplateFormatString =
      _id3Face_GetFaceTemplateFormatStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a FaceTemplate object.
  /// @param phFaceTemplate [in] Handle to the FaceTemplate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_Initialize(
    ffi.Pointer<ID3_FACE_TEMPLATE> phFaceTemplate,
  ) {
    return _id3FaceTemplate_Initialize(
      phFaceTemplate,
    );
  }

  late final _id3FaceTemplate_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE>)>>(
      'id3FaceTemplate_Initialize');
  late final _id3FaceTemplate_Initialize = _id3FaceTemplate_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_TEMPLATE>)>();

  /// @brief Releases the memory allocated for a FaceTemplate.
  /// @param phFaceTemplate [in] Handle to the FaceTemplate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_Dispose(
    ffi.Pointer<ID3_FACE_TEMPLATE> phFaceTemplate,
  ) {
    return _id3FaceTemplate_Dispose(
      phFaceTemplate,
    );
  }

  late final _id3FaceTemplate_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE>)>>(
      'id3FaceTemplate_Dispose');
  late final _id3FaceTemplate_Dispose = _id3FaceTemplate_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_TEMPLATE>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_CheckHandle(
    ID3_FACE_TEMPLATE hFaceTemplate,
  ) {
    return _id3FaceTemplate_CheckHandle(
      hFaceTemplate,
    );
  }

  late final _id3FaceTemplate_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TEMPLATE)>>(
          'id3FaceTemplate_CheckHandle');
  late final _id3FaceTemplate_CheckHandle = _id3FaceTemplate_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_TEMPLATE)>();

  /// @brief Copies an instance of FaceTemplate object to another.
  /// @param hFaceTemplateSrc [in] Handle to the source FaceTemplate object.
  /// @param hFaceTemplateDst [in] Handle to the destination FaceTemplate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_CopyTo(
    ID3_FACE_TEMPLATE hFaceTemplateSrc,
    ID3_FACE_TEMPLATE hFaceTemplateDst,
  ) {
    return _id3FaceTemplate_CopyTo(
      hFaceTemplateSrc,
      hFaceTemplateDst,
    );
  }

  late final _id3FaceTemplate_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_TEMPLATE, ID3_FACE_TEMPLATE)>>('id3FaceTemplate_CopyTo');
  late final _id3FaceTemplate_CopyTo = _id3FaceTemplate_CopyToPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE, ID3_FACE_TEMPLATE)>();

  /// Gets the format of the face template.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param eFormat [out] Format of the face template.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_GetFormat(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.Int32> eFormat,
  ) {
    return _id3FaceTemplate_GetFormat(
      hFaceTemplate,
      eFormat,
    );
  }

  late final _id3FaceTemplate_GetFormatPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE,
              ffi.Pointer<ffi.Int32>)>>('id3FaceTemplate_GetFormat');
  late final _id3FaceTemplate_GetFormat = _id3FaceTemplate_GetFormatPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.Int32>)>();

  /// Gets the quality of the face template.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param quality [out] Quality of the face template.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_GetQuality(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.Int> quality,
  ) {
    return _id3FaceTemplate_GetQuality(
      hFaceTemplate,
      quality,
    );
  }

  late final _id3FaceTemplate_GetQualityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE,
              ffi.Pointer<ffi.Int>)>>('id3FaceTemplate_GetQuality');
  late final _id3FaceTemplate_GetQuality = _id3FaceTemplate_GetQualityPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.Int>)>();

  /// Imports the face template object from a buffer.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param data [in] Buffer to import the face template object from.
  /// @param dataSize [in] Size of the 'data' buffer.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_FromBuffer(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.UnsignedChar> data,
    int dataSize,
  ) {
    return _id3FaceTemplate_FromBuffer(
      hFaceTemplate,
      data,
      dataSize,
    );
  }

  late final _id3FaceTemplate_FromBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int)>>('id3FaceTemplate_FromBuffer');
  late final _id3FaceTemplate_FromBuffer =
      _id3FaceTemplate_FromBufferPtr.asFunction<
          int Function(
              ID3_FACE_TEMPLATE, ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Imports the face template object from a file.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param path [in] Path to the file to import the face template object from.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_FromFile(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceTemplate_FromFile(
      hFaceTemplate,
      path,
    );
  }

  late final _id3FaceTemplate_FromFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE,
              ffi.Pointer<ffi.Char>)>>('id3FaceTemplate_FromFile');
  late final _id3FaceTemplate_FromFile = _id3FaceTemplate_FromFilePtr
      .asFunction<int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.Char>)>();

  /// Exports the face template object to a Biometric Data Template (BDT) buffer.
  /// This buffer can only be used with id3 Face Match on Card specific implementations to verify a face template.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param data [out] A buffer that receives the biometric data template.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_ToBdt(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3FaceTemplate_ToBdt(
      hFaceTemplate,
      data,
      dataSize,
    );
  }

  late final _id3FaceTemplate_ToBdtPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceTemplate_ToBdt');
  late final _id3FaceTemplate_ToBdt = _id3FaceTemplate_ToBdtPtr.asFunction<
      int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<ffi.Int>)>();

  /// Exports the face template as a Biometric Information Template (BIT) for enrolment on a smart card equipped with id3 Match-on-Card technology.
  /// Note: The threshold value is required and should be set according to the used Face Encoder and desired security level.
  /// Important: The reference data qualifier (RDQ) should be defined in accordance with the smart card application specifications.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param threshold [in] The decision threshold, from 0 to 653535, to be applied during the face comparison on the smart card. See FaceMatcherThreshold for a list of typical values.
  /// @param referenceDataQualifier [in] Reference data qualifier.
  /// @param data [out] A buffer that receives the biometric information template.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_ToBit(
    ID3_FACE_TEMPLATE hFaceTemplate,
    int threshold,
    int referenceDataQualifier,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3FaceTemplate_ToBit(
      hFaceTemplate,
      threshold,
      referenceDataQualifier,
      data,
      dataSize,
    );
  }

  late final _id3FaceTemplate_ToBitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_TEMPLATE,
              ffi.Int,
              ffi.Int,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceTemplate_ToBit');
  late final _id3FaceTemplate_ToBit = _id3FaceTemplate_ToBitPtr.asFunction<
      int Function(ID3_FACE_TEMPLATE, int, int, ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<ffi.Int>)>();

  /// Exports the face template object to a buffer.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param data [out] The buffer that receives the face template.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_ToBuffer(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3FaceTemplate_ToBuffer(
      hFaceTemplate,
      data,
      dataSize,
    );
  }

  late final _id3FaceTemplate_ToBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceTemplate_ToBuffer');
  late final _id3FaceTemplate_ToBuffer =
      _id3FaceTemplate_ToBufferPtr.asFunction<
          int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Exports the face template object to a file.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param path [in] Path to the file to export the face template object to.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_ToFile(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceTemplate_ToFile(
      hFaceTemplate,
      path,
    );
  }

  late final _id3FaceTemplate_ToFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE,
              ffi.Pointer<ffi.Char>)>>('id3FaceTemplate_ToFile');
  late final _id3FaceTemplate_ToFile = _id3FaceTemplate_ToFilePtr
      .asFunction<int Function(ID3_FACE_TEMPLATE, ffi.Pointer<ffi.Char>)>();

  /// Updates the face template by combining it with the specified face template.
  /// @param hFaceTemplate [in] Handle to the FaceTemplate object.
  /// @param hNewFaceTemplate [in] New face template to combine.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplate_Update(
    ID3_FACE_TEMPLATE hFaceTemplate,
    ID3_FACE_TEMPLATE hNewFaceTemplate,
  ) {
    return _id3FaceTemplate_Update(
      hFaceTemplate,
      hNewFaceTemplate,
    );
  }

  late final _id3FaceTemplate_UpdatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_TEMPLATE, ID3_FACE_TEMPLATE)>>('id3FaceTemplate_Update');
  late final _id3FaceTemplate_Update = _id3FaceTemplate_UpdatePtr
      .asFunction<int Function(ID3_FACE_TEMPLATE, ID3_FACE_TEMPLATE)>();

  /// @brief Initializes a FaceEncoder object.
  /// @param phFaceEncoder [in] Handle to the FaceEncoder object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_Initialize(
    ffi.Pointer<ID3_FACE_ENCODER> phFaceEncoder,
  ) {
    return _id3FaceEncoder_Initialize(
      phFaceEncoder,
    );
  }

  late final _id3FaceEncoder_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_ENCODER>)>>(
      'id3FaceEncoder_Initialize');
  late final _id3FaceEncoder_Initialize = _id3FaceEncoder_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_ENCODER>)>();

  /// @brief Releases the memory allocated for a FaceEncoder.
  /// @param phFaceEncoder [in] Handle to the FaceEncoder object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_Dispose(
    ffi.Pointer<ID3_FACE_ENCODER> phFaceEncoder,
  ) {
    return _id3FaceEncoder_Dispose(
      phFaceEncoder,
    );
  }

  late final _id3FaceEncoder_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_ENCODER>)>>(
      'id3FaceEncoder_Dispose');
  late final _id3FaceEncoder_Dispose = _id3FaceEncoder_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_ENCODER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_CheckHandle(
    ID3_FACE_ENCODER hFaceEncoder,
  ) {
    return _id3FaceEncoder_CheckHandle(
      hFaceEncoder,
    );
  }

  late final _id3FaceEncoder_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ENCODER)>>(
          'id3FaceEncoder_CheckHandle');
  late final _id3FaceEncoder_CheckHandle = _id3FaceEncoder_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_ENCODER)>();

  /// Gets the minimal interocular distance (IOD) in pixels required to perform a face encoding.
  /// Hint: Default value is 30 pixels. It is not recommended to change this value.
  /// Warning: Reducing the minimal required IOD to encode smaller face images may create unreliable face templates and significantly degrade recognition performances.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param minimalIod [out] Minimal interocular distance (IOD) in pixels required to perform a face encoding.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_GetMinimalIod(
    ID3_FACE_ENCODER hFaceEncoder,
    ffi.Pointer<ffi.Int> minimalIod,
  ) {
    return _id3FaceEncoder_GetMinimalIod(
      hFaceEncoder,
      minimalIod,
    );
  }

  late final _id3FaceEncoder_GetMinimalIodPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ENCODER,
              ffi.Pointer<ffi.Int>)>>('id3FaceEncoder_GetMinimalIod');
  late final _id3FaceEncoder_GetMinimalIod = _id3FaceEncoder_GetMinimalIodPtr
      .asFunction<int Function(ID3_FACE_ENCODER, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimal interocular distance (IOD) in pixels required to perform a face encoding.
  /// Hint: Default value is 30 pixels. It is not recommended to change this value.
  /// Warning: Reducing the minimal required IOD to encode smaller face images may create unreliable face templates and significantly degrade recognition performances.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param minimalIod [in] Minimal interocular distance (IOD) in pixels required to perform a face encoding.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_SetMinimalIod(
    ID3_FACE_ENCODER hFaceEncoder,
    int minimalIod,
  ) {
    return _id3FaceEncoder_SetMinimalIod(
      hFaceEncoder,
      minimalIod,
    );
  }

  late final _id3FaceEncoder_SetMinimalIodPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ENCODER, ffi.Int)>>(
          'id3FaceEncoder_SetMinimalIod');
  late final _id3FaceEncoder_SetMinimalIod = _id3FaceEncoder_SetMinimalIodPtr
      .asFunction<int Function(ID3_FACE_ENCODER, int)>();

  /// Gets the model used to create templates.
  /// Hint: Default value is FaceEncoder9A which is the best available algorithm in this SDK in terms of accuracy. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param eModel [out] Model used to create templates.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_GetModel(
    ID3_FACE_ENCODER hFaceEncoder,
    ffi.Pointer<ffi.Int32> eModel,
  ) {
    return _id3FaceEncoder_GetModel(
      hFaceEncoder,
      eModel,
    );
  }

  late final _id3FaceEncoder_GetModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ENCODER,
              ffi.Pointer<ffi.Int32>)>>('id3FaceEncoder_GetModel');
  late final _id3FaceEncoder_GetModel = _id3FaceEncoder_GetModelPtr
      .asFunction<int Function(ID3_FACE_ENCODER, ffi.Pointer<ffi.Int32>)>();

  /// Sets the model used to create templates.
  /// Hint: Default value is FaceEncoder9A which is the best available algorithm in this SDK in terms of accuracy. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param eModel [in] Model used to create templates.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_SetModel(
    ID3_FACE_ENCODER hFaceEncoder,
    int eModel,
  ) {
    return _id3FaceEncoder_SetModel(
      hFaceEncoder,
      eModel,
    );
  }

  late final _id3FaceEncoder_SetModelPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_ENCODER, ffi.Int32)>>(
      'id3FaceEncoder_SetModel');
  late final _id3FaceEncoder_SetModel = _id3FaceEncoder_SetModelPtr
      .asFunction<int Function(ID3_FACE_ENCODER, int)>();

  /// Gets the processing unit where to run the encoding process.
  /// Hint: Default value is CPU.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param eProcessingUnit [out] Processing unit where to run the encoding process.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_GetProcessingUnit(
    ID3_FACE_ENCODER hFaceEncoder,
    ffi.Pointer<ffi.Int32> eProcessingUnit,
  ) {
    return _id3FaceEncoder_GetProcessingUnit(
      hFaceEncoder,
      eProcessingUnit,
    );
  }

  late final _id3FaceEncoder_GetProcessingUnitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ENCODER,
              ffi.Pointer<ffi.Int32>)>>('id3FaceEncoder_GetProcessingUnit');
  late final _id3FaceEncoder_GetProcessingUnit =
      _id3FaceEncoder_GetProcessingUnitPtr
          .asFunction<int Function(ID3_FACE_ENCODER, ffi.Pointer<ffi.Int32>)>();

  /// Sets the processing unit where to run the encoding process.
  /// Hint: Default value is CPU.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param eProcessingUnit [in] Processing unit where to run the encoding process.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_SetProcessingUnit(
    ID3_FACE_ENCODER hFaceEncoder,
    int eProcessingUnit,
  ) {
    return _id3FaceEncoder_SetProcessingUnit(
      hFaceEncoder,
      eProcessingUnit,
    );
  }

  late final _id3FaceEncoder_SetProcessingUnitPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_ENCODER, ffi.Int32)>>(
      'id3FaceEncoder_SetProcessingUnit');
  late final _id3FaceEncoder_SetProcessingUnit =
      _id3FaceEncoder_SetProcessingUnitPtr
          .asFunction<int Function(ID3_FACE_ENCODER, int)>();

  /// Gets the number of threads to be used for template encoding.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param threadCount [out] Number of threads to be used for template encoding.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_GetThreadCount(
    ID3_FACE_ENCODER hFaceEncoder,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3FaceEncoder_GetThreadCount(
      hFaceEncoder,
      threadCount,
    );
  }

  late final _id3FaceEncoder_GetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ENCODER,
              ffi.Pointer<ffi.Int>)>>('id3FaceEncoder_GetThreadCount');
  late final _id3FaceEncoder_GetThreadCount = _id3FaceEncoder_GetThreadCountPtr
      .asFunction<int Function(ID3_FACE_ENCODER, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to be used for template encoding.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param threadCount [in] Number of threads to be used for template encoding.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_SetThreadCount(
    ID3_FACE_ENCODER hFaceEncoder,
    int threadCount,
  ) {
    return _id3FaceEncoder_SetThreadCount(
      hFaceEncoder,
      threadCount,
    );
  }

  late final _id3FaceEncoder_SetThreadCountPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ENCODER, ffi.Int)>>(
          'id3FaceEncoder_SetThreadCount');
  late final _id3FaceEncoder_SetThreadCount = _id3FaceEncoder_SetThreadCountPtr
      .asFunction<int Function(ID3_FACE_ENCODER, int)>();

  /// Computes the quality of a detected face.
  /// Here, quality expresses the match capability of an image: a high quality image will generate less match errors (false acceptance or false rejection) than a low quality one.
  /// Warning: A minimum interocular distance (IOD) of 30 pixels for the detected face is required for this function, below this value it will output an error.
  /// Important: Loading the ``FaceEncodingQualityEstimator`` model is required to use this function.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param quality [out] The estimated quality of the detected face. Range is [0:100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_ComputeQuality(
    ID3_FACE_ENCODER hFaceEncoder,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> quality,
  ) {
    return _id3FaceEncoder_ComputeQuality(
      hFaceEncoder,
      hImage,
      hDetectedFace,
      quality,
    );
  }

  late final _id3FaceEncoder_ComputeQualityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ENCODER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3FaceEncoder_ComputeQuality');
  late final _id3FaceEncoder_ComputeQuality =
      _id3FaceEncoder_ComputeQualityPtr.asFunction<
          int Function(ID3_FACE_ENCODER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>();

  /// Extracts the unique features of a detected face and store them in a FaceTemplate.
  /// Warning: A minimum interocular distance (IOD) of 30 pixels for the detected face is required for this function, below this value it will output an error.
  /// Important: Loading a ``FaceEncoder`` model is required to use this function.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param hFaceTemplate [out] The generated face template.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_CreateTemplate(
    ID3_FACE_ENCODER hFaceEncoder,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ID3_FACE_TEMPLATE hFaceTemplate,
  ) {
    return _id3FaceEncoder_CreateTemplate(
      hFaceEncoder,
      hImage,
      hDetectedFace,
      hFaceTemplate,
    );
  }

  late final _id3FaceEncoder_CreateTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_ENCODER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ID3_FACE_TEMPLATE)>>('id3FaceEncoder_CreateTemplate');
  late final _id3FaceEncoder_CreateTemplate =
      _id3FaceEncoder_CreateTemplatePtr.asFunction<
          int Function(ID3_FACE_ENCODER, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ID3_FACE_TEMPLATE)>();

  /// Gets the face encoder module ready to work by initializing all its internal memory layout.
  /// This function can be called after setting all the parameters of the face encoder module.
  /// Calling this function is not mandatory as the internal memory layout is automatically initialized in the first call to createTemplate() if missing.
  /// Important: Loading a ``FaceEncoder`` is required to use this function.
  /// @param hFaceEncoder [in] Handle to the FaceEncoder object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceEncoder_WarmUp(
    ID3_FACE_ENCODER hFaceEncoder,
  ) {
    return _id3FaceEncoder_WarmUp(
      hFaceEncoder,
    );
  }

  late final _id3FaceEncoder_WarmUpPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_ENCODER)>>(
          'id3FaceEncoder_WarmUp');
  late final _id3FaceEncoder_WarmUp =
      _id3FaceEncoder_WarmUpPtr.asFunction<int Function(ID3_FACE_ENCODER)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceErrorString(
    int value,
  ) {
    return _id3Face_GetFaceErrorString(
      value,
    );
  }

  late final _id3Face_GetFaceErrorStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceErrorString');
  late final _id3Face_GetFaceErrorString = _id3Face_GetFaceErrorStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceErrorMessage(
    int value,
  ) {
    return _id3Face_GetFaceErrorMessage(
      value,
    );
  }

  late final _id3Face_GetFaceErrorMessagePtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceErrorMessage');
  late final _id3Face_GetFaceErrorMessage = _id3Face_GetFaceErrorMessagePtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a StringList object.
  /// @param phStringList [in] Handle to the StringList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_Initialize(
    ffi.Pointer<ID3_FACE_STRING_LIST> phStringList,
  ) {
    return _id3FaceStringList_Initialize(
      phStringList,
    );
  }

  late final _id3FaceStringList_InitializePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_STRING_LIST>)>>(
      'id3FaceStringList_Initialize');
  late final _id3FaceStringList_Initialize = _id3FaceStringList_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_STRING_LIST>)>();

  /// @brief Releases the memory allocated for a StringList.
  /// @param phStringList [in] Handle to the StringList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_Dispose(
    ffi.Pointer<ID3_FACE_STRING_LIST> phStringList,
  ) {
    return _id3FaceStringList_Dispose(
      phStringList,
    );
  }

  late final _id3FaceStringList_DisposePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_STRING_LIST>)>>(
      'id3FaceStringList_Dispose');
  late final _id3FaceStringList_Dispose = _id3FaceStringList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_STRING_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hStringList [in] Handle to the StringList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_CheckHandle(
    ID3_FACE_STRING_LIST hStringList,
  ) {
    return _id3FaceStringList_CheckHandle(
      hStringList,
    );
  }

  late final _id3FaceStringList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_STRING_LIST)>>(
          'id3FaceStringList_CheckHandle');
  late final _id3FaceStringList_CheckHandle = _id3FaceStringList_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_STRING_LIST)>();

  /// Clears the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_Clear(
    ID3_FACE_STRING_LIST hStringList,
  ) {
    return _id3FaceStringList_Clear(
      hStringList,
    );
  }

  late final _id3FaceStringList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_STRING_LIST)>>(
          'id3FaceStringList_Clear');
  late final _id3FaceStringList_Clear = _id3FaceStringList_ClearPtr
      .asFunction<int Function(ID3_FACE_STRING_LIST)>();

  /// Adds an item to the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param item [in]  item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_Add(
    ID3_FACE_STRING_LIST hStringList,
    ffi.Pointer<ffi.Char> item,
  ) {
    return _id3FaceStringList_Add(
      hStringList,
      item,
    );
  }

  late final _id3FaceStringList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_STRING_LIST,
              ffi.Pointer<ffi.Char>)>>('id3FaceStringList_Add');
  late final _id3FaceStringList_Add = _id3FaceStringList_AddPtr
      .asFunction<int Function(ID3_FACE_STRING_LIST, ffi.Pointer<ffi.Char>)>();

  /// Gets an item of the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param index [in] Index of the  item to get.
  /// @param item [out]  item to get.
  /// @param itemSize [in,out] Size of the 'item' buffer. Receives the minimum required buffer size to hold the 'item' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'item' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_Get(
    ID3_FACE_STRING_LIST hStringList,
    int index,
    ffi.Pointer<ffi.Char> item,
    ffi.Pointer<ffi.Int> itemSize,
  ) {
    return _id3FaceStringList_Get(
      hStringList,
      index,
      item,
      itemSize,
    );
  }

  late final _id3FaceStringList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_STRING_LIST, ffi.Int, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceStringList_Get');
  late final _id3FaceStringList_Get = _id3FaceStringList_GetPtr.asFunction<
      int Function(ID3_FACE_STRING_LIST, int, ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Int>)>();

  /// Sets an item of the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param index [in] Index of the  item to set.
  /// @param item [in]  item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_Set(
    ID3_FACE_STRING_LIST hStringList,
    int index,
    ffi.Pointer<ffi.Char> item,
  ) {
    return _id3FaceStringList_Set(
      hStringList,
      index,
      item,
    );
  }

  late final _id3FaceStringList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_STRING_LIST, ffi.Int,
              ffi.Pointer<ffi.Char>)>>('id3FaceStringList_Set');
  late final _id3FaceStringList_Set = _id3FaceStringList_SetPtr.asFunction<
      int Function(ID3_FACE_STRING_LIST, int, ffi.Pointer<ffi.Char>)>();

  /// Gets the number of elements in the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param count [out] Number of elements in the  object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_GetCount(
    ID3_FACE_STRING_LIST hStringList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FaceStringList_GetCount(
      hStringList,
      count,
    );
  }

  late final _id3FaceStringList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_STRING_LIST,
              ffi.Pointer<ffi.Int>)>>('id3FaceStringList_GetCount');
  late final _id3FaceStringList_GetCount = _id3FaceStringList_GetCountPtr
      .asFunction<int Function(ID3_FACE_STRING_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param index [in] Index of the  item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_RemoveAt(
    ID3_FACE_STRING_LIST hStringList,
    int index,
  ) {
    return _id3FaceStringList_RemoveAt(
      hStringList,
      index,
    );
  }

  late final _id3FaceStringList_RemoveAtPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_STRING_LIST, ffi.Int)>>(
      'id3FaceStringList_RemoveAt');
  late final _id3FaceStringList_RemoveAt = _id3FaceStringList_RemoveAtPtr
      .asFunction<int Function(ID3_FACE_STRING_LIST, int)>();

  /// StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param newSize [in]  object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceStringList_Resize(
    ID3_FACE_STRING_LIST hStringList,
    int newSize,
  ) {
    return _id3FaceStringList_Resize(
      hStringList,
      newSize,
    );
  }

  late final _id3FaceStringList_ResizePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_STRING_LIST, ffi.Int)>>(
      'id3FaceStringList_Resize');
  late final _id3FaceStringList_Resize = _id3FaceStringList_ResizePtr
      .asFunction<int Function(ID3_FACE_STRING_LIST, int)>();

  /// @brief Initializes a ImageDict object.
  /// @param phImageDict [in] Handle to the ImageDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_Initialize(
    ffi.Pointer<ID3_FACE_IMAGE_DICT> phImageDict,
  ) {
    return _id3FaceImageDict_Initialize(
      phImageDict,
    );
  }

  late final _id3FaceImageDict_InitializePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_DICT>)>>(
      'id3FaceImageDict_Initialize');
  late final _id3FaceImageDict_Initialize = _id3FaceImageDict_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE_DICT>)>();

  /// @brief Releases the memory allocated for a ImageDict.
  /// @param phImageDict [in] Handle to the ImageDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_Dispose(
    ffi.Pointer<ID3_FACE_IMAGE_DICT> phImageDict,
  ) {
    return _id3FaceImageDict_Dispose(
      phImageDict,
    );
  }

  late final _id3FaceImageDict_DisposePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_DICT>)>>(
      'id3FaceImageDict_Dispose');
  late final _id3FaceImageDict_Dispose = _id3FaceImageDict_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE_DICT>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_CheckHandle(
    ID3_FACE_IMAGE_DICT hImageDict,
  ) {
    return _id3FaceImageDict_CheckHandle(
      hImageDict,
    );
  }

  late final _id3FaceImageDict_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE_DICT)>>(
          'id3FaceImageDict_CheckHandle');
  late final _id3FaceImageDict_CheckHandle = _id3FaceImageDict_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_IMAGE_DICT)>();

  /// @brief Copies an instance of ImageDict object to another.
  /// @param hImageDictSrc [in] Handle to the source ImageDict object.
  /// @param hImageDictDst [in] Handle to the destination ImageDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_CopyTo(
    ID3_FACE_IMAGE_DICT hImageDictSrc,
    ID3_FACE_IMAGE_DICT hImageDictDst,
  ) {
    return _id3FaceImageDict_CopyTo(
      hImageDictSrc,
      hImageDictDst,
    );
  }

  late final _id3FaceImageDict_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT,
              ID3_FACE_IMAGE_DICT)>>('id3FaceImageDict_CopyTo');
  late final _id3FaceImageDict_CopyTo = _id3FaceImageDict_CopyToPtr
      .asFunction<int Function(ID3_FACE_IMAGE_DICT, ID3_FACE_IMAGE_DICT)>();

  /// Gets the gets a string list containing the keys in the dict.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @param hKeys [out] Gets a string list containing the keys in the dict.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_GetKeys(
    ID3_FACE_IMAGE_DICT hImageDict,
    ID3_FACE_STRING_LIST hKeys,
  ) {
    return _id3FaceImageDict_GetKeys(
      hImageDict,
      hKeys,
    );
  }

  late final _id3FaceImageDict_GetKeysPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT,
              ID3_FACE_STRING_LIST)>>('id3FaceImageDict_GetKeys');
  late final _id3FaceImageDict_GetKeys = _id3FaceImageDict_GetKeysPtr
      .asFunction<int Function(ID3_FACE_IMAGE_DICT, ID3_FACE_STRING_LIST)>();

  /// Clears the ImageDict object.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_Clear(
    ID3_FACE_IMAGE_DICT hImageDict,
  ) {
    return _id3FaceImageDict_Clear(
      hImageDict,
    );
  }

  late final _id3FaceImageDict_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE_DICT)>>(
          'id3FaceImageDict_Clear');
  late final _id3FaceImageDict_Clear = _id3FaceImageDict_ClearPtr
      .asFunction<int Function(ID3_FACE_IMAGE_DICT)>();

  /// Adds an item to the ImageDict object.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @param key [in] Unique key of the Image item to add.
  /// @param hImageItem [in] Image item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_Add(
    ID3_FACE_IMAGE_DICT hImageDict,
    ffi.Pointer<ffi.Char> key,
    ID3_FACE_IMAGE hImageItem,
  ) {
    return _id3FaceImageDict_Add(
      hImageDict,
      key,
      hImageItem,
    );
  }

  late final _id3FaceImageDict_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>,
              ID3_FACE_IMAGE)>>('id3FaceImageDict_Add');
  late final _id3FaceImageDict_Add = _id3FaceImageDict_AddPtr.asFunction<
      int Function(
          ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>, ID3_FACE_IMAGE)>();

  /// Gets an item of the ImageDict object.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @param key [in] Unique key of the Image item to get.
  /// @param hImageItem [out] Image item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_Get(
    ID3_FACE_IMAGE_DICT hImageDict,
    ffi.Pointer<ffi.Char> key,
    ID3_FACE_IMAGE hImageItem,
  ) {
    return _id3FaceImageDict_Get(
      hImageDict,
      key,
      hImageItem,
    );
  }

  late final _id3FaceImageDict_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>,
              ID3_FACE_IMAGE)>>('id3FaceImageDict_Get');
  late final _id3FaceImageDict_Get = _id3FaceImageDict_GetPtr.asFunction<
      int Function(
          ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>, ID3_FACE_IMAGE)>();

  /// Sets an item of the ImageDict object.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @param key [in] Unique key of the Image item to set.
  /// @param hImageItem [in] Image item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_Set(
    ID3_FACE_IMAGE_DICT hImageDict,
    ffi.Pointer<ffi.Char> key,
    ID3_FACE_IMAGE hImageItem,
  ) {
    return _id3FaceImageDict_Set(
      hImageDict,
      key,
      hImageItem,
    );
  }

  late final _id3FaceImageDict_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>,
              ID3_FACE_IMAGE)>>('id3FaceImageDict_Set');
  late final _id3FaceImageDict_Set = _id3FaceImageDict_SetPtr.asFunction<
      int Function(
          ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>, ID3_FACE_IMAGE)>();

  /// Gets the number of elements in the ImageDict object.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @param count [out] Number of elements in the Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_GetCount(
    ID3_FACE_IMAGE_DICT hImageDict,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FaceImageDict_GetCount(
      hImageDict,
      count,
    );
  }

  late final _id3FaceImageDict_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT,
              ffi.Pointer<ffi.Int>)>>('id3FaceImageDict_GetCount');
  late final _id3FaceImageDict_GetCount = _id3FaceImageDict_GetCountPtr
      .asFunction<int Function(ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Int>)>();

  /// Determines whether the ImageDictobject contains the specified key.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @param key [in] The key to locate in the Image object.
  /// @param result [out] true if the Image object contains an element with the specified key, otherwise false.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_ContainsKey(
    ID3_FACE_IMAGE_DICT hImageDict,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Bool> result,
  ) {
    return _id3FaceImageDict_ContainsKey(
      hImageDict,
      key,
      result,
    );
  }

  late final _id3FaceImageDict_ContainsKeyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>>('id3FaceImageDict_ContainsKey');
  late final _id3FaceImageDict_ContainsKey =
      _id3FaceImageDict_ContainsKeyPtr.asFunction<
          int Function(ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>();

  /// Removes an element of the ImageDict object.
  /// @param hImageDict [in] Handle to the ImageDict object.
  /// @param key [in] Unique key of the Image item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageDict_Remove(
    ID3_FACE_IMAGE_DICT hImageDict,
    ffi.Pointer<ffi.Char> key,
  ) {
    return _id3FaceImageDict_Remove(
      hImageDict,
      key,
    );
  }

  late final _id3FaceImageDict_RemovePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_DICT,
              ffi.Pointer<ffi.Char>)>>('id3FaceImageDict_Remove');
  late final _id3FaceImageDict_Remove = _id3FaceImageDict_RemovePtr
      .asFunction<int Function(ID3_FACE_IMAGE_DICT, ffi.Pointer<ffi.Char>)>();

  ffi.Pointer<ffi.Char> id3Face_GetImageErrorString(
    int value,
  ) {
    return _id3Face_GetImageErrorString(
      value,
    );
  }

  late final _id3Face_GetImageErrorStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetImageErrorString');
  late final _id3Face_GetImageErrorString = _id3Face_GetImageErrorStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetImageErrorMessage(
    int value,
  ) {
    return _id3Face_GetImageErrorMessage(
      value,
    );
  }

  late final _id3Face_GetImageErrorMessagePtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetImageErrorMessage');
  late final _id3Face_GetImageErrorMessage = _id3Face_GetImageErrorMessagePtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a ImageList object.
  /// @param phImageList [in] Handle to the ImageList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_Initialize(
    ffi.Pointer<ID3_FACE_IMAGE_LIST> phImageList,
  ) {
    return _id3FaceImageList_Initialize(
      phImageList,
    );
  }

  late final _id3FaceImageList_InitializePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_LIST>)>>(
      'id3FaceImageList_Initialize');
  late final _id3FaceImageList_Initialize = _id3FaceImageList_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE_LIST>)>();

  /// @brief Releases the memory allocated for a ImageList.
  /// @param phImageList [in] Handle to the ImageList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_Dispose(
    ffi.Pointer<ID3_FACE_IMAGE_LIST> phImageList,
  ) {
    return _id3FaceImageList_Dispose(
      phImageList,
    );
  }

  late final _id3FaceImageList_DisposePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_LIST>)>>(
      'id3FaceImageList_Dispose');
  late final _id3FaceImageList_Dispose = _id3FaceImageList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_IMAGE_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_CheckHandle(
    ID3_FACE_IMAGE_LIST hImageList,
  ) {
    return _id3FaceImageList_CheckHandle(
      hImageList,
    );
  }

  late final _id3FaceImageList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE_LIST)>>(
          'id3FaceImageList_CheckHandle');
  late final _id3FaceImageList_CheckHandle = _id3FaceImageList_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST)>();

  /// @brief Copies an instance of ImageList object to another.
  /// @param hImageListSrc [in] Handle to the source ImageList object.
  /// @param hImageListDst [in] Handle to the destination ImageList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_CopyTo(
    ID3_FACE_IMAGE_LIST hImageListSrc,
    ID3_FACE_IMAGE_LIST hImageListDst,
  ) {
    return _id3FaceImageList_CopyTo(
      hImageListSrc,
      hImageListDst,
    );
  }

  late final _id3FaceImageList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_LIST,
              ID3_FACE_IMAGE_LIST)>>('id3FaceImageList_CopyTo');
  late final _id3FaceImageList_CopyTo = _id3FaceImageList_CopyToPtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST, ID3_FACE_IMAGE_LIST)>();

  /// Clears the ImageList object.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_Clear(
    ID3_FACE_IMAGE_LIST hImageList,
  ) {
    return _id3FaceImageList_Clear(
      hImageList,
    );
  }

  late final _id3FaceImageList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE_LIST)>>(
          'id3FaceImageList_Clear');
  late final _id3FaceImageList_Clear = _id3FaceImageList_ClearPtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST)>();

  /// Adds an item to the ImageList object.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @param hImageItem [in] Image item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_Add(
    ID3_FACE_IMAGE_LIST hImageList,
    ID3_FACE_IMAGE hImageItem,
  ) {
    return _id3FaceImageList_Add(
      hImageList,
      hImageItem,
    );
  }

  late final _id3FaceImageList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_IMAGE_LIST, ID3_FACE_IMAGE)>>('id3FaceImageList_Add');
  late final _id3FaceImageList_Add = _id3FaceImageList_AddPtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST, ID3_FACE_IMAGE)>();

  /// Gets an item of the ImageList object.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @param index [in] Index of the Image item to get.
  /// @param hImageItem [out] Image item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_Get(
    ID3_FACE_IMAGE_LIST hImageList,
    int index,
    ID3_FACE_IMAGE hImageItem,
  ) {
    return _id3FaceImageList_Get(
      hImageList,
      index,
      hImageItem,
    );
  }

  late final _id3FaceImageList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_LIST, ffi.Int,
              ID3_FACE_IMAGE)>>('id3FaceImageList_Get');
  late final _id3FaceImageList_Get = _id3FaceImageList_GetPtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST, int, ID3_FACE_IMAGE)>();

  /// Sets an item of the ImageList object.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @param index [in] Index of the Image item to set.
  /// @param hImageItem [in] Image item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_Set(
    ID3_FACE_IMAGE_LIST hImageList,
    int index,
    ID3_FACE_IMAGE hImageItem,
  ) {
    return _id3FaceImageList_Set(
      hImageList,
      index,
      hImageItem,
    );
  }

  late final _id3FaceImageList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_LIST, ffi.Int,
              ID3_FACE_IMAGE)>>('id3FaceImageList_Set');
  late final _id3FaceImageList_Set = _id3FaceImageList_SetPtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST, int, ID3_FACE_IMAGE)>();

  /// Gets the number of elements in the ImageList object.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @param count [out] Number of elements in the Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_GetCount(
    ID3_FACE_IMAGE_LIST hImageList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FaceImageList_GetCount(
      hImageList,
      count,
    );
  }

  late final _id3FaceImageList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_IMAGE_LIST,
              ffi.Pointer<ffi.Int>)>>('id3FaceImageList_GetCount');
  late final _id3FaceImageList_GetCount = _id3FaceImageList_GetCountPtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the ImageList object.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @param index [in] Index of the Image item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_RemoveAt(
    ID3_FACE_IMAGE_LIST hImageList,
    int index,
  ) {
    return _id3FaceImageList_RemoveAt(
      hImageList,
      index,
    );
  }

  late final _id3FaceImageList_RemoveAtPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE_LIST, ffi.Int)>>(
      'id3FaceImageList_RemoveAt');
  late final _id3FaceImageList_RemoveAt = _id3FaceImageList_RemoveAtPtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST, int)>();

  /// ImageList object.
  /// @param hImageList [in] Handle to the ImageList object.
  /// @param newSize [in] Image object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceImageList_Resize(
    ID3_FACE_IMAGE_LIST hImageList,
    int newSize,
  ) {
    return _id3FaceImageList_Resize(
      hImageList,
      newSize,
    );
  }

  late final _id3FaceImageList_ResizePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_IMAGE_LIST, ffi.Int)>>(
      'id3FaceImageList_Resize');
  late final _id3FaceImageList_Resize = _id3FaceImageList_ResizePtr
      .asFunction<int Function(ID3_FACE_IMAGE_LIST, int)>();

  /// @brief Initializes a FaceIndexer object.
  /// @param phFaceIndexer [in] Handle to the FaceIndexer object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_Initialize(
    ffi.Pointer<ID3_FACE_INDEXER> phFaceIndexer,
  ) {
    return _id3FaceIndexer_Initialize(
      phFaceIndexer,
    );
  }

  late final _id3FaceIndexer_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_INDEXER>)>>(
      'id3FaceIndexer_Initialize');
  late final _id3FaceIndexer_Initialize = _id3FaceIndexer_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_INDEXER>)>();

  /// @brief Releases the memory allocated for a FaceIndexer.
  /// @param phFaceIndexer [in] Handle to the FaceIndexer object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_Dispose(
    ffi.Pointer<ID3_FACE_INDEXER> phFaceIndexer,
  ) {
    return _id3FaceIndexer_Dispose(
      phFaceIndexer,
    );
  }

  late final _id3FaceIndexer_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_INDEXER>)>>(
      'id3FaceIndexer_Dispose');
  late final _id3FaceIndexer_Dispose = _id3FaceIndexer_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_INDEXER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_CheckHandle(
    ID3_FACE_INDEXER hFaceIndexer,
  ) {
    return _id3FaceIndexer_CheckHandle(
      hFaceIndexer,
    );
  }

  late final _id3FaceIndexer_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_INDEXER)>>(
          'id3FaceIndexer_CheckHandle');
  late final _id3FaceIndexer_CheckHandle = _id3FaceIndexer_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_INDEXER)>();

  /// Gets the face template format accepted by this face indexer.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param eFormat [out] Face template format accepted by this face indexer.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_GetFormat(
    ID3_FACE_INDEXER hFaceIndexer,
    ffi.Pointer<ffi.Int32> eFormat,
  ) {
    return _id3FaceIndexer_GetFormat(
      hFaceIndexer,
      eFormat,
    );
  }

  late final _id3FaceIndexer_GetFormatPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER,
              ffi.Pointer<ffi.Int32>)>>('id3FaceIndexer_GetFormat');
  late final _id3FaceIndexer_GetFormat = _id3FaceIndexer_GetFormatPtr
      .asFunction<int Function(ID3_FACE_INDEXER, ffi.Pointer<ffi.Int32>)>();

  /// Gets the maximum number of templates that this face indexer can hold.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param maximumTemplateCount [out] Maximum number of templates that this face indexer can hold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_GetMaximumTemplateCount(
    ID3_FACE_INDEXER hFaceIndexer,
    ffi.Pointer<ffi.Int> maximumTemplateCount,
  ) {
    return _id3FaceIndexer_GetMaximumTemplateCount(
      hFaceIndexer,
      maximumTemplateCount,
    );
  }

  late final _id3FaceIndexer_GetMaximumTemplateCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER,
              ffi.Pointer<ffi.Int>)>>('id3FaceIndexer_GetMaximumTemplateCount');
  late final _id3FaceIndexer_GetMaximumTemplateCount =
      _id3FaceIndexer_GetMaximumTemplateCountPtr
          .asFunction<int Function(ID3_FACE_INDEXER, ffi.Pointer<ffi.Int>)>();

  /// Gets the current number of indexed templates.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param templateCount [out] Current number of indexed templates.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_GetTemplateCount(
    ID3_FACE_INDEXER hFaceIndexer,
    ffi.Pointer<ffi.Int> templateCount,
  ) {
    return _id3FaceIndexer_GetTemplateCount(
      hFaceIndexer,
      templateCount,
    );
  }

  late final _id3FaceIndexer_GetTemplateCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER,
              ffi.Pointer<ffi.Int>)>>('id3FaceIndexer_GetTemplateCount');
  late final _id3FaceIndexer_GetTemplateCount =
      _id3FaceIndexer_GetTemplateCountPtr
          .asFunction<int Function(ID3_FACE_INDEXER, ffi.Pointer<ffi.Int>)>();

  /// Adds a template to the Face Indexer.
  /// Note: This function is thread safe with other AddTemplate() calls but not with SearchTemplates() calls.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param hFaceTemplate [in] Face template to add to the face indexer.
  /// @param id [in] ID of the added face template.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_AddTemplate(
    ID3_FACE_INDEXER hFaceIndexer,
    ID3_FACE_TEMPLATE hFaceTemplate,
    ffi.Pointer<ffi.Char> id,
  ) {
    return _id3FaceIndexer_AddTemplate(
      hFaceIndexer,
      hFaceTemplate,
      id,
    );
  }

  late final _id3FaceIndexer_AddTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER, ID3_FACE_TEMPLATE,
              ffi.Pointer<ffi.Char>)>>('id3FaceIndexer_AddTemplate');
  late final _id3FaceIndexer_AddTemplate =
      _id3FaceIndexer_AddTemplatePtr.asFunction<
          int Function(
              ID3_FACE_INDEXER, ID3_FACE_TEMPLATE, ffi.Pointer<ffi.Char>)>();

  /// Creates an empty face indexer
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param maximumTemplateCount [in] Maximum number of templates that this face indexer can hold.
  /// @param eFormat [in] Face template format accepted by this face indexer.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_Create(
    ID3_FACE_INDEXER hFaceIndexer,
    int maximumTemplateCount,
    int eFormat,
  ) {
    return _id3FaceIndexer_Create(
      hFaceIndexer,
      maximumTemplateCount,
      eFormat,
    );
  }

  late final _id3FaceIndexer_CreatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_INDEXER, ffi.Int, ffi.Int32)>>('id3FaceIndexer_Create');
  late final _id3FaceIndexer_Create = _id3FaceIndexer_CreatePtr
      .asFunction<int Function(ID3_FACE_INDEXER, int, int)>();

  /// Deletes a template from the face indexer.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param id [in] ID of the face template to delete.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_DeleteTemplate(
    ID3_FACE_INDEXER hFaceIndexer,
    ffi.Pointer<ffi.Char> id,
  ) {
    return _id3FaceIndexer_DeleteTemplate(
      hFaceIndexer,
      id,
    );
  }

  late final _id3FaceIndexer_DeleteTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER,
              ffi.Pointer<ffi.Char>)>>('id3FaceIndexer_DeleteTemplate');
  late final _id3FaceIndexer_DeleteTemplate = _id3FaceIndexer_DeleteTemplatePtr
      .asFunction<int Function(ID3_FACE_INDEXER, ffi.Pointer<ffi.Char>)>();

  /// Imports the face indexer object from a file.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param path [in] Path to the file to import the face indexer object from.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_FromFile(
    ID3_FACE_INDEXER hFaceIndexer,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceIndexer_FromFile(
      hFaceIndexer,
      path,
    );
  }

  late final _id3FaceIndexer_FromFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER,
              ffi.Pointer<ffi.Char>)>>('id3FaceIndexer_FromFile');
  late final _id3FaceIndexer_FromFile = _id3FaceIndexer_FromFilePtr
      .asFunction<int Function(ID3_FACE_INDEXER, ffi.Pointer<ffi.Char>)>();

  /// Retrieves a template from the face indexer by ID.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param id [in] ID of the required face template.
  /// @param hFaceTemplate [out] The face template.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_GetTemplate(
    ID3_FACE_INDEXER hFaceIndexer,
    ffi.Pointer<ffi.Char> id,
    ID3_FACE_TEMPLATE hFaceTemplate,
  ) {
    return _id3FaceIndexer_GetTemplate(
      hFaceIndexer,
      id,
      hFaceTemplate,
    );
  }

  late final _id3FaceIndexer_GetTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER, ffi.Pointer<ffi.Char>,
              ID3_FACE_TEMPLATE)>>('id3FaceIndexer_GetTemplate');
  late final _id3FaceIndexer_GetTemplate =
      _id3FaceIndexer_GetTemplatePtr.asFunction<
          int Function(
              ID3_FACE_INDEXER, ffi.Pointer<ffi.Char>, ID3_FACE_TEMPLATE)>();

  /// Resizes the maximum number of templates that the face indexer can hold.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param maximumCount [in] Maximum number of templates that this face indexer can hold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_Resize(
    ID3_FACE_INDEXER hFaceIndexer,
    int maximumCount,
  ) {
    return _id3FaceIndexer_Resize(
      hFaceIndexer,
      maximumCount,
    );
  }

  late final _id3FaceIndexer_ResizePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_INDEXER, ffi.Int)>>(
          'id3FaceIndexer_Resize');
  late final _id3FaceIndexer_Resize = _id3FaceIndexer_ResizePtr
      .asFunction<int Function(ID3_FACE_INDEXER, int)>();

  /// Performs a one-to-many search of a face template probe against a previously initialized face indexer and outputs a candidate list.
  /// This function is thread safe with other SearchTemplate() calls but not with AddTemplate() calls.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param hProbe [in] The face template probe.
  /// @param maxCandidates [in] Maximum number of candidates in the candidate list.
  /// @param hCandidates [out] The list of candidates sorted by decreasing match score.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_SearchTemplate(
    ID3_FACE_INDEXER hFaceIndexer,
    ID3_FACE_TEMPLATE hProbe,
    int maxCandidates,
    ID3_FACE_CANDIDATE_LIST hCandidates,
  ) {
    return _id3FaceIndexer_SearchTemplate(
      hFaceIndexer,
      hProbe,
      maxCandidates,
      hCandidates,
    );
  }

  late final _id3FaceIndexer_SearchTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER, ID3_FACE_TEMPLATE, ffi.Int,
              ID3_FACE_CANDIDATE_LIST)>>('id3FaceIndexer_SearchTemplate');
  late final _id3FaceIndexer_SearchTemplate =
      _id3FaceIndexer_SearchTemplatePtr.asFunction<
          int Function(ID3_FACE_INDEXER, ID3_FACE_TEMPLATE, int,
              ID3_FACE_CANDIDATE_LIST)>();

  /// Saves the face indexer object to a file.
  /// @param hFaceIndexer [in] Handle to the FaceIndexer object.
  /// @param path [in] Path to the file to export the face indexer object to.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceIndexer_ToFile(
    ID3_FACE_INDEXER hFaceIndexer,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceIndexer_ToFile(
      hFaceIndexer,
      path,
    );
  }

  late final _id3FaceIndexer_ToFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_INDEXER,
              ffi.Pointer<ffi.Char>)>>('id3FaceIndexer_ToFile');
  late final _id3FaceIndexer_ToFile = _id3FaceIndexer_ToFilePtr
      .asFunction<int Function(ID3_FACE_INDEXER, ffi.Pointer<ffi.Char>)>();

  /// Retrieves the model file name which is needed in the LoadModel function.
  /// @param eModel [in] The Face Model to look for.
  /// @param fileName [out] The expected file name
  /// @param fileNameSize [in,out] Size of the 'fileName' buffer. Receives the minimum required buffer size to hold the 'fileName' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'fileName' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLibrary_GetModelFileName(
    int eModel,
    ffi.Pointer<ffi.Char> fileName,
    ffi.Pointer<ffi.Int> fileNameSize,
  ) {
    return _id3FaceLibrary_GetModelFileName(
      eModel,
      fileName,
      fileNameSize,
    );
  }

  late final _id3FaceLibrary_GetModelFileNamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Int32, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLibrary_GetModelFileName');
  late final _id3FaceLibrary_GetModelFileName =
      _id3FaceLibrary_GetModelFileNamePtr.asFunction<
          int Function(int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the library version as a `X.Y.Z` formatted string.
  /// @param libraryVersion [out] A string that identifies the library version.
  /// @param libraryVersionSize [in,out] Size of the 'libraryVersion' buffer. Receives the minimum required buffer size to hold the 'libraryVersion' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'libraryVersion' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLibrary_GetVersion(
    ffi.Pointer<ffi.Char> libraryVersion,
    ffi.Pointer<ffi.Int> libraryVersionSize,
  ) {
    return _id3FaceLibrary_GetVersion(
      libraryVersion,
      libraryVersionSize,
    );
  }

  late final _id3FaceLibrary_GetVersionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLibrary_GetVersion');
  late final _id3FaceLibrary_GetVersion = _id3FaceLibrary_GetVersionPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the library version as a structure.
  /// @param sVersion [out] The version.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLibrary_GetVersionEx(
    ffi.Pointer<id3FaceLibVersion> sVersion,
  ) {
    return _id3FaceLibrary_GetVersionEx(
      sVersion,
    );
  }

  late final _id3FaceLibrary_GetVersionExPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<id3FaceLibVersion>)>>(
      'id3FaceLibrary_GetVersionEx');
  late final _id3FaceLibrary_GetVersionEx = _id3FaceLibrary_GetVersionExPtr
      .asFunction<int Function(ffi.Pointer<id3FaceLibVersion>)>();

  /// Loads a specified AI model into memory from the specified directory.
  /// @param modelPath [in] The path to directory containing the AI model files.
  /// @param eFaceModel [in] The AI model to be loaded.
  /// @param eProcessingUnit [in] The processing unit to be used.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLibrary_LoadModel(
    ffi.Pointer<ffi.Char> modelPath,
    int eFaceModel,
    int eProcessingUnit,
  ) {
    return _id3FaceLibrary_LoadModel(
      modelPath,
      eFaceModel,
      eProcessingUnit,
    );
  }

  late final _id3FaceLibrary_LoadModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Int32,
              ffi.Int32)>>('id3FaceLibrary_LoadModel');
  late final _id3FaceLibrary_LoadModel = _id3FaceLibrary_LoadModelPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, int, int)>();

  /// Loads a model into memory from the specified buffer.
  /// @param modelBuffer [in] A buffer containing the AI model to be loaded.
  /// @param modelBufferSize [in] Size of the 'modelBuffer' buffer.
  /// @param eFaceModel [in] The AI model to be loaded.
  /// @param eProcessingUnit [in] The processing unit to be used.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLibrary_LoadModelBuffer(
    ffi.Pointer<ffi.UnsignedChar> modelBuffer,
    int modelBufferSize,
    int eFaceModel,
    int eProcessingUnit,
  ) {
    return _id3FaceLibrary_LoadModelBuffer(
      modelBuffer,
      modelBufferSize,
      eFaceModel,
      eProcessingUnit,
    );
  }

  late final _id3FaceLibrary_LoadModelBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Int, ffi.Int32,
              ffi.Int32)>>('id3FaceLibrary_LoadModelBuffer');
  late final _id3FaceLibrary_LoadModelBuffer =
      _id3FaceLibrary_LoadModelBufferPtr.asFunction<
          int Function(ffi.Pointer<ffi.UnsignedChar>, int, int, int)>();

  /// Unloads a model from memory.
  /// @param eFaceModel [in] The AI model to be unloaded.
  /// @param eProcessingUnit [in] The processing unit used for the model.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLibrary_UnloadModel(
    int eFaceModel,
    int eProcessingUnit,
  ) {
    return _id3FaceLibrary_UnloadModel(
      eFaceModel,
      eProcessingUnit,
    );
  }

  late final _id3FaceLibrary_UnloadModelPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Int32, ffi.Int32)>>(
          'id3FaceLibrary_UnloadModel');
  late final _id3FaceLibrary_UnloadModel =
      _id3FaceLibrary_UnloadModelPtr.asFunction<int Function(int, int)>();

  ffi.Pointer<ffi.Char> id3Face_GetLicenseHardwareCodeTypeString(
    int value,
  ) {
    return _id3Face_GetLicenseHardwareCodeTypeString(
      value,
    );
  }

  late final _id3Face_GetLicenseHardwareCodeTypeStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetLicenseHardwareCodeTypeString');
  late final _id3Face_GetLicenseHardwareCodeTypeString =
      _id3Face_GetLicenseHardwareCodeTypeStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetLicenseTypeString(
    int value,
  ) {
    return _id3Face_GetLicenseTypeString(
      value,
    );
  }

  late final _id3Face_GetLicenseTypeStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetLicenseTypeString');
  late final _id3Face_GetLicenseTypeString = _id3Face_GetLicenseTypeStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// Activates a license using customer credentials and a product reference and saves the license to a file.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param login [in] The id3 account login.
  /// @param password [in] The id3 account password.
  /// @param productReference [in] The requested product reference.
  /// @param commentary [in] Commentary associated to this license activation.
  /// @param path [in] Path to the retrieved license file.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_Activate(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> login,
    ffi.Pointer<ffi.Char> password,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceLicense_Activate(
      hardwareCode,
      login,
      password,
      productReference,
      commentary,
      path,
    );
  }

  late final _id3FaceLicense_ActivatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3FaceLicense_Activate');
  late final _id3FaceLicense_Activate = _id3FaceLicense_ActivatePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>)>();

  /// Activates a license file using an activation key and saves the license to a file.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param activationKey [in] The activation key.
  /// @param commentary [in] Commentary associated to this license activation, generally the host name.
  /// @param path [in] Path to the retrieved license file.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_ActivateActivationKey(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> activationKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceLicense_ActivateActivationKey(
      hardwareCode,
      activationKey,
      commentary,
      path,
    );
  }

  late final _id3FaceLicense_ActivateActivationKeyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3FaceLicense_ActivateActivationKey');
  late final _id3FaceLicense_ActivateActivationKey =
      _id3FaceLicense_ActivateActivationKeyPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  /// Activates a license using an activation key and returns the license in a data buffer.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param activationKey [in] The id3 activation key.
  /// @param commentary [in] Commentary associated to this license activation.
  /// @param licenseFileBuffer [out] The license data buffer.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_ActivateActivationKeyBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> activationKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3FaceLicense_ActivateActivationKeyBuffer(
      hardwareCode,
      activationKey,
      commentary,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3FaceLicense_ActivateActivationKeyBufferPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.UnsignedChar>,
                  ffi.Pointer<ffi.Int>)>>(
      'id3FaceLicense_ActivateActivationKeyBuffer');
  late final _id3FaceLicense_ActivateActivationKeyBuffer =
      _id3FaceLicense_ActivateActivationKeyBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Retrieves a license file buffer using customer credentials and a product reference and returns the license in a data buffer.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param login [in] The customer login.
  /// @param password [in] The customer password.
  /// @param productReference [in] The requested product reference.
  /// @param commentary [in] Commentary associated to this license activation, generally the host name.
  /// @param licenseFileBuffer [out] The license data.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_ActivateBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> login,
    ffi.Pointer<ffi.Char> password,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3FaceLicense_ActivateBuffer(
      hardwareCode,
      login,
      password,
      productReference,
      commentary,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3FaceLicense_ActivateBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_ActivateBuffer');
  late final _id3FaceLicense_ActivateBuffer =
      _id3FaceLicense_ActivateBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Activates a license using a serial key and saves the license to a file.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param serialKey [in] The serial key to activate.
  /// @param commentary [in] Commentary associated to this license activation, generally the host name.
  /// @param path [in] Path to the license file.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_ActivateSerialKey(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> serialKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceLicense_ActivateSerialKey(
      hardwareCode,
      serialKey,
      commentary,
      path,
    );
  }

  late final _id3FaceLicense_ActivateSerialKeyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3FaceLicense_ActivateSerialKey');
  late final _id3FaceLicense_ActivateSerialKey =
      _id3FaceLicense_ActivateSerialKeyPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  /// Activates a license using a serial key and returns the license in a data buffer.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param serialKey [in] The id3 serial key.
  /// @param commentary [in] Commentary associated to this license activation.
  /// @param licenseFileBuffer [out] The license data buffer.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_ActivateSerialKeyBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> serialKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3FaceLicense_ActivateSerialKeyBuffer(
      hardwareCode,
      serialKey,
      commentary,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3FaceLicense_ActivateSerialKeyBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_ActivateSerialKeyBuffer');
  late final _id3FaceLicense_ActivateSerialKeyBuffer =
      _id3FaceLicense_ActivateSerialKeyBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Checks a license from a file.
  /// This function does two things:
  /// - First it loads the license from a file using the given path
  /// - Then it checks the validity of the license regarding the host it is called on (Windows, Linux, Android ...)
  /// Important: Calling this function is required to get access to the license member getters.
  /// Note: The optional parameter is required on Android and must be the JNIEnv* pointer casted as a void*. It can be set as NULL for other devices.
  /// @param licensePath [in] Absolute or relative path to the license file.
  /// @param optionalParameter [in] Only used on Android: JNIEnv* pointer casted as a void*. Ignored for other devices.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_CheckLicense(
    ffi.Pointer<ffi.Char> licensePath,
    ffi.Pointer<ffi.Void> optionalParameter,
  ) {
    return _id3FaceLicense_CheckLicense(
      licensePath,
      optionalParameter,
    );
  }

  late final _id3FaceLicense_CheckLicensePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Void>)>>('id3FaceLicense_CheckLicense');
  late final _id3FaceLicense_CheckLicense = _id3FaceLicense_CheckLicensePtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Void>)>();

  /// Checks a license from a buffer.
  /// This function does two things:
  /// - First it loads the license from a buffer
  /// - Then it checks the validity of the license regarding the host it is called on (Windows, Linux, Android ...)
  /// Important: Calling one of the license checking function is required to get access to all the license member getters.
  /// Note: The optional parameter is required on Android and must be the JNIEnv* pointer casted as a void*. It can be set as NULL for other devices.
  /// @param licenseData [in] A buffer containing the license file data.
  /// @param licenseDataSize [in] Size of the 'licenseData' buffer.
  /// @param optionalParameter [in] Only used on Android: JNIEnv* pointer casted as a void*. Ignored for other devices.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_CheckLicenseBuffer(
    ffi.Pointer<ffi.UnsignedChar> licenseData,
    int licenseDataSize,
    ffi.Pointer<ffi.Void> optionalParameter,
  ) {
    return _id3FaceLicense_CheckLicenseBuffer(
      licenseData,
      licenseDataSize,
      optionalParameter,
    );
  }

  late final _id3FaceLicense_CheckLicenseBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Int,
              ffi.Pointer<ffi.Void>)>>('id3FaceLicense_CheckLicenseBuffer');
  late final _id3FaceLicense_CheckLicenseBuffer =
      _id3FaceLicense_CheckLicenseBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.UnsignedChar>, int, ffi.Pointer<ffi.Void>)>();

  /// Checks the license using a buffer containing the license data and a card-based verification process.
  /// It outputs a challenge response for further verification.
  /// @param licenseData [in] A buffer containing the license file data.
  /// @param licenseDataSize [in] Size of the 'licenseData' buffer.
  /// @param challengeR1 [out] An array to hold the challenge response generated by the host.
  /// @param challengeR1Size [in,out] Size of the 'challengeR1' buffer. Receives the number of elements in the 'challengeR1' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_CheckLicenseBufferWithCard(
    ffi.Pointer<ffi.UnsignedChar> licenseData,
    int licenseDataSize,
    ffi.Pointer<ffi.UnsignedChar> challengeR1,
    ffi.Pointer<ffi.Int> challengeR1Size,
  ) {
    return _id3FaceLicense_CheckLicenseBufferWithCard(
      licenseData,
      licenseDataSize,
      challengeR1,
      challengeR1Size,
    );
  }

  late final _id3FaceLicense_CheckLicenseBufferWithCardPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Int,
                  ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>>(
      'id3FaceLicense_CheckLicenseBufferWithCard');
  late final _id3FaceLicense_CheckLicenseBufferWithCard =
      _id3FaceLicense_CheckLicenseBufferWithCardPtr.asFunction<
          int Function(ffi.Pointer<ffi.UnsignedChar>, int,
              ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>();

  /// Checks the license by using a card-based verification process.
  /// It takes the path to the license file and outputs a challenge response for further verification.
  /// @param licensePath [in] The file path to the license that needs to be checked.
  /// @param challengeR1 [out] An array to hold the challenge response generated by the host.
  /// @param challengeR1Size [in,out] Size of the 'challengeR1' buffer. Receives the number of elements in the 'challengeR1' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_CheckLicenseWithCard(
    ffi.Pointer<ffi.Char> licensePath,
    ffi.Pointer<ffi.UnsignedChar> challengeR1,
    ffi.Pointer<ffi.Int> challengeR1Size,
  ) {
    return _id3FaceLicense_CheckLicenseWithCard(
      licensePath,
      challengeR1,
      challengeR1Size,
    );
  }

  late final _id3FaceLicense_CheckLicenseWithCardPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_CheckLicenseWithCard');
  late final _id3FaceLicense_CheckLicenseWithCard =
      _id3FaceLicense_CheckLicenseWithCardPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Checks if a module is present in the previously loaded license.
  /// @param moduleName [in] The module name.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_CheckModule(
    ffi.Pointer<ffi.Char> moduleName,
  ) {
    return _id3FaceLicense_CheckModule(
      moduleName,
    );
  }

  late final _id3FaceLicense_CheckModulePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>)>>(
          'id3FaceLicense_CheckModule');
  late final _id3FaceLicense_CheckModule = _id3FaceLicense_CheckModulePtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>)>();

  /// Finalizes the license check process using the provided cryptogram.
  /// It ensures the integrity and authenticity of the license verification.
  /// @param cryptogram [in] A 32-byte array containing the cryptogram used for final verification.
  /// @param cryptogramSize [in] Size of the 'cryptogram' buffer.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_FinalizeCheckLicenseWithCard(
    ffi.Pointer<ffi.UnsignedChar> cryptogram,
    int cryptogramSize,
  ) {
    return _id3FaceLicense_FinalizeCheckLicenseWithCard(
      cryptogram,
      cryptogramSize,
    );
  }

  late final _id3FaceLicense_FinalizeCheckLicenseWithCardPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int)>>('id3FaceLicense_FinalizeCheckLicenseWithCard');
  late final _id3FaceLicense_FinalizeCheckLicenseWithCard =
      _id3FaceLicense_FinalizeCheckLicenseWithCardPtr
          .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Retrieves the license expiry date.
  /// @param expiryDate [out] The license expiry date.
  /// @param expiryDateSize [in,out] Size of the 'expiryDate' buffer. Receives the minimum required buffer size to hold the 'expiryDate' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'expiryDate' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetExpiryDate(
    ffi.Pointer<ffi.Char> expiryDate,
    ffi.Pointer<ffi.Int> expiryDateSize,
  ) {
    return _id3FaceLicense_GetExpiryDate(
      expiryDate,
      expiryDateSize,
    );
  }

  late final _id3FaceLicense_GetExpiryDatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetExpiryDate');
  late final _id3FaceLicense_GetExpiryDate = _id3FaceLicense_GetExpiryDatePtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the hardware code of the external drive you run the library on. This function works on Windows only.
  /// @param eHardwareCodeType [in] The requested hardware code type. Must be windowsUsb.
  /// @param code [out] The device hardware code.
  /// @param codeSize [in,out] Size of the 'code' buffer. Receives the minimum required buffer size to hold the 'code' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'code' (excluding terminating NULL character).
  /// @param externalDrivePath [in] On Windows to activate a license on a USB device, it must contain the path to the requested USB drive (e.g 'G:\').
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetExternalDriveHardwareCode(
    int eHardwareCodeType,
    ffi.Pointer<ffi.Char> code,
    ffi.Pointer<ffi.Int> codeSize,
    ffi.Pointer<ffi.Char> externalDrivePath,
  ) {
    return _id3FaceLicense_GetExternalDriveHardwareCode(
      eHardwareCodeType,
      code,
      codeSize,
      externalDrivePath,
    );
  }

  late final _id3FaceLicense_GetExternalDriveHardwareCodePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Int32, ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Int>, ffi.Pointer<ffi.Char>)>>(
      'id3FaceLicense_GetExternalDriveHardwareCode');
  late final _id3FaceLicense_GetExternalDriveHardwareCode =
      _id3FaceLicense_GetExternalDriveHardwareCodePtr.asFunction<
          int Function(int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Char>)>();

  /// Retrieves the hardware code of the device using the requested hardware code type.
  /// This function retrieves the hardware code of the device you run the library on.
  /// The optional parameter is required:
  /// - On Android, it must be the JNIEnv* pointer cast as a void*.
  /// - In other cases, it must be set to NULL.
  /// @param eHardwareCodeType [in] The requested hardware code type.
  /// @param code [out] The device hardware code.
  /// @param codeSize [in,out] Size of the 'code' buffer. Receives the minimum required buffer size to hold the 'code' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'code' (excluding terminating NULL character).
  /// @param optionalParameter [in] Only used on Android for JNIEnv* pointer. Ignored for other devices (NULL).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetHostHardwareCode(
    int eHardwareCodeType,
    ffi.Pointer<ffi.Char> code,
    ffi.Pointer<ffi.Int> codeSize,
    ffi.Pointer<ffi.Void> optionalParameter,
  ) {
    return _id3FaceLicense_GetHostHardwareCode(
      eHardwareCodeType,
      code,
      codeSize,
      optionalParameter,
    );
  }

  late final _id3FaceLicense_GetHostHardwareCodePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Int32,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Void>)>>('id3FaceLicense_GetHostHardwareCode');
  late final _id3FaceLicense_GetHostHardwareCode =
      _id3FaceLicense_GetHostHardwareCodePtr.asFunction<
          int Function(int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Void>)>();

  /// Retrieves the hardware code of the previously loaded license.
  /// @param licenseFileHardwareCode [out] The license hardware code.
  /// @param licenseFileHardwareCodeSize [in,out] Size of the 'licenseFileHardwareCode' buffer. Receives the minimum required buffer size to hold the 'licenseFileHardwareCode' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseFileHardwareCode' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetLicenseFileHardwareCode(
    ffi.Pointer<ffi.Char> licenseFileHardwareCode,
    ffi.Pointer<ffi.Int> licenseFileHardwareCodeSize,
  ) {
    return _id3FaceLicense_GetLicenseFileHardwareCode(
      licenseFileHardwareCode,
      licenseFileHardwareCodeSize,
    );
  }

  late final _id3FaceLicense_GetLicenseFileHardwareCodePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>>(
      'id3FaceLicense_GetLicenseFileHardwareCode');
  late final _id3FaceLicense_GetLicenseFileHardwareCode =
      _id3FaceLicense_GetLicenseFileHardwareCodePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the serial number of the previously loaded license.
  /// @param licenseFileSerial [out] The license serial number.
  /// @param licenseFileSerialSize [in,out] Size of the 'licenseFileSerial' buffer. Receives the minimum required buffer size to hold the 'licenseFileSerial' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseFileSerial' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetLicenseFileSerial(
    ffi.Pointer<ffi.Char> licenseFileSerial,
    ffi.Pointer<ffi.Int> licenseFileSerialSize,
  ) {
    return _id3FaceLicense_GetLicenseFileSerial(
      licenseFileSerial,
      licenseFileSerialSize,
    );
  }

  late final _id3FaceLicense_GetLicenseFileSerialPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetLicenseFileSerial');
  late final _id3FaceLicense_GetLicenseFileSerial =
      _id3FaceLicense_GetLicenseFileSerialPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license name.
  /// @param licenseName [out] The license name.
  /// @param licenseNameSize [in,out] Size of the 'licenseName' buffer. Receives the minimum required buffer size to hold the 'licenseName' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseName' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetLicenseName(
    ffi.Pointer<ffi.Char> licenseName,
    ffi.Pointer<ffi.Int> licenseNameSize,
  ) {
    return _id3FaceLicense_GetLicenseName(
      licenseName,
      licenseNameSize,
    );
  }

  late final _id3FaceLicense_GetLicenseNamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetLicenseName');
  late final _id3FaceLicense_GetLicenseName = _id3FaceLicense_GetLicenseNamePtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license owner.
  /// @param licenseOwner [out] The license owner.
  /// @param licenseOwnerSize [in,out] Size of the 'licenseOwner' buffer. Receives the minimum required buffer size to hold the 'licenseOwner' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseOwner' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetLicenseOwner(
    ffi.Pointer<ffi.Char> licenseOwner,
    ffi.Pointer<ffi.Int> licenseOwnerSize,
  ) {
    return _id3FaceLicense_GetLicenseOwner(
      licenseOwner,
      licenseOwnerSize,
    );
  }

  late final _id3FaceLicense_GetLicenseOwnerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetLicenseOwner');
  late final _id3FaceLicense_GetLicenseOwner =
      _id3FaceLicense_GetLicenseOwnerPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license path.
  /// @param licensePath [out] The license path.
  /// @param licensePathSize [in,out] Size of the 'licensePath' buffer. Receives the minimum required buffer size to hold the 'licensePath' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licensePath' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetLicensePath(
    ffi.Pointer<ffi.Char> licensePath,
    ffi.Pointer<ffi.Int> licensePathSize,
  ) {
    return _id3FaceLicense_GetLicensePath(
      licensePath,
      licensePathSize,
    );
  }

  late final _id3FaceLicense_GetLicensePathPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetLicensePath');
  late final _id3FaceLicense_GetLicensePath = _id3FaceLicense_GetLicensePathPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license type.
  /// @param eFaceLicenseType [out] The license type.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetLicenseType(
    ffi.Pointer<ffi.Int32> eFaceLicenseType,
  ) {
    return _id3FaceLicense_GetLicenseType(
      eFaceLicenseType,
    );
  }

  late final _id3FaceLicense_GetLicenseTypePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Int32>)>>(
          'id3FaceLicense_GetLicenseType');
  late final _id3FaceLicense_GetLicenseType = _id3FaceLicense_GetLicenseTypePtr
      .asFunction<int Function(ffi.Pointer<ffi.Int32>)>();

  /// Retrieves the number of modules in the license.
  /// @param count [out] The number of modules in the license.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetModuleCount(
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FaceLicense_GetModuleCount(
      count,
    );
  }

  late final _id3FaceLicense_GetModuleCountPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Int>)>>(
          'id3FaceLicense_GetModuleCount');
  late final _id3FaceLicense_GetModuleCount = _id3FaceLicense_GetModuleCountPtr
      .asFunction<int Function(ffi.Pointer<ffi.Int>)>();

  /// Retrieves the name of the specified license module.
  /// @param index [in] Index of the module, starting from 0.
  /// @param name [out] The license module name.
  /// @param nameSize [in,out] Size of the 'name' buffer. Receives the minimum required buffer size to hold the 'name' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'name' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetModuleName(
    int index,
    ffi.Pointer<ffi.Char> name,
    ffi.Pointer<ffi.Int> nameSize,
  ) {
    return _id3FaceLicense_GetModuleName(
      index,
      name,
      nameSize,
    );
  }

  late final _id3FaceLicense_GetModuleNamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Int, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetModuleName');
  late final _id3FaceLicense_GetModuleName =
      _id3FaceLicense_GetModuleNamePtr.asFunction<
          int Function(int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the value associated to the specified license module.
  /// @param name [in] Name of the requested module.
  /// @param value [out] The value associated to the licence module.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetModuleValue(
    ffi.Pointer<ffi.Char> name,
    ffi.Pointer<ffi.Int> value,
  ) {
    return _id3FaceLicense_GetModuleValue(
      name,
      value,
    );
  }

  late final _id3FaceLicense_GetModuleValuePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetModuleValue');
  late final _id3FaceLicense_GetModuleValue = _id3FaceLicense_GetModuleValuePtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license product reference.
  /// @param productReference [out] The product reference.
  /// @param productReferenceSize [in,out] Size of the 'productReference' buffer. Receives the minimum required buffer size to hold the 'productReference' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'productReference' (excluding terminating NULL character).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetProductReference(
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Int> productReferenceSize,
  ) {
    return _id3FaceLicense_GetProductReference(
      productReference,
      productReferenceSize,
    );
  }

  late final _id3FaceLicense_GetProductReferencePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_GetProductReference');
  late final _id3FaceLicense_GetProductReference =
      _id3FaceLicense_GetProductReferencePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the number of remaining days.
  /// @param remainingDays [out] The number of remaining days.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_GetRemainingDays(
    ffi.Pointer<ffi.Int> remainingDays,
  ) {
    return _id3FaceLicense_GetRemainingDays(
      remainingDays,
    );
  }

  late final _id3FaceLicense_GetRemainingDaysPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Int>)>>(
          'id3FaceLicense_GetRemainingDays');
  late final _id3FaceLicense_GetRemainingDays =
      _id3FaceLicense_GetRemainingDaysPtr
          .asFunction<int Function(ffi.Pointer<ffi.Int>)>();

  /// Reactivates a license file using the host hardware code and the product reference.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param productReference [in] The product reference.
  /// @param path [in] Path to the license file.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_Reactivate(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3FaceLicense_Reactivate(
      hardwareCode,
      productReference,
      path,
    );
  }

  late final _id3FaceLicense_ReactivatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3FaceLicense_Reactivate');
  late final _id3FaceLicense_Reactivate =
      _id3FaceLicense_ReactivatePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>();

  /// Reactivates a license in a data buffer using the host hardware code and the product reference.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param productReference [in] The product reference.
  /// @param licenseFileBuffer [out] The new license data buffer.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceLicense_ReactivateBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3FaceLicense_ReactivateBuffer(
      hardwareCode,
      productReference,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3FaceLicense_ReactivateBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FaceLicense_ReactivateBuffer');
  late final _id3FaceLicense_ReactivateBuffer =
      _id3FaceLicense_ReactivateBufferPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>();

  ffi.Pointer<ffi.Char> id3Face_GetLicenseErrorString(
    int value,
  ) {
    return _id3Face_GetLicenseErrorString(
      value,
    );
  }

  late final _id3Face_GetLicenseErrorStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetLicenseErrorString');
  late final _id3Face_GetLicenseErrorString = _id3Face_GetLicenseErrorStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetLicenseErrorMessage(
    int value,
  ) {
    return _id3Face_GetLicenseErrorMessage(
      value,
    );
  }

  late final _id3Face_GetLicenseErrorMessagePtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetLicenseErrorMessage');
  late final _id3Face_GetLicenseErrorMessage =
      _id3Face_GetLicenseErrorMessagePtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a FaceTemplateList object.
  /// @param phFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_Initialize(
    ffi.Pointer<ID3_FACE_TEMPLATE_LIST> phFaceTemplateList,
  ) {
    return _id3FaceTemplateList_Initialize(
      phFaceTemplateList,
    );
  }

  late final _id3FaceTemplateList_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE_LIST>)>>(
      'id3FaceTemplateList_Initialize');
  late final _id3FaceTemplateList_Initialize =
      _id3FaceTemplateList_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_FACE_TEMPLATE_LIST>)>();

  /// @brief Releases the memory allocated for a FaceTemplateList.
  /// @param phFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_Dispose(
    ffi.Pointer<ID3_FACE_TEMPLATE_LIST> phFaceTemplateList,
  ) {
    return _id3FaceTemplateList_Dispose(
      phFaceTemplateList,
    );
  }

  late final _id3FaceTemplateList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE_LIST>)>>(
      'id3FaceTemplateList_Dispose');
  late final _id3FaceTemplateList_Dispose = _id3FaceTemplateList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_TEMPLATE_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_CheckHandle(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
  ) {
    return _id3FaceTemplateList_CheckHandle(
      hFaceTemplateList,
    );
  }

  late final _id3FaceTemplateList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TEMPLATE_LIST)>>(
          'id3FaceTemplateList_CheckHandle');
  late final _id3FaceTemplateList_CheckHandle =
      _id3FaceTemplateList_CheckHandlePtr
          .asFunction<int Function(ID3_FACE_TEMPLATE_LIST)>();

  /// @brief Copies an instance of FaceTemplateList object to another.
  /// @param hFaceTemplateListSrc [in] Handle to the source FaceTemplateList object.
  /// @param hFaceTemplateListDst [in] Handle to the destination FaceTemplateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_CopyTo(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateListSrc,
    ID3_FACE_TEMPLATE_LIST hFaceTemplateListDst,
  ) {
    return _id3FaceTemplateList_CopyTo(
      hFaceTemplateListSrc,
      hFaceTemplateListDst,
    );
  }

  late final _id3FaceTemplateList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_LIST,
              ID3_FACE_TEMPLATE_LIST)>>('id3FaceTemplateList_CopyTo');
  late final _id3FaceTemplateList_CopyTo =
      _id3FaceTemplateList_CopyToPtr.asFunction<
          int Function(ID3_FACE_TEMPLATE_LIST, ID3_FACE_TEMPLATE_LIST)>();

  /// Clears the FaceTemplateList object.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_Clear(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
  ) {
    return _id3FaceTemplateList_Clear(
      hFaceTemplateList,
    );
  }

  late final _id3FaceTemplateList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TEMPLATE_LIST)>>(
          'id3FaceTemplateList_Clear');
  late final _id3FaceTemplateList_Clear = _id3FaceTemplateList_ClearPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_LIST)>();

  /// Adds an item to the FaceTemplateList object.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @param hFaceTemplateItem [in] FaceTemplate item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_Add(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
    ID3_FACE_TEMPLATE hFaceTemplateItem,
  ) {
    return _id3FaceTemplateList_Add(
      hFaceTemplateList,
      hFaceTemplateItem,
    );
  }

  late final _id3FaceTemplateList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_LIST,
              ID3_FACE_TEMPLATE)>>('id3FaceTemplateList_Add');
  late final _id3FaceTemplateList_Add = _id3FaceTemplateList_AddPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_LIST, ID3_FACE_TEMPLATE)>();

  /// Gets an item of the FaceTemplateList object.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @param index [in] Index of the FaceTemplate item to get.
  /// @param hFaceTemplateItem [out] FaceTemplate item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_Get(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
    int index,
    ID3_FACE_TEMPLATE hFaceTemplateItem,
  ) {
    return _id3FaceTemplateList_Get(
      hFaceTemplateList,
      index,
      hFaceTemplateItem,
    );
  }

  late final _id3FaceTemplateList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_LIST, ffi.Int,
              ID3_FACE_TEMPLATE)>>('id3FaceTemplateList_Get');
  late final _id3FaceTemplateList_Get = _id3FaceTemplateList_GetPtr.asFunction<
      int Function(ID3_FACE_TEMPLATE_LIST, int, ID3_FACE_TEMPLATE)>();

  /// Sets an item of the FaceTemplateList object.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @param index [in] Index of the FaceTemplate item to set.
  /// @param hFaceTemplateItem [in] FaceTemplate item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_Set(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
    int index,
    ID3_FACE_TEMPLATE hFaceTemplateItem,
  ) {
    return _id3FaceTemplateList_Set(
      hFaceTemplateList,
      index,
      hFaceTemplateItem,
    );
  }

  late final _id3FaceTemplateList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_LIST, ffi.Int,
              ID3_FACE_TEMPLATE)>>('id3FaceTemplateList_Set');
  late final _id3FaceTemplateList_Set = _id3FaceTemplateList_SetPtr.asFunction<
      int Function(ID3_FACE_TEMPLATE_LIST, int, ID3_FACE_TEMPLATE)>();

  /// Gets the number of elements in the FaceTemplateList object.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @param count [out] Number of elements in the FaceTemplate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_GetCount(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FaceTemplateList_GetCount(
      hFaceTemplateList,
      count,
    );
  }

  late final _id3FaceTemplateList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_LIST,
              ffi.Pointer<ffi.Int>)>>('id3FaceTemplateList_GetCount');
  late final _id3FaceTemplateList_GetCount = _id3FaceTemplateList_GetCountPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the FaceTemplateList object.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @param index [in] Index of the FaceTemplate item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_RemoveAt(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
    int index,
  ) {
    return _id3FaceTemplateList_RemoveAt(
      hFaceTemplateList,
      index,
    );
  }

  late final _id3FaceTemplateList_RemoveAtPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_FACE_TEMPLATE_LIST, ffi.Int)>>(
      'id3FaceTemplateList_RemoveAt');
  late final _id3FaceTemplateList_RemoveAt = _id3FaceTemplateList_RemoveAtPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_LIST, int)>();

  /// FaceTemplateList object.
  /// @param hFaceTemplateList [in] Handle to the FaceTemplateList object.
  /// @param newSize [in] FaceTemplate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateList_Resize(
    ID3_FACE_TEMPLATE_LIST hFaceTemplateList,
    int newSize,
  ) {
    return _id3FaceTemplateList_Resize(
      hFaceTemplateList,
      newSize,
    );
  }

  late final _id3FaceTemplateList_ResizePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_FACE_TEMPLATE_LIST, ffi.Int)>>(
      'id3FaceTemplateList_Resize');
  late final _id3FaceTemplateList_Resize = _id3FaceTemplateList_ResizePtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_LIST, int)>();

  ffi.Pointer<ffi.Char> id3Face_GetPoolingMethodString(
    int value,
  ) {
    return _id3Face_GetPoolingMethodString(
      value,
    );
  }

  late final _id3Face_GetPoolingMethodStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetPoolingMethodString');
  late final _id3Face_GetPoolingMethodString =
      _id3Face_GetPoolingMethodStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a FaceTemplateDict object.
  /// @param phFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_Initialize(
    ffi.Pointer<ID3_FACE_TEMPLATE_DICT> phFaceTemplateDict,
  ) {
    return _id3FaceTemplateDict_Initialize(
      phFaceTemplateDict,
    );
  }

  late final _id3FaceTemplateDict_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE_DICT>)>>(
      'id3FaceTemplateDict_Initialize');
  late final _id3FaceTemplateDict_Initialize =
      _id3FaceTemplateDict_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_FACE_TEMPLATE_DICT>)>();

  /// @brief Releases the memory allocated for a FaceTemplateDict.
  /// @param phFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_Dispose(
    ffi.Pointer<ID3_FACE_TEMPLATE_DICT> phFaceTemplateDict,
  ) {
    return _id3FaceTemplateDict_Dispose(
      phFaceTemplateDict,
    );
  }

  late final _id3FaceTemplateDict_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE_DICT>)>>(
      'id3FaceTemplateDict_Dispose');
  late final _id3FaceTemplateDict_Dispose = _id3FaceTemplateDict_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_TEMPLATE_DICT>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_CheckHandle(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
  ) {
    return _id3FaceTemplateDict_CheckHandle(
      hFaceTemplateDict,
    );
  }

  late final _id3FaceTemplateDict_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TEMPLATE_DICT)>>(
          'id3FaceTemplateDict_CheckHandle');
  late final _id3FaceTemplateDict_CheckHandle =
      _id3FaceTemplateDict_CheckHandlePtr
          .asFunction<int Function(ID3_FACE_TEMPLATE_DICT)>();

  /// @brief Copies an instance of FaceTemplateDict object to another.
  /// @param hFaceTemplateDictSrc [in] Handle to the source FaceTemplateDict object.
  /// @param hFaceTemplateDictDst [in] Handle to the destination FaceTemplateDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_CopyTo(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDictSrc,
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDictDst,
  ) {
    return _id3FaceTemplateDict_CopyTo(
      hFaceTemplateDictSrc,
      hFaceTemplateDictDst,
    );
  }

  late final _id3FaceTemplateDict_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT,
              ID3_FACE_TEMPLATE_DICT)>>('id3FaceTemplateDict_CopyTo');
  late final _id3FaceTemplateDict_CopyTo =
      _id3FaceTemplateDict_CopyToPtr.asFunction<
          int Function(ID3_FACE_TEMPLATE_DICT, ID3_FACE_TEMPLATE_DICT)>();

  /// Gets the gets a string list containing the keys in the dict.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @param hKeys [out] Gets a string list containing the keys in the dict.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_GetKeys(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
    ID3_FACE_STRING_LIST hKeys,
  ) {
    return _id3FaceTemplateDict_GetKeys(
      hFaceTemplateDict,
      hKeys,
    );
  }

  late final _id3FaceTemplateDict_GetKeysPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT,
              ID3_FACE_STRING_LIST)>>('id3FaceTemplateDict_GetKeys');
  late final _id3FaceTemplateDict_GetKeys = _id3FaceTemplateDict_GetKeysPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_DICT, ID3_FACE_STRING_LIST)>();

  /// Clears the FaceTemplateDict object.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_Clear(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
  ) {
    return _id3FaceTemplateDict_Clear(
      hFaceTemplateDict,
    );
  }

  late final _id3FaceTemplateDict_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TEMPLATE_DICT)>>(
          'id3FaceTemplateDict_Clear');
  late final _id3FaceTemplateDict_Clear = _id3FaceTemplateDict_ClearPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_DICT)>();

  /// Adds an item to the FaceTemplateDict object.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @param key [in] Unique key of the FaceTemplate item to add.
  /// @param hFaceTemplateItem [in] FaceTemplate item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_Add(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
    ffi.Pointer<ffi.Char> key,
    ID3_FACE_TEMPLATE hFaceTemplateItem,
  ) {
    return _id3FaceTemplateDict_Add(
      hFaceTemplateDict,
      key,
      hFaceTemplateItem,
    );
  }

  late final _id3FaceTemplateDict_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>,
              ID3_FACE_TEMPLATE)>>('id3FaceTemplateDict_Add');
  late final _id3FaceTemplateDict_Add = _id3FaceTemplateDict_AddPtr.asFunction<
      int Function(
          ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>, ID3_FACE_TEMPLATE)>();

  /// Gets an item of the FaceTemplateDict object.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @param key [in] Unique key of the FaceTemplate item to get.
  /// @param hFaceTemplateItem [out] FaceTemplate item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_Get(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
    ffi.Pointer<ffi.Char> key,
    ID3_FACE_TEMPLATE hFaceTemplateItem,
  ) {
    return _id3FaceTemplateDict_Get(
      hFaceTemplateDict,
      key,
      hFaceTemplateItem,
    );
  }

  late final _id3FaceTemplateDict_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>,
              ID3_FACE_TEMPLATE)>>('id3FaceTemplateDict_Get');
  late final _id3FaceTemplateDict_Get = _id3FaceTemplateDict_GetPtr.asFunction<
      int Function(
          ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>, ID3_FACE_TEMPLATE)>();

  /// Sets an item of the FaceTemplateDict object.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @param key [in] Unique key of the FaceTemplate item to set.
  /// @param hFaceTemplateItem [in] FaceTemplate item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_Set(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
    ffi.Pointer<ffi.Char> key,
    ID3_FACE_TEMPLATE hFaceTemplateItem,
  ) {
    return _id3FaceTemplateDict_Set(
      hFaceTemplateDict,
      key,
      hFaceTemplateItem,
    );
  }

  late final _id3FaceTemplateDict_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>,
              ID3_FACE_TEMPLATE)>>('id3FaceTemplateDict_Set');
  late final _id3FaceTemplateDict_Set = _id3FaceTemplateDict_SetPtr.asFunction<
      int Function(
          ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>, ID3_FACE_TEMPLATE)>();

  /// Gets the number of elements in the FaceTemplateDict object.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @param count [out] Number of elements in the FaceTemplate object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_GetCount(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3FaceTemplateDict_GetCount(
      hFaceTemplateDict,
      count,
    );
  }

  late final _id3FaceTemplateDict_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT,
              ffi.Pointer<ffi.Int>)>>('id3FaceTemplateDict_GetCount');
  late final _id3FaceTemplateDict_GetCount = _id3FaceTemplateDict_GetCountPtr
      .asFunction<int Function(ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Int>)>();

  /// Determines whether the FaceTemplateDictobject contains the specified key.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @param key [in] The key to locate in the FaceTemplate object.
  /// @param result [out] true if the FaceTemplate object contains an element with the specified key, otherwise false.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_ContainsKey(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Bool> result,
  ) {
    return _id3FaceTemplateDict_ContainsKey(
      hFaceTemplateDict,
      key,
      result,
    );
  }

  late final _id3FaceTemplateDict_ContainsKeyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>>('id3FaceTemplateDict_ContainsKey');
  late final _id3FaceTemplateDict_ContainsKey =
      _id3FaceTemplateDict_ContainsKeyPtr.asFunction<
          int Function(ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>();

  /// Removes an element of the FaceTemplateDict object.
  /// @param hFaceTemplateDict [in] Handle to the FaceTemplateDict object.
  /// @param key [in] Unique key of the FaceTemplate item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTemplateDict_Remove(
    ID3_FACE_TEMPLATE_DICT hFaceTemplateDict,
    ffi.Pointer<ffi.Char> key,
  ) {
    return _id3FaceTemplateDict_Remove(
      hFaceTemplateDict,
      key,
    );
  }

  late final _id3FaceTemplateDict_RemovePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TEMPLATE_DICT,
              ffi.Pointer<ffi.Char>)>>('id3FaceTemplateDict_Remove');
  late final _id3FaceTemplateDict_Remove =
      _id3FaceTemplateDict_RemovePtr.asFunction<
          int Function(ID3_FACE_TEMPLATE_DICT, ffi.Pointer<ffi.Char>)>();

  /// @brief Initializes a FaceMatcher object.
  /// @param phFaceMatcher [in] Handle to the FaceMatcher object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceMatcher_Initialize(
    ffi.Pointer<ID3_FACE_MATCHER> phFaceMatcher,
  ) {
    return _id3FaceMatcher_Initialize(
      phFaceMatcher,
    );
  }

  late final _id3FaceMatcher_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_MATCHER>)>>(
      'id3FaceMatcher_Initialize');
  late final _id3FaceMatcher_Initialize = _id3FaceMatcher_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_MATCHER>)>();

  /// @brief Releases the memory allocated for a FaceMatcher.
  /// @param phFaceMatcher [in] Handle to the FaceMatcher object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceMatcher_Dispose(
    ffi.Pointer<ID3_FACE_MATCHER> phFaceMatcher,
  ) {
    return _id3FaceMatcher_Dispose(
      phFaceMatcher,
    );
  }

  late final _id3FaceMatcher_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_MATCHER>)>>(
      'id3FaceMatcher_Dispose');
  late final _id3FaceMatcher_Dispose = _id3FaceMatcher_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_MATCHER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceMatcher [in] Handle to the FaceMatcher object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceMatcher_CheckHandle(
    ID3_FACE_MATCHER hFaceMatcher,
  ) {
    return _id3FaceMatcher_CheckHandle(
      hFaceMatcher,
    );
  }

  late final _id3FaceMatcher_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_MATCHER)>>(
          'id3FaceMatcher_CheckHandle');
  late final _id3FaceMatcher_CheckHandle = _id3FaceMatcher_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_MATCHER)>();

  /// Compares two template lists and outputs a comparison score.
  /// @param hFaceMatcher [in] Handle to the FaceMatcher object.
  /// @param hReferenceList [in] Reference template list.
  /// @param hProbeList [in] Probe template list.
  /// @param ePoolingMethod [in] Pooling method applied during the match process.
  /// @param score [out] The comparison score, in the range [0;65535].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceMatcher_CompareTemplateLists(
    ID3_FACE_MATCHER hFaceMatcher,
    ID3_FACE_TEMPLATE_LIST hReferenceList,
    ID3_FACE_TEMPLATE_LIST hProbeList,
    int ePoolingMethod,
    ffi.Pointer<ffi.Int> score,
  ) {
    return _id3FaceMatcher_CompareTemplateLists(
      hFaceMatcher,
      hReferenceList,
      hProbeList,
      ePoolingMethod,
      score,
    );
  }

  late final _id3FaceMatcher_CompareTemplateListsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_MATCHER,
              ID3_FACE_TEMPLATE_LIST,
              ID3_FACE_TEMPLATE_LIST,
              ffi.Int32,
              ffi.Pointer<ffi.Int>)>>('id3FaceMatcher_CompareTemplateLists');
  late final _id3FaceMatcher_CompareTemplateLists =
      _id3FaceMatcher_CompareTemplateListsPtr.asFunction<
          int Function(ID3_FACE_MATCHER, ID3_FACE_TEMPLATE_LIST,
              ID3_FACE_TEMPLATE_LIST, int, ffi.Pointer<ffi.Int>)>();

  /// Compares two templates and outputs a comparison score.
  /// @param hFaceMatcher [in] Handle to the FaceMatcher object.
  /// @param hReference [in] Reference template.
  /// @param hProbe [in] Probe template.
  /// @param score [out] The comparison score, in the range [0;65535].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceMatcher_CompareTemplates(
    ID3_FACE_MATCHER hFaceMatcher,
    ID3_FACE_TEMPLATE hReference,
    ID3_FACE_TEMPLATE hProbe,
    ffi.Pointer<ffi.Int> score,
  ) {
    return _id3FaceMatcher_CompareTemplates(
      hFaceMatcher,
      hReference,
      hProbe,
      score,
    );
  }

  late final _id3FaceMatcher_CompareTemplatesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_MATCHER,
              ID3_FACE_TEMPLATE,
              ID3_FACE_TEMPLATE,
              ffi.Pointer<ffi.Int>)>>('id3FaceMatcher_CompareTemplates');
  late final _id3FaceMatcher_CompareTemplates =
      _id3FaceMatcher_CompareTemplatesPtr.asFunction<
          int Function(ID3_FACE_MATCHER, ID3_FACE_TEMPLATE, ID3_FACE_TEMPLATE,
              ffi.Pointer<ffi.Int>)>();

  /// Performs a one-to-many search of a biometric probe against a previously initialized dictionary of biometric references and outputs a candidate list.
  /// @param hFaceMatcher [in] Handle to the FaceMatcher object.
  /// @param hReferenceDict [in] Reference template dictionary.
  /// @param hProbe [in] Probe template.
  /// @param maxCandidates [in] Maximum number of candidates to output.
  /// @param hCandidateList [in] List of candidates sorted by decreasing match score.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceMatcher_SearchTemplate(
    ID3_FACE_MATCHER hFaceMatcher,
    ID3_FACE_TEMPLATE_DICT hReferenceDict,
    ID3_FACE_TEMPLATE hProbe,
    int maxCandidates,
    ID3_FACE_CANDIDATE_LIST hCandidateList,
  ) {
    return _id3FaceMatcher_SearchTemplate(
      hFaceMatcher,
      hReferenceDict,
      hProbe,
      maxCandidates,
      hCandidateList,
    );
  }

  late final _id3FaceMatcher_SearchTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_MATCHER,
              ID3_FACE_TEMPLATE_DICT,
              ID3_FACE_TEMPLATE,
              ffi.Int,
              ID3_FACE_CANDIDATE_LIST)>>('id3FaceMatcher_SearchTemplate');
  late final _id3FaceMatcher_SearchTemplate =
      _id3FaceMatcher_SearchTemplatePtr.asFunction<
          int Function(ID3_FACE_MATCHER, ID3_FACE_TEMPLATE_DICT,
              ID3_FACE_TEMPLATE, int, ID3_FACE_CANDIDATE_LIST)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceMatcherThresholdString(
    int value,
  ) {
    return _id3Face_GetFaceMatcherThresholdString(
      value,
    );
  }

  late final _id3Face_GetFaceMatcherThresholdStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceMatcherThresholdString');
  late final _id3Face_GetFaceMatcherThresholdString =
      _id3Face_GetFaceMatcherThresholdStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a FacePad object.
  /// @param phFacePad [in] Handle to the FacePad object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_Initialize(
    ffi.Pointer<ID3_FACE_PAD> phFacePad,
  ) {
    return _id3FacePad_Initialize(
      phFacePad,
    );
  }

  late final _id3FacePad_InitializePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_PAD>)>>(
          'id3FacePad_Initialize');
  late final _id3FacePad_Initialize = _id3FacePad_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_PAD>)>();

  /// @brief Releases the memory allocated for a FacePad.
  /// @param phFacePad [in] Handle to the FacePad object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_Dispose(
    ffi.Pointer<ID3_FACE_PAD> phFacePad,
  ) {
    return _id3FacePad_Dispose(
      phFacePad,
    );
  }

  late final _id3FacePad_DisposePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_PAD>)>>(
          'id3FacePad_Dispose');
  late final _id3FacePad_Dispose = _id3FacePad_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_PAD>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFacePad [in] Handle to the FacePad object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_CheckHandle(
    ID3_FACE_PAD hFacePad,
  ) {
    return _id3FacePad_CheckHandle(
      hFacePad,
    );
  }

  late final _id3FacePad_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_PAD)>>(
          'id3FacePad_CheckHandle');
  late final _id3FacePad_CheckHandle =
      _id3FacePad_CheckHandlePtr.asFunction<int Function(ID3_FACE_PAD)>();

  /// Gets the attack support detector confidence threshold, in the range [0;100].
  /// Hint: Default value is 25.
  /// Note: Setting a high threshold reduces false attack support detections but can increase the number of undetected attack supports.
  /// @param hFacePad [in] Handle to the FacePad object.
  /// @param attackSupportDetectorConfidenceThreshold [out] Attack support detector confidence threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_GetAttackSupportDetectorConfidenceThreshold(
    ID3_FACE_PAD hFacePad,
    ffi.Pointer<ffi.Int> attackSupportDetectorConfidenceThreshold,
  ) {
    return _id3FacePad_GetAttackSupportDetectorConfidenceThreshold(
      hFacePad,
      attackSupportDetectorConfidenceThreshold,
    );
  }

  late final _id3FacePad_GetAttackSupportDetectorConfidenceThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_FACE_PAD, ffi.Pointer<ffi.Int>)>>(
          'id3FacePad_GetAttackSupportDetectorConfidenceThreshold');
  late final _id3FacePad_GetAttackSupportDetectorConfidenceThreshold =
      _id3FacePad_GetAttackSupportDetectorConfidenceThresholdPtr
          .asFunction<int Function(ID3_FACE_PAD, ffi.Pointer<ffi.Int>)>();

  /// Sets the attack support detector confidence threshold, in the range [0;100].
  /// Hint: Default value is 25.
  /// Note: Setting a high threshold reduces false attack support detections but can increase the number of undetected attack supports.
  /// @param hFacePad [in] Handle to the FacePad object.
  /// @param attackSupportDetectorConfidenceThreshold [in] Attack support detector confidence threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_SetAttackSupportDetectorConfidenceThreshold(
    ID3_FACE_PAD hFacePad,
    int attackSupportDetectorConfidenceThreshold,
  ) {
    return _id3FacePad_SetAttackSupportDetectorConfidenceThreshold(
      hFacePad,
      attackSupportDetectorConfidenceThreshold,
    );
  }

  late final _id3FacePad_SetAttackSupportDetectorConfidenceThresholdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_PAD, ffi.Int)>>(
          'id3FacePad_SetAttackSupportDetectorConfidenceThreshold');
  late final _id3FacePad_SetAttackSupportDetectorConfidenceThreshold =
      _id3FacePad_SetAttackSupportDetectorConfidenceThresholdPtr
          .asFunction<int Function(ID3_FACE_PAD, int)>();

  /// Computes a blurriness score for a color image.
  /// An attack presented on a low resolution support has more chance to be blurred than a bonafide.
  /// The maximum recommended value is 20.
  /// Important: Loading the model ``FaceBlurrinessDetector`` is required to use this function.
  /// @param hFacePad [in] Handle to the FacePad object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param score [out] The computed blurriness score, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_ComputeBlurrinessScore(
    ID3_FACE_PAD hFacePad,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> score,
  ) {
    return _id3FacePad_ComputeBlurrinessScore(
      hFacePad,
      hImage,
      hDetectedFace,
      score,
    );
  }

  late final _id3FacePad_ComputeBlurrinessScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3FacePad_ComputeBlurrinessScore');
  late final _id3FacePad_ComputeBlurrinessScore =
      _id3FacePad_ComputeBlurrinessScorePtr.asFunction<
          int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>();

  /// Computes the PAD score and confidence of a detected face using only the color image.
  /// A high score means a high probability for the face to be bona-fide, hence not an attack. The minimum recommended score is 90.
  /// A low confidence means that the quality of the image is not sufficient enough to take a decision. The minimum recommended confidence is 70.
  /// Warning: A minimum IOD (64 pixels per default) for the detected face is required for this function, below this value it will output an error.
  /// Important: Loading the ``FaceColorBasedPad`` model is required to use this function.
  /// @param hFacePad [in] Handle to the FacePad object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param sColorBasedPadResult [out] The computed PAD result including score and confidence.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_ComputeColorBasedScore(
    ID3_FACE_PAD hFacePad,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3FaceColorBasedPadResult> sColorBasedPadResult,
  ) {
    return _id3FacePad_ComputeColorBasedScore(
      hFacePad,
      hImage,
      hDetectedFace,
      sColorBasedPadResult,
    );
  }

  late final _id3FacePad_ComputeColorBasedScorePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
                  ffi.Pointer<id3FaceColorBasedPadResult>)>>(
      'id3FacePad_ComputeColorBasedScore');
  late final _id3FacePad_ComputeColorBasedScore =
      _id3FacePad_ComputeColorBasedScorePtr.asFunction<
          int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<id3FaceColorBasedPadResult>)>();

  /// Computes the PAD score of a detected face using a depth map image.
  /// A high score means a high probability for the face to be bona-fide, hence not an attack.
  /// The minimum recommended value is 10.
  /// Important: Loading the ``FaceDepthBasedPad`` model is required to use this function.
  /// @param hFacePad [in] Handle to the FacePad object.
  /// @param hImage [in] Source image to process. Must be Grayscale 16 Bits.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param score [out] The computed PAD score, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_ComputeDepthBasedScore(
    ID3_FACE_PAD hFacePad,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<ffi.Int> score,
  ) {
    return _id3FacePad_ComputeDepthBasedScore(
      hFacePad,
      hImage,
      hDetectedFace,
      score,
    );
  }

  late final _id3FacePad_ComputeDepthBasedScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3FacePad_ComputeDepthBasedScore');
  late final _id3FacePad_ComputeDepthBasedScore =
      _id3FacePad_ComputeDepthBasedScorePtr.asFunction<
          int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<ffi.Int>)>();

  /// Detects if an attack support surrounds the detected face.
  /// The recommended usage is to consider the image to be an attack as soon as an attack support is detected.
  /// Important: Loading the ``FaceAttackSupportDetector`` model is required to use this function.
  /// @param hFacePad [in] Handle to the FacePad object.
  /// @param hImage [in] Source image to process.
  /// @param hDetectedFace [in] Detected face to process.
  /// @param sDetectedFaceAttackSupport [out] The detected face attack support.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePad_DetectAttackSupport(
    ID3_FACE_PAD hFacePad,
    ID3_FACE_IMAGE hImage,
    ID3_DETECTED_FACE hDetectedFace,
    ffi.Pointer<id3DetectedFaceAttackSupport> sDetectedFaceAttackSupport,
  ) {
    return _id3FacePad_DetectAttackSupport(
      hFacePad,
      hImage,
      hDetectedFace,
      sDetectedFaceAttackSupport,
    );
  }

  late final _id3FacePad_DetectAttackSupportPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
                  ffi.Pointer<id3DetectedFaceAttackSupport>)>>(
      'id3FacePad_DetectAttackSupport');
  late final _id3FacePad_DetectAttackSupport =
      _id3FacePad_DetectAttackSupportPtr.asFunction<
          int Function(ID3_FACE_PAD, ID3_FACE_IMAGE, ID3_DETECTED_FACE,
              ffi.Pointer<id3DetectedFaceAttackSupport>)>();

  ffi.Pointer<ffi.Char> id3Face_GetPadStatusString(
    int value,
  ) {
    return _id3Face_GetPadStatusString(
      value,
    );
  }

  late final _id3Face_GetPadStatusStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetPadStatusString');
  late final _id3Face_GetPadStatusString = _id3Face_GetPadStatusStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetPortraitInstructionString(
    int value,
  ) {
    return _id3Face_GetPortraitInstructionString(
      value,
    );
  }

  late final _id3Face_GetPortraitInstructionStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetPortraitInstructionString');
  late final _id3Face_GetPortraitInstructionString =
      _id3Face_GetPortraitInstructionStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetPortraitStatusString(
    int value,
  ) {
    return _id3Face_GetPortraitStatusString(
      value,
    );
  }

  late final _id3Face_GetPortraitStatusStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetPortraitStatusString');
  late final _id3Face_GetPortraitStatusString =
      _id3Face_GetPortraitStatusStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetSubjectPositionString(
    int value,
  ) {
    return _id3Face_GetSubjectPositionString(
      value,
    );
  }

  late final _id3Face_GetSubjectPositionStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetSubjectPositionString');
  late final _id3Face_GetSubjectPositionString =
      _id3Face_GetSubjectPositionStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Face_GetTrackingStatusString(
    int value,
  ) {
    return _id3Face_GetTrackingStatusString(
      value,
    );
  }

  late final _id3Face_GetTrackingStatusStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetTrackingStatusString');
  late final _id3Face_GetTrackingStatusString =
      _id3Face_GetTrackingStatusStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a TrackedFace object.
  /// @param phTrackedFace [in] Handle to the TrackedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_Initialize(
    ffi.Pointer<ID3_TRACKED_FACE> phTrackedFace,
  ) {
    return _id3TrackedFace_Initialize(
      phTrackedFace,
    );
  }

  late final _id3TrackedFace_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_TRACKED_FACE>)>>(
      'id3TrackedFace_Initialize');
  late final _id3TrackedFace_Initialize = _id3TrackedFace_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_TRACKED_FACE>)>();

  /// @brief Releases the memory allocated for a TrackedFace.
  /// @param phTrackedFace [in] Handle to the TrackedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_Dispose(
    ffi.Pointer<ID3_TRACKED_FACE> phTrackedFace,
  ) {
    return _id3TrackedFace_Dispose(
      phTrackedFace,
    );
  }

  late final _id3TrackedFace_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_TRACKED_FACE>)>>(
      'id3TrackedFace_Dispose');
  late final _id3TrackedFace_Dispose = _id3TrackedFace_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_TRACKED_FACE>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_CheckHandle(
    ID3_TRACKED_FACE hTrackedFace,
  ) {
    return _id3TrackedFace_CheckHandle(
      hTrackedFace,
    );
  }

  late final _id3TrackedFace_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_TRACKED_FACE)>>(
          'id3TrackedFace_CheckHandle');
  late final _id3TrackedFace_CheckHandle = _id3TrackedFace_CheckHandlePtr
      .asFunction<int Function(ID3_TRACKED_FACE)>();

  /// @brief Copies an instance of TrackedFace object to another.
  /// @param hTrackedFaceSrc [in] Handle to the source TrackedFace object.
  /// @param hTrackedFaceDst [in] Handle to the destination TrackedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_CopyTo(
    ID3_TRACKED_FACE hTrackedFaceSrc,
    ID3_TRACKED_FACE hTrackedFaceDst,
  ) {
    return _id3TrackedFace_CopyTo(
      hTrackedFaceSrc,
      hTrackedFaceDst,
    );
  }

  late final _id3TrackedFace_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_TRACKED_FACE, ID3_TRACKED_FACE)>>('id3TrackedFace_CopyTo');
  late final _id3TrackedFace_CopyTo = _id3TrackedFace_CopyToPtr
      .asFunction<int Function(ID3_TRACKED_FACE, ID3_TRACKED_FACE)>();

  /// Gets the bounds of the detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param sBounds [out] Bounds of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetBounds(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<id3FaceRectangle> sBounds,
  ) {
    return _id3TrackedFace_GetBounds(
      hTrackedFace,
      sBounds,
    );
  }

  late final _id3TrackedFace_GetBoundsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ffi.Pointer<id3FaceRectangle>)>>('id3TrackedFace_GetBounds');
  late final _id3TrackedFace_GetBounds =
      _id3TrackedFace_GetBoundsPtr.asFunction<
          int Function(ID3_TRACKED_FACE, ffi.Pointer<id3FaceRectangle>)>();

  /// Sets the bounds of the detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param sBounds [in] Bounds of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_SetBounds(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<id3FaceRectangle> sBounds,
  ) {
    return _id3TrackedFace_SetBounds(
      hTrackedFace,
      sBounds,
    );
  }

  late final _id3TrackedFace_SetBoundsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ffi.Pointer<id3FaceRectangle>)>>('id3TrackedFace_SetBounds');
  late final _id3TrackedFace_SetBounds =
      _id3TrackedFace_SetBoundsPtr.asFunction<
          int Function(ID3_TRACKED_FACE, ffi.Pointer<id3FaceRectangle>)>();

  /// Gets the confidence score of the detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param detectionScore [out] Confidence score of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetDetectionScore(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.Int> detectionScore,
  ) {
    return _id3TrackedFace_GetDetectionScore(
      hTrackedFace,
      detectionScore,
    );
  }

  late final _id3TrackedFace_GetDetectionScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3TrackedFace_GetDetectionScore');
  late final _id3TrackedFace_GetDetectionScore =
      _id3TrackedFace_GetDetectionScorePtr
          .asFunction<int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.Int>)>();

  /// Gets the computed template the tracked face. It aims at tracking an identity over time and is consolidated.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param hFaceTemplate [out] Computed template the tracked face. It aims at tracking an identity over time and is consolidated.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetFaceTemplate(
    ID3_TRACKED_FACE hTrackedFace,
    ID3_FACE_TEMPLATE hFaceTemplate,
  ) {
    return _id3TrackedFace_GetFaceTemplate(
      hTrackedFace,
      hFaceTemplate,
    );
  }

  late final _id3TrackedFace_GetFaceTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ID3_FACE_TEMPLATE)>>('id3TrackedFace_GetFaceTemplate');
  late final _id3TrackedFace_GetFaceTemplate =
      _id3TrackedFace_GetFaceTemplatePtr
          .asFunction<int Function(ID3_TRACKED_FACE, ID3_FACE_TEMPLATE)>();

  /// Gets the ID of the detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param id [out] ID of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetId(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.Int> id,
  ) {
    return _id3TrackedFace_GetId(
      hTrackedFace,
      id,
    );
  }

  late final _id3TrackedFace_GetIdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_TRACKED_FACE, ffi.Pointer<ffi.Int>)>>('id3TrackedFace_GetId');
  late final _id3TrackedFace_GetId = _id3TrackedFace_GetIdPtr
      .asFunction<int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.Int>)>();

  /// Sets the ID of the detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param id [in] ID of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_SetId(
    ID3_TRACKED_FACE hTrackedFace,
    int id,
  ) {
    return _id3TrackedFace_SetId(
      hTrackedFace,
      id,
    );
  }

  late final _id3TrackedFace_SetIdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_TRACKED_FACE, ffi.Int)>>(
          'id3TrackedFace_SetId');
  late final _id3TrackedFace_SetId = _id3TrackedFace_SetIdPtr
      .asFunction<int Function(ID3_TRACKED_FACE, int)>();

  /// Gets the landmarks (eyes, nose and mouth corners) of the detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param hLandmarks [out] Landmarks (eyes, nose and mouth corners) of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetLandmarks(
    ID3_TRACKED_FACE hTrackedFace,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3TrackedFace_GetLandmarks(
      hTrackedFace,
      hLandmarks,
    );
  }

  late final _id3TrackedFace_GetLandmarksPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ID3_FACE_POINT_LIST)>>('id3TrackedFace_GetLandmarks');
  late final _id3TrackedFace_GetLandmarks = _id3TrackedFace_GetLandmarksPtr
      .asFunction<int Function(ID3_TRACKED_FACE, ID3_FACE_POINT_LIST)>();

  /// Sets the landmarks (eyes, nose and mouth corners) of the detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param hLandmarks [in] Landmarks (eyes, nose and mouth corners) of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_SetLandmarks(
    ID3_TRACKED_FACE hTrackedFace,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3TrackedFace_SetLandmarks(
      hTrackedFace,
      hLandmarks,
    );
  }

  late final _id3TrackedFace_SetLandmarksPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ID3_FACE_POINT_LIST)>>('id3TrackedFace_SetLandmarks');
  late final _id3TrackedFace_SetLandmarks = _id3TrackedFace_SetLandmarksPtr
      .asFunction<int Function(ID3_TRACKED_FACE, ID3_FACE_POINT_LIST)>();

  /// Gets the predicted bounds of the tracked face. Those bounds are computed using a Kalman filter which has the effect of making them smooth and robust to false non-detections.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param sPredictedBounds [out] Predicted bounds of the tracked face. Those bounds are computed using a Kalman filter which has the effect of making them smooth and robust to false non-detections.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetPredictedBounds(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<id3FaceRectangle> sPredictedBounds,
  ) {
    return _id3TrackedFace_GetPredictedBounds(
      hTrackedFace,
      sPredictedBounds,
    );
  }

  late final _id3TrackedFace_GetPredictedBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_TRACKED_FACE, ffi.Pointer<id3FaceRectangle>)>>(
      'id3TrackedFace_GetPredictedBounds');
  late final _id3TrackedFace_GetPredictedBounds =
      _id3TrackedFace_GetPredictedBoundsPtr.asFunction<
          int Function(ID3_TRACKED_FACE, ffi.Pointer<id3FaceRectangle>)>();

  /// Gets the status of the tracked face. See FaceTrackingStatus for more details.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param eTrackingStatus [out] Status of the tracked face. See FaceTrackingStatus for more details.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetTrackingStatus(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.Int32> eTrackingStatus,
  ) {
    return _id3TrackedFace_GetTrackingStatus(
      hTrackedFace,
      eTrackingStatus,
    );
  }

  late final _id3TrackedFace_GetTrackingStatusPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ffi.Pointer<ffi.Int32>)>>('id3TrackedFace_GetTrackingStatus');
  late final _id3TrackedFace_GetTrackingStatus =
      _id3TrackedFace_GetTrackingStatusPtr
          .asFunction<int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.Int32>)>();

  /// Creates a detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param sBounds [in] Bounds of the detected face.
  /// @param detectionScore [in] Confidence score of the detected face.
  /// @param id [in] ID of the detected face.
  /// @param hLandmarks [in] Landmarks (eyes, nose and mouth corners) of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_Create(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<id3FaceRectangle> sBounds,
    int detectionScore,
    int id,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3TrackedFace_Create(
      hTrackedFace,
      sBounds,
      detectionScore,
      id,
      hLandmarks,
    );
  }

  late final _id3TrackedFace_CreatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE, ffi.Pointer<id3FaceRectangle>,
              ffi.Int, ffi.Int, ID3_FACE_POINT_LIST)>>('id3TrackedFace_Create');
  late final _id3TrackedFace_Create = _id3TrackedFace_CreatePtr.asFunction<
      int Function(ID3_TRACKED_FACE, ffi.Pointer<id3FaceRectangle>, int, int,
          ID3_FACE_POINT_LIST)>();

  /// Imports the face object from a buffer.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param data [in] Buffer to import the face object from.
  /// @param dataSize [in] Size of the 'data' buffer.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_FromBuffer(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.UnsignedChar> data,
    int dataSize,
  ) {
    return _id3TrackedFace_FromBuffer(
      hTrackedFace,
      data,
      dataSize,
    );
  }

  late final _id3TrackedFace_FromBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int)>>('id3TrackedFace_FromBuffer');
  late final _id3TrackedFace_FromBuffer =
      _id3TrackedFace_FromBufferPtr.asFunction<
          int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Imports the face object from a file.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param path [in] Path to the file to import the face object from.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_FromFile(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3TrackedFace_FromFile(
      hTrackedFace,
      path,
    );
  }

  late final _id3TrackedFace_FromFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ffi.Pointer<ffi.Char>)>>('id3TrackedFace_FromFile');
  late final _id3TrackedFace_FromFile = _id3TrackedFace_FromFilePtr
      .asFunction<int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.Char>)>();

  /// Gets the tracked face as a detected face.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param hDetectedFace [out] The tracked face as a detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetAsDetectedFace(
    ID3_TRACKED_FACE hTrackedFace,
    ID3_DETECTED_FACE hDetectedFace,
  ) {
    return _id3TrackedFace_GetAsDetectedFace(
      hTrackedFace,
      hDetectedFace,
    );
  }

  late final _id3TrackedFace_GetAsDetectedFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ID3_DETECTED_FACE)>>('id3TrackedFace_GetAsDetectedFace');
  late final _id3TrackedFace_GetAsDetectedFace =
      _id3TrackedFace_GetAsDetectedFacePtr
          .asFunction<int Function(ID3_TRACKED_FACE, ID3_DETECTED_FACE)>();

  /// Gets the distance between the detected face and the camera when using a depth map in pixels.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param hDepthImage [in] Depth image to process.
  /// @param distanceToCamera [out] The estimated distance to camera in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetDistanceToCamera(
    ID3_TRACKED_FACE hTrackedFace,
    ID3_FACE_IMAGE hDepthImage,
    ffi.Pointer<ffi.Int> distanceToCamera,
  ) {
    return _id3TrackedFace_GetDistanceToCamera(
      hTrackedFace,
      hDepthImage,
      distanceToCamera,
    );
  }

  late final _id3TrackedFace_GetDistanceToCameraPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE, ID3_FACE_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3TrackedFace_GetDistanceToCamera');
  late final _id3TrackedFace_GetDistanceToCamera =
      _id3TrackedFace_GetDistanceToCameraPtr.asFunction<
          int Function(
              ID3_TRACKED_FACE, ID3_FACE_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the bounding box around the detected face with specified aspect ratio and specified margin.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param aspectRatio [in] Aspect ratio of the bounding box. Default recommended value is 1.33 (4/3).
  /// @param margin [in] Relative margin around the detected face. Recommended value is 0.5.
  /// @param sPortraitBounds [out] The portrait bounds.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetExpandedBounds(
    ID3_TRACKED_FACE hTrackedFace,
    double aspectRatio,
    double margin,
    ffi.Pointer<id3FaceRectangle> sPortraitBounds,
  ) {
    return _id3TrackedFace_GetExpandedBounds(
      hTrackedFace,
      aspectRatio,
      margin,
      sPortraitBounds,
    );
  }

  late final _id3TrackedFace_GetExpandedBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_TRACKED_FACE, ffi.Float, ffi.Float,
                  ffi.Pointer<id3FaceRectangle>)>>(
      'id3TrackedFace_GetExpandedBounds');
  late final _id3TrackedFace_GetExpandedBounds =
      _id3TrackedFace_GetExpandedBoundsPtr.asFunction<
          int Function(ID3_TRACKED_FACE, double, double,
              ffi.Pointer<id3FaceRectangle>)>();

  /// Gets the distance between the eyes (IOD) of the detected face in pixels.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param iod [out] The computed interocular distance (IOD) in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetInterocularDistance(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.Int> iod,
  ) {
    return _id3TrackedFace_GetInterocularDistance(
      hTrackedFace,
      iod,
    );
  }

  late final _id3TrackedFace_GetInterocularDistancePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ffi.Pointer<ffi.Int>)>>('id3TrackedFace_GetInterocularDistance');
  late final _id3TrackedFace_GetInterocularDistance =
      _id3TrackedFace_GetInterocularDistancePtr
          .asFunction<int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.Int>)>();

  /// Gets the bounding box of the detected face for ICAO portrait cropping.
  /// This method shall be used to ensure compliance with the ICAO standard.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param eyeImageWidthRatio [in] Ratio between eye distance and image width. Must be in the range ]0;1[. Default recommended value is 0.25.
  /// @param eyeImageHeightRatio [in] Ratio between eye distance to top and image height. Must be in the range ]0;1[. Default recommended value is 0.45.
  /// @param imageRatio [in] Ratio between image height and image width. Default recommended value is 1.33 (4/3).
  /// @param sPortraitBounds [out] The portrait bounds of the detected face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_GetPortraitBounds(
    ID3_TRACKED_FACE hTrackedFace,
    double eyeImageWidthRatio,
    double eyeImageHeightRatio,
    double imageRatio,
    ffi.Pointer<id3FaceRectangle> sPortraitBounds,
  ) {
    return _id3TrackedFace_GetPortraitBounds(
      hTrackedFace,
      eyeImageWidthRatio,
      eyeImageHeightRatio,
      imageRatio,
      sPortraitBounds,
    );
  }

  late final _id3TrackedFace_GetPortraitBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_TRACKED_FACE, ffi.Float, ffi.Float,
                  ffi.Float, ffi.Pointer<id3FaceRectangle>)>>(
      'id3TrackedFace_GetPortraitBounds');
  late final _id3TrackedFace_GetPortraitBounds =
      _id3TrackedFace_GetPortraitBoundsPtr.asFunction<
          int Function(ID3_TRACKED_FACE, double, double, double,
              ffi.Pointer<id3FaceRectangle>)>();

  /// Rescales the detected face object bounding box and landmarks. This function can be useful if the image was downscaled to speed up detection, then you need to upscale the detected face to fit the source image size.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param scale [in] The multiplicative rescaling factor to apply to the face object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_Rescale(
    ID3_TRACKED_FACE hTrackedFace,
    double scale,
  ) {
    return _id3TrackedFace_Rescale(
      hTrackedFace,
      scale,
    );
  }

  late final _id3TrackedFace_RescalePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_TRACKED_FACE, ffi.Float)>>(
      'id3TrackedFace_Rescale');
  late final _id3TrackedFace_Rescale = _id3TrackedFace_RescalePtr
      .asFunction<int Function(ID3_TRACKED_FACE, double)>();

  /// Rotates the face object by a given angle in degrees from a given center.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param angle [in] Angle of the rotation to apply to the face object.
  /// @param sCenter [in] Center of the rotation to apply to the face object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_Rotate(
    ID3_TRACKED_FACE hTrackedFace,
    int angle,
    ffi.Pointer<id3FacePoint> sCenter,
  ) {
    return _id3TrackedFace_Rotate(
      hTrackedFace,
      angle,
      sCenter,
    );
  }

  late final _id3TrackedFace_RotatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE, ffi.Int,
              ffi.Pointer<id3FacePoint>)>>('id3TrackedFace_Rotate');
  late final _id3TrackedFace_Rotate = _id3TrackedFace_RotatePtr.asFunction<
      int Function(ID3_TRACKED_FACE, int, ffi.Pointer<id3FacePoint>)>();

  /// Exports the face object to a buffer.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param data [out] The buffer to which the face object is exported.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_ToBuffer(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3TrackedFace_ToBuffer(
      hTrackedFace,
      data,
      dataSize,
    );
  }

  late final _id3TrackedFace_ToBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3TrackedFace_ToBuffer');
  late final _id3TrackedFace_ToBuffer = _id3TrackedFace_ToBufferPtr.asFunction<
      int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<ffi.Int>)>();

  /// Saves the face object to a file.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param path [in] Path to the file to export the face object to.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_ToFile(
    ID3_TRACKED_FACE hTrackedFace,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3TrackedFace_ToFile(
      hTrackedFace,
      path,
    );
  }

  late final _id3TrackedFace_ToFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE,
              ffi.Pointer<ffi.Char>)>>('id3TrackedFace_ToFile');
  late final _id3TrackedFace_ToFile = _id3TrackedFace_ToFilePtr
      .asFunction<int Function(ID3_TRACKED_FACE, ffi.Pointer<ffi.Char>)>();

  /// Translates the face object.
  /// @param hTrackedFace [in] Handle to the TrackedFace object.
  /// @param tx [in] Translation to apply to the face object alongside the x-axis.
  /// @param ty [in] Translation to apply to the face object alongside the y-axis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFace_Translate(
    ID3_TRACKED_FACE hTrackedFace,
    int tx,
    int ty,
  ) {
    return _id3TrackedFace_Translate(
      hTrackedFace,
      tx,
      ty,
    );
  }

  late final _id3TrackedFace_TranslatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_TRACKED_FACE, ffi.Int, ffi.Int)>>('id3TrackedFace_Translate');
  late final _id3TrackedFace_Translate = _id3TrackedFace_TranslatePtr
      .asFunction<int Function(ID3_TRACKED_FACE, int, int)>();

  /// @brief Initializes a Portrait object.
  /// @param phPortrait [in] Handle to the Portrait object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_Initialize(
    ffi.Pointer<ID3_FACE_PORTRAIT> phPortrait,
  ) {
    return _id3FacePortrait_Initialize(
      phPortrait,
    );
  }

  late final _id3FacePortrait_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_PORTRAIT>)>>(
      'id3FacePortrait_Initialize');
  late final _id3FacePortrait_Initialize = _id3FacePortrait_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_PORTRAIT>)>();

  /// @brief Releases the memory allocated for a Portrait.
  /// @param phPortrait [in] Handle to the Portrait object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_Dispose(
    ffi.Pointer<ID3_FACE_PORTRAIT> phPortrait,
  ) {
    return _id3FacePortrait_Dispose(
      phPortrait,
    );
  }

  late final _id3FacePortrait_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_PORTRAIT>)>>(
      'id3FacePortrait_Dispose');
  late final _id3FacePortrait_Dispose = _id3FacePortrait_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_PORTRAIT>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_CheckHandle(
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortrait_CheckHandle(
      hPortrait,
    );
  }

  late final _id3FacePortrait_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_PORTRAIT)>>(
          'id3FacePortrait_CheckHandle');
  late final _id3FacePortrait_CheckHandle = _id3FacePortrait_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT)>();

  /// @brief Copies an instance of Portrait object to another.
  /// @param hPortraitSrc [in] Handle to the source Portrait object.
  /// @param hPortraitDst [in] Handle to the destination Portrait object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_CopyTo(
    ID3_FACE_PORTRAIT hPortraitSrc,
    ID3_FACE_PORTRAIT hPortraitDst,
  ) {
    return _id3FacePortrait_CopyTo(
      hPortraitSrc,
      hPortraitDst,
    );
  }

  late final _id3FacePortrait_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_PORTRAIT, ID3_FACE_PORTRAIT)>>('id3FacePortrait_CopyTo');
  late final _id3FacePortrait_CopyTo = _id3FacePortrait_CopyToPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ID3_FACE_PORTRAIT)>();

  /// Gets the estimated age of the subject. -1 if not computed.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param age [out] Estimated age of the subject. -1 if not computed.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetAge(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> age,
  ) {
    return _id3FacePortrait_GetAge(
      hPortrait,
      age,
    );
  }

  late final _id3FacePortrait_GetAgePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetAge');
  late final _id3FacePortrait_GetAge = _id3FacePortrait_GetAgePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the result of the background uniformity computation.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sBackgroundUniformity [out] Result of the background uniformity computation.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetBackgroundUniformity(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FaceBackgroundUniformity> sBackgroundUniformity,
  ) {
    return _id3FacePortrait_GetBackgroundUniformity(
      hPortrait,
      sBackgroundUniformity,
    );
  }

  late final _id3FacePortrait_GetBackgroundUniformityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PORTRAIT,
                  ffi.Pointer<id3FaceBackgroundUniformity>)>>(
      'id3FacePortrait_GetBackgroundUniformity');
  late final _id3FacePortrait_GetBackgroundUniformity =
      _id3FacePortrait_GetBackgroundUniformityPtr.asFunction<
          int Function(
              ID3_FACE_PORTRAIT, ffi.Pointer<id3FaceBackgroundUniformity>)>();

  /// Gets the estimated expression of the subject (angriness, disgust, fear, happiness, sadness, surprise, or neutral). Unknown if not computed.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param eExpression [out] Estimated expression of the subject (angriness, disgust, fear, happiness, sadness, surprise, or neutral). Unknown if not computed.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetExpression(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int32> eExpression,
  ) {
    return _id3FacePortrait_GetExpression(
      hPortrait,
      eExpression,
    );
  }

  late final _id3FacePortrait_GetExpressionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int32>)>>('id3FacePortrait_GetExpression');
  late final _id3FacePortrait_GetExpression = _id3FacePortrait_GetExpressionPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int32>)>();

  /// Gets the estimated gaze.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sEyeGaze [out] Estimated gaze.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetEyeGaze(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FaceEyeGaze> sEyeGaze,
  ) {
    return _id3FacePortrait_GetEyeGaze(
      hPortrait,
      sEyeGaze,
    );
  }

  late final _id3FacePortrait_GetEyeGazePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<id3FaceEyeGaze>)>>('id3FacePortrait_GetEyeGaze');
  late final _id3FacePortrait_GetEyeGaze =
      _id3FacePortrait_GetEyeGazePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT, ffi.Pointer<id3FaceEyeGaze>)>();

  /// Gets the unique face ID.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param faceId [out] Unique face ID.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetFaceId(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> faceId,
  ) {
    return _id3FacePortrait_GetFaceId(
      hPortrait,
      faceId,
    );
  }

  late final _id3FacePortrait_GetFaceIdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetFaceId');
  late final _id3FacePortrait_GetFaceId = _id3FacePortrait_GetFaceIdPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value indicating whether a face mask is detected. The range is 0-100, 100 meaning a mask is detected.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param faceMask [out] Value indicating whether a face mask is detected. The range is 0-100, 100 meaning a mask is detected.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetFaceMask(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> faceMask,
  ) {
    return _id3FacePortrait_GetFaceMask(
      hPortrait,
      faceMask,
    );
  }

  late final _id3FacePortrait_GetFaceMaskPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetFaceMask');
  late final _id3FacePortrait_GetFaceMask = _id3FacePortrait_GetFaceMaskPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the face template.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param hFaceTemplate [out] Face template.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetFaceTemplate(
    ID3_FACE_PORTRAIT hPortrait,
    ID3_FACE_TEMPLATE hFaceTemplate,
  ) {
    return _id3FacePortrait_GetFaceTemplate(
      hPortrait,
      hFaceTemplate,
    );
  }

  late final _id3FacePortrait_GetFaceTemplatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ID3_FACE_TEMPLATE)>>('id3FacePortrait_GetFaceTemplate');
  late final _id3FacePortrait_GetFaceTemplate =
      _id3FacePortrait_GetFaceTemplatePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ID3_FACE_TEMPLATE)>();

  /// Gets the value indicating whether the subject is a male. -1 if not computed. The range is 0 (female) -100 (male).
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param genderMale [out] Value indicating whether the subject is a male. -1 if not computed. The range is 0 (female) -100 (male).
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetGenderMale(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> genderMale,
  ) {
    return _id3FacePortrait_GetGenderMale(
      hPortrait,
      genderMale,
    );
  }

  late final _id3FacePortrait_GetGenderMalePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetGenderMale');
  late final _id3FacePortrait_GetGenderMale = _id3FacePortrait_GetGenderMalePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the geometric attributes.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sGeometricAttributes [out] Geometric attributes.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetGeometricAttributes(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FaceGeometricAttributes> sGeometricAttributes,
  ) {
    return _id3FacePortrait_GetGeometricAttributes(
      hPortrait,
      sGeometricAttributes,
    );
  }

  late final _id3FacePortrait_GetGeometricAttributesPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT, ffi.Pointer<id3FaceGeometricAttributes>)>>(
      'id3FacePortrait_GetGeometricAttributes');
  late final _id3FacePortrait_GetGeometricAttributes =
      _id3FacePortrait_GetGeometricAttributesPtr.asFunction<
          int Function(
              ID3_FACE_PORTRAIT, ffi.Pointer<id3FaceGeometricAttributes>)>();

  /// Gets the value indicating whether the subject wears glasses. -1 if not computed. The range is 0-100, 100 meaning glasses are detected.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param glasses [out] Value indicating whether the subject wears glasses. -1 if not computed. The range is 0-100, 100 meaning glasses are detected.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetGlasses(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> glasses,
  ) {
    return _id3FacePortrait_GetGlasses(
      hPortrait,
      glasses,
    );
  }

  late final _id3FacePortrait_GetGlassesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetGlasses');
  late final _id3FacePortrait_GetGlasses = _id3FacePortrait_GetGlassesPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value indicating whether the subject wears a hat. -1 if not computed. The range is 0-100, 100 meaning a hat is detected.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param hat [out] Value indicating whether the subject wears a hat. -1 if not computed. The range is 0-100, 100 meaning a hat is detected.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetHat(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> hat,
  ) {
    return _id3FacePortrait_GetHat(
      hPortrait,
      hat,
    );
  }

  late final _id3FacePortrait_GetHatPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetHat');
  late final _id3FacePortrait_GetHat = _id3FacePortrait_GetHatPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the source image.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param hImage [out] Source image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetImage(
    ID3_FACE_PORTRAIT hPortrait,
    ID3_FACE_IMAGE hImage,
  ) {
    return _id3FacePortrait_GetImage(
      hPortrait,
      hImage,
    );
  }

  late final _id3FacePortrait_GetImagePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_FACE_PORTRAIT, ID3_FACE_IMAGE)>>(
      'id3FacePortrait_GetImage');
  late final _id3FacePortrait_GetImage = _id3FacePortrait_GetImagePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ID3_FACE_IMAGE)>();

  /// Gets the center of the portrait in the source image.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sImageCenter [out] Center of the portrait in the source image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetImageCenter(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FacePoint> sImageCenter,
  ) {
    return _id3FacePortrait_GetImageCenter(
      hPortrait,
      sImageCenter,
    );
  }

  late final _id3FacePortrait_GetImageCenterPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<id3FacePoint>)>>('id3FacePortrait_GetImageCenter');
  late final _id3FacePortrait_GetImageCenter =
      _id3FacePortrait_GetImageCenterPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT, ffi.Pointer<id3FacePoint>)>();

  /// Gets the scale to be applied to the source image to display the portrait.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param imageScale [out] Scale to be applied to the source image to display the portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetImageScale(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Float> imageScale,
  ) {
    return _id3FacePortrait_GetImageScale(
      hPortrait,
      imageScale,
    );
  }

  late final _id3FacePortrait_GetImageScalePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Float>)>>('id3FacePortrait_GetImageScale');
  late final _id3FacePortrait_GetImageScale = _id3FacePortrait_GetImageScalePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Float>)>();

  /// Gets the translation to be applied to the source image to display the portrait.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sImageTranslation [out] Translation to be applied to the source image to display the portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetImageTranslation(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FacePoint> sImageTranslation,
  ) {
    return _id3FacePortrait_GetImageTranslation(
      hPortrait,
      sImageTranslation,
    );
  }

  late final _id3FacePortrait_GetImageTranslationPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PORTRAIT, ffi.Pointer<id3FacePoint>)>>(
      'id3FacePortrait_GetImageTranslation');
  late final _id3FacePortrait_GetImageTranslation =
      _id3FacePortrait_GetImageTranslationPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT, ffi.Pointer<id3FacePoint>)>();

  /// Gets the instruction to be given to the user for portrait capture.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param eInstruction [out] Instruction to be given to the user for portrait capture.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetInstruction(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int32> eInstruction,
  ) {
    return _id3FacePortrait_GetInstruction(
      hPortrait,
      eInstruction,
    );
  }

  late final _id3FacePortrait_GetInstructionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int32>)>>('id3FacePortrait_GetInstruction');
  late final _id3FacePortrait_GetInstruction =
      _id3FacePortrait_GetInstructionPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int32>)>();

  /// Gets the 68-points landmarks.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param hLandmarks [out] 68-points landmarks.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetLandmarks(
    ID3_FACE_PORTRAIT hPortrait,
    ID3_FACE_POINT_LIST hLandmarks,
  ) {
    return _id3FacePortrait_GetLandmarks(
      hPortrait,
      hLandmarks,
    );
  }

  late final _id3FacePortrait_GetLandmarksPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ID3_FACE_POINT_LIST)>>('id3FacePortrait_GetLandmarks');
  late final _id3FacePortrait_GetLandmarks = _id3FacePortrait_GetLandmarksPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ID3_FACE_POINT_LIST)>();

  /// Gets the value estimating the opening of the left eye. -1 if not computed. The range is 0-100, 100 meaning the eye is fully opened.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param leftEyeOpening [out] Value estimating the opening of the left eye. -1 if not computed. The range is 0-100, 100 meaning the eye is fully opened.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetLeftEyeOpening(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> leftEyeOpening,
  ) {
    return _id3FacePortrait_GetLeftEyeOpening(
      hPortrait,
      leftEyeOpening,
    );
  }

  late final _id3FacePortrait_GetLeftEyeOpeningPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetLeftEyeOpening');
  late final _id3FacePortrait_GetLeftEyeOpening =
      _id3FacePortrait_GetLeftEyeOpeningPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value estimating the visibility of the left eye. -1 if not computed. The range is 0-100, 100 meaning the left eye is fully visible.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param leftEyeVisibility [out] Value estimating the visibility of the left eye. -1 if not computed. The range is 0-100, 100 meaning the left eye is fully visible.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetLeftEyeVisibility(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> leftEyeVisibility,
  ) {
    return _id3FacePortrait_GetLeftEyeVisibility(
      hPortrait,
      leftEyeVisibility,
    );
  }

  late final _id3FacePortrait_GetLeftEyeVisibilityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetLeftEyeVisibility');
  late final _id3FacePortrait_GetLeftEyeVisibility =
      _id3FacePortrait_GetLeftEyeVisibilityPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value estimating if the user is looking straight towards the camera. -1 if not computed. The range is 0-100, 100 meaning the look is straight.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param lookStraightScore [out] Value estimating if the user is looking straight towards the camera. -1 if not computed. The range is 0-100, 100 meaning the look is straight.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetLookStraightScore(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> lookStraightScore,
  ) {
    return _id3FacePortrait_GetLookStraightScore(
      hPortrait,
      lookStraightScore,
    );
  }

  late final _id3FacePortrait_GetLookStraightScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetLookStraightScore');
  late final _id3FacePortrait_GetLookStraightScore =
      _id3FacePortrait_GetLookStraightScorePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value indicating whether makeup is detected. -1 if not computed. The range is 0-100, 100 meaning makeup is detected.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param makeup [out] Value indicating whether makeup is detected. -1 if not computed. The range is 0-100, 100 meaning makeup is detected.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetMakeup(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> makeup,
  ) {
    return _id3FacePortrait_GetMakeup(
      hPortrait,
      makeup,
    );
  }

  late final _id3FacePortrait_GetMakeupPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetMakeup');
  late final _id3FacePortrait_GetMakeup = _id3FacePortrait_GetMakeupPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value indicating estimating the opening of the mouth. -1 if not computed. The range is 0-100, 100 meaning the mouth is fully open.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param mouthOpening [out] Value indicating estimating the opening of the mouth. -1 if not computed. The range is 0-100, 100 meaning the mouth is fully open.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetMouthOpening(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> mouthOpening,
  ) {
    return _id3FacePortrait_GetMouthOpening(
      hPortrait,
      mouthOpening,
    );
  }

  late final _id3FacePortrait_GetMouthOpeningPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetMouthOpening');
  late final _id3FacePortrait_GetMouthOpening =
      _id3FacePortrait_GetMouthOpeningPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value estimating the visibility of the mouth. -1 if not computed. The range is 0-100, 100 meaning the mouth is fully visible.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param mouthVisibility [out] Value estimating the visibility of the mouth. -1 if not computed. The range is 0-100, 100 meaning the mouth is fully visible.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetMouthVisibility(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> mouthVisibility,
  ) {
    return _id3FacePortrait_GetMouthVisibility(
      hPortrait,
      mouthVisibility,
    );
  }

  late final _id3FacePortrait_GetMouthVisibilityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetMouthVisibility');
  late final _id3FacePortrait_GetMouthVisibility =
      _id3FacePortrait_GetMouthVisibilityPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value estimating the visibility of the nose. -1 if not computed. The range is 0-100, 100 meaning the nose is fully visible.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param noseVisibility [out] Value estimating the visibility of the nose. -1 if not computed. The range is 0-100, 100 meaning the nose is fully visible.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetNoseVisibility(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> noseVisibility,
  ) {
    return _id3FacePortrait_GetNoseVisibility(
      hPortrait,
      noseVisibility,
    );
  }

  late final _id3FacePortrait_GetNoseVisibilityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetNoseVisibility');
  late final _id3FacePortrait_GetNoseVisibility =
      _id3FacePortrait_GetNoseVisibilityPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the score of the presentation attack detection.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param padScore [out] Score of the presentation attack detection.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetPadScore(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> padScore,
  ) {
    return _id3FacePortrait_GetPadScore(
      hPortrait,
      padScore,
    );
  }

  late final _id3FacePortrait_GetPadScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetPadScore');
  late final _id3FacePortrait_GetPadScore = _id3FacePortrait_GetPadScorePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the status of the presentation attack detection.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param ePadStatus [out] Status of the presentation attack detection.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetPadStatus(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int32> ePadStatus,
  ) {
    return _id3FacePortrait_GetPadStatus(
      hPortrait,
      ePadStatus,
    );
  }

  late final _id3FacePortrait_GetPadStatusPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int32>)>>('id3FacePortrait_GetPadStatus');
  late final _id3FacePortrait_GetPadStatus = _id3FacePortrait_GetPadStatusPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int32>)>();

  /// Gets the photographic attributes.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sPhotographicAttributes [out] Photographic attributes.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetPhotographicAttributes(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FacePhotographicAttributes> sPhotographicAttributes,
  ) {
    return _id3FacePortrait_GetPhotographicAttributes(
      hPortrait,
      sPhotographicAttributes,
    );
  }

  late final _id3FacePortrait_GetPhotographicAttributesPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PORTRAIT,
                  ffi.Pointer<id3FacePhotographicAttributes>)>>(
      'id3FacePortrait_GetPhotographicAttributes');
  late final _id3FacePortrait_GetPhotographicAttributes =
      _id3FacePortrait_GetPhotographicAttributesPtr.asFunction<
          int Function(
              ID3_FACE_PORTRAIT, ffi.Pointer<id3FacePhotographicAttributes>)>();

  /// Gets the face pose.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sPose [out] Face pose.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetPose(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FacePose> sPose,
  ) {
    return _id3FacePortrait_GetPose(
      hPortrait,
      sPose,
    );
  }

  late final _id3FacePortrait_GetPosePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<id3FacePose>)>>('id3FacePortrait_GetPose');
  late final _id3FacePortrait_GetPose = _id3FacePortrait_GetPosePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<id3FacePose>)>();

  /// Gets the quality check points of the portrait.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param sQualityCheckpoints [out] Quality check points of the portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetQualityCheckpoints(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<id3FacePortraitQualityCheckpoints> sQualityCheckpoints,
  ) {
    return _id3FacePortrait_GetQualityCheckpoints(
      hPortrait,
      sQualityCheckpoints,
    );
  }

  late final _id3FacePortrait_GetQualityCheckpointsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PORTRAIT,
                  ffi.Pointer<id3FacePortraitQualityCheckpoints>)>>(
      'id3FacePortrait_GetQualityCheckpoints');
  late final _id3FacePortrait_GetQualityCheckpoints =
      _id3FacePortrait_GetQualityCheckpointsPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<id3FacePortraitQualityCheckpoints>)>();

  /// Gets the unified quality score, from 0 to 100. -1 if not computed.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param qualityScore [out] Unified quality score, from 0 to 100. -1 if not computed.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetQualityScore(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> qualityScore,
  ) {
    return _id3FacePortrait_GetQualityScore(
      hPortrait,
      qualityScore,
    );
  }

  late final _id3FacePortrait_GetQualityScorePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetQualityScore');
  late final _id3FacePortrait_GetQualityScore =
      _id3FacePortrait_GetQualityScorePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value estimating the opening of the left eye. -1 if not computed. The range is 0-100, 100 meaning the eye is fully opened.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param rightEyeOpening [out] Value estimating the opening of the left eye. -1 if not computed. The range is 0-100, 100 meaning the eye is fully opened.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetRightEyeOpening(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> rightEyeOpening,
  ) {
    return _id3FacePortrait_GetRightEyeOpening(
      hPortrait,
      rightEyeOpening,
    );
  }

  late final _id3FacePortrait_GetRightEyeOpeningPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetRightEyeOpening');
  late final _id3FacePortrait_GetRightEyeOpening =
      _id3FacePortrait_GetRightEyeOpeningPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value estimating the visibility of the right eye. -1 if not computed. The range is 0-100, 100 meaning the right eye is fully visible.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param rightEyeVisibility [out] Value estimating the visibility of the right eye. -1 if not computed. The range is 0-100, 100 meaning the right eye is fully visible.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetRightEyeVisibility(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> rightEyeVisibility,
  ) {
    return _id3FacePortrait_GetRightEyeVisibility(
      hPortrait,
      rightEyeVisibility,
    );
  }

  late final _id3FacePortrait_GetRightEyeVisibilityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetRightEyeVisibility');
  late final _id3FacePortrait_GetRightEyeVisibility =
      _id3FacePortrait_GetRightEyeVisibilityPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the value indicating whether the subject is smiling. -1 if not computed. The range is 0-100, 100 meaning the person is smiling.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param smile [out] Value indicating whether the subject is smiling. -1 if not computed. The range is 0-100, 100 meaning the person is smiling.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetSmile(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int> smile,
  ) {
    return _id3FacePortrait_GetSmile(
      hPortrait,
      smile,
    );
  }

  late final _id3FacePortrait_GetSmilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_GetSmile');
  late final _id3FacePortrait_GetSmile = _id3FacePortrait_GetSmilePtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int>)>();

  /// Gets the status of the portrait.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param eStatus [out] Status of the portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetStatus(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int32> eStatus,
  ) {
    return _id3FacePortrait_GetStatus(
      hPortrait,
      eStatus,
    );
  }

  late final _id3FacePortrait_GetStatusPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int32>)>>('id3FacePortrait_GetStatus');
  late final _id3FacePortrait_GetStatus = _id3FacePortrait_GetStatusPtr
      .asFunction<int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int32>)>();

  /// Gets the position of the subject in the image.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param eSubjectPosition [out] Position of the subject in the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetSubjectPosition(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.Int32> eSubjectPosition,
  ) {
    return _id3FacePortrait_GetSubjectPosition(
      hPortrait,
      eSubjectPosition,
    );
  }

  late final _id3FacePortrait_GetSubjectPositionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ffi.Pointer<ffi.Int32>)>>('id3FacePortrait_GetSubjectPosition');
  late final _id3FacePortrait_GetSubjectPosition =
      _id3FacePortrait_GetSubjectPositionPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.Int32>)>();

  /// Gets the tracked face.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param hTrackedFace [out] Tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_GetTrackedFace(
    ID3_FACE_PORTRAIT hPortrait,
    ID3_TRACKED_FACE hTrackedFace,
  ) {
    return _id3FacePortrait_GetTrackedFace(
      hPortrait,
      hTrackedFace,
    );
  }

  late final _id3FacePortrait_GetTrackedFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT,
              ID3_TRACKED_FACE)>>('id3FacePortrait_GetTrackedFace');
  late final _id3FacePortrait_GetTrackedFace =
      _id3FacePortrait_GetTrackedFacePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT, ID3_TRACKED_FACE)>();

  /// Clears all attributes.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_Clear(
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortrait_Clear(
      hPortrait,
    );
  }

  late final _id3FacePortrait_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_PORTRAIT)>>(
          'id3FacePortrait_Clear');
  late final _id3FacePortrait_Clear =
      _id3FacePortrait_ClearPtr.asFunction<int Function(ID3_FACE_PORTRAIT)>();

  /// Imports the portrait object from a buffer.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param data [in] Buffer to import the portrait object from.
  /// @param dataSize [in] Size of the 'data' buffer.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_FromBuffer(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.UnsignedChar> data,
    int dataSize,
  ) {
    return _id3FacePortrait_FromBuffer(
      hPortrait,
      data,
      dataSize,
    );
  }

  late final _id3FacePortrait_FromBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int)>>('id3FacePortrait_FromBuffer');
  late final _id3FacePortrait_FromBuffer =
      _id3FacePortrait_FromBufferPtr.asFunction<
          int Function(
              ID3_FACE_PORTRAIT, ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Exports the portrait to a buffer.
  /// @param hPortrait [in] Handle to the Portrait object.
  /// @param data [out] The buffer to which the portrait object is exported.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortrait_ToBuffer(
    ID3_FACE_PORTRAIT hPortrait,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3FacePortrait_ToBuffer(
      hPortrait,
      data,
      dataSize,
    );
  }

  late final _id3FacePortrait_ToBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3FacePortrait_ToBuffer');
  late final _id3FacePortrait_ToBuffer =
      _id3FacePortrait_ToBufferPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// @brief Initializes a PortraitProcessor object.
  /// @param phPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_Initialize(
    ffi.Pointer<ID3_FACE_PORTRAIT_PROCESSOR> phPortraitProcessor,
  ) {
    return _id3FacePortraitProcessor_Initialize(
      phPortraitProcessor,
    );
  }

  late final _id3FacePortraitProcessor_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_PORTRAIT_PROCESSOR>)>>(
      'id3FacePortraitProcessor_Initialize');
  late final _id3FacePortraitProcessor_Initialize =
      _id3FacePortraitProcessor_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_FACE_PORTRAIT_PROCESSOR>)>();

  /// @brief Releases the memory allocated for a PortraitProcessor.
  /// @param phPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_Dispose(
    ffi.Pointer<ID3_FACE_PORTRAIT_PROCESSOR> phPortraitProcessor,
  ) {
    return _id3FacePortraitProcessor_Dispose(
      phPortraitProcessor,
    );
  }

  late final _id3FacePortraitProcessor_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_PORTRAIT_PROCESSOR>)>>(
      'id3FacePortraitProcessor_Dispose');
  late final _id3FacePortraitProcessor_Dispose =
      _id3FacePortraitProcessor_DisposePtr
          .asFunction<int Function(ffi.Pointer<ID3_FACE_PORTRAIT_PROCESSOR>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_CheckHandle(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
  ) {
    return _id3FacePortraitProcessor_CheckHandle(
      hPortraitProcessor,
    );
  }

  late final _id3FacePortraitProcessor_CheckHandlePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR)>>(
      'id3FacePortraitProcessor_CheckHandle');
  late final _id3FacePortraitProcessor_CheckHandle =
      _id3FacePortraitProcessor_CheckHandlePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR)>();

  /// Gets the background color uniformity threshold.
  /// If the score is above this value, the background color of the image is definitely uniform.
  /// Hint: Default value is 80.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param backgroundColorUniformityThreshold [out] Background color uniformity threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetBackgroundColorUniformityThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> backgroundColorUniformityThreshold,
  ) {
    return _id3FacePortraitProcessor_GetBackgroundColorUniformityThreshold(
      hPortraitProcessor,
      backgroundColorUniformityThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetBackgroundColorUniformityThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
          'id3FacePortraitProcessor_GetBackgroundColorUniformityThreshold');
  late final _id3FacePortraitProcessor_GetBackgroundColorUniformityThreshold =
      _id3FacePortraitProcessor_GetBackgroundColorUniformityThresholdPtr
          .asFunction<
              int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the background color uniformity threshold.
  /// If the score is above this value, the background color of the image is definitely uniform.
  /// Hint: Default value is 80.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param backgroundColorUniformityThreshold [in] Background color uniformity threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetBackgroundColorUniformityThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int backgroundColorUniformityThreshold,
  ) {
    return _id3FacePortraitProcessor_SetBackgroundColorUniformityThreshold(
      hPortraitProcessor,
      backgroundColorUniformityThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetBackgroundColorUniformityThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
          'id3FacePortraitProcessor_SetBackgroundColorUniformityThreshold');
  late final _id3FacePortraitProcessor_SetBackgroundColorUniformityThreshold =
      _id3FacePortraitProcessor_SetBackgroundColorUniformityThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the background structure uniformity threshold.
  /// If the score is above this value, the background structure of the image is definitely uniform.
  /// Hint: Default value is 80.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param backgroundStructureUniformityThreshold [out] Background structure uniformity threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetBackgroundStructureUniformityThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> backgroundStructureUniformityThreshold,
  ) {
    return _id3FacePortraitProcessor_GetBackgroundStructureUniformityThreshold(
      hPortraitProcessor,
      backgroundStructureUniformityThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetBackgroundStructureUniformityThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
          'id3FacePortraitProcessor_GetBackgroundStructureUniformityThreshold');
  late final _id3FacePortraitProcessor_GetBackgroundStructureUniformityThreshold =
      _id3FacePortraitProcessor_GetBackgroundStructureUniformityThresholdPtr
          .asFunction<
              int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the background structure uniformity threshold.
  /// If the score is above this value, the background structure of the image is definitely uniform.
  /// Hint: Default value is 80.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param backgroundStructureUniformityThreshold [in] Background structure uniformity threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetBackgroundStructureUniformityThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int backgroundStructureUniformityThreshold,
  ) {
    return _id3FacePortraitProcessor_SetBackgroundStructureUniformityThreshold(
      hPortraitProcessor,
      backgroundStructureUniformityThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetBackgroundStructureUniformityThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
          'id3FacePortraitProcessor_SetBackgroundStructureUniformityThreshold');
  late final _id3FacePortraitProcessor_SetBackgroundStructureUniformityThreshold =
      _id3FacePortraitProcessor_SetBackgroundStructureUniformityThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the aspect ratio (height to width) of the cropped portrait image.
  /// Hint: Default value is 4/3.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropAspectRatio [out] Aspect ratio (height to width) of the cropped portrait image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetCropAspectRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Float> cropAspectRatio,
  ) {
    return _id3FacePortraitProcessor_GetCropAspectRatio(
      hPortraitProcessor,
      cropAspectRatio,
    );
  }

  late final _id3FacePortraitProcessor_GetCropAspectRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>>(
      'id3FacePortraitProcessor_GetCropAspectRatio');
  late final _id3FacePortraitProcessor_GetCropAspectRatio =
      _id3FacePortraitProcessor_GetCropAspectRatioPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the aspect ratio (height to width) of the cropped portrait image.
  /// Hint: Default value is 4/3.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropAspectRatio [in] Aspect ratio (height to width) of the cropped portrait image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetCropAspectRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    double cropAspectRatio,
  ) {
    return _id3FacePortraitProcessor_SetCropAspectRatio(
      hPortraitProcessor,
      cropAspectRatio,
    );
  }

  late final _id3FacePortraitProcessor_SetCropAspectRatioPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Float)>>('id3FacePortraitProcessor_SetCropAspectRatio');
  late final _id3FacePortraitProcessor_SetCropAspectRatio =
      _id3FacePortraitProcessor_SetCropAspectRatioPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, double)>();

  /// Gets the ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range ]0;1[.
  /// Hint: Default value is 0.45.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropEyePositionRatio [out] Ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range ]0;1[.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetCropEyePositionRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Float> cropEyePositionRatio,
  ) {
    return _id3FacePortraitProcessor_GetCropEyePositionRatio(
      hPortraitProcessor,
      cropEyePositionRatio,
    );
  }

  late final _id3FacePortraitProcessor_GetCropEyePositionRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>>(
      'id3FacePortraitProcessor_GetCropEyePositionRatio');
  late final _id3FacePortraitProcessor_GetCropEyePositionRatio =
      _id3FacePortraitProcessor_GetCropEyePositionRatioPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range ]0;1[.
  /// Hint: Default value is 0.45.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropEyePositionRatio [in] Ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range ]0;1[.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetCropEyePositionRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    double cropEyePositionRatio,
  ) {
    return _id3FacePortraitProcessor_SetCropEyePositionRatio(
      hPortraitProcessor,
      cropEyePositionRatio,
    );
  }

  late final _id3FacePortraitProcessor_SetCropEyePositionRatioPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Float)>>('id3FacePortraitProcessor_SetCropEyePositionRatio');
  late final _id3FacePortraitProcessor_SetCropEyePositionRatio =
      _id3FacePortraitProcessor_SetCropEyePositionRatioPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, double)>();

  /// Gets the ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range ]0;1[.
  /// Hint: Default value is 0.25.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropIodRatio [out] Ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range ]0;1[.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetCropIodRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Float> cropIodRatio,
  ) {
    return _id3FacePortraitProcessor_GetCropIodRatio(
      hPortraitProcessor,
      cropIodRatio,
    );
  }

  late final _id3FacePortraitProcessor_GetCropIodRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>>(
      'id3FacePortraitProcessor_GetCropIodRatio');
  late final _id3FacePortraitProcessor_GetCropIodRatio =
      _id3FacePortraitProcessor_GetCropIodRatioPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range ]0;1[.
  /// Hint: Default value is 0.25.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropIodRatio [in] Ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range ]0;1[.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetCropIodRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    double cropIodRatio,
  ) {
    return _id3FacePortraitProcessor_SetCropIodRatio(
      hPortraitProcessor,
      cropIodRatio,
    );
  }

  late final _id3FacePortraitProcessor_SetCropIodRatioPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Float)>>('id3FacePortraitProcessor_SetCropIodRatio');
  late final _id3FacePortraitProcessor_SetCropIodRatio =
      _id3FacePortraitProcessor_SetCropIodRatioPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, double)>();

  /// Gets the relative margin around the face for basic portrait cropping.
  /// Hint: Default value is 0.5.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropMargin [out] Relative margin around the face for basic portrait cropping.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetCropMargin(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Float> cropMargin,
  ) {
    return _id3FacePortraitProcessor_GetCropMargin(
      hPortraitProcessor,
      cropMargin,
    );
  }

  late final _id3FacePortraitProcessor_GetCropMarginPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>>(
      'id3FacePortraitProcessor_GetCropMargin');
  late final _id3FacePortraitProcessor_GetCropMargin =
      _id3FacePortraitProcessor_GetCropMarginPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the relative margin around the face for basic portrait cropping.
  /// Hint: Default value is 0.5.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param cropMargin [in] Relative margin around the face for basic portrait cropping.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetCropMargin(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    double cropMargin,
  ) {
    return _id3FacePortraitProcessor_SetCropMargin(
      hPortraitProcessor,
      cropMargin,
    );
  }

  late final _id3FacePortraitProcessor_SetCropMarginPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Float)>>('id3FacePortraitProcessor_SetCropMargin');
  late final _id3FacePortraitProcessor_SetCropMargin =
      _id3FacePortraitProcessor_SetCropMarginPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, double)>();

  /// Gets the face dynamic range threshold.
  /// Above this threshold, the dynamic range of the image in the face region is good enough.
  /// Hint: Default value is 128.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param dynamicRangeThreshold [out] Face dynamic range threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetDynamicRangeThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> dynamicRangeThreshold,
  ) {
    return _id3FacePortraitProcessor_GetDynamicRangeThreshold(
      hPortraitProcessor,
      dynamicRangeThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetDynamicRangeThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetDynamicRangeThreshold');
  late final _id3FacePortraitProcessor_GetDynamicRangeThreshold =
      _id3FacePortraitProcessor_GetDynamicRangeThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the face dynamic range threshold.
  /// Above this threshold, the dynamic range of the image in the face region is good enough.
  /// Hint: Default value is 128.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param dynamicRangeThreshold [in] Face dynamic range threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetDynamicRangeThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int dynamicRangeThreshold,
  ) {
    return _id3FacePortraitProcessor_SetDynamicRangeThreshold(
      hPortraitProcessor,
      dynamicRangeThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetDynamicRangeThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetDynamicRangeThreshold');
  late final _id3FacePortraitProcessor_SetDynamicRangeThreshold =
      _id3FacePortraitProcessor_SetDynamicRangeThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the equal brightness threshold.
  /// Above this value, the face is equally exposed.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param equalBrightnessThreshold [out] Equal brightness threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetEqualBrightnessThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> equalBrightnessThreshold,
  ) {
    return _id3FacePortraitProcessor_GetEqualBrightnessThreshold(
      hPortraitProcessor,
      equalBrightnessThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetEqualBrightnessThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetEqualBrightnessThreshold');
  late final _id3FacePortraitProcessor_GetEqualBrightnessThreshold =
      _id3FacePortraitProcessor_GetEqualBrightnessThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the equal brightness threshold.
  /// Above this value, the face is equally exposed.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param equalBrightnessThreshold [in] Equal brightness threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetEqualBrightnessThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int equalBrightnessThreshold,
  ) {
    return _id3FacePortraitProcessor_SetEqualBrightnessThreshold(
      hPortraitProcessor,
      equalBrightnessThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetEqualBrightnessThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
      'id3FacePortraitProcessor_SetEqualBrightnessThreshold');
  late final _id3FacePortraitProcessor_SetEqualBrightnessThreshold =
      _id3FacePortraitProcessor_SetEqualBrightnessThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the sensibility of the expression classifier.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be less likely to estimate neutral expression out of the detected face.
  /// Hint: Default value is 60.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param expressionSensibility [out] Sensibility of the expression classifier.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetExpressionSensibility(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> expressionSensibility,
  ) {
    return _id3FacePortraitProcessor_GetExpressionSensibility(
      hPortraitProcessor,
      expressionSensibility,
    );
  }

  late final _id3FacePortraitProcessor_GetExpressionSensibilityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetExpressionSensibility');
  late final _id3FacePortraitProcessor_GetExpressionSensibility =
      _id3FacePortraitProcessor_GetExpressionSensibilityPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the sensibility of the expression classifier.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be less likely to estimate neutral expression out of the detected face.
  /// Hint: Default value is 60.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param expressionSensibility [in] Sensibility of the expression classifier.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetExpressionSensibility(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int expressionSensibility,
  ) {
    return _id3FacePortraitProcessor_SetExpressionSensibility(
      hPortraitProcessor,
      expressionSensibility,
    );
  }

  late final _id3FacePortraitProcessor_SetExpressionSensibilityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetExpressionSensibility');
  late final _id3FacePortraitProcessor_SetExpressionSensibility =
      _id3FacePortraitProcessor_SetExpressionSensibilityPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the visible eye threshold.
  /// If the score is above this value, the eye is probably occluded.
  /// Hint: Default value 80.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eyeOcclusionThreshold [out] Visible eye threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetEyeOcclusionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> eyeOcclusionThreshold,
  ) {
    return _id3FacePortraitProcessor_GetEyeOcclusionThreshold(
      hPortraitProcessor,
      eyeOcclusionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetEyeOcclusionThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetEyeOcclusionThreshold');
  late final _id3FacePortraitProcessor_GetEyeOcclusionThreshold =
      _id3FacePortraitProcessor_GetEyeOcclusionThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the visible eye threshold.
  /// If the score is above this value, the eye is probably occluded.
  /// Hint: Default value 80.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eyeOcclusionThreshold [in] Visible eye threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetEyeOcclusionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int eyeOcclusionThreshold,
  ) {
    return _id3FacePortraitProcessor_SetEyeOcclusionThreshold(
      hPortraitProcessor,
      eyeOcclusionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetEyeOcclusionThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetEyeOcclusionThreshold');
  late final _id3FacePortraitProcessor_SetEyeOcclusionThreshold =
      _id3FacePortraitProcessor_SetEyeOcclusionThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the eye opening threshold.
  /// If the score is above this value, the eyes are definitely open.
  /// Hint: Default value is 5.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eyeOpeningThreshold [out] Eye opening threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetEyeOpeningThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> eyeOpeningThreshold,
  ) {
    return _id3FacePortraitProcessor_GetEyeOpeningThreshold(
      hPortraitProcessor,
      eyeOpeningThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetEyeOpeningThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetEyeOpeningThreshold');
  late final _id3FacePortraitProcessor_GetEyeOpeningThreshold =
      _id3FacePortraitProcessor_GetEyeOpeningThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the eye opening threshold.
  /// If the score is above this value, the eyes are definitely open.
  /// Hint: Default value is 5.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eyeOpeningThreshold [in] Eye opening threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetEyeOpeningThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int eyeOpeningThreshold,
  ) {
    return _id3FacePortraitProcessor_SetEyeOpeningThreshold(
      hPortraitProcessor,
      eyeOpeningThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetEyeOpeningThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetEyeOpeningThreshold');
  late final _id3FacePortraitProcessor_SetEyeOpeningThreshold =
      _id3FacePortraitProcessor_SetEyeOpeningThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the the size, in pixels, of the downscaled image used for face detection.
  /// Hint: Default value is 256. Low values tend to ignore small faces in the input image, while higher values tend to take longer to process.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param faceDetectionImageSize [out] The size, in pixels, of the downscaled image used for face detection.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetFaceDetectionImageSize(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> faceDetectionImageSize,
  ) {
    return _id3FacePortraitProcessor_GetFaceDetectionImageSize(
      hPortraitProcessor,
      faceDetectionImageSize,
    );
  }

  late final _id3FacePortraitProcessor_GetFaceDetectionImageSizePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetFaceDetectionImageSize');
  late final _id3FacePortraitProcessor_GetFaceDetectionImageSize =
      _id3FacePortraitProcessor_GetFaceDetectionImageSizePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the the size, in pixels, of the downscaled image used for face detection.
  /// Hint: Default value is 256. Low values tend to ignore small faces in the input image, while higher values tend to take longer to process.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param faceDetectionImageSize [in] The size, in pixels, of the downscaled image used for face detection.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetFaceDetectionImageSize(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int faceDetectionImageSize,
  ) {
    return _id3FacePortraitProcessor_SetFaceDetectionImageSize(
      hPortraitProcessor,
      faceDetectionImageSize,
    );
  }

  late final _id3FacePortraitProcessor_SetFaceDetectionImageSizePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetFaceDetectionImageSize');
  late final _id3FacePortraitProcessor_SetFaceDetectionImageSize =
      _id3FacePortraitProcessor_SetFaceDetectionImageSizePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the specifies the model used to detect and track faces.
  /// Hint: Default value is ``FaceDetector4B``. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eFaceDetectionModel [out] Specifies the model used to detect and track faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetFaceDetectionModel(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int32> eFaceDetectionModel,
  ) {
    return _id3FacePortraitProcessor_GetFaceDetectionModel(
      hPortraitProcessor,
      eFaceDetectionModel,
    );
  }

  late final _id3FacePortraitProcessor_GetFaceDetectionModelPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int32>)>>(
      'id3FacePortraitProcessor_GetFaceDetectionModel');
  late final _id3FacePortraitProcessor_GetFaceDetectionModel =
      _id3FacePortraitProcessor_GetFaceDetectionModelPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int32>)>();

  /// Sets the specifies the model used to detect and track faces.
  /// Hint: Default value is ``FaceDetector4B``. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eFaceDetectionModel [in] Specifies the model used to detect and track faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetFaceDetectionModel(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int eFaceDetectionModel,
  ) {
    return _id3FacePortraitProcessor_SetFaceDetectionModel(
      hPortraitProcessor,
      eFaceDetectionModel,
    );
  }

  late final _id3FacePortraitProcessor_SetFaceDetectionModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int32)>>('id3FacePortraitProcessor_SetFaceDetectionModel');
  late final _id3FacePortraitProcessor_SetFaceDetectionModel =
      _id3FacePortraitProcessor_SetFaceDetectionModelPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the specifies the face detection confidence threshold, in the range is [0;100].
  /// Hint: Default value is 50. Setting a high threshold reduces false detections but may increase the number of undetected faces.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param faceDetectionThreshold [out] Specifies the face detection confidence threshold, in the range is [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetFaceDetectionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> faceDetectionThreshold,
  ) {
    return _id3FacePortraitProcessor_GetFaceDetectionThreshold(
      hPortraitProcessor,
      faceDetectionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetFaceDetectionThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetFaceDetectionThreshold');
  late final _id3FacePortraitProcessor_GetFaceDetectionThreshold =
      _id3FacePortraitProcessor_GetFaceDetectionThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the specifies the face detection confidence threshold, in the range is [0;100].
  /// Hint: Default value is 50. Setting a high threshold reduces false detections but may increase the number of undetected faces.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param faceDetectionThreshold [in] Specifies the face detection confidence threshold, in the range is [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetFaceDetectionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int faceDetectionThreshold,
  ) {
    return _id3FacePortraitProcessor_SetFaceDetectionThreshold(
      hPortraitProcessor,
      faceDetectionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetFaceDetectionThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetFaceDetectionThreshold');
  late final _id3FacePortraitProcessor_SetFaceDetectionThreshold =
      _id3FacePortraitProcessor_SetFaceDetectionThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the model used to create features and assess consistancy among views of a given face.
  /// Hint: Default value is ``FaceEncoder9B``. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eFaceEncodingModel [out] Model used to create features and assess consistancy among views of a given face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetFaceEncodingModel(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int32> eFaceEncodingModel,
  ) {
    return _id3FacePortraitProcessor_GetFaceEncodingModel(
      hPortraitProcessor,
      eFaceEncodingModel,
    );
  }

  late final _id3FacePortraitProcessor_GetFaceEncodingModelPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int32>)>>(
      'id3FacePortraitProcessor_GetFaceEncodingModel');
  late final _id3FacePortraitProcessor_GetFaceEncodingModel =
      _id3FacePortraitProcessor_GetFaceEncodingModelPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int32>)>();

  /// Sets the model used to create features and assess consistancy among views of a given face.
  /// Hint: Default value is ``FaceEncoder9B``. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param eFaceEncodingModel [in] Model used to create features and assess consistancy among views of a given face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetFaceEncodingModel(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int eFaceEncodingModel,
  ) {
    return _id3FacePortraitProcessor_SetFaceEncodingModel(
      hPortraitProcessor,
      eFaceEncodingModel,
    );
  }

  late final _id3FacePortraitProcessor_SetFaceEncodingModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int32)>>('id3FacePortraitProcessor_SetFaceEncodingModel');
  late final _id3FacePortraitProcessor_SetFaceEncodingModel =
      _id3FacePortraitProcessor_SetFaceEncodingModelPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the face mask detection threshold.
  /// If the detection score is above this value, the person is probably wearing a mask.
  /// Hint: Default value is 35.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param faceMaskThreshold [out] Face mask detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetFaceMaskThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> faceMaskThreshold,
  ) {
    return _id3FacePortraitProcessor_GetFaceMaskThreshold(
      hPortraitProcessor,
      faceMaskThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetFaceMaskThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetFaceMaskThreshold');
  late final _id3FacePortraitProcessor_GetFaceMaskThreshold =
      _id3FacePortraitProcessor_GetFaceMaskThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the face mask detection threshold.
  /// If the detection score is above this value, the person is probably wearing a mask.
  /// Hint: Default value is 35.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param faceMaskThreshold [in] Face mask detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetFaceMaskThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int faceMaskThreshold,
  ) {
    return _id3FacePortraitProcessor_SetFaceMaskThreshold(
      hPortraitProcessor,
      faceMaskThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetFaceMaskThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetFaceMaskThreshold');
  late final _id3FacePortraitProcessor_SetFaceMaskThreshold =
      _id3FacePortraitProcessor_SetFaceMaskThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the glasses detection threshold.
  /// If the score is above this value, the person is probably wearing glasses.
  /// Hint: Default value 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param glassesThreshold [out] Glasses detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetGlassesThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> glassesThreshold,
  ) {
    return _id3FacePortraitProcessor_GetGlassesThreshold(
      hPortraitProcessor,
      glassesThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetGlassesThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetGlassesThreshold');
  late final _id3FacePortraitProcessor_GetGlassesThreshold =
      _id3FacePortraitProcessor_GetGlassesThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the glasses detection threshold.
  /// If the score is above this value, the person is probably wearing glasses.
  /// Hint: Default value 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param glassesThreshold [in] Glasses detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetGlassesThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int glassesThreshold,
  ) {
    return _id3FacePortraitProcessor_SetGlassesThreshold(
      hPortraitProcessor,
      glassesThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetGlassesThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetGlassesThreshold');
  late final _id3FacePortraitProcessor_SetGlassesThreshold =
      _id3FacePortraitProcessor_SetGlassesThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the threshold for confirming that the person is wearing a hat.
  /// Hint: Default value is 98.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hatThreshold [out] Threshold for confirming that the person is wearing a hat.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetHatThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> hatThreshold,
  ) {
    return _id3FacePortraitProcessor_GetHatThreshold(
      hPortraitProcessor,
      hatThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetHatThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetHatThreshold');
  late final _id3FacePortraitProcessor_GetHatThreshold =
      _id3FacePortraitProcessor_GetHatThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the threshold for confirming that the person is wearing a hat.
  /// Hint: Default value is 98.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hatThreshold [in] Threshold for confirming that the person is wearing a hat.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetHatThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int hatThreshold,
  ) {
    return _id3FacePortraitProcessor_SetHatThreshold(
      hPortraitProcessor,
      hatThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetHatThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetHatThreshold');
  late final _id3FacePortraitProcessor_SetHatThreshold =
      _id3FacePortraitProcessor_SetHatThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the make-up detection threshold.
  /// If the detection score is above this value, the persone is definitely wearing make-up.
  /// Hint: Default value 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param makeupThreshold [out] Make-up detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMakeupThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> makeupThreshold,
  ) {
    return _id3FacePortraitProcessor_GetMakeupThreshold(
      hPortraitProcessor,
      makeupThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetMakeupThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMakeupThreshold');
  late final _id3FacePortraitProcessor_GetMakeupThreshold =
      _id3FacePortraitProcessor_GetMakeupThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the make-up detection threshold.
  /// If the detection score is above this value, the persone is definitely wearing make-up.
  /// Hint: Default value 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param makeupThreshold [in] Make-up detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMakeupThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int makeupThreshold,
  ) {
    return _id3FacePortraitProcessor_SetMakeupThreshold(
      hPortraitProcessor,
      makeupThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetMakeupThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMakeupThreshold');
  late final _id3FacePortraitProcessor_SetMakeupThreshold =
      _id3FacePortraitProcessor_SetMakeupThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the male gender detection threshold.
  /// If the score is higher than this value, the person is probably male.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maleThreshold [out] Male gender detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaleThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maleThreshold,
  ) {
    return _id3FacePortraitProcessor_GetMaleThreshold(
      hPortraitProcessor,
      maleThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetMaleThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMaleThreshold');
  late final _id3FacePortraitProcessor_GetMaleThreshold =
      _id3FacePortraitProcessor_GetMaleThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the male gender detection threshold.
  /// If the score is higher than this value, the person is probably male.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maleThreshold [in] Male gender detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaleThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maleThreshold,
  ) {
    return _id3FacePortraitProcessor_SetMaleThreshold(
      hPortraitProcessor,
      maleThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetMaleThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMaleThreshold');
  late final _id3FacePortraitProcessor_SetMaleThreshold =
      _id3FacePortraitProcessor_SetMaleThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the maximum value of the eye gaze alongside the X axis.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumEyeGazeX [out] Maximum value of the eye gaze alongside the X axis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumEyeGazeX(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maximumEyeGazeX,
  ) {
    return _id3FacePortraitProcessor_GetMaximumEyeGazeX(
      hPortraitProcessor,
      maximumEyeGazeX,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumEyeGazeXPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMaximumEyeGazeX');
  late final _id3FacePortraitProcessor_GetMaximumEyeGazeX =
      _id3FacePortraitProcessor_GetMaximumEyeGazeXPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the maximum value of the eye gaze alongside the X axis.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumEyeGazeX [in] Maximum value of the eye gaze alongside the X axis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumEyeGazeX(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maximumEyeGazeX,
  ) {
    return _id3FacePortraitProcessor_SetMaximumEyeGazeX(
      hPortraitProcessor,
      maximumEyeGazeX,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumEyeGazeXPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMaximumEyeGazeX');
  late final _id3FacePortraitProcessor_SetMaximumEyeGazeX =
      _id3FacePortraitProcessor_SetMaximumEyeGazeXPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the maximum value of the eye gaze alongside the Y axis.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumEyeGazeY [out] Maximum value of the eye gaze alongside the Y axis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumEyeGazeY(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maximumEyeGazeY,
  ) {
    return _id3FacePortraitProcessor_GetMaximumEyeGazeY(
      hPortraitProcessor,
      maximumEyeGazeY,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumEyeGazeYPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMaximumEyeGazeY');
  late final _id3FacePortraitProcessor_GetMaximumEyeGazeY =
      _id3FacePortraitProcessor_GetMaximumEyeGazeYPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the maximum value of the eye gaze alongside the Y axis.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumEyeGazeY [in] Maximum value of the eye gaze alongside the Y axis.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumEyeGazeY(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maximumEyeGazeY,
  ) {
    return _id3FacePortraitProcessor_SetMaximumEyeGazeY(
      hPortraitProcessor,
      maximumEyeGazeY,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumEyeGazeYPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMaximumEyeGazeY');
  late final _id3FacePortraitProcessor_SetMaximumEyeGazeY =
      _id3FacePortraitProcessor_SetMaximumEyeGazeYPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumHeadHeightRatio [out] Maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumHeadHeightRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maximumHeadHeightRatio,
  ) {
    return _id3FacePortraitProcessor_GetMaximumHeadHeightRatio(
      hPortraitProcessor,
      maximumHeadHeightRatio,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumHeadHeightRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMaximumHeadHeightRatio');
  late final _id3FacePortraitProcessor_GetMaximumHeadHeightRatio =
      _id3FacePortraitProcessor_GetMaximumHeadHeightRatioPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumHeadHeightRatio [in] Maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumHeadHeightRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maximumHeadHeightRatio,
  ) {
    return _id3FacePortraitProcessor_SetMaximumHeadHeightRatio(
      hPortraitProcessor,
      maximumHeadHeightRatio,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumHeadHeightRatioPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMaximumHeadHeightRatio');
  late final _id3FacePortraitProcessor_SetMaximumHeadHeightRatio =
      _id3FacePortraitProcessor_SetMaximumHeadHeightRatioPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 75.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumHeadWidthRatio [out] Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumHeadWidthRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maximumHeadWidthRatio,
  ) {
    return _id3FacePortraitProcessor_GetMaximumHeadWidthRatio(
      hPortraitProcessor,
      maximumHeadWidthRatio,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumHeadWidthRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMaximumHeadWidthRatio');
  late final _id3FacePortraitProcessor_GetMaximumHeadWidthRatio =
      _id3FacePortraitProcessor_GetMaximumHeadWidthRatioPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 75.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumHeadWidthRatio [in] Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumHeadWidthRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maximumHeadWidthRatio,
  ) {
    return _id3FacePortraitProcessor_SetMaximumHeadWidthRatio(
      hPortraitProcessor,
      maximumHeadWidthRatio,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumHeadWidthRatioPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMaximumHeadWidthRatio');
  late final _id3FacePortraitProcessor_SetMaximumHeadWidthRatio =
      _id3FacePortraitProcessor_SetMaximumHeadWidthRatioPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 55.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumHorizontalPosition [out] Value indicating if the head is correctly centered horizontally.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumHorizontalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maximumHorizontalPosition,
  ) {
    return _id3FacePortraitProcessor_GetMaximumHorizontalPosition(
      hPortraitProcessor,
      maximumHorizontalPosition,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumHorizontalPositionPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
          'id3FacePortraitProcessor_GetMaximumHorizontalPosition');
  late final _id3FacePortraitProcessor_GetMaximumHorizontalPosition =
      _id3FacePortraitProcessor_GetMaximumHorizontalPositionPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 55.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumHorizontalPosition [in] Value indicating if the head is correctly centered horizontally.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumHorizontalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maximumHorizontalPosition,
  ) {
    return _id3FacePortraitProcessor_SetMaximumHorizontalPosition(
      hPortraitProcessor,
      maximumHorizontalPosition,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumHorizontalPositionPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
          'id3FacePortraitProcessor_SetMaximumHorizontalPosition');
  late final _id3FacePortraitProcessor_SetMaximumHorizontalPosition =
      _id3FacePortraitProcessor_SetMaximumHorizontalPositionPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the maximum interocular distance (IOD), in pixels.
  /// This parameter is used to prevent the subject from being too close to the camera.
  /// Hint: Default value is 512.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumIod [out] Maximum interocular distance (IOD), in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumIod(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maximumIod,
  ) {
    return _id3FacePortraitProcessor_GetMaximumIod(
      hPortraitProcessor,
      maximumIod,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumIodPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Pointer<ffi.Int>)>>('id3FacePortraitProcessor_GetMaximumIod');
  late final _id3FacePortraitProcessor_GetMaximumIod =
      _id3FacePortraitProcessor_GetMaximumIodPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the maximum interocular distance (IOD), in pixels.
  /// This parameter is used to prevent the subject from being too close to the camera.
  /// Hint: Default value is 512.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumIod [in] Maximum interocular distance (IOD), in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumIod(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maximumIod,
  ) {
    return _id3FacePortraitProcessor_SetMaximumIod(
      hPortraitProcessor,
      maximumIod,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumIodPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMaximumIod');
  late final _id3FacePortraitProcessor_SetMaximumIod =
      _id3FacePortraitProcessor_SetMaximumIodPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the maximum head pitch angle, in degrees, for frontal positioning.
  /// Hint: Default value is 20.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumPitchAngle [out] Maximum head pitch angle, in degrees, for frontal positioning.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumPitchAngle(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Float> maximumPitchAngle,
  ) {
    return _id3FacePortraitProcessor_GetMaximumPitchAngle(
      hPortraitProcessor,
      maximumPitchAngle,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumPitchAnglePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>>(
      'id3FacePortraitProcessor_GetMaximumPitchAngle');
  late final _id3FacePortraitProcessor_GetMaximumPitchAngle =
      _id3FacePortraitProcessor_GetMaximumPitchAnglePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the maximum head pitch angle, in degrees, for frontal positioning.
  /// Hint: Default value is 20.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumPitchAngle [in] Maximum head pitch angle, in degrees, for frontal positioning.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumPitchAngle(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    double maximumPitchAngle,
  ) {
    return _id3FacePortraitProcessor_SetMaximumPitchAngle(
      hPortraitProcessor,
      maximumPitchAngle,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumPitchAnglePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Float)>>('id3FacePortraitProcessor_SetMaximumPitchAngle');
  late final _id3FacePortraitProcessor_SetMaximumPitchAngle =
      _id3FacePortraitProcessor_SetMaximumPitchAnglePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, double)>();

  /// Gets the maximum head roll angle, in degrees, for frontal positioning.
  /// Hint: Default value is 15.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumRollAngle [out] Maximum head roll angle, in degrees, for frontal positioning.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumRollAngle(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Float> maximumRollAngle,
  ) {
    return _id3FacePortraitProcessor_GetMaximumRollAngle(
      hPortraitProcessor,
      maximumRollAngle,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumRollAnglePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>>(
      'id3FacePortraitProcessor_GetMaximumRollAngle');
  late final _id3FacePortraitProcessor_GetMaximumRollAngle =
      _id3FacePortraitProcessor_GetMaximumRollAnglePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the maximum head roll angle, in degrees, for frontal positioning.
  /// Hint: Default value is 15.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumRollAngle [in] Maximum head roll angle, in degrees, for frontal positioning.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumRollAngle(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    double maximumRollAngle,
  ) {
    return _id3FacePortraitProcessor_SetMaximumRollAngle(
      hPortraitProcessor,
      maximumRollAngle,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumRollAnglePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Float)>>('id3FacePortraitProcessor_SetMaximumRollAngle');
  late final _id3FacePortraitProcessor_SetMaximumRollAngle =
      _id3FacePortraitProcessor_SetMaximumRollAnglePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, double)>();

  /// Gets the maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumVerticalPosition [out] Maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumVerticalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> maximumVerticalPosition,
  ) {
    return _id3FacePortraitProcessor_GetMaximumVerticalPosition(
      hPortraitProcessor,
      maximumVerticalPosition,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumVerticalPositionPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMaximumVerticalPosition');
  late final _id3FacePortraitProcessor_GetMaximumVerticalPosition =
      _id3FacePortraitProcessor_GetMaximumVerticalPositionPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumVerticalPosition [in] Maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumVerticalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int maximumVerticalPosition,
  ) {
    return _id3FacePortraitProcessor_SetMaximumVerticalPosition(
      hPortraitProcessor,
      maximumVerticalPosition,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumVerticalPositionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMaximumVerticalPosition');
  late final _id3FacePortraitProcessor_SetMaximumVerticalPosition =
      _id3FacePortraitProcessor_SetMaximumVerticalPositionPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the maximum head yaw angle, in degrees, for frontal positioning.
  /// Hint: Default value is 8.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumYawAngle [out] Maximum head yaw angle, in degrees, for frontal positioning.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMaximumYawAngle(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Float> maximumYawAngle,
  ) {
    return _id3FacePortraitProcessor_GetMaximumYawAngle(
      hPortraitProcessor,
      maximumYawAngle,
    );
  }

  late final _id3FacePortraitProcessor_GetMaximumYawAnglePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>>(
      'id3FacePortraitProcessor_GetMaximumYawAngle');
  late final _id3FacePortraitProcessor_GetMaximumYawAngle =
      _id3FacePortraitProcessor_GetMaximumYawAnglePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the maximum head yaw angle, in degrees, for frontal positioning.
  /// Hint: Default value is 8.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param maximumYawAngle [in] Maximum head yaw angle, in degrees, for frontal positioning.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMaximumYawAngle(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    double maximumYawAngle,
  ) {
    return _id3FacePortraitProcessor_SetMaximumYawAngle(
      hPortraitProcessor,
      maximumYawAngle,
    );
  }

  late final _id3FacePortraitProcessor_SetMaximumYawAnglePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Float)>>('id3FacePortraitProcessor_SetMaximumYawAngle');
  late final _id3FacePortraitProcessor_SetMaximumYawAngle =
      _id3FacePortraitProcessor_SetMaximumYawAnglePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, double)>();

  /// Gets the minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 60.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumHeadHeightRatio [out] Minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMinimumHeadHeightRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> minimumHeadHeightRatio,
  ) {
    return _id3FacePortraitProcessor_GetMinimumHeadHeightRatio(
      hPortraitProcessor,
      minimumHeadHeightRatio,
    );
  }

  late final _id3FacePortraitProcessor_GetMinimumHeadHeightRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMinimumHeadHeightRatio');
  late final _id3FacePortraitProcessor_GetMinimumHeadHeightRatio =
      _id3FacePortraitProcessor_GetMinimumHeadHeightRatioPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 60.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumHeadHeightRatio [in] Minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMinimumHeadHeightRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int minimumHeadHeightRatio,
  ) {
    return _id3FacePortraitProcessor_SetMinimumHeadHeightRatio(
      hPortraitProcessor,
      minimumHeadHeightRatio,
    );
  }

  late final _id3FacePortraitProcessor_SetMinimumHeadHeightRatioPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMinimumHeadHeightRatio');
  late final _id3FacePortraitProcessor_SetMinimumHeadHeightRatio =
      _id3FacePortraitProcessor_SetMinimumHeadHeightRatioPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumHeadWidthRatio [out] Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMinimumHeadWidthRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> minimumHeadWidthRatio,
  ) {
    return _id3FacePortraitProcessor_GetMinimumHeadWidthRatio(
      hPortraitProcessor,
      minimumHeadWidthRatio,
    );
  }

  late final _id3FacePortraitProcessor_GetMinimumHeadWidthRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMinimumHeadWidthRatio');
  late final _id3FacePortraitProcessor_GetMinimumHeadWidthRatio =
      _id3FacePortraitProcessor_GetMinimumHeadWidthRatioPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumHeadWidthRatio [in] Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMinimumHeadWidthRatio(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int minimumHeadWidthRatio,
  ) {
    return _id3FacePortraitProcessor_SetMinimumHeadWidthRatio(
      hPortraitProcessor,
      minimumHeadWidthRatio,
    );
  }

  late final _id3FacePortraitProcessor_SetMinimumHeadWidthRatioPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMinimumHeadWidthRatio');
  late final _id3FacePortraitProcessor_SetMinimumHeadWidthRatio =
      _id3FacePortraitProcessor_SetMinimumHeadWidthRatioPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 45.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumHorizontalPosition [out] Value indicating if the head is correctly centered horizontally.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMinimumHorizontalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> minimumHorizontalPosition,
  ) {
    return _id3FacePortraitProcessor_GetMinimumHorizontalPosition(
      hPortraitProcessor,
      minimumHorizontalPosition,
    );
  }

  late final _id3FacePortraitProcessor_GetMinimumHorizontalPositionPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
          'id3FacePortraitProcessor_GetMinimumHorizontalPosition');
  late final _id3FacePortraitProcessor_GetMinimumHorizontalPosition =
      _id3FacePortraitProcessor_GetMinimumHorizontalPositionPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 45.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumHorizontalPosition [in] Value indicating if the head is correctly centered horizontally.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMinimumHorizontalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int minimumHorizontalPosition,
  ) {
    return _id3FacePortraitProcessor_SetMinimumHorizontalPosition(
      hPortraitProcessor,
      minimumHorizontalPosition,
    );
  }

  late final _id3FacePortraitProcessor_SetMinimumHorizontalPositionPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
          'id3FacePortraitProcessor_SetMinimumHorizontalPosition');
  late final _id3FacePortraitProcessor_SetMinimumHorizontalPosition =
      _id3FacePortraitProcessor_SetMinimumHorizontalPositionPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the minimum intra-occular distance, in pixels.
  /// This parameter is used to the limit the distance from the subject to the camera.
  /// Hint: Default value is 0.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumIod [out] Minimum intra-occular distance, in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMinimumIod(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> minimumIod,
  ) {
    return _id3FacePortraitProcessor_GetMinimumIod(
      hPortraitProcessor,
      minimumIod,
    );
  }

  late final _id3FacePortraitProcessor_GetMinimumIodPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Pointer<ffi.Int>)>>('id3FacePortraitProcessor_GetMinimumIod');
  late final _id3FacePortraitProcessor_GetMinimumIod =
      _id3FacePortraitProcessor_GetMinimumIodPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimum intra-occular distance, in pixels.
  /// This parameter is used to the limit the distance from the subject to the camera.
  /// Hint: Default value is 0.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumIod [in] Minimum intra-occular distance, in pixels.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMinimumIod(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int minimumIod,
  ) {
    return _id3FacePortraitProcessor_SetMinimumIod(
      hPortraitProcessor,
      minimumIod,
    );
  }

  late final _id3FacePortraitProcessor_SetMinimumIodPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMinimumIod');
  late final _id3FacePortraitProcessor_SetMinimumIod =
      _id3FacePortraitProcessor_SetMinimumIodPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 30.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumVerticalPosition [out] Minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMinimumVerticalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> minimumVerticalPosition,
  ) {
    return _id3FacePortraitProcessor_GetMinimumVerticalPosition(
      hPortraitProcessor,
      minimumVerticalPosition,
    );
  }

  late final _id3FacePortraitProcessor_GetMinimumVerticalPositionPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMinimumVerticalPosition');
  late final _id3FacePortraitProcessor_GetMinimumVerticalPosition =
      _id3FacePortraitProcessor_GetMinimumVerticalPositionPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 30.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param minimumVerticalPosition [in] Minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMinimumVerticalPosition(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int minimumVerticalPosition,
  ) {
    return _id3FacePortraitProcessor_SetMinimumVerticalPosition(
      hPortraitProcessor,
      minimumVerticalPosition,
    );
  }

  late final _id3FacePortraitProcessor_SetMinimumVerticalPositionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMinimumVerticalPosition');
  late final _id3FacePortraitProcessor_SetMinimumVerticalPosition =
      _id3FacePortraitProcessor_SetMinimumVerticalPositionPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the mouth occlusion threshold.
  /// If the mouth occlusion score is above this value, the mouth is probably occluded.
  /// Hint: Default value 70.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param mouthOcclusionThreshold [out] Mouth occlusion threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMouthOcclusionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> mouthOcclusionThreshold,
  ) {
    return _id3FacePortraitProcessor_GetMouthOcclusionThreshold(
      hPortraitProcessor,
      mouthOcclusionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetMouthOcclusionThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMouthOcclusionThreshold');
  late final _id3FacePortraitProcessor_GetMouthOcclusionThreshold =
      _id3FacePortraitProcessor_GetMouthOcclusionThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the mouth occlusion threshold.
  /// If the mouth occlusion score is above this value, the mouth is probably occluded.
  /// Hint: Default value 70.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param mouthOcclusionThreshold [in] Mouth occlusion threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMouthOcclusionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int mouthOcclusionThreshold,
  ) {
    return _id3FacePortraitProcessor_SetMouthOcclusionThreshold(
      hPortraitProcessor,
      mouthOcclusionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetMouthOcclusionThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMouthOcclusionThreshold');
  late final _id3FacePortraitProcessor_SetMouthOcclusionThreshold =
      _id3FacePortraitProcessor_SetMouthOcclusionThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the mouth opening threshold.
  /// If the mouth opening score is above this value, the mouth of detected face is definitely open.
  /// Hint: Default value is 35.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param mouthOpenThreshold [out] Mouth opening threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetMouthOpenThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> mouthOpenThreshold,
  ) {
    return _id3FacePortraitProcessor_GetMouthOpenThreshold(
      hPortraitProcessor,
      mouthOpenThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetMouthOpenThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetMouthOpenThreshold');
  late final _id3FacePortraitProcessor_GetMouthOpenThreshold =
      _id3FacePortraitProcessor_GetMouthOpenThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the mouth opening threshold.
  /// If the mouth opening score is above this value, the mouth of detected face is definitely open.
  /// Hint: Default value is 35.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param mouthOpenThreshold [in] Mouth opening threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetMouthOpenThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int mouthOpenThreshold,
  ) {
    return _id3FacePortraitProcessor_SetMouthOpenThreshold(
      hPortraitProcessor,
      mouthOpenThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetMouthOpenThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetMouthOpenThreshold');
  late final _id3FacePortraitProcessor_SetMouthOpenThreshold =
      _id3FacePortraitProcessor_SetMouthOpenThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the natural skin color threshold.
  /// Above this threshold, th skin of the person looks natural.
  /// Hint: Default value is 5.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param naturalSkinColorThreshold [out] Natural skin color threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetNaturalSkinColorThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> naturalSkinColorThreshold,
  ) {
    return _id3FacePortraitProcessor_GetNaturalSkinColorThreshold(
      hPortraitProcessor,
      naturalSkinColorThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetNaturalSkinColorThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
          'id3FacePortraitProcessor_GetNaturalSkinColorThreshold');
  late final _id3FacePortraitProcessor_GetNaturalSkinColorThreshold =
      _id3FacePortraitProcessor_GetNaturalSkinColorThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the natural skin color threshold.
  /// Above this threshold, th skin of the person looks natural.
  /// Hint: Default value is 5.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param naturalSkinColorThreshold [in] Natural skin color threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetNaturalSkinColorThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int naturalSkinColorThreshold,
  ) {
    return _id3FacePortraitProcessor_SetNaturalSkinColorThreshold(
      hPortraitProcessor,
      naturalSkinColorThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetNaturalSkinColorThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
          'id3FacePortraitProcessor_SetNaturalSkinColorThreshold');
  late final _id3FacePortraitProcessor_SetNaturalSkinColorThreshold =
      _id3FacePortraitProcessor_SetNaturalSkinColorThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the flash reflexion detection threshold.
  /// Above this threshold, the flash reflexion is probably present on the face.
  /// Hint: Default value is 70.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param noFlashReflectionThreshold [out] Flash reflexion detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetNoFlashReflectionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> noFlashReflectionThreshold,
  ) {
    return _id3FacePortraitProcessor_GetNoFlashReflectionThreshold(
      hPortraitProcessor,
      noFlashReflectionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetNoFlashReflectionThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
          'id3FacePortraitProcessor_GetNoFlashReflectionThreshold');
  late final _id3FacePortraitProcessor_GetNoFlashReflectionThreshold =
      _id3FacePortraitProcessor_GetNoFlashReflectionThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the flash reflexion detection threshold.
  /// Above this threshold, the flash reflexion is probably present on the face.
  /// Hint: Default value is 70.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param noFlashReflectionThreshold [in] Flash reflexion detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetNoFlashReflectionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int noFlashReflectionThreshold,
  ) {
    return _id3FacePortraitProcessor_SetNoFlashReflectionThreshold(
      hPortraitProcessor,
      noFlashReflectionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetNoFlashReflectionThresholdPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
          'id3FacePortraitProcessor_SetNoFlashReflectionThreshold');
  late final _id3FacePortraitProcessor_SetNoFlashReflectionThreshold =
      _id3FacePortraitProcessor_SetNoFlashReflectionThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the threshold for confirming the presence of noise in the image.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param noiseThreshold [out] Threshold for confirming the presence of noise in the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetNoiseThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> noiseThreshold,
  ) {
    return _id3FacePortraitProcessor_GetNoiseThreshold(
      hPortraitProcessor,
      noiseThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetNoiseThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetNoiseThreshold');
  late final _id3FacePortraitProcessor_GetNoiseThreshold =
      _id3FacePortraitProcessor_GetNoiseThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the threshold for confirming the presence of noise in the image.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param noiseThreshold [in] Threshold for confirming the presence of noise in the image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetNoiseThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int noiseThreshold,
  ) {
    return _id3FacePortraitProcessor_SetNoiseThreshold(
      hPortraitProcessor,
      noiseThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetNoiseThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetNoiseThreshold');
  late final _id3FacePortraitProcessor_SetNoiseThreshold =
      _id3FacePortraitProcessor_SetNoiseThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the nose occlusion threshold.
  /// If the score is above this value, the nose is probably occluded.
  /// Hint: Default value 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param noseOcclusionThreshold [out] Nose occlusion threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetNoseOcclusionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> noseOcclusionThreshold,
  ) {
    return _id3FacePortraitProcessor_GetNoseOcclusionThreshold(
      hPortraitProcessor,
      noseOcclusionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetNoseOcclusionThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetNoseOcclusionThreshold');
  late final _id3FacePortraitProcessor_GetNoseOcclusionThreshold =
      _id3FacePortraitProcessor_GetNoseOcclusionThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the nose occlusion threshold.
  /// If the score is above this value, the nose is probably occluded.
  /// Hint: Default value 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param noseOcclusionThreshold [in] Nose occlusion threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetNoseOcclusionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int noseOcclusionThreshold,
  ) {
    return _id3FacePortraitProcessor_SetNoseOcclusionThreshold(
      hPortraitProcessor,
      noseOcclusionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetNoseOcclusionThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetNoseOcclusionThreshold');
  late final _id3FacePortraitProcessor_SetNoseOcclusionThreshold =
      _id3FacePortraitProcessor_SetNoseOcclusionThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the over exposure threshold.
  /// Above this threshold, the ratio of face pixels are over-exposed.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param overExposureThreshold [out] Over exposure threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetOverExposureThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> overExposureThreshold,
  ) {
    return _id3FacePortraitProcessor_GetOverExposureThreshold(
      hPortraitProcessor,
      overExposureThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetOverExposureThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetOverExposureThreshold');
  late final _id3FacePortraitProcessor_GetOverExposureThreshold =
      _id3FacePortraitProcessor_GetOverExposureThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the over exposure threshold.
  /// Above this threshold, the ratio of face pixels are over-exposed.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param overExposureThreshold [in] Over exposure threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetOverExposureThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int overExposureThreshold,
  ) {
    return _id3FacePortraitProcessor_SetOverExposureThreshold(
      hPortraitProcessor,
      overExposureThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetOverExposureThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetOverExposureThreshold');
  late final _id3FacePortraitProcessor_SetOverExposureThreshold =
      _id3FacePortraitProcessor_SetOverExposureThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the presentation attack detection threshold, from 0 to 100.
  /// Higher values enable more attacks to be detected, but may reduce ease of use.
  /// Hint: Default value 95.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param padThreshold [out] Presentation attack detection threshold, from 0 to 100.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetPadThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> padThreshold,
  ) {
    return _id3FacePortraitProcessor_GetPadThreshold(
      hPortraitProcessor,
      padThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetPadThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetPadThreshold');
  late final _id3FacePortraitProcessor_GetPadThreshold =
      _id3FacePortraitProcessor_GetPadThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the presentation attack detection threshold, from 0 to 100.
  /// Higher values enable more attacks to be detected, but may reduce ease of use.
  /// Hint: Default value 95.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param padThreshold [in] Presentation attack detection threshold, from 0 to 100.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetPadThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int padThreshold,
  ) {
    return _id3FacePortraitProcessor_SetPadThreshold(
      hPortraitProcessor,
      padThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetPadThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetPadThreshold');
  late final _id3FacePortraitProcessor_SetPadThreshold =
      _id3FacePortraitProcessor_SetPadThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the pixelation detection threshold.
  /// Above this threshold, the image is probably pixelated.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param pixelationThreshold [out] Pixelation detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetPixelationThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> pixelationThreshold,
  ) {
    return _id3FacePortraitProcessor_GetPixelationThreshold(
      hPortraitProcessor,
      pixelationThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetPixelationThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetPixelationThreshold');
  late final _id3FacePortraitProcessor_GetPixelationThreshold =
      _id3FacePortraitProcessor_GetPixelationThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the pixelation detection threshold.
  /// Above this threshold, the image is probably pixelated.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param pixelationThreshold [in] Pixelation detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetPixelationThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int pixelationThreshold,
  ) {
    return _id3FacePortraitProcessor_SetPixelationThreshold(
      hPortraitProcessor,
      pixelationThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetPixelationThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetPixelationThreshold');
  late final _id3FacePortraitProcessor_SetPixelationThreshold =
      _id3FacePortraitProcessor_SetPixelationThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the threshold for confirming the presence of red eyes.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param redEyeThreshold [out] Threshold for confirming the presence of red eyes.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetRedEyeThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> redEyeThreshold,
  ) {
    return _id3FacePortraitProcessor_GetRedEyeThreshold(
      hPortraitProcessor,
      redEyeThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetRedEyeThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetRedEyeThreshold');
  late final _id3FacePortraitProcessor_GetRedEyeThreshold =
      _id3FacePortraitProcessor_GetRedEyeThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the threshold for confirming the presence of red eyes.
  /// Hint: Default value is 10.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param redEyeThreshold [in] Threshold for confirming the presence of red eyes.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetRedEyeThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int redEyeThreshold,
  ) {
    return _id3FacePortraitProcessor_SetRedEyeThreshold(
      hPortraitProcessor,
      redEyeThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetRedEyeThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetRedEyeThreshold');
  late final _id3FacePortraitProcessor_SetRedEyeThreshold =
      _id3FacePortraitProcessor_SetRedEyeThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the threshold indicating whether the image resolution is sufficient.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param resolutionThreshold [out] Threshold indicating whether the image resolution is sufficient.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetResolutionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> resolutionThreshold,
  ) {
    return _id3FacePortraitProcessor_GetResolutionThreshold(
      hPortraitProcessor,
      resolutionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetResolutionThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetResolutionThreshold');
  late final _id3FacePortraitProcessor_GetResolutionThreshold =
      _id3FacePortraitProcessor_GetResolutionThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the threshold indicating whether the image resolution is sufficient.
  /// Hint: Default value is 90.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param resolutionThreshold [in] Threshold indicating whether the image resolution is sufficient.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetResolutionThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int resolutionThreshold,
  ) {
    return _id3FacePortraitProcessor_SetResolutionThreshold(
      hPortraitProcessor,
      resolutionThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetResolutionThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetResolutionThreshold');
  late final _id3FacePortraitProcessor_SetResolutionThreshold =
      _id3FacePortraitProcessor_SetResolutionThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the sharpness threshold.
  /// If the sharpness score is above this value, the image sharpness is sufficient.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param sharpnessThreshold [out] Sharpness threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetSharpnessThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> sharpnessThreshold,
  ) {
    return _id3FacePortraitProcessor_GetSharpnessThreshold(
      hPortraitProcessor,
      sharpnessThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetSharpnessThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetSharpnessThreshold');
  late final _id3FacePortraitProcessor_GetSharpnessThreshold =
      _id3FacePortraitProcessor_GetSharpnessThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the sharpness threshold.
  /// If the sharpness score is above this value, the image sharpness is sufficient.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param sharpnessThreshold [in] Sharpness threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetSharpnessThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int sharpnessThreshold,
  ) {
    return _id3FacePortraitProcessor_SetSharpnessThreshold(
      hPortraitProcessor,
      sharpnessThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetSharpnessThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetSharpnessThreshold');
  late final _id3FacePortraitProcessor_SetSharpnessThreshold =
      _id3FacePortraitProcessor_SetSharpnessThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the smile threshold.
  /// If the Smile score is above this value, the detected face is definitely smiling.
  /// Hint: Default value is 75.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param smileThreshold [out] Smile threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetSmileThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> smileThreshold,
  ) {
    return _id3FacePortraitProcessor_GetSmileThreshold(
      hPortraitProcessor,
      smileThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetSmileThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetSmileThreshold');
  late final _id3FacePortraitProcessor_GetSmileThreshold =
      _id3FacePortraitProcessor_GetSmileThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the smile threshold.
  /// If the Smile score is above this value, the detected face is definitely smiling.
  /// Hint: Default value is 75.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param smileThreshold [in] Smile threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetSmileThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int smileThreshold,
  ) {
    return _id3FacePortraitProcessor_SetSmileThreshold(
      hPortraitProcessor,
      smileThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetSmileThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetSmileThreshold');
  late final _id3FacePortraitProcessor_SetSmileThreshold =
      _id3FacePortraitProcessor_SetSmileThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the number of threads to be used for portrait processing.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param threadCount [out] Number of threads to be used for portrait processing.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetThreadCount(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3FacePortraitProcessor_GetThreadCount(
      hPortraitProcessor,
      threadCount,
    );
  }

  late final _id3FacePortraitProcessor_GetThreadCountPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetThreadCount');
  late final _id3FacePortraitProcessor_GetThreadCount =
      _id3FacePortraitProcessor_GetThreadCountPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to be used for portrait processing.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param threadCount [in] Number of threads to be used for portrait processing.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetThreadCount(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int threadCount,
  ) {
    return _id3FacePortraitProcessor_SetThreadCount(
      hPortraitProcessor,
      threadCount,
    );
  }

  late final _id3FacePortraitProcessor_SetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetThreadCount');
  late final _id3FacePortraitProcessor_SetThreadCount =
      _id3FacePortraitProcessor_SetThreadCountPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the tinted glass detection threshold.
  /// If the score is above this value, the person is definitely wearing tinted glasses.
  /// Hint: Default value 25.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param tintedGlassThreshold [out] Tinted glass detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetTintedGlassThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> tintedGlassThreshold,
  ) {
    return _id3FacePortraitProcessor_GetTintedGlassThreshold(
      hPortraitProcessor,
      tintedGlassThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetTintedGlassThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetTintedGlassThreshold');
  late final _id3FacePortraitProcessor_GetTintedGlassThreshold =
      _id3FacePortraitProcessor_GetTintedGlassThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the tinted glass detection threshold.
  /// If the score is above this value, the person is definitely wearing tinted glasses.
  /// Hint: Default value 25.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param tintedGlassThreshold [in] Tinted glass detection threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetTintedGlassThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int tintedGlassThreshold,
  ) {
    return _id3FacePortraitProcessor_SetTintedGlassThreshold(
      hPortraitProcessor,
      tintedGlassThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetTintedGlassThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetTintedGlassThreshold');
  late final _id3FacePortraitProcessor_SetTintedGlassThreshold =
      _id3FacePortraitProcessor_SetTintedGlassThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// Hint: Default value is 3000 which corresponds to a False Match Rate of 1/1000.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerMatchingThreshold [out] Minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetTrackerMatchingThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> trackerMatchingThreshold,
  ) {
    return _id3FacePortraitProcessor_GetTrackerMatchingThreshold(
      hPortraitProcessor,
      trackerMatchingThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetTrackerMatchingThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetTrackerMatchingThreshold');
  late final _id3FacePortraitProcessor_GetTrackerMatchingThreshold =
      _id3FacePortraitProcessor_GetTrackerMatchingThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// Hint: Default value is 3000 which corresponds to a False Match Rate of 1/1000.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerMatchingThreshold [in] Minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetTrackerMatchingThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int trackerMatchingThreshold,
  ) {
    return _id3FacePortraitProcessor_SetTrackerMatchingThreshold(
      hPortraitProcessor,
      trackerMatchingThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetTrackerMatchingThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Int)>>(
      'id3FacePortraitProcessor_SetTrackerMatchingThreshold');
  late final _id3FacePortraitProcessor_SetTrackerMatchingThreshold =
      _id3FacePortraitProcessor_SetTrackerMatchingThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// Hint: Default value is 2. One must adapt this value to its needs in terms of tracker identity memory (in seconds) and measured frame rate on target platform.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerMaximumFaceAge [out] Maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetTrackerMaximumFaceAge(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> trackerMaximumFaceAge,
  ) {
    return _id3FacePortraitProcessor_GetTrackerMaximumFaceAge(
      hPortraitProcessor,
      trackerMaximumFaceAge,
    );
  }

  late final _id3FacePortraitProcessor_GetTrackerMaximumFaceAgePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetTrackerMaximumFaceAge');
  late final _id3FacePortraitProcessor_GetTrackerMaximumFaceAge =
      _id3FacePortraitProcessor_GetTrackerMaximumFaceAgePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// Hint: Default value is 2. One must adapt this value to its needs in terms of tracker identity memory (in seconds) and measured frame rate on target platform.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerMaximumFaceAge [in] Maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetTrackerMaximumFaceAge(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int trackerMaximumFaceAge,
  ) {
    return _id3FacePortraitProcessor_SetTrackerMaximumFaceAge(
      hPortraitProcessor,
      trackerMaximumFaceAge,
    );
  }

  late final _id3FacePortraitProcessor_SetTrackerMaximumFaceAgePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetTrackerMaximumFaceAge');
  late final _id3FacePortraitProcessor_SetTrackerMaximumFaceAge =
      _id3FacePortraitProcessor_SetTrackerMaximumFaceAgePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the minimum number of consecutive detections to reach before creating a tracked face.
  /// Hint: Default value is 1 for ``FaceDetector4B`` since the false detection rate is low enough. If using a less accurate detector (such as FaceDetector3C) one might consider increasing a bit this value to avoid false tracks.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerMinimumFaceAge [out] Minimum number of consecutive detections to reach before creating a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetTrackerMinimumFaceAge(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> trackerMinimumFaceAge,
  ) {
    return _id3FacePortraitProcessor_GetTrackerMinimumFaceAge(
      hPortraitProcessor,
      trackerMinimumFaceAge,
    );
  }

  late final _id3FacePortraitProcessor_GetTrackerMinimumFaceAgePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetTrackerMinimumFaceAge');
  late final _id3FacePortraitProcessor_GetTrackerMinimumFaceAge =
      _id3FacePortraitProcessor_GetTrackerMinimumFaceAgePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimum number of consecutive detections to reach before creating a tracked face.
  /// Hint: Default value is 1 for ``FaceDetector4B`` since the false detection rate is low enough. If using a less accurate detector (such as FaceDetector3C) one might consider increasing a bit this value to avoid false tracks.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerMinimumFaceAge [in] Minimum number of consecutive detections to reach before creating a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetTrackerMinimumFaceAge(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int trackerMinimumFaceAge,
  ) {
    return _id3FacePortraitProcessor_SetTrackerMinimumFaceAge(
      hPortraitProcessor,
      trackerMinimumFaceAge,
    );
  }

  late final _id3FacePortraitProcessor_SetTrackerMinimumFaceAgePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetTrackerMinimumFaceAge');
  late final _id3FacePortraitProcessor_SetTrackerMinimumFaceAge =
      _id3FacePortraitProcessor_SetTrackerMinimumFaceAgePtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range [0;100].
  /// Hint: Default value is 0. Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerNmsIouThreshold [out] Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetTrackerNmsIouThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> trackerNmsIouThreshold,
  ) {
    return _id3FacePortraitProcessor_GetTrackerNmsIouThreshold(
      hPortraitProcessor,
      trackerNmsIouThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetTrackerNmsIouThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetTrackerNmsIouThreshold');
  late final _id3FacePortraitProcessor_GetTrackerNmsIouThreshold =
      _id3FacePortraitProcessor_GetTrackerNmsIouThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range [0;100].
  /// Hint: Default value is 0. Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param trackerNmsIouThreshold [in] Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetTrackerNmsIouThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int trackerNmsIouThreshold,
  ) {
    return _id3FacePortraitProcessor_SetTrackerNmsIouThreshold(
      hPortraitProcessor,
      trackerNmsIouThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetTrackerNmsIouThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetTrackerNmsIouThreshold');
  late final _id3FacePortraitProcessor_SetTrackerNmsIouThreshold =
      _id3FacePortraitProcessor_SetTrackerNmsIouThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Gets the under exposure threshold.
  /// Above this threshold, the face is probably under-exposed.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param underExposureThreshold [out] Under exposure threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_GetUnderExposureThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ffi.Pointer<ffi.Int> underExposureThreshold,
  ) {
    return _id3FacePortraitProcessor_GetUnderExposureThreshold(
      hPortraitProcessor,
      underExposureThreshold,
    );
  }

  late final _id3FacePortraitProcessor_GetUnderExposureThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>>(
      'id3FacePortraitProcessor_GetUnderExposureThreshold');
  late final _id3FacePortraitProcessor_GetUnderExposureThreshold =
      _id3FacePortraitProcessor_GetUnderExposureThresholdPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the under exposure threshold.
  /// Above this threshold, the face is probably under-exposed.
  /// Hint: Default value is 50.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param underExposureThreshold [in] Under exposure threshold.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_SetUnderExposureThreshold(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    int underExposureThreshold,
  ) {
    return _id3FacePortraitProcessor_SetUnderExposureThreshold(
      hPortraitProcessor,
      underExposureThreshold,
    );
  }

  late final _id3FacePortraitProcessor_SetUnderExposureThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ffi.Int)>>('id3FacePortraitProcessor_SetUnderExposureThreshold');
  late final _id3FacePortraitProcessor_SetUnderExposureThreshold =
      _id3FacePortraitProcessor_SetUnderExposureThresholdPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR, int)>();

  /// Analyses an image and creates a portrait with the first detected face or the currently tracked face if the update parameter is activated.
  /// This method performs the following tasks:
  /// - Face detection
  /// - Landmark detection (68 points)
  /// - Head pose estimation
  /// - Verification of subject position
  /// - Geometric attributes computation
  /// - Unified quality score computation
  /// Important: This method requires the ``FaceDetector``, ``FaceLandmarksEstimator`` and ``FacePoseEstimator`` models to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hImage [in] Source image.
  /// @param hPortrait [out] The newly created portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_CreatePortrait(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_IMAGE hImage,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_CreatePortrait(
      hPortraitProcessor,
      hImage,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_CreatePortraitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_IMAGE,
              ID3_FACE_PORTRAIT)>>('id3FacePortraitProcessor_CreatePortrait');
  late final _id3FacePortraitProcessor_CreatePortrait =
      _id3FacePortraitProcessor_CreatePortraitPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_IMAGE,
              ID3_FACE_PORTRAIT)>();

  /// Creates an ICAO-compliant portrait image by cropping the source image around the detected face.
  /// This method uses the following parameters:
  /// - Portrait aspect ratio
  /// - Portrait eye position ratio
  /// - Portrait IOD ratio
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] Source portrait.
  /// @param hImage [out] The output cropped image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_CropIcaoPortrait(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
    ID3_FACE_IMAGE hImage,
  ) {
    return _id3FacePortraitProcessor_CropIcaoPortrait(
      hPortraitProcessor,
      hPortrait,
      hImage,
    );
  }

  late final _id3FacePortraitProcessor_CropIcaoPortraitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT,
              ID3_FACE_IMAGE)>>('id3FacePortraitProcessor_CropIcaoPortrait');
  late final _id3FacePortraitProcessor_CropIcaoPortrait =
      _id3FacePortraitProcessor_CropIcaoPortraitPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT,
              ID3_FACE_IMAGE)>();

  /// Creates a portrait image by cropping the source image around the detected face.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait to extract the face from.
  /// @param hImage [out] The output cropped image of the face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_CropPortrait(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
    ID3_FACE_IMAGE hImage,
  ) {
    return _id3FacePortraitProcessor_CropPortrait(
      hPortraitProcessor,
      hPortrait,
      hImage,
    );
  }

  late final _id3FacePortraitProcessor_CropPortraitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT,
              ID3_FACE_IMAGE)>>('id3FacePortraitProcessor_CropPortrait');
  late final _id3FacePortraitProcessor_CropPortrait =
      _id3FacePortraitProcessor_CropPortraitPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT,
              ID3_FACE_IMAGE)>();

  /// Detects occlusions on the subject's face.
  /// Important: This function requires the ``FaceOcclusionDetector2A`` model to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_DetectOcclusions(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_DetectOcclusions(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_DetectOcclusionsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ID3_FACE_PORTRAIT)>>('id3FacePortraitProcessor_DetectOcclusions');
  late final _id3FacePortraitProcessor_DetectOcclusions =
      _id3FacePortraitProcessor_DetectOcclusionsPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Detects a possible presentation attack.
  /// Important: This method requires the ``FaceColorBasedPad`` models to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_DetectPresentationAttack(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_DetectPresentationAttack(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_DetectPresentationAttackPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>>(
      'id3FacePortraitProcessor_DetectPresentationAttack');
  late final _id3FacePortraitProcessor_DetectPresentationAttack =
      _id3FacePortraitProcessor_DetectPresentationAttackPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Estimates the age of the person.
  /// Important: This method requires the ``FaceAgeEstimator1A`` model to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_EstimateAge(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_EstimateAge(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_EstimateAgePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR,
              ID3_FACE_PORTRAIT)>>('id3FacePortraitProcessor_EstimateAge');
  late final _id3FacePortraitProcessor_EstimateAge =
      _id3FacePortraitProcessor_EstimateAgePtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Checks the background uniformity of the specified portrait.
  /// Important: This method requires the ``FaceBackgroundUniformityEstimator1A`` model to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_EstimateBackgroundUniformity(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_EstimateBackgroundUniformity(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_EstimateBackgroundUniformityPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>>(
          'id3FacePortraitProcessor_EstimateBackgroundUniformity');
  late final _id3FacePortraitProcessor_EstimateBackgroundUniformity =
      _id3FacePortraitProcessor_EstimateBackgroundUniformityPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Estimates the subject's expression on the specified portrait.
  /// Important: This method requires the ``FaceExpressionClassifier1A`` model to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_EstimateExpression(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_EstimateExpression(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_EstimateExpressionPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>>(
      'id3FacePortraitProcessor_EstimateExpression');
  late final _id3FacePortraitProcessor_EstimateExpression =
      _id3FacePortraitProcessor_EstimateExpressionPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Estimates the face attributes of the specified portrait.
  /// It includes glasses, hat, makeup, mouth opening, gender, smile, eye gaze, eye opening, face mask
  /// Note: The appropriate AI models must be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_EstimateFaceAttributes(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_EstimateFaceAttributes(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_EstimateFaceAttributesPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>>(
      'id3FacePortraitProcessor_EstimateFaceAttributes');
  late final _id3FacePortraitProcessor_EstimateFaceAttributes =
      _id3FacePortraitProcessor_EstimateFaceAttributesPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Estimates the geometric quality of the specified portrait according to the ICAO portrait parameters.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_EstimateGeometryQuality(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_EstimateGeometryQuality(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_EstimateGeometryQualityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>>(
      'id3FacePortraitProcessor_EstimateGeometryQuality');
  late final _id3FacePortraitProcessor_EstimateGeometryQuality =
      _id3FacePortraitProcessor_EstimateGeometryQualityPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Etimates the photographic quality of the specified portrait.
  /// It includes image colorization, equal brightness, dynamic range, resolution, natural skin color, flash reflection, noise, over-exposure, under-exposure, pixelation, sharpness.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_EstimatePhotographicQuality(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
  ) {
    return _id3FacePortraitProcessor_EstimatePhotographicQuality(
      hPortraitProcessor,
      hPortrait,
    );
  }

  late final _id3FacePortraitProcessor_EstimatePhotographicQualityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>>(
      'id3FacePortraitProcessor_EstimatePhotographicQuality');
  late final _id3FacePortraitProcessor_EstimatePhotographicQuality =
      _id3FacePortraitProcessor_EstimatePhotographicQualityPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT)>();

  /// Removes the background on the specified portrait image.
  /// Important: This method requires the ``FaceBackgroundSegmenter1A`` model to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hImage [in] The portrait image.
  /// @param red [in] Green channel of the background color. Must be a value from 0 to 255.
  /// @param green [in] Red channel of the background color. Must be a value from 0 to 255.
  /// @param blue [in] Blue channel of the background color. Must be a value from 0 to 255.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_RemoveBackground(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_IMAGE hImage,
    int red,
    int green,
    int blue,
  ) {
    return _id3FacePortraitProcessor_RemoveBackground(
      hPortraitProcessor,
      hImage,
      red,
      green,
      blue,
    );
  }

  late final _id3FacePortraitProcessor_RemoveBackgroundPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_IMAGE, ffi.Int,
              ffi.Int, ffi.Int)>>('id3FacePortraitProcessor_RemoveBackground');
  late final _id3FacePortraitProcessor_RemoveBackground =
      _id3FacePortraitProcessor_RemoveBackgroundPtr.asFunction<
          int Function(
              ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_IMAGE, int, int, int)>();

  /// Resets the face tracker.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_Reset(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
  ) {
    return _id3FacePortraitProcessor_Reset(
      hPortraitProcessor,
    );
  }

  late final _id3FacePortraitProcessor_ResetPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR)>>(
      'id3FacePortraitProcessor_Reset');
  late final _id3FacePortraitProcessor_Reset =
      _id3FacePortraitProcessor_ResetPtr
          .asFunction<int Function(ID3_FACE_PORTRAIT_PROCESSOR)>();

  /// Analyses an image and updates the specified portrait with the first detected face or the currently tracked face.
  /// This method performs the following tasks:
  /// - Face detection and tracking with prediction models
  /// - Landmark detection (68 points)
  /// - Head pose estimation
  /// - Verification of subject position
  /// - Template encoding and updating
  /// - Geometric attributes computation
  /// - Unified quality score computation
  /// Important: This method requires the ``FaceDetector``, ``FaceEncoder``, ``FaceLandmarksEstimator`` and ``FacePoseEstimator`` models to be loaded.
  /// @param hPortraitProcessor [in] Handle to the PortraitProcessor object.
  /// @param hPortrait [in] The portrait to be updated.
  /// @param hImage [in] The source image.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FacePortraitProcessor_UpdatePortrait(
    ID3_FACE_PORTRAIT_PROCESSOR hPortraitProcessor,
    ID3_FACE_PORTRAIT hPortrait,
    ID3_FACE_IMAGE hImage,
  ) {
    return _id3FacePortraitProcessor_UpdatePortrait(
      hPortraitProcessor,
      hPortrait,
      hImage,
    );
  }

  late final _id3FacePortraitProcessor_UpdatePortraitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT,
              ID3_FACE_IMAGE)>>('id3FacePortraitProcessor_UpdatePortrait');
  late final _id3FacePortraitProcessor_UpdatePortrait =
      _id3FacePortraitProcessor_UpdatePortraitPtr.asFunction<
          int Function(ID3_FACE_PORTRAIT_PROCESSOR, ID3_FACE_PORTRAIT,
              ID3_FACE_IMAGE)>();

  ffi.Pointer<ffi.Char> id3Face_GetFaceSegmentationLabelString(
    int value,
  ) {
    return _id3Face_GetFaceSegmentationLabelString(
      value,
    );
  }

  late final _id3Face_GetFaceSegmentationLabelStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Face_GetFaceSegmentationLabelString');
  late final _id3Face_GetFaceSegmentationLabelString =
      _id3Face_GetFaceSegmentationLabelStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a TrackedFaceList object.
  /// @param phTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_Initialize(
    ffi.Pointer<ID3_TRACKED_FACE_LIST> phTrackedFaceList,
  ) {
    return _id3TrackedFaceList_Initialize(
      phTrackedFaceList,
    );
  }

  late final _id3TrackedFaceList_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_TRACKED_FACE_LIST>)>>(
      'id3TrackedFaceList_Initialize');
  late final _id3TrackedFaceList_Initialize = _id3TrackedFaceList_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_TRACKED_FACE_LIST>)>();

  /// @brief Releases the memory allocated for a TrackedFaceList.
  /// @param phTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_Dispose(
    ffi.Pointer<ID3_TRACKED_FACE_LIST> phTrackedFaceList,
  ) {
    return _id3TrackedFaceList_Dispose(
      phTrackedFaceList,
    );
  }

  late final _id3TrackedFaceList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_TRACKED_FACE_LIST>)>>(
      'id3TrackedFaceList_Dispose');
  late final _id3TrackedFaceList_Dispose = _id3TrackedFaceList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_TRACKED_FACE_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_CheckHandle(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
  ) {
    return _id3TrackedFaceList_CheckHandle(
      hTrackedFaceList,
    );
  }

  late final _id3TrackedFaceList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_TRACKED_FACE_LIST)>>(
          'id3TrackedFaceList_CheckHandle');
  late final _id3TrackedFaceList_CheckHandle =
      _id3TrackedFaceList_CheckHandlePtr
          .asFunction<int Function(ID3_TRACKED_FACE_LIST)>();

  /// @brief Copies an instance of TrackedFaceList object to another.
  /// @param hTrackedFaceListSrc [in] Handle to the source TrackedFaceList object.
  /// @param hTrackedFaceListDst [in] Handle to the destination TrackedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_CopyTo(
    ID3_TRACKED_FACE_LIST hTrackedFaceListSrc,
    ID3_TRACKED_FACE_LIST hTrackedFaceListDst,
  ) {
    return _id3TrackedFaceList_CopyTo(
      hTrackedFaceListSrc,
      hTrackedFaceListDst,
    );
  }

  late final _id3TrackedFaceList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST,
              ID3_TRACKED_FACE_LIST)>>('id3TrackedFaceList_CopyTo');
  late final _id3TrackedFaceList_CopyTo = _id3TrackedFaceList_CopyToPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, ID3_TRACKED_FACE_LIST)>();

  /// Clears the TrackedFaceList object.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_Clear(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
  ) {
    return _id3TrackedFaceList_Clear(
      hTrackedFaceList,
    );
  }

  late final _id3TrackedFaceList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_TRACKED_FACE_LIST)>>(
          'id3TrackedFaceList_Clear');
  late final _id3TrackedFaceList_Clear = _id3TrackedFaceList_ClearPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST)>();

  /// Adds an item to the TrackedFaceList object.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param hTrackedFaceItem [in] TrackedFace item to add.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_Add(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    ID3_TRACKED_FACE hTrackedFaceItem,
  ) {
    return _id3TrackedFaceList_Add(
      hTrackedFaceList,
      hTrackedFaceItem,
    );
  }

  late final _id3TrackedFaceList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST,
              ID3_TRACKED_FACE)>>('id3TrackedFaceList_Add');
  late final _id3TrackedFaceList_Add = _id3TrackedFaceList_AddPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, ID3_TRACKED_FACE)>();

  /// Gets an item of the TrackedFaceList object.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param index [in] Index of the TrackedFace item to get.
  /// @param hTrackedFaceItem [out] TrackedFace item to get.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_Get(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    int index,
    ID3_TRACKED_FACE hTrackedFaceItem,
  ) {
    return _id3TrackedFaceList_Get(
      hTrackedFaceList,
      index,
      hTrackedFaceItem,
    );
  }

  late final _id3TrackedFaceList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST, ffi.Int,
              ID3_TRACKED_FACE)>>('id3TrackedFaceList_Get');
  late final _id3TrackedFaceList_Get = _id3TrackedFaceList_GetPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, int, ID3_TRACKED_FACE)>();

  /// Sets an item of the TrackedFaceList object.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param index [in] Index of the TrackedFace item to set.
  /// @param hTrackedFaceItem [in] TrackedFace item to set.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_Set(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    int index,
    ID3_TRACKED_FACE hTrackedFaceItem,
  ) {
    return _id3TrackedFaceList_Set(
      hTrackedFaceList,
      index,
      hTrackedFaceItem,
    );
  }

  late final _id3TrackedFaceList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST, ffi.Int,
              ID3_TRACKED_FACE)>>('id3TrackedFaceList_Set');
  late final _id3TrackedFaceList_Set = _id3TrackedFaceList_SetPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, int, ID3_TRACKED_FACE)>();

  /// Gets the number of elements in the TrackedFaceList object.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param count [out] Number of elements in the TrackedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_GetCount(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3TrackedFaceList_GetCount(
      hTrackedFaceList,
      count,
    );
  }

  late final _id3TrackedFaceList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST,
              ffi.Pointer<ffi.Int>)>>('id3TrackedFaceList_GetCount');
  late final _id3TrackedFaceList_GetCount = _id3TrackedFaceList_GetCountPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the TrackedFaceList object.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param index [in] Index of the TrackedFace item to remove.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_RemoveAt(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    int index,
  ) {
    return _id3TrackedFaceList_RemoveAt(
      hTrackedFaceList,
      index,
    );
  }

  late final _id3TrackedFaceList_RemoveAtPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_TRACKED_FACE_LIST, ffi.Int)>>(
      'id3TrackedFaceList_RemoveAt');
  late final _id3TrackedFaceList_RemoveAt = _id3TrackedFaceList_RemoveAtPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, int)>();

  /// TrackedFaceList object.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param newSize [in] TrackedFace object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_Resize(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    int newSize,
  ) {
    return _id3TrackedFaceList_Resize(
      hTrackedFaceList,
      newSize,
    );
  }

  late final _id3TrackedFaceList_ResizePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_TRACKED_FACE_LIST, ffi.Int)>>(
      'id3TrackedFaceList_Resize');
  late final _id3TrackedFaceList_Resize = _id3TrackedFaceList_ResizePtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, int)>();

  /// Finds a tracked face by ID.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param id [in] ID of the tracked face to find in the list.
  /// @param hTrackedFace [out] The found tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_FindTrackedFace(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    int id,
    ID3_TRACKED_FACE hTrackedFace,
  ) {
    return _id3TrackedFaceList_FindTrackedFace(
      hTrackedFaceList,
      id,
      hTrackedFace,
    );
  }

  late final _id3TrackedFaceList_FindTrackedFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST, ffi.Int,
              ID3_TRACKED_FACE)>>('id3TrackedFaceList_FindTrackedFace');
  late final _id3TrackedFaceList_FindTrackedFace =
      _id3TrackedFaceList_FindTrackedFacePtr.asFunction<
          int Function(ID3_TRACKED_FACE_LIST, int, ID3_TRACKED_FACE)>();

  /// Gets the list of IDs in the list.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param ids [out] The list of IDs in the list.
  /// @param idsSize [in,out] Size of the 'ids' buffer. Receives the number of elements in the 'ids' array.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_GetIdList(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    ffi.Pointer<ffi.Int> ids,
    ffi.Pointer<ffi.Int> idsSize,
  ) {
    return _id3TrackedFaceList_GetIdList(
      hTrackedFaceList,
      ids,
      idsSize,
    );
  }

  late final _id3TrackedFaceList_GetIdListPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>>('id3TrackedFaceList_GetIdList');
  late final _id3TrackedFaceList_GetIdList =
      _id3TrackedFaceList_GetIdListPtr.asFunction<
          int Function(ID3_TRACKED_FACE_LIST, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the largest face in the list.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param hLargestFace [out] The largest tracked face in the list.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_GetLargestFace(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    ID3_TRACKED_FACE hLargestFace,
  ) {
    return _id3TrackedFaceList_GetLargestFace(
      hTrackedFaceList,
      hLargestFace,
    );
  }

  late final _id3TrackedFaceList_GetLargestFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_TRACKED_FACE_LIST,
              ID3_TRACKED_FACE)>>('id3TrackedFaceList_GetLargestFace');
  late final _id3TrackedFaceList_GetLargestFace =
      _id3TrackedFaceList_GetLargestFacePtr
          .asFunction<int Function(ID3_TRACKED_FACE_LIST, ID3_TRACKED_FACE)>();

  /// Rescales all tracked faces in the list.
  /// @param hTrackedFaceList [in] Handle to the TrackedFaceList object.
  /// @param scale [in] Scale factor to apply. Range is [0;+inf[.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3TrackedFaceList_RescaleAll(
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
    double scale,
  ) {
    return _id3TrackedFaceList_RescaleAll(
      hTrackedFaceList,
      scale,
    );
  }

  late final _id3TrackedFaceList_RescaleAllPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_TRACKED_FACE_LIST, ffi.Float)>>(
      'id3TrackedFaceList_RescaleAll');
  late final _id3TrackedFaceList_RescaleAll = _id3TrackedFaceList_RescaleAllPtr
      .asFunction<int Function(ID3_TRACKED_FACE_LIST, double)>();

  /// @brief Initializes a FaceTracker object.
  /// @param phFaceTracker [in] Handle to the FaceTracker object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_Initialize(
    ffi.Pointer<ID3_FACE_TRACKER> phFaceTracker,
  ) {
    return _id3FaceTracker_Initialize(
      phFaceTracker,
    );
  }

  late final _id3FaceTracker_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_TRACKER>)>>(
      'id3FaceTracker_Initialize');
  late final _id3FaceTracker_Initialize = _id3FaceTracker_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_TRACKER>)>();

  /// @brief Releases the memory allocated for a FaceTracker.
  /// @param phFaceTracker [in] Handle to the FaceTracker object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_Dispose(
    ffi.Pointer<ID3_FACE_TRACKER> phFaceTracker,
  ) {
    return _id3FaceTracker_Dispose(
      phFaceTracker,
    );
  }

  late final _id3FaceTracker_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_TRACKER>)>>(
      'id3FaceTracker_Dispose');
  late final _id3FaceTracker_Dispose = _id3FaceTracker_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_FACE_TRACKER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_CheckHandle(
    ID3_FACE_TRACKER hFaceTracker,
  ) {
    return _id3FaceTracker_CheckHandle(
      hFaceTracker,
    );
  }

  late final _id3FaceTracker_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER)>>(
          'id3FaceTracker_CheckHandle');
  late final _id3FaceTracker_CheckHandle = _id3FaceTracker_CheckHandlePtr
      .asFunction<int Function(ID3_FACE_TRACKER)>();

  /// Gets the confidence threshold, in the range [0;100].
  /// Hint: Default value is 50.
  /// Note: Setting a high threshold reduces false detection but can increase the number of undetected faces.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param confidenceThreshold [out] Confidence threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetConfidenceThreshold(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int> confidenceThreshold,
  ) {
    return _id3FaceTracker_GetConfidenceThreshold(
      hFaceTracker,
      confidenceThreshold,
    );
  }

  late final _id3FaceTracker_GetConfidenceThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER,
              ffi.Pointer<ffi.Int>)>>('id3FaceTracker_GetConfidenceThreshold');
  late final _id3FaceTracker_GetConfidenceThreshold =
      _id3FaceTracker_GetConfidenceThresholdPtr
          .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>();

  /// Sets the confidence threshold, in the range [0;100].
  /// Hint: Default value is 50.
  /// Note: Setting a high threshold reduces false detection but can increase the number of undetected faces.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param confidenceThreshold [in] Confidence threshold, in the range [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetConfidenceThreshold(
    ID3_FACE_TRACKER hFaceTracker,
    int confidenceThreshold,
  ) {
    return _id3FaceTracker_SetConfidenceThreshold(
      hFaceTracker,
      confidenceThreshold,
    );
  }

  late final _id3FaceTracker_SetConfidenceThresholdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int)>>(
          'id3FaceTracker_SetConfidenceThreshold');
  late final _id3FaceTracker_SetConfidenceThreshold =
      _id3FaceTracker_SetConfidenceThresholdPtr
          .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Gets the model used to detect and track faces.
  /// Hint: Default value is FaceDetector4B.
  /// Note: Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param eDetectionModel [out] Model used to detect and track faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetDetectionModel(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int32> eDetectionModel,
  ) {
    return _id3FaceTracker_GetDetectionModel(
      hFaceTracker,
      eDetectionModel,
    );
  }

  late final _id3FaceTracker_GetDetectionModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER,
              ffi.Pointer<ffi.Int32>)>>('id3FaceTracker_GetDetectionModel');
  late final _id3FaceTracker_GetDetectionModel =
      _id3FaceTracker_GetDetectionModelPtr
          .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int32>)>();

  /// Sets the model used to detect and track faces.
  /// Hint: Default value is FaceDetector4B.
  /// Note: Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param eDetectionModel [in] Model used to detect and track faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetDetectionModel(
    ID3_FACE_TRACKER hFaceTracker,
    int eDetectionModel,
  ) {
    return _id3FaceTracker_SetDetectionModel(
      hFaceTracker,
      eDetectionModel,
    );
  }

  late final _id3FaceTracker_SetDetectionModelPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int32)>>(
      'id3FaceTracker_SetDetectionModel');
  late final _id3FaceTracker_SetDetectionModel =
      _id3FaceTracker_SetDetectionModelPtr
          .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Gets the model used to create features and assess consistancy among views of a given face.
  /// Hint: Default value is FaceEncoder9B. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param eEncodingModel [out] Model used to create features and assess consistancy among views of a given face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetEncodingModel(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int32> eEncodingModel,
  ) {
    return _id3FaceTracker_GetEncodingModel(
      hFaceTracker,
      eEncodingModel,
    );
  }

  late final _id3FaceTracker_GetEncodingModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER,
              ffi.Pointer<ffi.Int32>)>>('id3FaceTracker_GetEncodingModel');
  late final _id3FaceTracker_GetEncodingModel =
      _id3FaceTracker_GetEncodingModelPtr
          .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int32>)>();

  /// Sets the model used to create features and assess consistancy among views of a given face.
  /// Hint: Default value is FaceEncoder9B. Some better accuracy/speed balances can be found by choosing another model.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param eEncodingModel [in] Model used to create features and assess consistancy among views of a given face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetEncodingModel(
    ID3_FACE_TRACKER hFaceTracker,
    int eEncodingModel,
  ) {
    return _id3FaceTracker_SetEncodingModel(
      hFaceTracker,
      eEncodingModel,
    );
  }

  late final _id3FaceTracker_SetEncodingModelPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int32)>>(
      'id3FaceTracker_SetEncodingModel');
  late final _id3FaceTracker_SetEncodingModel =
      _id3FaceTracker_SetEncodingModelPtr
          .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Gets the minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// Hint: Default value is 3000 which corresponds to a False Match Rate of 1/1000.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param matchThreshold [out] Minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetMatchThreshold(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int> matchThreshold,
  ) {
    return _id3FaceTracker_GetMatchThreshold(
      hFaceTracker,
      matchThreshold,
    );
  }

  late final _id3FaceTracker_GetMatchThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER,
              ffi.Pointer<ffi.Int>)>>('id3FaceTracker_GetMatchThreshold');
  late final _id3FaceTracker_GetMatchThreshold =
      _id3FaceTracker_GetMatchThresholdPtr
          .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// Hint: Default value is 3000 which corresponds to a False Match Rate of 1/1000.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param matchThreshold [in] Minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetMatchThreshold(
    ID3_FACE_TRACKER hFaceTracker,
    int matchThreshold,
  ) {
    return _id3FaceTracker_SetMatchThreshold(
      hFaceTracker,
      matchThreshold,
    );
  }

  late final _id3FaceTracker_SetMatchThresholdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int)>>(
          'id3FaceTracker_SetMatchThreshold');
  late final _id3FaceTracker_SetMatchThreshold =
      _id3FaceTracker_SetMatchThresholdPtr
          .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Gets the maximum number of consecutive non-detections to reach before deleting a tracked face.
  /// Hint: Default value is 30 which corresponds to 2s at a frame rate of 15 FPS. One must adapt this value to its needs in terms of tracker identity memory (in seconds) and measured frame rate on target platform.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param maximumTrackedFaceAge [out] Maximum number of consecutive non-detections to reach before deleting a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetMaximumTrackedFaceAge(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int> maximumTrackedFaceAge,
  ) {
    return _id3FaceTracker_GetMaximumTrackedFaceAge(
      hFaceTracker,
      maximumTrackedFaceAge,
    );
  }

  late final _id3FaceTracker_GetMaximumTrackedFaceAgePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>>(
      'id3FaceTracker_GetMaximumTrackedFaceAge');
  late final _id3FaceTracker_GetMaximumTrackedFaceAge =
      _id3FaceTracker_GetMaximumTrackedFaceAgePtr
          .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>();

  /// Sets the maximum number of consecutive non-detections to reach before deleting a tracked face.
  /// Hint: Default value is 30 which corresponds to 2s at a frame rate of 15 FPS. One must adapt this value to its needs in terms of tracker identity memory (in seconds) and measured frame rate on target platform.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param maximumTrackedFaceAge [in] Maximum number of consecutive non-detections to reach before deleting a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetMaximumTrackedFaceAge(
    ID3_FACE_TRACKER hFaceTracker,
    int maximumTrackedFaceAge,
  ) {
    return _id3FaceTracker_SetMaximumTrackedFaceAge(
      hFaceTracker,
      maximumTrackedFaceAge,
    );
  }

  late final _id3FaceTracker_SetMaximumTrackedFaceAgePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int)>>(
          'id3FaceTracker_SetMaximumTrackedFaceAge');
  late final _id3FaceTracker_SetMaximumTrackedFaceAge =
      _id3FaceTracker_SetMaximumTrackedFaceAgePtr
          .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Gets the minimum number of consecutive detections to reach before creating a tracked face.
  /// Hint: Default value is 1 for FaceDetector4B since the false detection rate is low enough. If using a less accurate detector (such as FaceDetector3C) one might consider increasing a bit this value to avoid false tracks.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param minimumTrackedFaceAge [out] Minimum number of consecutive detections to reach before creating a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetMinimumTrackedFaceAge(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int> minimumTrackedFaceAge,
  ) {
    return _id3FaceTracker_GetMinimumTrackedFaceAge(
      hFaceTracker,
      minimumTrackedFaceAge,
    );
  }

  late final _id3FaceTracker_GetMinimumTrackedFaceAgePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>>(
      'id3FaceTracker_GetMinimumTrackedFaceAge');
  late final _id3FaceTracker_GetMinimumTrackedFaceAge =
      _id3FaceTracker_GetMinimumTrackedFaceAgePtr
          .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>();

  /// Sets the minimum number of consecutive detections to reach before creating a tracked face.
  /// Hint: Default value is 1 for FaceDetector4B since the false detection rate is low enough. If using a less accurate detector (such as FaceDetector3C) one might consider increasing a bit this value to avoid false tracks.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param minimumTrackedFaceAge [in] Minimum number of consecutive detections to reach before creating a tracked face.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetMinimumTrackedFaceAge(
    ID3_FACE_TRACKER hFaceTracker,
    int minimumTrackedFaceAge,
  ) {
    return _id3FaceTracker_SetMinimumTrackedFaceAge(
      hFaceTracker,
      minimumTrackedFaceAge,
    );
  }

  late final _id3FaceTracker_SetMinimumTrackedFaceAgePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int)>>(
          'id3FaceTracker_SetMinimumTrackedFaceAge');
  late final _id3FaceTracker_SetMinimumTrackedFaceAge =
      _id3FaceTracker_SetMinimumTrackedFaceAgePtr
          .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Gets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// Hint: Default value is 40. Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param nmsIouThreshold [out] Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetNmsIouThreshold(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int> nmsIouThreshold,
  ) {
    return _id3FaceTracker_GetNmsIouThreshold(
      hFaceTracker,
      nmsIouThreshold,
    );
  }

  late final _id3FaceTracker_GetNmsIouThresholdPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER,
              ffi.Pointer<ffi.Int>)>>('id3FaceTracker_GetNmsIouThreshold');
  late final _id3FaceTracker_GetNmsIouThreshold =
      _id3FaceTracker_GetNmsIouThresholdPtr
          .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>();

  /// Sets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// Hint: Default value is 40. Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param nmsIouThreshold [in] Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range is [0;100].
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetNmsIouThreshold(
    ID3_FACE_TRACKER hFaceTracker,
    int nmsIouThreshold,
  ) {
    return _id3FaceTracker_SetNmsIouThreshold(
      hFaceTracker,
      nmsIouThreshold,
    );
  }

  late final _id3FaceTracker_SetNmsIouThresholdPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int)>>(
          'id3FaceTracker_SetNmsIouThreshold');
  late final _id3FaceTracker_SetNmsIouThreshold =
      _id3FaceTracker_SetNmsIouThresholdPtr
          .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Gets the number of threads to be used for face detection and tracking.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param threadCount [out] Number of threads to be used for face detection and tracking.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_GetThreadCount(
    ID3_FACE_TRACKER hFaceTracker,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3FaceTracker_GetThreadCount(
      hFaceTracker,
      threadCount,
    );
  }

  late final _id3FaceTracker_GetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER,
              ffi.Pointer<ffi.Int>)>>('id3FaceTracker_GetThreadCount');
  late final _id3FaceTracker_GetThreadCount = _id3FaceTracker_GetThreadCountPtr
      .asFunction<int Function(ID3_FACE_TRACKER, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to be used for face detection and tracking.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param threadCount [in] Number of threads to be used for face detection and tracking.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_SetThreadCount(
    ID3_FACE_TRACKER hFaceTracker,
    int threadCount,
  ) {
    return _id3FaceTracker_SetThreadCount(
      hFaceTracker,
      threadCount,
    );
  }

  late final _id3FaceTracker_SetThreadCountPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_FACE_TRACKER, ffi.Int)>>(
          'id3FaceTracker_SetThreadCount');
  late final _id3FaceTracker_SetThreadCount = _id3FaceTracker_SetThreadCountPtr
      .asFunction<int Function(ID3_FACE_TRACKER, int)>();

  /// Detects faces in an image and update their info in a TrackedFaceList object.
  /// The algorithm searches for faces in the range [16px;512px]. If the image is too large to fit this range, one must resize it before the tracking process.
  /// In a realtime process, one must use this function to keep the face IDs stable in time.
  /// Important: Loading a ``FaceDetector`` is required to use this function.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param hImage [in] Source image to process.
  /// @param hTrackedFaceList [in] List of tracked faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_DetectFaces(
    ID3_FACE_TRACKER hFaceTracker,
    ID3_FACE_IMAGE hImage,
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
  ) {
    return _id3FaceTracker_DetectFaces(
      hFaceTracker,
      hImage,
      hTrackedFaceList,
    );
  }

  late final _id3FaceTracker_DetectFacesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER, ID3_FACE_IMAGE,
              ID3_TRACKED_FACE_LIST)>>('id3FaceTracker_DetectFaces');
  late final _id3FaceTracker_DetectFaces =
      _id3FaceTracker_DetectFacesPtr.asFunction<
          int Function(
              ID3_FACE_TRACKER, ID3_FACE_IMAGE, ID3_TRACKED_FACE_LIST)>();

  /// Tracks faces in an image and update their info in a TrackedFaceList object.
  /// The algorithm searches for faces in the range [16px;512px]. If the image is too large to fit this range, one must resize it before the tracking process.
  /// In a realtime process, one must use this function to keep the face IDs stable in time.
  /// Important: Loading a ``FaceDetector`` and a ``FaceEncoder`` model is required to use this function.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param hImage [in] Source image to process.
  /// @param hTrackedFaceList [in] List of tracked faces.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_TrackFaces(
    ID3_FACE_TRACKER hFaceTracker,
    ID3_FACE_IMAGE hImage,
    ID3_TRACKED_FACE_LIST hTrackedFaceList,
  ) {
    return _id3FaceTracker_TrackFaces(
      hFaceTracker,
      hImage,
      hTrackedFaceList,
    );
  }

  late final _id3FaceTracker_TrackFacesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_FACE_TRACKER, ID3_FACE_IMAGE,
              ID3_TRACKED_FACE_LIST)>>('id3FaceTracker_TrackFaces');
  late final _id3FaceTracker_TrackFaces =
      _id3FaceTracker_TrackFacesPtr.asFunction<
          int Function(
              ID3_FACE_TRACKER, ID3_FACE_IMAGE, ID3_TRACKED_FACE_LIST)>();

  /// Gets the face tracker module ready to work on a specific image size by initializing all its internal memory layout.
  /// This function can be called after setting all the parameters of the face detector module if the image size is fixed, for example using frames from a video stream.
  /// Calling this function is not mandatory as the internal memory layout is automatically initialized in the first call to detectFaces() or trackFaces() if missing.
  /// Important: Loading a ``FaceDetector`` model is required to use this function.
  /// @param hFaceTracker [in] Handle to the FaceTracker object.
  /// @param imageWidth [in] Width of the expected image size.
  /// @param imageHeight [in] Height of expected image size.
  /// @return An error code. See id3FaceError file for the list of possible error codes.
  /// @retval id3FaceError_Success The function succeeded.
  int id3FaceTracker_WarmUp(
    ID3_FACE_TRACKER hFaceTracker,
    int imageWidth,
    int imageHeight,
  ) {
    return _id3FaceTracker_WarmUp(
      hFaceTracker,
      imageWidth,
      imageHeight,
    );
  }

  late final _id3FaceTracker_WarmUpPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_FACE_TRACKER, ffi.Int, ffi.Int)>>('id3FaceTracker_WarmUp');
  late final _id3FaceTracker_WarmUp = _id3FaceTracker_WarmUpPtr
      .asFunction<int Function(ID3_FACE_TRACKER, int, int)>();

  late final addresses = _SymbolAddresses(this);
}

class _SymbolAddresses {
  final FaceSDK _library;
  _SymbolAddresses(this._library);
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_POINT_LIST>)>>
      get id3FacePointList_Dispose => _library._id3FacePointList_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_BUFFER>)>>
      get id3FaceImageBuffer_Dispose => _library._id3FaceImageBuffer_DisposePtr;
  ffi.Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE>)>>
      get id3FaceImage_Dispose => _library._id3FaceImage_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DETECTED_FACE>)>>
      get id3DetectedFace_Dispose => _library._id3DetectedFace_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DETECTED_FACE_LIST>)>>
      get id3DetectedFaceList_Dispose =>
          _library._id3DetectedFaceList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_ANALYSER>)>>
      get id3FaceAnalyser_Dispose => _library._id3FaceAnalyser_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_CANDIDATE>)>>
      get id3FaceCandidate_Dispose => _library._id3FaceCandidate_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_CANDIDATE_LIST>)>>
      get id3FaceCandidateList_Dispose =>
          _library._id3FaceCandidateList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_DETECTOR>)>>
      get id3FaceDetector_Dispose => _library._id3FaceDetector_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE>)>>
      get id3FaceTemplate_Dispose => _library._id3FaceTemplate_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_ENCODER>)>>
      get id3FaceEncoder_Dispose => _library._id3FaceEncoder_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_STRING_LIST>)>>
      get id3FaceStringList_Dispose => _library._id3FaceStringList_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_DICT>)>>
      get id3FaceImageDict_Dispose => _library._id3FaceImageDict_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_IMAGE_LIST>)>>
      get id3FaceImageList_Dispose => _library._id3FaceImageList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_INDEXER>)>>
      get id3FaceIndexer_Dispose => _library._id3FaceIndexer_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE_LIST>)>>
      get id3FaceTemplateList_Dispose =>
          _library._id3FaceTemplateList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_TEMPLATE_DICT>)>>
      get id3FaceTemplateDict_Dispose =>
          _library._id3FaceTemplateDict_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_MATCHER>)>>
      get id3FaceMatcher_Dispose => _library._id3FaceMatcher_DisposePtr;
  ffi.Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_PAD>)>>
      get id3FacePad_Dispose => _library._id3FacePad_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_TRACKED_FACE>)>>
      get id3TrackedFace_Dispose => _library._id3TrackedFace_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_PORTRAIT>)>>
      get id3FacePortrait_Dispose => _library._id3FacePortrait_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_FACE_PORTRAIT_PROCESSOR>)>>
      get id3FacePortraitProcessor_Dispose =>
          _library._id3FacePortraitProcessor_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_TRACKED_FACE_LIST>)>>
      get id3TrackedFaceList_Dispose => _library._id3TrackedFaceList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_FACE_TRACKER>)>>
      get id3FaceTracker_Dispose => _library._id3FaceTracker_DisposePtr;
}

/// Represents a point.
final class id3FacePoint extends ffi.Struct {
  /// X-coordinate of the point.
  @ffi.Int()
  external int X;

  /// Y-coordinate of the point.
  @ffi.Int()
  external int Y;
}

/// Represents a rectangle.
final class id3FaceRectangle extends ffi.Struct {
  /// Bottom-left corner of the rectangle.
  external id3FacePoint BottomLeft;

  /// Bottom-right corner of the rectangle.
  external id3FacePoint BottomRight;

  /// Top-left corner of the rectangle.
  external id3FacePoint TopLeft;

  /// Top-right corner of the rectangle.
  external id3FacePoint TopRight;
}

final class id3FacePointList extends ffi.Opaque {}

/// Handle to a PointList object of the Face module.
typedef ID3_FACE_POINT_LIST = ffi.Pointer<id3FacePointList>;

/// Enumerates supported pixel formats.
abstract class id3FacePixelFormat {
  /// Undefined.
  static const int id3FacePixelFormat_Undefined = 0;

  /// 8-bits grayscale.
  static const int id3FacePixelFormat_Grayscale8Bits = 10;

  /// 16-bits grayscale.
  static const int id3FacePixelFormat_Grayscale16Bits = 20;

  /// Floating point grayscale.
  static const int id3FacePixelFormat_GrayscaleFloat = 25;

  /// 24 bits BGR.
  static const int id3FacePixelFormat_Bgr24Bits = 30;

  /// 24 bits RGB.
  static const int id3FacePixelFormat_Rgb24Bits = 31;

  /// 32 bits BGRA.
  static const int id3FacePixelFormat_Bgra = 32;

  /// 32 bits RGBA.
  static const int id3FacePixelFormat_Rgba = 33;

  /// NV12 (YUV semi-planar format).
  static const int id3FacePixelFormat_Nv12 = 40;

  /// I420 (YUV packed format).
  static const int id3FacePixelFormat_I420 = 41;

  /// YUY2 (YUV packed format).
  static const int id3FacePixelFormat_Yuy2 = 42;

  /// YV12 (YUV packed format).
  static const int id3FacePixelFormat_Yv12 = 43;
}

/// Enumerates supported image formats.
abstract class id3FaceImageFormat {
  /// BMP.
  static const int id3FaceImageFormat_Bmp = 0;

  /// JPEG.
  static const int id3FaceImageFormat_Jpeg = 2;

  /// PNG.
  static const int id3FaceImageFormat_Png = 13;

  /// Tiff.
  static const int id3FaceImageFormat_Tiff = 18;

  /// JPEG 2000.
  static const int id3FaceImageFormat_Jpeg2000 = 30;

  /// WEBP.
  static const int id3FaceImageFormat_Webp = 31;

  /// Raw.
  static const int id3FaceImageFormat_Raw = 34;
}

final class id3FaceImageBuffer extends ffi.Opaque {}

/// Handle to a ImageBuffer object of the Face module.
typedef ID3_FACE_IMAGE_BUFFER = ffi.Pointer<id3FaceImageBuffer>;

final class id3FaceImage extends ffi.Opaque {}

/// Handle to a Image object of the Face module.
typedef ID3_FACE_IMAGE = ffi.Pointer<id3FaceImage>;

final class id3DetectedFace extends ffi.Opaque {}

/// Handle to a DetectedFace object of the Face module.
typedef ID3_DETECTED_FACE = ffi.Pointer<id3DetectedFace>;

/// Enumerates the types of presentation attack supports.
abstract class id3FaceAttackSupport {
  /// No attack support.
  static const int id3FaceAttackSupport_None = 0;

  /// ID card support.
  static const int id3FaceAttackSupport_IdCard = 1;

  /// Screen support (includes smartphones, tablets, laptops, etc).
  static const int id3FaceAttackSupport_Screen = 2;

  /// Printed support.
  static const int id3FaceAttackSupport_Print = 3;
}

/// Represents the result of the attack support detection.
final class id3DetectedFaceAttackSupport extends ffi.Struct {
  /// Attack support type.
  @ffi.Int32()
  external int AttackSupport;

  /// Confidence score of the detected attack support, in the range [0:100].
  @ffi.Int()
  external int Score;
}

final class id3DetectedFaceList extends ffi.Opaque {}

/// Handle to a DetectedFaceList object of the Face module.
typedef ID3_DETECTED_FACE_LIST = ffi.Pointer<id3DetectedFaceList>;

/// Represents the face attributes.
final class id3FaceAttributes extends ffi.Struct {
  /// Value, from 0 to 100, indicating whether the subject is wearing glasses or not.
  /// Hint: The recommended threshold is 10.
  @ffi.Int()
  external int Glasses;

  /// Value, from 0 to 100, indicating whether the subject is wearing a hat or not.
  /// Hint: The recommended value is less than 10.
  @ffi.Int()
  external int Hat;

  /// Value, from 0 to 100, indicating whether the subject is wearing makeup or not.
  /// Hint: The recommended value is less than 50.
  @ffi.Int()
  external int MakeUp;

  /// Value, from 0 to 100, indicating the estimated gender of the subject.
  /// A value near 0 suggests that the subject is estimated to be female.
  /// A value near 100 suggests that the subject is estimated to be male.
  @ffi.Int()
  external int Male;

  /// Value, from 0 to 100, indicating whether the subject's mouth is open or not.
  /// Hint: The recommended value is less than 35.
  @ffi.Int()
  external int MouthOpen;

  /// Value, from 0 to 100, indicating whether the subject is smiling or not.
  /// Hint: The recommended value is less than 75.
  @ffi.Int()
  external int Smile;
}

/// Represents the result of the background uniformity check.
final class id3FaceBackgroundUniformity extends ffi.Struct {
  /// Color uniformity score, in the range [0:100].
  /// Hint: Recommended threshold is 80.
  @ffi.Int()
  external int ColorUniformity;

  /// Structure uniformity score, in the range [0:100].
  /// Hint: Recommended threshold is 80.
  @ffi.Int()
  external int StructureUniformity;
}

/// Enumerates the possible facial expressions.
abstract class id3FaceExpression {
  /// Unknown.
  static const int id3FaceExpression_Unknown = 0;

  /// Angriness.
  static const int id3FaceExpression_Angriness = 1;

  /// Disgust.
  static const int id3FaceExpression_Disgust = 2;

  /// Fear.
  static const int id3FaceExpression_Fear = 3;

  /// Happiness.
  static const int id3FaceExpression_Happiness = 4;

  /// Neutrality.
  static const int id3FaceExpression_Neutrality = 5;

  /// Sadness.
  static const int id3FaceExpression_Sadness = 6;

  /// Surprise.
  static const int id3FaceExpression_Surprise = 7;
}

/// Represents the eye gaze.
final class id3FaceEyeGaze extends ffi.Struct {
  /// Value indicating the gaze alongside the x-axis of the left eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  @ffi.Float()
  external double LeftEyeXGaze;

  /// Value indicating the gaze alongside the y-axis of the left eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  @ffi.Float()
  external double LeftEyeYGaze;

  /// Value indicating the gaze alongside the x-axis of the right eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  @ffi.Float()
  external double RightEyeXGaze;

  /// Value indicating the gaze alongside the y-axis of the right eye in degrees.
  /// Values vary in the range [-90, +90].
  /// Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
  @ffi.Float()
  external double RightEyeYGaze;
}

/// Represents the geometric attributes of a portrait image.
final class id3FaceGeometricAttributes extends ffi.Struct {
  /// Value indicating if the distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// Hint: For ICAO compliance, the value must be in the range 60 to 90.
  @ffi.Int()
  external int HeadImageHeightRatio;

  /// Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// Hint: For ICAO compliance, the value must be in the range 50 to 75.
  @ffi.Int()
  external int HeadImageWidthRatio;

  /// Value indicating if the head is correctly centered horizontally.
  /// Hint: For ICAO compliance, the value must be in the range 45 to 55.
  @ffi.Int()
  external int HorizontalPosition;

  /// Value indicating if the image resolution is sufficient.
  /// Hint: The recommended value is over 90.
  @ffi.Int()
  external int Resolution;

  /// Value indicating if the distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// Hint: For ICAO compliance, the value must be in the range 30 to 50.
  @ffi.Int()
  external int VerticalPosition;
}

/// Represents some glasses attributes.
final class id3FaceGlassesAttributes extends ffi.Struct {
  /// Value indicating if the glasses frame is not on the eyes.
  /// 0 means that there is no occlusion of the eye by the frame.
  /// Hint: The recommended value is under 10.
  @ffi.Int()
  external int FrameOnEye;

  /// Value, from 0 to 100, indicating if the glasses' frame is too heavy.
  /// 0 means that the frame is super thick.
  /// Hint: The recommended value is over 20.
  @ffi.Int()
  external int HeavyFrame;

  /// Value, from 0 to 100, indicating if the glasses are tinted.
  /// 100 means that the glasses are completely transparent.
  /// Hint: The recommended value is over 25.
  @ffi.Int()
  external int TintedGlasses;
}

/// Represents the photographic attributes of a portrait image.
final class id3FacePhotographicAttributes extends ffi.Struct {
  /// Value, from 0 to 100, indicating if one side of the face is ligther than the other side.
  /// 0 means that brightness is perfectly equal on both sides of the face.
  /// Hint: The recommended value is over 90.
  @ffi.Int()
  external int EqualBrightness;

  /// Value, from 0 to 255, indicating the dynamic range of the image in the face region.
  /// Hint: The recommended threshold is 110.
  @ffi.Int()
  external int FaceDynamicRange;

  /// Value, from 0 to 100, indicating if a flash reflection is present on the face.
  /// 100 means that there is no flash reflection.
  /// Hint: The recommended threshold is 70.
  @ffi.Int()
  external int FlashReflection;

  /// Value, from 0 to 100, indicating if the skin looks natural.
  /// 0 means that the face does not have a natural skin color at all.
  /// Hint: The recommended threshold is over 5.
  @ffi.Int()
  external int NaturalSkinColor;

  /// Value, from 0 to 100, indicating the ratio of face pixels that are over-exposed.
  /// 0 means that the face is not over-exposed at all.
  /// Hint: The recommended value is under 50.
  @ffi.Int()
  external int OverExposure;

  /// Value, from 0 to 100, indicating if the image is pixelized.
  /// 0 means that there is no pixelation at all.
  /// Hint: The recommended value is under 50.
  @ffi.Int()
  external int Pixelation;

  /// Value, from 0 to 100, indicating if the image sharpness is sufficient.
  /// 0 means that the image is not sharp at all.
  /// Hint: The recommended value is over 40.
  @ffi.Int()
  external int Sharpness;

  /// Value, from 0 to 100, indicating the ratio of face pixels that are under-exposed.
  /// 0 means that the face is not under-exposed at all.
  /// Hint: The recommended value is under 50.
  @ffi.Int()
  external int UnderExposure;
}

/// Represents the face pose (yaw, pitch, roll).
final class id3FacePose extends ffi.Struct {
  /// Pitch angle in degrees.
  @ffi.Float()
  external double Pitch;

  /// Roll angle in degrees.
  @ffi.Float()
  external double Roll;

  /// Yaw angle in degrees.
  @ffi.Float()
  external double Yaw;
}

/// Represents the result of face occlusion detection.
final class id3FaceOcclusionScores extends ffi.Struct {
  /// Value, from 0 to 100, indicating whether the left eye is occluded or not.
  /// 100 means that the left eye is definitely occluded.
  /// Hint: The recommended threshold is 50.
  @ffi.Int()
  external int LeftEyeOcclusionScore;

  /// Value, from 0 to 100, indicating whether the mouth is occluded or not.
  /// 100 means that the mouth is definitely occluded.
  /// Hint: The recommended threshold is 30.
  @ffi.Int()
  external int MouthOcclusionScore;

  /// Value, from 0 to 100, indicating whether the nose is occluded or not.
  /// 100 means that the nose is definitely occluded.
  /// Hint: The recommended threshold is 50.
  @ffi.Int()
  external int NoseOcclusionScore;

  /// Value, from 0 to 100, indicating whether the right eye is occluded or not.
  /// 100 means that the right eye is definitely occluded.
  /// Hint: The recommended threshold is 50.
  @ffi.Int()
  external int RightEyeOcclusionScore;
}

final class id3FaceAnalyser extends ffi.Opaque {}

/// Handle to a FaceAnalyser object of the Face module.
typedef ID3_FACE_ANALYSER = ffi.Pointer<id3FaceAnalyser>;

final class id3FaceCandidate extends ffi.Opaque {}

/// Handle to a FaceCandidate object of the Face module.
typedef ID3_FACE_CANDIDATE = ffi.Pointer<id3FaceCandidate>;

final class id3FaceCandidateList extends ffi.Opaque {}

/// Handle to a FaceCandidateList object of the Face module.
typedef ID3_FACE_CANDIDATE_LIST = ffi.Pointer<id3FaceCandidateList>;

/// Represents the result of the color-based PAD method.
final class id3FaceColorBasedPadResult extends ffi.Struct {
  /// Color-based PAD score, in the range [0:100].
  @ffi.Int()
  external int Score;

  /// Confidence score of the color-based PAD algorithm, in the range [0:100].
  @ffi.Int()
  external int Confidence;
}

/// Enumerates the AI models available in this SDK.
abstract class id3FaceModel {
  /// Face detector 3A. Legacy high-accuracy detector, mainly for server-based or offline applications.
  static const int id3FaceModel_FaceDetector3A = 1001;

  /// Face detector 3B. Legacy light detector, mainly for mobile/embedded real-time detection/tracking applications.
  static const int id3FaceModel_FaceDetector3B = 1002;

  /// Face detector 3C. Ultra-light detector, dedicated to short-range real-time detection/tracking applications only.
  static const int id3FaceModel_FaceDetector3C = 1003;

  /// Face detector 4A. Highest accuracy detector in this SDK, mainly for server-based or offline applications.
  static const int id3FaceModel_FaceDetector4A = 1004;

  /// Face detector 4B. Light and accurate detector, mainly for mobile/embedded real-time detection/tracking applications.
  static const int id3FaceModel_FaceDetector4B = 1005;

  /// Hardware specific declination of Face detector 4B.
  static const int id3FaceModel_FaceDetector4BQ = 1006;

  /// Face encoder 8A. Legacy model.
  static const int id3FaceModel_FaceEncoder8A = 1102;

  /// Face encoder 8B. Legacy model.
  static const int id3FaceModel_FaceEncoder8B = 1103;

  /// Face encoder 9A. Highest accuracy face encoder in this SDK, mainly for server-based 1:N applications.
  static const int id3FaceModel_FaceEncoder9A = 1104;

  /// Face encoder 9B. Light and accurate face encoder, mainly for mobile/embedded 1:1 applications.
  static const int id3FaceModel_FaceEncoder9B = 1105;

  /// Face encoder 9C. Ultra-light face encoder, dedicated to face tracking only.
  static const int id3FaceModel_FaceEncoder9C = 1106;

  /// Periocular encoder 2A. Highest accuracy periocular encoder in this SDK. Provides an efficient alternative to face encoders when people wear masks in server-based 1:N applications.
  static const int id3FaceModel_FacePeriocularEncoder2A = 1152;

  /// Face encoding quality estimator 3A.
  static const int id3FaceModel_FaceEncodingQualityEstimator3A = 1202;

  /// Face landmarks estimator 2A.
  static const int id3FaceModel_FaceLandmarksEstimator2A = 1301;

  /// Face age estimator 1A.
  static const int id3FaceModel_FaceAgeEstimator1A = 1350;

  /// Face attributes estimator 2A.
  static const int id3FaceModel_FaceAttributesClassifier2A = 1401;

  /// Face expression classifier 1A.
  static const int id3FaceModel_FaceExpressionClassifier1A = 1450;

  /// Eye openness detector 1A.
  static const int id3FaceModel_EyeOpennessDetector1A = 1510;

  /// Eye redness detector 1A.
  static const int id3FaceModel_EyeRednessDetector1A = 1520;

  /// Eye gaze estimator 2A.
  static const int id3FaceModel_EyeGazeEstimator2A = 1531;

  /// Face background uniformity estimator 1A.
  static const int id3FaceModel_FaceBackgroundUniformity1A = 1550;

  /// Face mask classifier 2A.
  static const int id3FaceModel_FaceMaskClassifier2A = 1601;

  /// Face occlusion detector 2A.
  static const int id3FaceModel_FaceOcclusionDetector2A = 1651;

  /// Face pose estimator 1A.
  static const int id3FaceModel_FacePoseEstimator1A = 1700;

  /// Face color-based presentation attack detector (PAD) 2A.
  static const int id3FaceModel_FaceColorBasedPad2A = 1801;

  /// Face color-based presentation attack detector (PAD) 3A.
  static const int id3FaceModel_FaceColorBasedPad3A = 1802;

  /// Face blurriness detector 1A.
  static const int id3FaceModel_FaceBlurrinessDetector1A = 1810;

  /// Face attack support detector 2A.
  static const int id3FaceModel_FaceAttackSupportDetector2A = 1831;

  /// Face attack support detector 3A.
  static const int id3FaceModel_FaceAttackSupportDetector3A = 1841;

  /// Face depth-based presentation attack detector (PAD) 2A.
  static const int id3FaceModel_FaceDepthBasedPad2A = 1850;

  /// Background removal model.
  static const int id3FaceModel_FaceBackgroundSegmenter1A = 1870;

  /// Face segmenter model.
  static const int id3FaceModel_FaceSegmenter2A = 1871;

  /// Compression artificat remover.
  static const int id3FaceModel_CompressionArtifactRemover1A = 1872;
}

/// Enumerates the processing units for the inference of AI models.
abstract class id3FaceProcessingUnit {
  /// CPU.
  static const int id3FaceProcessingUnit_Cpu = 0;

  /// GPU (automatic backend selection).
  static const int id3FaceProcessingUnit_Gpu = 1;

  /// OpenCL Backend.
  static const int id3FaceProcessingUnit_Opencl = 2;

  /// CUDA Backend.
  static const int id3FaceProcessingUnit_Cuda = 3;

  /// Metal Backend.
  static const int id3FaceProcessingUnit_Metal = 4;

  /// Vulkan Backend.
  static const int id3FaceProcessingUnit_Vulkan = 5;
}

final class id3FaceDetector extends ffi.Opaque {}

/// Handle to a FaceDetector object of the Face module.
typedef ID3_FACE_DETECTOR = ffi.Pointer<id3FaceDetector>;

/// Enumerates the face template formats.
abstract class id3FaceTemplateFormat {
  /// Undefined template format.
  static const int id3FaceTemplateFormat_Undefined = 0;

  /// Template generated with the FaceEncoder8A model.
  static const int id3FaceTemplateFormat_V8A = 8586;

  /// Template generated with the FaceEncoder8B model.
  static const int id3FaceTemplateFormat_V8B = 8587;

  /// Template generated with the FaceEncoder9A model.
  static const int id3FaceTemplateFormat_V9A = 8602;

  /// Template generated with the FaceEncoder9B model.
  static const int id3FaceTemplateFormat_V9B = 8603;

  /// Template generated with the FaceEncoder9C model.
  static const int id3FaceTemplateFormat_V9C = 8604;

  /// Template generated with the FacePeriocularEncoder2A model.
  static const int id3FaceTemplateFormat_PeriocularV2A = 8746;

  /// Template generated with the FacePeriocularEncoder2B model.
  static const int id3FaceTemplateFormat_PeriocularV2B = 8747;
}

final class id3FaceTemplate extends ffi.Opaque {}

/// Handle to a FaceTemplate object of the Face module.
typedef ID3_FACE_TEMPLATE = ffi.Pointer<id3FaceTemplate>;

final class id3FaceEncoder extends ffi.Opaque {}

/// Handle to a FaceEncoder object of the Face module.
typedef ID3_FACE_ENCODER = ffi.Pointer<id3FaceEncoder>;

/// Enumerates the possible error codes returned by this SDK.
abstract class id3FaceError {
  /// No error.
  static const int id3FaceError_Success = 0;

  /// The given buffer is too small.
  static const int id3FaceError_InsufficientBuffer = -1;

  /// The requested object does not exist; a 'null' should be returned if possible.
  static const int id3FaceError_ObjectDoesNotExist = -2;

  /// Base error code of the Face module.
  static const int id3FaceError_Base = -1000;

  /// Minimum error code of the Face module.
  static const int id3FaceError_Minimum = -1999;

  /// The handle is invalid.
  static const int id3FaceError_InvalidHandle = -1001;

  /// The parameter is invalid.
  static const int id3FaceError_InvalidParameter = -1002;

  /// The image pixel format is invalid.
  static const int id3FaceError_InvalidPixelFormat = -1004;

  /// The template format is invalid.
  static const int id3FaceError_InvalidTemplateFormat = -1005;

  /// The computed landmarks are invalid and do not allow to process the desired information.
  static const int id3FaceError_InvalidLandmarks = -1006;

  /// The computed interocular distance (IOD) is too small to allow to process the desired information.
  static const int id3FaceError_IodTooSmall = -1007;

  /// The model could not be found in the given directory path.
  static const int id3FaceError_InvalidModelPath = -1008;

  /// The input image size is invalid for this operation.
  static const int id3FaceError_InvalidImageSize = -1010;

  /// The model which is required for this operation was not loaded.
  static const int id3FaceError_UnloadedModel = -1020;

  /// The inference backend failed to infer, probably due to inconsistent input.
  static const int id3FaceError_InferenceBackendError = -1040;

  /// The requested processing unit is not available in this build.
  static const int id3FaceError_ProcessingUnitUnavailable = -1041;

  /// The face indexer object is already initialized.
  static const int id3FaceError_IndexerAlreadyInitialized = -1050;

  /// The requested id already exists in the Face Indexer object.
  static const int id3FaceError_IndexerIdAlreadyExists = -1051;

  /// The data of the template is corrupted and cannot be added to the Face Indexer object.
  static const int id3FaceError_IndexerInvalidTemplateData = -1052;

  /// Maximum template number of the Face Indexer object has been reached.
  static const int id3FaceError_IndexerFull = -1053;

  /// No template with this id has been found in the Face Indexer object.
  static const int id3FaceError_IndexerIdNotFound = -1054;

  /// This index file is not valid and cannot be loaded.
  static const int id3FaceError_IndexerInvalidIndexFile = -1055;

  /// This function is not implemented.
  static const int id3FaceError_FunctionNotImplemented = -1056;
}

final class id3FaceStringList extends ffi.Opaque {}

/// Handle to a StringList object of the Face module.
typedef ID3_FACE_STRING_LIST = ffi.Pointer<id3FaceStringList>;

final class id3FaceImageDict extends ffi.Opaque {}

/// Handle to a ImageDict object of the Face module.
typedef ID3_FACE_IMAGE_DICT = ffi.Pointer<id3FaceImageDict>;

/// Enumerates possible error codes related to image management.
abstract class id3FaceImageError {
  /// No error.
  static const int id3FaceImageError_Success = 0;

  /// The given buffer is too small.
  static const int id3FaceImageError_InsufficientBuffer = -1;

  /// The requested object does not exist; a 'null' should be returned if possible.
  static const int id3FaceImageError_ObjectDoesNotExist = -2;

  /// Base error code for Image module.
  static const int id3FaceImageError_Base = -3000;

  /// Minimum error code for Image module.
  static const int id3FaceImageError_Minimum = -3999;

  /// The handle is invalid.
  static const int id3FaceImageError_InvalidHandle = -3001;

  /// The parameter is invalid.
  static const int id3FaceImageError_InvalidParameter = -3002;

  /// The image sizes are not compatible for the requested operation.
  static const int id3FaceImageError_ImageSizeMismatch = -3003;

  /// The pixel formats are not compatible.
  static const int id3FaceImageError_PixelFormatMismatch = -3004;

  /// The given key is already used in the dictionary. Multiple values per key is not supported.
  static const int id3FaceImageError_KeyAlreadyExists = -3005;

  /// The given key is not present in the dictionary.
  static const int id3FaceImageError_KeyNotFound = -3006;

  /// The required pixel format is not correct.
  static const int id3FaceImageError_InvalidPixelFormat = -3007;

  /// An error as occured during python module initialization.
  static const int id3FaceImageError_PythonModule = -3008;

  /// Function not implemented.
  static const int id3FaceImageError_FunctionNotImplemented = -3009;

  /// TODO
  static const int id3FaceImageError_BackendError = -3010;
}

final class id3FaceImageList extends ffi.Opaque {}

/// Handle to a ImageList object of the Face module.
typedef ID3_FACE_IMAGE_LIST = ffi.Pointer<id3FaceImageList>;

final class id3FaceIndexer extends ffi.Opaque {}

/// Handle to a FaceIndexer object of the Face module.
typedef ID3_FACE_INDEXER = ffi.Pointer<id3FaceIndexer>;

/// Contains data for LibVersion
final class id3FaceLibVersion extends ffi.Struct {
  /// Version.
  @ffi.Int()
  external int Major;

  /// Release.
  @ffi.Int()
  external int Minor;

  /// Build.
  @ffi.Int()
  external int Build;
}

/// Enumerates the types of hardware codes.
abstract class id3FaceLicenseHardwareCodeType {
  /// License locked on Windows OS.
  static const int id3FaceLicenseHardwareCodeType_WindowsOs = 1;

  /// License locked on Linux OS.
  static const int id3FaceLicenseHardwareCodeType_LinuxOs = 3;

  /// License locked on Android device.
  static const int id3FaceLicenseHardwareCodeType_Android = 5;

  /// License locked on Android application package name.
  static const int id3FaceLicenseHardwareCodeType_AndroidPackageName = 6;

  /// License locked on iOS device.
  static const int id3FaceLicenseHardwareCodeType_Ios = 7;

  /// License locked on macOS.
  static const int id3FaceLicenseHardwareCodeType_MacOs = 8;

  /// License locked on Jetson Nano.
  static const int id3FaceLicenseHardwareCodeType_JetsonNano = 9;

  /// License locked on iOS application Bundle ID.
  static const int id3FaceLicenseHardwareCodeType_IosBundleId = 10;

  /// License locked on Windows USB stick.
  static const int id3FaceLicenseHardwareCodeType_WindowsUsb = 11;

  /// License locked on a smart card.
  static const int id3FaceLicenseHardwareCodeType_SmartCard = 12;
}

/// Enumerates the license types.
abstract class id3FaceLicenseType {
  /// Classic id3 license.
  static const int id3FaceLicenseType_Classic = 1;

  /// Trial id3 license with a time limitation.
  static const int id3FaceLicenseType_Trial = 2;

  /// Online id3 license with an online check.
  static const int id3FaceLicenseType_Online = 3;
}

/// Enumerates the error codes related to license management.
abstract class id3FaceLicenseError {
  /// No error.
  static const int id3FaceLicenseError_Success = 0;

  /// The given buffer is too small.
  static const int id3FaceLicenseError_InsufficientBuffer = -1;

  /// The requested object does not exist; a 'null' should be returned if possible.
  static const int id3FaceLicenseError_ObjectDoesNotExist = -2;

  /// Base error code of the License module.
  static const int id3FaceLicenseError_Base = -100;

  /// Minimum error code of the License module.
  static const int id3FaceLicenseError_Minimum = -999;

  /// The handle is invalid.
  static const int id3FaceLicenseError_InvalidHandle = -101;

  /// One of the parameters is incorrect.
  static const int id3FaceLicenseError_InvalidParameter = -102;

  /// No license was found.
  static const int id3FaceLicenseError_LicenseNotFound = -103;

  /// License is not valid or a required module is not licensed.
  static const int id3FaceLicenseError_InvalidLicense = -104;

  /// The license has expired.
  static const int id3FaceLicenseError_ExpiredLicense = -105;

  /// Installation code does not match hardware ID.
  static const int id3FaceLicenseError_InvalidHardwareId = -106;

  /// The license is already fulfilled by another user (or computer).
  static const int id3FaceLicenseError_AlreadyFulfilled = -107;

  /// A required module is not licensed or the usage limit has been reached.
  static const int id3FaceLicenseError_ModuleError = -108;

  /// The license file cannot be accessed in write mode.
  static const int id3FaceLicenseError_WriteError = -109;

  /// The number of available licenses has been reached. There isn't any available license remaining.
  static const int id3FaceLicenseError_InsufficientLicenseCredits = -110;

  /// The serial is invalid.
  static const int id3FaceLicenseError_InvalidSerial = -111;

  /// Invalid login or password.
  static const int id3FaceLicenseError_InvalidCredentials = -112;

  /// The license is revoked or does not exist anymore.
  static const int id3FaceLicenseError_RevokedLicense = -113;

  /// The license is blocked after a predefined period.
  static const int id3FaceLicenseError_BlockedLicense = -114;

  /// The license server is currently unreachable.
  static const int id3FaceLicenseError_UnreachableServer = -115;

  /// An unexpected error happened.
  static const int id3FaceLicenseError_LicenseOtherError = -116;

  /// No license file was provided.
  static const int id3FaceLicenseError_MissingFile = -117;

  /// This device is not compatible with id3 licensing system.
  static const int id3FaceLicenseError_DeviceNotCompatible = -118;
}

final class id3FaceTemplateList extends ffi.Opaque {}

/// Handle to a FaceTemplateList object of the Face module.
typedef ID3_FACE_TEMPLATE_LIST = ffi.Pointer<id3FaceTemplateList>;

/// Enumerates the possible pooling methods for template agregration in the FaceTracker module.
abstract class id3FacePoolingMethod {
  /// Average pooling method. Merges instances (scores, templates, etc) into one.
  static const int id3FacePoolingMethod_Average = 0;

  /// Maximum pooling method. Selects best instance according to a given metric.
  static const int id3FacePoolingMethod_Maximum = 1;
}

final class id3FaceTemplateDict extends ffi.Opaque {}

/// Handle to a FaceTemplateDict object of the Face module.
typedef ID3_FACE_TEMPLATE_DICT = ffi.Pointer<id3FaceTemplateDict>;

final class id3FaceMatcher extends ffi.Opaque {}

/// Handle to a FaceMatcher object of the Face module.
typedef ID3_FACE_MATCHER = ffi.Pointer<id3FaceMatcher>;

/// Enumerates some typical values for the matching decision threshold.
abstract class id3FaceMatcherThreshold {
  /// False Match Rate = 1%
  static const int id3FaceMatcherThreshold_Fmr100 = 2000;

  /// False Match Rate = 0.1% (1/1K)
  static const int id3FaceMatcherThreshold_Fmr1000 = 3000;

  /// False Match Rate = 0.01% (1/10K)
  static const int id3FaceMatcherThreshold_Fmr10000 = 4000;

  /// False Match Rate = 0.001% (1/100K)
  static const int id3FaceMatcherThreshold_Fmr100000 = 5000;

  /// False Match Rate = 0.0001% (1/1M)
  static const int id3FaceMatcherThreshold_Fmr1000000 = 6000;

  /// False Match Rate = 0.00001% (1/10M)
  static const int id3FaceMatcherThreshold_Fmr10000000 = 7000;

  /// False Match Rate = 0.000001% (1/100M)
  static const int id3FaceMatcherThreshold_Fmr100000000 = 8000;

  /// False Match Rate = 0.0000001% (1/1B)
  static const int id3FaceMatcherThreshold_Fmr1000000000 = 9000;

  /// False Match Rate = 0.00000001% (1/10B)
  static const int id3FaceMatcherThreshold_Fmr10000000000 = 10000;
}

final class id3FacePad extends ffi.Opaque {}

/// Handle to a FacePad object of the Face module.
typedef ID3_FACE_PAD = ffi.Pointer<id3FacePad>;

/// Enumerates the statuses of the presentation attack detection (PAD).
abstract class id3FacePadStatus {
  /// No decision could be made.
  static const int id3FacePadStatus_Unknown = 0;

  /// The detected face is a bonafide (real face).
  static const int id3FacePadStatus_Bonafide = 1;

  /// The detected face is an attack (spoof).
  static const int id3FacePadStatus_Attack = 2;
}

/// Enumerates the instructions to be given to the user for effective portrait capture.
abstract class id3FacePortraitInstruction {
  /// No instruction given.
  static const int id3FacePortraitInstruction_None = 0;

  /// Center your face in the frame.
  static const int id3FacePortraitInstruction_CenterFace = 1;

  /// Look directly at the camera.
  static const int id3FacePortraitInstruction_LookStraight = 2;

  /// Look away.
  static const int id3FacePortraitInstruction_LookAway = 3;

  /// Ensure your face is well-lit.
  static const int id3FacePortraitInstruction_AdjustLightning = 4;

  /// The image contrast is too low.
  static const int id3FacePortraitInstruction_LowContrast = 5;

  /// Image colors are not balanced correctly.
  static const int id3FacePortraitInstruction_UnbalancedColors = 6;

  /// Image is out of focus.
  static const int id3FacePortraitInstruction_ImageOutOfFocus = 7;

  /// Move closer to the camera.
  static const int id3FacePortraitInstruction_MoveCloser = 8;

  /// Move back from the camera.
  static const int id3FacePortraitInstruction_MoveBack = 9;

  /// Move your face lower to align with the camera.
  static const int id3FacePortraitInstruction_MoveDown = 10;

  /// Move your face higher to align with the camera.
  static const int id3FacePortraitInstruction_MoveUp = 11;

  /// Move your face to the right.
  static const int id3FacePortraitInstruction_MoveRight = 12;

  /// Move your face to the left.
  static const int id3FacePortraitInstruction_MoveLeft = 13;

  /// Stay still in front of the camera.
  static const int id3FacePortraitInstruction_StayStill = 14;

  /// Close your mouth.
  static const int id3FacePortraitInstruction_CloseMouth = 15;

  /// Open your mouth.
  static const int id3FacePortraitInstruction_OpenMouth = 16;

  /// Smile.
  static const int id3FacePortraitInstruction_Smile = 17;

  /// Ensure a neutral expression.
  static const int id3FacePortraitInstruction_EnsureNeutralExpression = 18;

  /// Remove any obstacle from your face.
  static const int id3FacePortraitInstruction_FacePartiallyHidden = 19;

  /// Turn your head to the left.
  static const int id3FacePortraitInstruction_TurnHeadLeft = 20;

  /// Turn your head to the right.
  static const int id3FacePortraitInstruction_TurnHeadRight = 21;

  /// Raise your head.
  static const int id3FacePortraitInstruction_RaiseHead = 22;

  /// Lower your head.
  static const int id3FacePortraitInstruction_LowerHead = 23;

  /// Rotate your head in the specified direction.
  static const int id3FacePortraitInstruction_RotateHead = 24;

  /// Turn your head slightly.
  static const int id3FacePortraitInstruction_TurnHeadSlightly = 25;

  /// Remove any head coverings.
  static const int id3FacePortraitInstruction_RemoveHeadCoverings = 26;

  /// Remove your face mask.
  static const int id3FacePortraitInstruction_RemoveFaceMask = 27;

  /// Remove your glasses.
  static const int id3FacePortraitInstruction_RemoveGlasses = 28;

  /// Remove your sunglasses.
  static const int id3FacePortraitInstruction_RemoveSunglasses = 29;
}

/// Represents the portrait quality check points.
final class id3FacePortraitQualityCheckpoints extends ffi.Struct {
  /// Value indicating whether the mouth is closed.
  @ffi.Int()
  external int MouthClosed;

  /// Value indicating whether the image is coloured, not grayscale.
  @ffi.Int()
  external int ImageColoured;

  /// Value indicating whether lighting is equally distributed on the face, in particular symmetrically, i.e., there is no difference between the brightness of the right and left side of the face.
  @ffi.Int()
  external int BrightnessBalanced;

  /// Value indicating whether the subject's face is frontal.
  @ffi.Int()
  external int PoseFrontal;

  /// Value indicating whether the dynamic range on the image is sufficient.
  @ffi.Int()
  external int DynamicRange;

  /// Value indicating whether the height of the head in the image is correct.
  @ffi.Int()
  external int HeadHeightCorrect;

  /// Value indicating whether the width of the head in the image is correct.
  @ffi.Int()
  external int HeadWidthCorrect;

  /// Value indicating whether the horizontal position of the head in the image is correct.
  @ffi.Int()
  external int HeadHorizontalPositionCorrect;

  /// Value indicating whether the vertical position of the head in the image is correct.
  @ffi.Int()
  external int HeadVerticalPositionCorrect;

  /// Value indicating whether the image resolution is correct.
  @ffi.Int()
  external int ImageResolutionCorrect;

  /// Value indicating whether the image is sharp.
  @ffi.Int()
  external int ImageSharp;

  /// Value indicating whether the skin looks natural.
  @ffi.Int()
  external int SkinColorNatural;

  /// Value indicating whether no emotion is visible on the subject's face.
  @ffi.Int()
  external int ExpressionNeutral;

  /// Value indicating whether no flash reflection is visible.
  @ffi.Int()
  external int NoFlashReflection;

  /// Value indicating whether the subject does not wear glasses.
  @ffi.Int()
  external int NoGlasses;

  /// Value indicating whether the subject does not wear a hat.
  @ffi.Int()
  external int NoHat;

  /// Value indicating whether no noise is present in the image.
  @ffi.Int()
  external int NoNoise;

  /// Value indicating whether the image is not over-exposed.
  @ffi.Int()
  external int NoOverExposure;

  /// Value indicating whether the image is not pixelated.
  @ffi.Int()
  external int NoPixelation;

  /// Value indicating whether no red-eye is present.
  @ffi.Int()
  external int NoRedEye;

  /// Value indicating whether the subject is not smiling.
  @ffi.Int()
  external int NoSmile;

  /// Value indicating whether the image is not under-exposed.
  @ffi.Int()
  external int NoUnderExposure;

  /// Value indicating whether the eyes are open.
  @ffi.Int()
  external int EyesOpen;

  /// Value indicating whether the subject looks straight towards the camera.
  @ffi.Int()
  external int LookStraight;

  /// Value indicating whether the color of the background is uniform.
  @ffi.Int()
  external int BackgroundUniform;

  /// Value indicating whether the left eye is visible.
  @ffi.Int()
  external int LeftEyeVisible;

  /// Value indicating whether the right eye is visible.
  @ffi.Int()
  external int RightEyeVisible;

  /// Value indicating whether the mouth is visible.
  @ffi.Int()
  external int MouthVisible;

  /// Value indicating whether the nose is visible.
  @ffi.Int()
  external int NoseVisible;
}

/// Enumerates the possible statuses of a portrait.
abstract class id3FacePortraitStatus {
  /// The status is undefined.
  static const int id3FacePortraitStatus_Undefined = 0;

  /// No face has been detected in the provided image.
  static const int id3FacePortraitStatus_NoFaceDetected = 1;

  /// A new portrait has been created.
  static const int id3FacePortraitStatus_Created = 2;

  /// The portrait has been updated.
  static const int id3FacePortraitStatus_Updated = 3;
}

/// Enumerates the positions of a subject in an image.
abstract class id3FaceSubjectPosition {
  /// The position is undefined.
  static const int id3FaceSubjectPosition_Undefined = 255;

  /// The position is correct.
  static const int id3FaceSubjectPosition_Correct = 0;

  /// The subject is too close.
  static const int id3FaceSubjectPosition_TooClose = 1;

  /// The subject is too far.
  static const int id3FaceSubjectPosition_TooFar = 2;

  /// The subject is too left.
  static const int id3FaceSubjectPosition_TooLeft = 4;

  /// The subject is too right.
  static const int id3FaceSubjectPosition_TooRight = 8;

  /// The subject is too high.
  static const int id3FaceSubjectPosition_TooHigh = 16;

  /// The subject is too low.
  static const int id3FaceSubjectPosition_TooLow = 32;
}

/// Enumerates the possible face-tracking statuses.
abstract class id3FaceTrackingStatus {
  /// No status.
  static const int id3FaceTrackingStatus_None = 0;

  /// A face was detected and a track is initialized. Once the required number of consecutive detections will be reached (see MinimumTrackedFaceAge in FaceTracker), the track will move on to 'Confirmed' status.
  static const int id3FaceTrackingStatus_Initialized = 1;

  /// The face was detected and tracked for the required number of consecutive frames, hence the track is confirmed.
  static const int id3FaceTrackingStatus_Confirmed = 2;

  /// The face was missed for at least one frame. It can come back to 'Confirmed' if it is re-detected or move on to 'Deleted' if it keeps being missed for a given number of consecutive frames (see MinimumTrackedFaceAge in FaceTracker).
  static const int id3FaceTrackingStatus_TemporaryLost = 3;

  /// The face was missed for too many frames, the track is over. Remark: this state is purely internal.
  static const int id3FaceTrackingStatus_Deleted = 4;
}

final class id3TrackedFace extends ffi.Opaque {}

/// Handle to a TrackedFace object of the Face module.
typedef ID3_TRACKED_FACE = ffi.Pointer<id3TrackedFace>;

final class id3FacePortrait extends ffi.Opaque {}

/// Handle to a Portrait object of the Face module.
typedef ID3_FACE_PORTRAIT = ffi.Pointer<id3FacePortrait>;

final class id3FacePortraitProcessor extends ffi.Opaque {}

/// Handle to a PortraitProcessor object of the Face module.
typedef ID3_FACE_PORTRAIT_PROCESSOR = ffi.Pointer<id3FacePortraitProcessor>;

/// Enumerates the face segmentation labels
abstract class id3FaceSegmentationLabel {
  /// Background label
  static const int id3FaceSegmentationLabel_Background = 0;

  /// Cloth label
  static const int id3FaceSegmentationLabel_Cloth = 1;

  /// Neck label
  static const int id3FaceSegmentationLabel_Neck = 2;

  /// Skin label
  static const int id3FaceSegmentationLabel_Skin = 3;

  /// Mouth label
  static const int id3FaceSegmentationLabel_Mouth = 4;

  /// Lips label
  static const int id3FaceSegmentationLabel_Lips = 5;

  /// Nose label
  static const int id3FaceSegmentationLabel_Nose = 6;

  /// Ears label
  static const int id3FaceSegmentationLabel_Ears = 7;

  /// Earring label
  static const int id3FaceSegmentationLabel_Earring = 8;

  /// Necklace label
  static const int id3FaceSegmentationLabel_Necklace = 9;

  /// Eyebrows label
  static const int id3FaceSegmentationLabel_Eyebrows = 10;

  /// Hair label
  static const int id3FaceSegmentationLabel_Hair = 11;

  /// Glasses label
  static const int id3FaceSegmentationLabel_Glasses = 12;

  /// Eyes label
  static const int id3FaceSegmentationLabel_Eyes = 13;

  /// Hat label
  static const int id3FaceSegmentationLabel_Hat = 14;
}

final class id3TrackedFaceList extends ffi.Opaque {}

/// Handle to a TrackedFaceList object of the Face module.
typedef ID3_TRACKED_FACE_LIST = ffi.Pointer<id3TrackedFaceList>;

final class id3FaceTracker extends ffi.Opaque {}

/// Handle to a FaceTracker object of the Face module.
typedef ID3_FACE_TRACKER = ffi.Pointer<id3FaceTracker>;

const int true1 = 1;

const int false1 = 0;

const int __bool_true_false_are_defined = 1;

const int ID3FACE_VERSION_MAJOR = 9;

const int ID3FACE_VERSION_MINOR = 15;

const int ID3FACE_VERSION_BUILD = 3;
