//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the face segmentation labels
enum FaceSegmentationLabel {
	/// Background label
	background,
	/// Cloth label
	cloth,
	/// Neck label
	neck,
	/// Skin label
	skin,
	/// Mouth label
	mouth,
	/// Lips label
	lips,
	/// Nose label
	nose,
	/// Ears label
	ears,
	/// Earring label
	earring,
	/// Necklace label
	necklace,
	/// Eyebrows label
	eyebrows,
	/// Hair label
	hair,
	/// Glasses label
	glasses,
	/// Eyes label
	eyes,
	/// Hat label
	hat,
}

extension FaceSegmentationLabelX on FaceSegmentationLabel {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created FaceSegmentationLabel.
  	static FaceSegmentationLabel fromValue(int value) {
    	switch (value) {
      	case 0:
        	return FaceSegmentationLabel.background;
      	case 1:
        	return FaceSegmentationLabel.cloth;
      	case 2:
        	return FaceSegmentationLabel.neck;
      	case 3:
        	return FaceSegmentationLabel.skin;
      	case 4:
        	return FaceSegmentationLabel.mouth;
      	case 5:
        	return FaceSegmentationLabel.lips;
      	case 6:
        	return FaceSegmentationLabel.nose;
      	case 7:
        	return FaceSegmentationLabel.ears;
      	case 8:
        	return FaceSegmentationLabel.earring;
      	case 9:
        	return FaceSegmentationLabel.necklace;
      	case 10:
        	return FaceSegmentationLabel.eyebrows;
      	case 11:
        	return FaceSegmentationLabel.hair;
      	case 12:
        	return FaceSegmentationLabel.glasses;
      	case 13:
        	return FaceSegmentationLabel.eyes;
      	case 14:
        	return FaceSegmentationLabel.hat;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case FaceSegmentationLabel.background:
        	return 0;
      	case FaceSegmentationLabel.cloth:
        	return 1;
      	case FaceSegmentationLabel.neck:
        	return 2;
      	case FaceSegmentationLabel.skin:
        	return 3;
      	case FaceSegmentationLabel.mouth:
        	return 4;
      	case FaceSegmentationLabel.lips:
        	return 5;
      	case FaceSegmentationLabel.nose:
        	return 6;
      	case FaceSegmentationLabel.ears:
        	return 7;
      	case FaceSegmentationLabel.earring:
        	return 8;
      	case FaceSegmentationLabel.necklace:
        	return 9;
      	case FaceSegmentationLabel.eyebrows:
        	return 10;
      	case FaceSegmentationLabel.hair:
        	return 11;
      	case FaceSegmentationLabel.glasses:
        	return 12;
      	case FaceSegmentationLabel.eyes:
        	return 13;
      	case FaceSegmentationLabel.hat:
        	return 14;
		}
  	}
}
