//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';
import 'face_native.dart';

import '../id3_face.dart';

final _finalizer = NativeFinalizer(faceSDK.addresses.id3FaceTemplateDict_Dispose.cast());

/// Represents a dictionary of face templates.
class FaceTemplateDict extends Object with IterableMixin<FaceTemplate> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3FaceTemplateDict>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3FaceTemplateDict> get handle => _pHandle.value;

  /// Creates a new instance of the FaceTemplateDict class.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplateDict() {
    _pHandle = calloc();
    try {
      var err = faceSDK.id3FaceTemplateDict_Initialize(_pHandle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the FaceTemplateDict class.
  ///
  /// param handle     Handle to the FaceTemplateDict.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplateDict.fromHandle(Pointer<id3FaceTemplateDict> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this FaceTemplateDict.
  void dispose() {
    if (_disposable) {
      faceSDK.id3FaceTemplateDict_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the FaceTemplateDict object.
  ///
  /// return The newly created FaceTemplateDict object.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplateDict clone() {
    FaceTemplateDict clone = FaceTemplateDict();
    var err = faceSDK.id3FaceTemplateDict_CopyTo(_pHandle.value, clone.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](String key) => get(key);
  operator []=(String key, FaceTemplate item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<FaceTemplate> get iterator => FaceTemplateDictIterator(this);

  ///
  /// Gets a string list containing the keys in the dict.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  StringList get keys => getKeys();

  // Public methods
  /// Clears the FaceTemplateDict object.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  void clear() {
    var err = faceSDK.id3FaceTemplateDict_Clear(_pHandle.value);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Adds an item to the FaceTemplateDict object.
  ///
  /// param key Unique key of the FaceTemplate item to add.
  /// param faceTemplateItem FaceTemplate item to add.
  /// throws FaceException An error has occurred during Face Library execution.
  void add(String? key, FaceTemplate faceTemplateItem) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    try {
      var err = faceSDK.id3FaceTemplateDict_Add(_pHandle.value, pKey ?? nullptr, faceTemplateItem.handle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
    }
  }

  /// Gets an item of the FaceTemplateDict object.
  ///
  /// param key Unique key of the FaceTemplate item to get.
  /// return FaceTemplate item to get.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplate get(String? key) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    FaceTemplate faceTemplateItem = FaceTemplate();
    try {
      var err = faceSDK.id3FaceTemplateDict_Get(_pHandle.value, pKey ?? nullptr, faceTemplateItem.handle);
      if (err != FaceError.success.value) {
        faceTemplateItem.dispose();
        throw FaceException(err);
      }
      return faceTemplateItem;
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
    }
  }

  /// Sets an item of the FaceTemplateDict object.
  ///
  /// param key Unique key of the FaceTemplate item to set.
  /// param faceTemplateItem FaceTemplate item to set.
  /// throws FaceException An error has occurred during Face Library execution.
  void set(String? key, FaceTemplate faceTemplateItem) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    try {
      var err = faceSDK.id3FaceTemplateDict_Set(_pHandle.value, pKey ?? nullptr, faceTemplateItem.handle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
    }
  }

  /// Gets the number of elements in the FaceTemplateDict object.
  ///
  /// return Number of elements in the FaceTemplate object.
  /// throws FaceException An error has occurred during Face Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = faceSDK.id3FaceTemplateDict_GetCount(_pHandle.value, pCount);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Determines whether the FaceTemplateDictobject contains the specified key.
  ///
  /// param key The key to locate in the FaceTemplate object.
  /// return true if the FaceTemplate object contains an element with the specified key, otherwise false.
  /// throws FaceException An error has occurred during Face Library execution.
  bool containsKey(String? key) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    Pointer<Bool> pResult = calloc();
    try {
      var err = faceSDK.id3FaceTemplateDict_ContainsKey(_pHandle.value, pKey ?? nullptr, pResult);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vResult = pResult.value;
      return vResult;
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
      calloc.free(pResult);
    }
  }

  /// Removes an element of the FaceTemplateDict object.
  ///
  /// param key Unique key of the FaceTemplate item to remove.
  /// throws FaceException An error has occurred during Face Library execution.
  void remove(String? key) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    try {
      var err = faceSDK.id3FaceTemplateDict_Remove(_pHandle.value, pKey ?? nullptr);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
    }
  }

  /// Gets the gets a string list containing the keys in the dict.
  ///
  /// return Gets a string list containing the keys in the dict.
  /// throws FaceException An error has occurred during Face Library execution.
  StringList getKeys() {
    StringList keys = StringList();
    var err = faceSDK.id3FaceTemplateDict_GetKeys(_pHandle.value, keys.handle);
    if (err != FaceError.success.value) {
      keys.dispose();
      throw FaceException(err);
    }
    return keys;
  }

}

class FaceTemplateDictIterator implements Iterator<FaceTemplate> {
  FaceTemplateDictIterator(this._list)
      : _count = _list.getCount(),
        _keys = [] {
    final StringList keys = _list.getKeys();
    for (var key in keys) {
      _keys.add(key);
    }
    keys.dispose();
  }
  final FaceTemplateDict _list;
  final int _count;
  int _index = -1;
  final List<String> _keys;

  @override
  FaceTemplate get current => _list.get(_keys[_index]);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
