//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the face template formats.
enum FaceTemplateFormat {
	/// Undefined template format.
	undefined,
	/// Template generated with the FaceEncoder8A model.
	v8A,
	/// Template generated with the FaceEncoder8B model.
	v8B,
	/// Template generated with the FaceEncoder9A model.
	v9A,
	/// Template generated with the FaceEncoder9B model.
	v9B,
	/// Template generated with the FaceEncoder9C model.
	v9C,
	/// Template generated with the FacePeriocularEncoder2A model.
	periocularV2A,
	/// Template generated with the FacePeriocularEncoder2B model.
	periocularV2B,
}

extension FaceTemplateFormatX on FaceTemplateFormat {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created FaceTemplateFormat.
  	static FaceTemplateFormat fromValue(int value) {
    	switch (value) {
      	case 0x0000:
        	return FaceTemplateFormat.undefined;
      	case 0x218A:
        	return FaceTemplateFormat.v8A;
      	case 0x218B:
        	return FaceTemplateFormat.v8B;
      	case 0x219A:
        	return FaceTemplateFormat.v9A;
      	case 0x219B:
        	return FaceTemplateFormat.v9B;
      	case 0x219C:
        	return FaceTemplateFormat.v9C;
      	case 0x222A:
        	return FaceTemplateFormat.periocularV2A;
      	case 0x222B:
        	return FaceTemplateFormat.periocularV2B;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case FaceTemplateFormat.undefined:
        	return 0x0000;
      	case FaceTemplateFormat.v8A:
        	return 0x218A;
      	case FaceTemplateFormat.v8B:
        	return 0x218B;
      	case FaceTemplateFormat.v9A:
        	return 0x219A;
      	case FaceTemplateFormat.v9B:
        	return 0x219B;
      	case FaceTemplateFormat.v9C:
        	return 0x219C;
      	case FaceTemplateFormat.periocularV2A:
        	return 0x222A;
      	case FaceTemplateFormat.periocularV2B:
        	return 0x222B;
		}
  	}
}
