//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';
import 'face_native.dart';

import '../id3_face.dart';

final _finalizer = NativeFinalizer(faceSDK.addresses.id3FaceTemplateList_Dispose.cast());

/// Represents a list of face templates.
class FaceTemplateList extends Object with IterableMixin<FaceTemplate> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3FaceTemplateList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3FaceTemplateList> get handle => _pHandle.value;

  /// Creates a new instance of the FaceTemplateList class.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplateList() {
    _pHandle = calloc();
    try {
      var err = faceSDK.id3FaceTemplateList_Initialize(_pHandle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the FaceTemplateList class.
  ///
  /// param handle     Handle to the FaceTemplateList.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplateList.fromHandle(Pointer<id3FaceTemplateList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this FaceTemplateList.
  void dispose() {
    if (_disposable) {
      faceSDK.id3FaceTemplateList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the FaceTemplateList object.
  ///
  /// return The newly created FaceTemplateList object.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplateList clone() {
    FaceTemplateList clone = FaceTemplateList();
    var err = faceSDK.id3FaceTemplateList_CopyTo(_pHandle.value, clone.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);
  operator []=(int key, FaceTemplate item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<FaceTemplate> get iterator => FaceTemplateListIterator(this);

  // Public methods
  /// Clears the FaceTemplateList object.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  void clear() {
    var err = faceSDK.id3FaceTemplateList_Clear(_pHandle.value);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Adds an item to the FaceTemplateList object.
  ///
  /// param faceTemplateItem FaceTemplate item to add.
  /// throws FaceException An error has occurred during Face Library execution.
  void add(FaceTemplate faceTemplateItem) {
    var err = faceSDK.id3FaceTemplateList_Add(_pHandle.value, faceTemplateItem.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets an item of the FaceTemplateList object.
  ///
  /// param index Index of the FaceTemplate item to get.
  /// return FaceTemplate item to get.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceTemplate get(int index) {
    FaceTemplate faceTemplateItem = FaceTemplate();
    var err = faceSDK.id3FaceTemplateList_Get(_pHandle.value, index, faceTemplateItem.handle);
    if (err != FaceError.success.value) {
      faceTemplateItem.dispose();
      throw FaceException(err);
    }
    return faceTemplateItem;
  }

  /// Sets an item of the FaceTemplateList object.
  ///
  /// param index Index of the FaceTemplate item to set.
  /// param faceTemplateItem FaceTemplate item to set.
  /// throws FaceException An error has occurred during Face Library execution.
  void set(int index, FaceTemplate faceTemplateItem) {
    var err = faceSDK.id3FaceTemplateList_Set(_pHandle.value, index, faceTemplateItem.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the number of elements in the FaceTemplateList object.
  ///
  /// return Number of elements in the FaceTemplate object.
  /// throws FaceException An error has occurred during Face Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = faceSDK.id3FaceTemplateList_GetCount(_pHandle.value, pCount);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Removes an element of the FaceTemplateList object.
  ///
  /// param index Index of the FaceTemplate item to remove.
  /// throws FaceException An error has occurred during Face Library execution.
  void removeAt(int index) {
    var err = faceSDK.id3FaceTemplateList_RemoveAt(_pHandle.value, index);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// FaceTemplateList object.
  ///
  /// param newSize FaceTemplate object.
  /// throws FaceException An error has occurred during Face Library execution.
  void resize(int newSize) {
    var err = faceSDK.id3FaceTemplateList_Resize(_pHandle.value, newSize);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

}

class FaceTemplateListIterator implements Iterator<FaceTemplate> {
  FaceTemplateListIterator(this._list) : _count = _list.getCount();
  final FaceTemplateList _list;
  final int _count;
  int _index = -1;

  @override
  FaceTemplate get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
