//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents some glasses attributes.
class GlassesAttributes {
  final Pointer<id3FaceGlassesAttributes> _handle;

  static final Finalizer<Pointer<id3FaceGlassesAttributes>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FaceGlassesAttributes> get handle => _handle;

  id3FaceGlassesAttributes get struct => _handle.ref;

  /// Initializes a new instance of the GlassesAttributes class from its members.
  GlassesAttributes(this._handle);

  /// Create a new instance of the GlassesAttributes.
  GlassesAttributes.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the GlassesAttributes from the native struct
  GlassesAttributes.createFromStruct(id3FaceGlassesAttributes value) : _handle = calloc() {
    _handle.ref.FrameOnEye = value.FrameOnEye;
    _handle.ref.HeavyFrame = value.HeavyFrame;
    _handle.ref.TintedGlasses = value.TintedGlasses;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Value indicating if the glasses frame is not on the eyes.
  /// 0 means that there is no occlusion of the eye by the frame.
  /// Hint: The recommended value is under 10.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get frameOnEye => _handle.ref.FrameOnEye;
  set frameOnEye(int value) => _handle.ref.FrameOnEye = value;

  /// 
  /// Value, from 0 to 100, indicating if the glasses' frame is too heavy.
  /// 0 means that the frame is super thick.
  /// Hint: The recommended value is over 20.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get heavyFrame => _handle.ref.HeavyFrame;
  set heavyFrame(int value) => _handle.ref.HeavyFrame = value;

  /// 
  /// Value, from 0 to 100, indicating if the glasses are tinted.
  /// 100 means that the glasses are completely transparent.
  /// Hint: The recommended value is over 25.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get tintedGlasses => _handle.ref.TintedGlasses;
  set tintedGlasses(int value) => _handle.ref.TintedGlasses = value;


  Map<String, dynamic> toMap() {
    return {
        'frameOnEye': frameOnEye,
        'heavyFrame': heavyFrame,
        'tintedGlasses': tintedGlasses,
    };
  }
}
