//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';
import 'face_native.dart';

import '../id3_face.dart';

final _finalizer = NativeFinalizer(faceSDK.addresses.id3FaceImageBuffer_Dispose.cast());

/// Represents an image buffer.
class ImageBuffer implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3FaceImageBuffer>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3FaceImageBuffer> get handle => _pHandle.value;

  /// Creates a new instance of the ImageBuffer class.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  ImageBuffer() {
    _pHandle = calloc();
    try {
      var err = faceSDK.id3FaceImageBuffer_Initialize(_pHandle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the ImageBuffer class.
  ///
  /// param handle     Handle to the ImageBuffer.
  /// throws FaceException An error has occurred during Face Library execution.
  ImageBuffer.fromHandle(Pointer<id3FaceImageBuffer> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this ImageBuffer.
  void dispose() {
    if (_disposable) {
      faceSDK.id3FaceImageBuffer_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the ImageBuffer object.
  ///
  /// return The newly created ImageBuffer object.
  /// throws FaceException An error has occurred during Face Library execution.
  ImageBuffer clone() {
    ImageBuffer clone = ImageBuffer();
    var err = faceSDK.id3FaceImageBuffer_CopyTo(_pHandle.value, clone.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
    return clone;
  }


  // Public methods
  /// Gets the image buffer data.
  ///
  /// return Data of the image buffer object.
  /// throws FaceException An error has occurred during Face Library execution.
  Uint8List getData() {
    Pointer<UnsignedChar> pData = nullptr;
    Pointer<Int> pDataSize = calloc();
    pDataSize[0] = -1;
    try {
      var err = faceSDK.id3FaceImageBuffer_GetData(_pHandle.value, pData, pDataSize);
      if (err == FaceError.insufficientBuffer.value) {
        pData = calloc.allocate(pDataSize.value);
        err = faceSDK.id3FaceImageBuffer_GetData(_pHandle.value, pData, pDataSize);
      }
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vData = Uint8List.fromList(pData.cast<Uint8>().asTypedList(pDataSize.value));
      return vData;
    } finally {
      calloc.free(pData);
      calloc.free(pDataSize);
    }
  }

}

