//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the statuses of the presentation attack detection (PAD).
enum PadStatus {
	/// No decision could be made.
	unknown,
	/// The detected face is a bonafide (real face).
	bonafide,
	/// The detected face is an attack (spoof).
	attack,
}

extension PadStatusX on PadStatus {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created PadStatus.
  	static PadStatus fromValue(int value) {
    	switch (value) {
      	case 0:
        	return PadStatus.unknown;
      	case 1:
        	return PadStatus.bonafide;
      	case 2:
        	return PadStatus.attack;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case PadStatus.unknown:
        	return 0;
      	case PadStatus.bonafide:
        	return 1;
      	case PadStatus.attack:
        	return 2;
		}
  	}
}
