//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the photographic attributes of a portrait image.
class PhotographicAttributes {
  final Pointer<id3FacePhotographicAttributes> _handle;

  static final Finalizer<Pointer<id3FacePhotographicAttributes>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FacePhotographicAttributes> get handle => _handle;

  id3FacePhotographicAttributes get struct => _handle.ref;

  /// Initializes a new instance of the PhotographicAttributes class from its members.
  PhotographicAttributes(this._handle);

  /// Create a new instance of the PhotographicAttributes.
  PhotographicAttributes.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the PhotographicAttributes from the native struct
  PhotographicAttributes.createFromStruct(id3FacePhotographicAttributes value) : _handle = calloc() {
    _handle.ref.EqualBrightness = value.EqualBrightness;
    _handle.ref.FaceDynamicRange = value.FaceDynamicRange;
    _handle.ref.FlashReflection = value.FlashReflection;
    _handle.ref.NaturalSkinColor = value.NaturalSkinColor;
    _handle.ref.OverExposure = value.OverExposure;
    _handle.ref.Pixelation = value.Pixelation;
    _handle.ref.Sharpness = value.Sharpness;
    _handle.ref.UnderExposure = value.UnderExposure;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Value, from 0 to 100, indicating if one side of the face is ligther than the other side.
  /// 0 means that brightness is perfectly equal on both sides of the face.
  /// Hint: The recommended value is over 90.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get equalBrightness => _handle.ref.EqualBrightness;
  set equalBrightness(int value) => _handle.ref.EqualBrightness = value;

  /// 
  /// Value, from 0 to 255, indicating the dynamic range of the image in the face region.
  /// Hint: The recommended threshold is 110.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get faceDynamicRange => _handle.ref.FaceDynamicRange;
  set faceDynamicRange(int value) => _handle.ref.FaceDynamicRange = value;

  /// 
  /// Value, from 0 to 100, indicating if a flash reflection is present on the face.
  /// 100 means that there is no flash reflection.
  /// Hint: The recommended threshold is 70.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get flashReflection => _handle.ref.FlashReflection;
  set flashReflection(int value) => _handle.ref.FlashReflection = value;

  /// 
  /// Value, from 0 to 100, indicating if the skin looks natural.
  /// 0 means that the face does not have a natural skin color at all.
  /// Hint: The recommended threshold is over 5.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get naturalSkinColor => _handle.ref.NaturalSkinColor;
  set naturalSkinColor(int value) => _handle.ref.NaturalSkinColor = value;

  /// 
  /// Value, from 0 to 100, indicating the ratio of face pixels that are over-exposed.
  /// 0 means that the face is not over-exposed at all.
  /// Hint: The recommended value is under 50.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get overExposure => _handle.ref.OverExposure;
  set overExposure(int value) => _handle.ref.OverExposure = value;

  /// 
  /// Value, from 0 to 100, indicating if the image is pixelized.
  /// 0 means that there is no pixelation at all.
  /// Hint: The recommended value is under 50.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get pixelation => _handle.ref.Pixelation;
  set pixelation(int value) => _handle.ref.Pixelation = value;

  /// 
  /// Value, from 0 to 100, indicating if the image sharpness is sufficient.
  /// 0 means that the image is not sharp at all.
  /// Hint: The recommended value is over 40.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get sharpness => _handle.ref.Sharpness;
  set sharpness(int value) => _handle.ref.Sharpness = value;

  /// 
  /// Value, from 0 to 100, indicating the ratio of face pixels that are under-exposed.
  /// 0 means that the face is not under-exposed at all.
  /// Hint: The recommended value is under 50.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get underExposure => _handle.ref.UnderExposure;
  set underExposure(int value) => _handle.ref.UnderExposure = value;


  Map<String, dynamic> toMap() {
    return {
        'equalBrightness': equalBrightness,
        'faceDynamicRange': faceDynamicRange,
        'flashReflection': flashReflection,
        'naturalSkinColor': naturalSkinColor,
        'overExposure': overExposure,
        'pixelation': pixelation,
        'sharpness': sharpness,
        'underExposure': underExposure,
    };
  }
}
