//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';
import 'face_native.dart';

import '../id3_face.dart';

final _finalizer = NativeFinalizer(faceSDK.addresses.id3FacePointList_Dispose.cast());

/// Represents a point list.
class PointList extends Object with IterableMixin<Point> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3FacePointList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3FacePointList> get handle => _pHandle.value;

  /// Creates a new instance of the PointList class.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  PointList() {
    _pHandle = calloc();
    try {
      var err = faceSDK.id3FacePointList_Initialize(_pHandle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the PointList class.
  ///
  /// param handle     Handle to the PointList.
  /// throws FaceException An error has occurred during Face Library execution.
  PointList.fromHandle(Pointer<id3FacePointList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this PointList.
  void dispose() {
    if (_disposable) {
      faceSDK.id3FacePointList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the PointList object.
  ///
  /// return The newly created PointList object.
  /// throws FaceException An error has occurred during Face Library execution.
  PointList clone() {
    PointList clone = PointList();
    var err = faceSDK.id3FacePointList_CopyTo(_pHandle.value, clone.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);
  operator []=(int key, Point item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<Point> get iterator => PointListIterator(this);

  // Public methods
  /// Clears the PointList object.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  void clear() {
    var err = faceSDK.id3FacePointList_Clear(_pHandle.value);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Adds an item to the PointList object.
  ///
  /// param pointItem Point item to add.
  /// throws FaceException An error has occurred during Face Library execution.
  void add(Point pointItem) {
    var err = faceSDK.id3FacePointList_Add(_pHandle.value, pointItem.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets an item of the PointList object.
  ///
  /// param index Index of the Point item to get.
  /// return Point item to get.
  /// throws FaceException An error has occurred during Face Library execution.
  Point get(int index) {
    Pointer<id3FacePoint> pPointItem = calloc();
    var err = faceSDK.id3FacePointList_Get(_pHandle.value, index, pPointItem);
    if (err != FaceError.success.value) {
    	calloc.free(pPointItem);
    	throw FaceException(err);
    }
    return Point(pPointItem);
  }

  /// Sets an item of the PointList object.
  ///
  /// param index Index of the Point item to set.
  /// param pointItem Point item to set.
  /// throws FaceException An error has occurred during Face Library execution.
  void set(int index, Point pointItem) {
    var err = faceSDK.id3FacePointList_Set(_pHandle.value, index, pointItem.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the number of elements in the PointList object.
  ///
  /// return Number of elements in the Point object.
  /// throws FaceException An error has occurred during Face Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = faceSDK.id3FacePointList_GetCount(_pHandle.value, pCount);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Removes an element of the PointList object.
  ///
  /// param index Index of the Point item to remove.
  /// throws FaceException An error has occurred during Face Library execution.
  void removeAt(int index) {
    var err = faceSDK.id3FacePointList_RemoveAt(_pHandle.value, index);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// PointList object.
  ///
  /// param newSize Point object.
  /// throws FaceException An error has occurred during Face Library execution.
  void resize(int newSize) {
    var err = faceSDK.id3FacePointList_Resize(_pHandle.value, newSize);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

}

class PointListIterator implements Iterator<Point> {
  PointListIterator(this._list) : _count = _list.getCount();
  final PointList _list;
  final int _count;
  int _index = -1;

  @override
  Point get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
