//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';
import 'face_native.dart';

import '../id3_face.dart';

final _finalizer = NativeFinalizer(faceSDK.addresses.id3FacePortraitProcessor_Dispose.cast());

/// Facilitates the creation of portraits in various scenarios such as enrolment or face verification.
class PortraitProcessor implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3FacePortraitProcessor>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3FacePortraitProcessor> get handle => _pHandle.value;

  /// Creates a new instance of the PortraitProcessor class.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  PortraitProcessor() {
    _pHandle = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_Initialize(_pHandle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the PortraitProcessor class.
  ///
  /// param handle     Handle to the PortraitProcessor.
  /// throws FaceException An error has occurred during Face Library execution.
  PortraitProcessor.fromHandle(Pointer<id3FacePortraitProcessor> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this PortraitProcessor.
  void dispose() {
    if (_disposable) {
      faceSDK.id3FacePortraitProcessor_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }


  ///
  /// Background color uniformity threshold.
  /// If the score is above this value, the background color of the image is definitely uniform.
  /// Hint: Default value is 80.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get backgroundColorUniformityThreshold => getBackgroundColorUniformityThreshold();
  set backgroundColorUniformityThreshold(int value) => setBackgroundColorUniformityThreshold(value);

  ///
  /// Background structure uniformity threshold.
  /// If the score is above this value, the background structure of the image is definitely uniform.
  /// Hint: Default value is 80.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get backgroundStructureUniformityThreshold => getBackgroundStructureUniformityThreshold();
  set backgroundStructureUniformityThreshold(int value) => setBackgroundStructureUniformityThreshold(value);

  ///
  /// Aspect ratio (height to width) of the cropped portrait image.
  /// Hint: Default value is 4/3.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  double get cropAspectRatio => getCropAspectRatio();
  set cropAspectRatio(double value) => setCropAspectRatio(value);

  ///
  /// Ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range ]0;1[.
  /// Hint: Default value is 0.45.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  double get cropEyePositionRatio => getCropEyePositionRatio();
  set cropEyePositionRatio(double value) => setCropEyePositionRatio(value);

  ///
  /// Ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range ]0;1[.
  /// Hint: Default value is 0.25.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  double get cropIodRatio => getCropIodRatio();
  set cropIodRatio(double value) => setCropIodRatio(value);

  ///
  /// Relative margin around the face for basic portrait cropping.
  /// Hint: Default value is 0.5.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  double get cropMargin => getCropMargin();
  set cropMargin(double value) => setCropMargin(value);

  ///
  /// Face dynamic range threshold.
  /// Above this threshold, the dynamic range of the image in the face region is good enough.
  /// Hint: Default value is 128.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get dynamicRangeThreshold => getDynamicRangeThreshold();
  set dynamicRangeThreshold(int value) => setDynamicRangeThreshold(value);

  ///
  /// Equal brightness threshold.
  /// Above this value, the face is equally exposed.
  /// Hint: Default value is 10.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get equalBrightnessThreshold => getEqualBrightnessThreshold();
  set equalBrightnessThreshold(int value) => setEqualBrightnessThreshold(value);

  ///
  /// Sensibility of the expression classifier.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be less likely to estimate neutral expression out of the detected face.
  /// Hint: Default value is 60.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get expressionSensibility => getExpressionSensibility();
  set expressionSensibility(int value) => setExpressionSensibility(value);

  ///
  /// Visible eye threshold.
  /// If the score is above this value, the eye is probably occluded.
  /// Hint: Default value 80.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get eyeOcclusionThreshold => getEyeOcclusionThreshold();
  set eyeOcclusionThreshold(int value) => setEyeOcclusionThreshold(value);

  ///
  /// Eye opening threshold.
  /// If the score is above this value, the eyes are definitely open.
  /// Hint: Default value is 5.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get eyeOpeningThreshold => getEyeOpeningThreshold();
  set eyeOpeningThreshold(int value) => setEyeOpeningThreshold(value);

  ///
  /// The size, in pixels, of the downscaled image used for face detection.
  /// Hint: Default value is 256. Low values tend to ignore small faces in the input image, while higher values tend to take longer to process.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get faceDetectionImageSize => getFaceDetectionImageSize();
  set faceDetectionImageSize(int value) => setFaceDetectionImageSize(value);

  ///
  /// Specifies the model used to detect and track faces.
  /// Hint: Default value is ``FaceDetector4B``. Some better accuracy/speed balances can be found by choosing another model.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  FaceModel get faceDetectionModel => getFaceDetectionModel();
  set faceDetectionModel(FaceModel value) => setFaceDetectionModel(value);

  ///
  /// Specifies the face detection confidence threshold, in the range is [0;100].
  /// Hint: Default value is 50. Setting a high threshold reduces false detections but may increase the number of undetected faces.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get faceDetectionThreshold => getFaceDetectionThreshold();
  set faceDetectionThreshold(int value) => setFaceDetectionThreshold(value);

  ///
  /// Model used to create features and assess consistancy among views of a given face.
  /// Hint: Default value is ``FaceEncoder9B``. Some better accuracy/speed balances can be found by choosing another model.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  FaceModel get faceEncodingModel => getFaceEncodingModel();
  set faceEncodingModel(FaceModel value) => setFaceEncodingModel(value);

  ///
  /// Face mask detection threshold.
  /// If the detection score is above this value, the person is probably wearing a mask.
  /// Hint: Default value is 35.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get faceMaskThreshold => getFaceMaskThreshold();
  set faceMaskThreshold(int value) => setFaceMaskThreshold(value);

  ///
  /// Glasses detection threshold.
  /// If the score is above this value, the person is probably wearing glasses.
  /// Hint: Default value 90.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get glassesThreshold => getGlassesThreshold();
  set glassesThreshold(int value) => setGlassesThreshold(value);

  ///
  /// Threshold for confirming that the person is wearing a hat.
  /// Hint: Default value is 98.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get hatThreshold => getHatThreshold();
  set hatThreshold(int value) => setHatThreshold(value);

  ///
  /// Make-up detection threshold.
  /// If the detection score is above this value, the persone is definitely wearing make-up.
  /// Hint: Default value 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get makeupThreshold => getMakeupThreshold();
  set makeupThreshold(int value) => setMakeupThreshold(value);

  ///
  /// Male gender detection threshold.
  /// If the score is higher than this value, the person is probably male.
  /// Hint: Default value is 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maleThreshold => getMaleThreshold();
  set maleThreshold(int value) => setMaleThreshold(value);

  ///
  /// Maximum value of the eye gaze alongside the X axis.
  /// Hint: Default value is 10.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maximumEyeGazeX => getMaximumEyeGazeX();
  set maximumEyeGazeX(int value) => setMaximumEyeGazeX(value);

  ///
  /// Maximum value of the eye gaze alongside the Y axis.
  /// Hint: Default value is 10.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maximumEyeGazeY => getMaximumEyeGazeY();
  set maximumEyeGazeY(int value) => setMaximumEyeGazeY(value);

  ///
  /// Maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 90.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maximumHeadHeightRatio => getMaximumHeadHeightRatio();
  set maximumHeadHeightRatio(int value) => setMaximumHeadHeightRatio(value);

  ///
  /// Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 75.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maximumHeadWidthRatio => getMaximumHeadWidthRatio();
  set maximumHeadWidthRatio(int value) => setMaximumHeadWidthRatio(value);

  ///
  /// Value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 55.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maximumHorizontalPosition => getMaximumHorizontalPosition();
  set maximumHorizontalPosition(int value) => setMaximumHorizontalPosition(value);

  ///
  /// Maximum interocular distance (IOD), in pixels.
  /// This parameter is used to prevent the subject from being too close to the camera.
  /// Hint: Default value is 512.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maximumIod => getMaximumIod();
  set maximumIod(int value) => setMaximumIod(value);

  ///
  /// Maximum head pitch angle, in degrees, for frontal positioning.
  /// Hint: Default value is 20.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  double get maximumPitchAngle => getMaximumPitchAngle();
  set maximumPitchAngle(double value) => setMaximumPitchAngle(value);

  ///
  /// Maximum head roll angle, in degrees, for frontal positioning.
  /// Hint: Default value is 15.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  double get maximumRollAngle => getMaximumRollAngle();
  set maximumRollAngle(double value) => setMaximumRollAngle(value);

  ///
  /// Maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get maximumVerticalPosition => getMaximumVerticalPosition();
  set maximumVerticalPosition(int value) => setMaximumVerticalPosition(value);

  ///
  /// Maximum head yaw angle, in degrees, for frontal positioning.
  /// Hint: Default value is 8.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  double get maximumYawAngle => getMaximumYawAngle();
  set maximumYawAngle(double value) => setMaximumYawAngle(value);

  ///
  /// Minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 60.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get minimumHeadHeightRatio => getMinimumHeadHeightRatio();
  set minimumHeadHeightRatio(int value) => setMinimumHeadHeightRatio(value);

  ///
  /// Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get minimumHeadWidthRatio => getMinimumHeadWidthRatio();
  set minimumHeadWidthRatio(int value) => setMinimumHeadWidthRatio(value);

  ///
  /// Value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 45.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get minimumHorizontalPosition => getMinimumHorizontalPosition();
  set minimumHorizontalPosition(int value) => setMinimumHorizontalPosition(value);

  ///
  /// Minimum intra-occular distance, in pixels.
  /// This parameter is used to the limit the distance from the subject to the camera.
  /// Hint: Default value is 0.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get minimumIod => getMinimumIod();
  set minimumIod(int value) => setMinimumIod(value);

  ///
  /// Minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 30.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get minimumVerticalPosition => getMinimumVerticalPosition();
  set minimumVerticalPosition(int value) => setMinimumVerticalPosition(value);

  ///
  /// Mouth occlusion threshold. 
  /// If the mouth occlusion score is above this value, the mouth is probably occluded.
  /// Hint: Default value 70.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get mouthOcclusionThreshold => getMouthOcclusionThreshold();
  set mouthOcclusionThreshold(int value) => setMouthOcclusionThreshold(value);

  ///
  /// Mouth opening threshold.
  /// If the mouth opening score is above this value, the mouth of detected face is definitely open.
  /// Hint: Default value is 35.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get mouthOpenThreshold => getMouthOpenThreshold();
  set mouthOpenThreshold(int value) => setMouthOpenThreshold(value);

  ///
  /// Natural skin color threshold.
  /// Above this threshold, th skin of the person looks natural.
  /// Hint: Default value is 5.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get naturalSkinColorThreshold => getNaturalSkinColorThreshold();
  set naturalSkinColorThreshold(int value) => setNaturalSkinColorThreshold(value);

  ///
  /// Flash reflexion detection threshold.
  /// Above this threshold, the flash reflexion is probably present on the face.
  /// Hint: Default value is 70.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get noFlashReflectionThreshold => getNoFlashReflectionThreshold();
  set noFlashReflectionThreshold(int value) => setNoFlashReflectionThreshold(value);

  ///
  /// Threshold for confirming the presence of noise in the image.
  /// Hint: Default value is 90.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get noiseThreshold => getNoiseThreshold();
  set noiseThreshold(int value) => setNoiseThreshold(value);

  ///
  /// Nose occlusion threshold. 
  /// If the score is above this value, the nose is probably occluded.
  /// Hint: Default value 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get noseOcclusionThreshold => getNoseOcclusionThreshold();
  set noseOcclusionThreshold(int value) => setNoseOcclusionThreshold(value);

  ///
  /// Over exposure threshold.
  /// Above this threshold, the ratio of face pixels are over-exposed. 
  /// Hint: Default value is 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get overExposureThreshold => getOverExposureThreshold();
  set overExposureThreshold(int value) => setOverExposureThreshold(value);

  ///
  /// Presentation attack detection threshold, from 0 to 100.
  /// Higher values enable more attacks to be detected, but may reduce ease of use.
  /// Hint: Default value 95.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get padThreshold => getPadThreshold();
  set padThreshold(int value) => setPadThreshold(value);

  ///
  /// Pixelation detection threshold.
  /// Above this threshold, the image is probably pixelated.
  /// Hint: Default value is 90.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get pixelationThreshold => getPixelationThreshold();
  set pixelationThreshold(int value) => setPixelationThreshold(value);

  ///
  /// Threshold for confirming the presence of red eyes.
  /// Hint: Default value is 10.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get redEyeThreshold => getRedEyeThreshold();
  set redEyeThreshold(int value) => setRedEyeThreshold(value);

  ///
  /// Threshold indicating whether the image resolution is sufficient.
  /// Hint: Default value is 90.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get resolutionThreshold => getResolutionThreshold();
  set resolutionThreshold(int value) => setResolutionThreshold(value);

  ///
  /// Sharpness threshold. 
  /// If the sharpness score is above this value, the image sharpness is sufficient.
  /// Hint: Default value is 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get sharpnessThreshold => getSharpnessThreshold();
  set sharpnessThreshold(int value) => setSharpnessThreshold(value);

  ///
  /// Smile threshold.
  /// If the Smile score is above this value, the detected face is definitely smiling.
  /// Hint: Default value is 75.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get smileThreshold => getSmileThreshold();
  set smileThreshold(int value) => setSmileThreshold(value);

  ///
  /// Number of threads to be used for portrait processing.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get threadCount => getThreadCount();
  set threadCount(int value) => setThreadCount(value);

  ///
  /// Tinted glass detection threshold.
  /// If the score is above this value, the person is definitely wearing tinted glasses.
  /// Hint: Default value 25.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get tintedGlassThreshold => getTintedGlassThreshold();
  set tintedGlassThreshold(int value) => setTintedGlassThreshold(value);

  ///
  /// Minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// Hint: Default value is 3000 which corresponds to a False Match Rate of 1/1000.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get trackerMatchingThreshold => getTrackerMatchingThreshold();
  set trackerMatchingThreshold(int value) => setTrackerMatchingThreshold(value);

  ///
  /// Maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// Hint: Default value is 2. One must adapt this value to its needs in terms of tracker identity memory (in seconds) and measured frame rate on target platform.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get trackerMaximumFaceAge => getTrackerMaximumFaceAge();
  set trackerMaximumFaceAge(int value) => setTrackerMaximumFaceAge(value);

  ///
  /// Minimum number of consecutive detections to reach before creating a tracked face.
  /// Hint: Default value is 1 for ``FaceDetector4B`` since the false detection rate is low enough. If using a less accurate detector (such as FaceDetector3C) one might consider increasing a bit this value to avoid false tracks. 
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get trackerMinimumFaceAge => getTrackerMinimumFaceAge();
  set trackerMinimumFaceAge(int value) => setTrackerMinimumFaceAge(value);

  ///
  /// Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range [0;100].
  /// Hint: Default value is 0. Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get trackerNmsIouThreshold => getTrackerNmsIouThreshold();
  set trackerNmsIouThreshold(int value) => setTrackerNmsIouThreshold(value);

  ///
  /// Under exposure threshold.
  /// Above this threshold, the face is probably under-exposed.
  /// Hint: Default value is 50.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  int get underExposureThreshold => getUnderExposureThreshold();
  set underExposureThreshold(int value) => setUnderExposureThreshold(value);

  // Public methods
  /// Gets the background color uniformity threshold.
  /// If the score is above this value, the background color of the image is definitely uniform.
  /// Hint: Default value is 80.
  ///
  /// return Background color uniformity threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getBackgroundColorUniformityThreshold() {
    Pointer<Int> pBackgroundColorUniformityThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetBackgroundColorUniformityThreshold(_pHandle.value, pBackgroundColorUniformityThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vBackgroundColorUniformityThreshold = pBackgroundColorUniformityThreshold.value;
      return vBackgroundColorUniformityThreshold;
    } finally {
      calloc.free(pBackgroundColorUniformityThreshold);
    }
  }

  /// Sets the background color uniformity threshold.
  /// If the score is above this value, the background color of the image is definitely uniform.
  /// Hint: Default value is 80.
  ///
  /// param backgroundColorUniformityThreshold Background color uniformity threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setBackgroundColorUniformityThreshold(int backgroundColorUniformityThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetBackgroundColorUniformityThreshold(_pHandle.value, backgroundColorUniformityThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the background structure uniformity threshold.
  /// If the score is above this value, the background structure of the image is definitely uniform.
  /// Hint: Default value is 80.
  ///
  /// return Background structure uniformity threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getBackgroundStructureUniformityThreshold() {
    Pointer<Int> pBackgroundStructureUniformityThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetBackgroundStructureUniformityThreshold(_pHandle.value, pBackgroundStructureUniformityThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vBackgroundStructureUniformityThreshold = pBackgroundStructureUniformityThreshold.value;
      return vBackgroundStructureUniformityThreshold;
    } finally {
      calloc.free(pBackgroundStructureUniformityThreshold);
    }
  }

  /// Sets the background structure uniformity threshold.
  /// If the score is above this value, the background structure of the image is definitely uniform.
  /// Hint: Default value is 80.
  ///
  /// param backgroundStructureUniformityThreshold Background structure uniformity threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setBackgroundStructureUniformityThreshold(int backgroundStructureUniformityThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetBackgroundStructureUniformityThreshold(_pHandle.value, backgroundStructureUniformityThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the aspect ratio (height to width) of the cropped portrait image.
  /// Hint: Default value is 4/3.
  ///
  /// return Aspect ratio (height to width) of the cropped portrait image.
  /// throws FaceException An error has occurred during Face Library execution.
  double getCropAspectRatio() {
    Pointer<Float> pCropAspectRatio = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetCropAspectRatio(_pHandle.value, pCropAspectRatio);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCropAspectRatio = pCropAspectRatio.value;
      return vCropAspectRatio;
    } finally {
      calloc.free(pCropAspectRatio);
    }
  }

  /// Sets the aspect ratio (height to width) of the cropped portrait image.
  /// Hint: Default value is 4/3.
  ///
  /// param cropAspectRatio Aspect ratio (height to width) of the cropped portrait image.
  /// throws FaceException An error has occurred during Face Library execution.
  void setCropAspectRatio(double cropAspectRatio) {
    var err = faceSDK.id3FacePortraitProcessor_SetCropAspectRatio(_pHandle.value, cropAspectRatio);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range )0;1(.
  /// Hint: Default value is 0.45.
  ///
  /// return Ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range )0;1(.
  /// throws FaceException An error has occurred during Face Library execution.
  double getCropEyePositionRatio() {
    Pointer<Float> pCropEyePositionRatio = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetCropEyePositionRatio(_pHandle.value, pCropEyePositionRatio);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCropEyePositionRatio = pCropEyePositionRatio.value;
      return vCropEyePositionRatio;
    } finally {
      calloc.free(pCropEyePositionRatio);
    }
  }

  /// Sets the ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range )0;1(.
  /// Hint: Default value is 0.45.
  ///
  /// param cropEyePositionRatio Ratio between the vertical eye position and the image height for ICAO portrait cropping. Must be in the range )0;1(.
  /// throws FaceException An error has occurred during Face Library execution.
  void setCropEyePositionRatio(double cropEyePositionRatio) {
    var err = faceSDK.id3FacePortraitProcessor_SetCropEyePositionRatio(_pHandle.value, cropEyePositionRatio);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range )0;1(.
  /// Hint: Default value is 0.25.
  ///
  /// return Ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range )0;1(.
  /// throws FaceException An error has occurred during Face Library execution.
  double getCropIodRatio() {
    Pointer<Float> pCropIodRatio = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetCropIodRatio(_pHandle.value, pCropIodRatio);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCropIodRatio = pCropIodRatio.value;
      return vCropIodRatio;
    } finally {
      calloc.free(pCropIodRatio);
    }
  }

  /// Sets the ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range )0;1(.
  /// Hint: Default value is 0.25.
  ///
  /// param cropIodRatio Ratio between the interocular distance (IOD) and the image width for ICAO portrait cropping. Must be in the range )0;1(.
  /// throws FaceException An error has occurred during Face Library execution.
  void setCropIodRatio(double cropIodRatio) {
    var err = faceSDK.id3FacePortraitProcessor_SetCropIodRatio(_pHandle.value, cropIodRatio);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the relative margin around the face for basic portrait cropping.
  /// Hint: Default value is 0.5.
  ///
  /// return Relative margin around the face for basic portrait cropping.
  /// throws FaceException An error has occurred during Face Library execution.
  double getCropMargin() {
    Pointer<Float> pCropMargin = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetCropMargin(_pHandle.value, pCropMargin);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vCropMargin = pCropMargin.value;
      return vCropMargin;
    } finally {
      calloc.free(pCropMargin);
    }
  }

  /// Sets the relative margin around the face for basic portrait cropping.
  /// Hint: Default value is 0.5.
  ///
  /// param cropMargin Relative margin around the face for basic portrait cropping.
  /// throws FaceException An error has occurred during Face Library execution.
  void setCropMargin(double cropMargin) {
    var err = faceSDK.id3FacePortraitProcessor_SetCropMargin(_pHandle.value, cropMargin);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the face dynamic range threshold.
  /// Above this threshold, the dynamic range of the image in the face region is good enough.
  /// Hint: Default value is 128.
  ///
  /// return Face dynamic range threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getDynamicRangeThreshold() {
    Pointer<Int> pDynamicRangeThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetDynamicRangeThreshold(_pHandle.value, pDynamicRangeThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vDynamicRangeThreshold = pDynamicRangeThreshold.value;
      return vDynamicRangeThreshold;
    } finally {
      calloc.free(pDynamicRangeThreshold);
    }
  }

  /// Sets the face dynamic range threshold.
  /// Above this threshold, the dynamic range of the image in the face region is good enough.
  /// Hint: Default value is 128.
  ///
  /// param dynamicRangeThreshold Face dynamic range threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setDynamicRangeThreshold(int dynamicRangeThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetDynamicRangeThreshold(_pHandle.value, dynamicRangeThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the equal brightness threshold.
  /// Above this value, the face is equally exposed.
  /// Hint: Default value is 10.
  ///
  /// return Equal brightness threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getEqualBrightnessThreshold() {
    Pointer<Int> pEqualBrightnessThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetEqualBrightnessThreshold(_pHandle.value, pEqualBrightnessThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vEqualBrightnessThreshold = pEqualBrightnessThreshold.value;
      return vEqualBrightnessThreshold;
    } finally {
      calloc.free(pEqualBrightnessThreshold);
    }
  }

  /// Sets the equal brightness threshold.
  /// Above this value, the face is equally exposed.
  /// Hint: Default value is 10.
  ///
  /// param equalBrightnessThreshold Equal brightness threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setEqualBrightnessThreshold(int equalBrightnessThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetEqualBrightnessThreshold(_pHandle.value, equalBrightnessThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the sensibility of the expression classifier.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be less likely to estimate neutral expression out of the detected face.
  /// Hint: Default value is 60.
  ///
  /// return Sensibility of the expression classifier.
  /// throws FaceException An error has occurred during Face Library execution.
  int getExpressionSensibility() {
    Pointer<Int> pExpressionSensibility = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetExpressionSensibility(_pHandle.value, pExpressionSensibility);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vExpressionSensibility = pExpressionSensibility.value;
      return vExpressionSensibility;
    } finally {
      calloc.free(pExpressionSensibility);
    }
  }

  /// Sets the sensibility of the expression classifier.
  /// The higher the value, the more sensitive the algorithm will be, meaning that it will be less likely to estimate neutral expression out of the detected face.
  /// Hint: Default value is 60.
  ///
  /// param expressionSensibility Sensibility of the expression classifier.
  /// throws FaceException An error has occurred during Face Library execution.
  void setExpressionSensibility(int expressionSensibility) {
    var err = faceSDK.id3FacePortraitProcessor_SetExpressionSensibility(_pHandle.value, expressionSensibility);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the visible eye threshold.
  /// If the score is above this value, the eye is probably occluded.
  /// Hint: Default value 80.
  ///
  /// return Visible eye threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getEyeOcclusionThreshold() {
    Pointer<Int> pEyeOcclusionThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetEyeOcclusionThreshold(_pHandle.value, pEyeOcclusionThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vEyeOcclusionThreshold = pEyeOcclusionThreshold.value;
      return vEyeOcclusionThreshold;
    } finally {
      calloc.free(pEyeOcclusionThreshold);
    }
  }

  /// Sets the visible eye threshold.
  /// If the score is above this value, the eye is probably occluded.
  /// Hint: Default value 80.
  ///
  /// param eyeOcclusionThreshold Visible eye threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setEyeOcclusionThreshold(int eyeOcclusionThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetEyeOcclusionThreshold(_pHandle.value, eyeOcclusionThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the eye opening threshold.
  /// If the score is above this value, the eyes are definitely open.
  /// Hint: Default value is 5.
  ///
  /// return Eye opening threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getEyeOpeningThreshold() {
    Pointer<Int> pEyeOpeningThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetEyeOpeningThreshold(_pHandle.value, pEyeOpeningThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vEyeOpeningThreshold = pEyeOpeningThreshold.value;
      return vEyeOpeningThreshold;
    } finally {
      calloc.free(pEyeOpeningThreshold);
    }
  }

  /// Sets the eye opening threshold.
  /// If the score is above this value, the eyes are definitely open.
  /// Hint: Default value is 5.
  ///
  /// param eyeOpeningThreshold Eye opening threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setEyeOpeningThreshold(int eyeOpeningThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetEyeOpeningThreshold(_pHandle.value, eyeOpeningThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the the size, in pixels, of the downscaled image used for face detection.
  /// Hint: Default value is 256. Low values tend to ignore small faces in the input image, while higher values tend to take longer to process.
  ///
  /// return The size, in pixels, of the downscaled image used for face detection.
  /// throws FaceException An error has occurred during Face Library execution.
  int getFaceDetectionImageSize() {
    Pointer<Int> pFaceDetectionImageSize = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetFaceDetectionImageSize(_pHandle.value, pFaceDetectionImageSize);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vFaceDetectionImageSize = pFaceDetectionImageSize.value;
      return vFaceDetectionImageSize;
    } finally {
      calloc.free(pFaceDetectionImageSize);
    }
  }

  /// Sets the the size, in pixels, of the downscaled image used for face detection.
  /// Hint: Default value is 256. Low values tend to ignore small faces in the input image, while higher values tend to take longer to process.
  ///
  /// param faceDetectionImageSize The size, in pixels, of the downscaled image used for face detection.
  /// throws FaceException An error has occurred during Face Library execution.
  void setFaceDetectionImageSize(int faceDetectionImageSize) {
    var err = faceSDK.id3FacePortraitProcessor_SetFaceDetectionImageSize(_pHandle.value, faceDetectionImageSize);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the specifies the model used to detect and track faces.
  /// Hint: Default value is ``FaceDetector4B``. Some better accuracy/speed balances can be found by choosing another model.
  ///
  /// return Specifies the model used to detect and track faces.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceModel getFaceDetectionModel() {
    Pointer<Int32> pFaceDetectionModel = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetFaceDetectionModel(_pHandle.value, pFaceDetectionModel);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vFaceDetectionModel = FaceModelX.fromValue(pFaceDetectionModel.value);
      return vFaceDetectionModel;
    } finally {
      calloc.free(pFaceDetectionModel);
    }
  }

  /// Sets the specifies the model used to detect and track faces.
  /// Hint: Default value is ``FaceDetector4B``. Some better accuracy/speed balances can be found by choosing another model.
  ///
  /// param faceDetectionModel Specifies the model used to detect and track faces.
  /// throws FaceException An error has occurred during Face Library execution.
  void setFaceDetectionModel(FaceModel faceDetectionModel) {
    var err = faceSDK.id3FacePortraitProcessor_SetFaceDetectionModel(_pHandle.value, faceDetectionModel.value);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the specifies the face detection confidence threshold, in the range is (0;100).
  /// Hint: Default value is 50. Setting a high threshold reduces false detections but may increase the number of undetected faces.
  ///
  /// return Specifies the face detection confidence threshold, in the range is (0;100).
  /// throws FaceException An error has occurred during Face Library execution.
  int getFaceDetectionThreshold() {
    Pointer<Int> pFaceDetectionThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetFaceDetectionThreshold(_pHandle.value, pFaceDetectionThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vFaceDetectionThreshold = pFaceDetectionThreshold.value;
      return vFaceDetectionThreshold;
    } finally {
      calloc.free(pFaceDetectionThreshold);
    }
  }

  /// Sets the specifies the face detection confidence threshold, in the range is (0;100).
  /// Hint: Default value is 50. Setting a high threshold reduces false detections but may increase the number of undetected faces.
  ///
  /// param faceDetectionThreshold Specifies the face detection confidence threshold, in the range is (0;100).
  /// throws FaceException An error has occurred during Face Library execution.
  void setFaceDetectionThreshold(int faceDetectionThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetFaceDetectionThreshold(_pHandle.value, faceDetectionThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the model used to create features and assess consistancy among views of a given face.
  /// Hint: Default value is ``FaceEncoder9B``. Some better accuracy/speed balances can be found by choosing another model.
  ///
  /// return Model used to create features and assess consistancy among views of a given face.
  /// throws FaceException An error has occurred during Face Library execution.
  FaceModel getFaceEncodingModel() {
    Pointer<Int32> pFaceEncodingModel = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetFaceEncodingModel(_pHandle.value, pFaceEncodingModel);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vFaceEncodingModel = FaceModelX.fromValue(pFaceEncodingModel.value);
      return vFaceEncodingModel;
    } finally {
      calloc.free(pFaceEncodingModel);
    }
  }

  /// Sets the model used to create features and assess consistancy among views of a given face.
  /// Hint: Default value is ``FaceEncoder9B``. Some better accuracy/speed balances can be found by choosing another model.
  ///
  /// param faceEncodingModel Model used to create features and assess consistancy among views of a given face.
  /// throws FaceException An error has occurred during Face Library execution.
  void setFaceEncodingModel(FaceModel faceEncodingModel) {
    var err = faceSDK.id3FacePortraitProcessor_SetFaceEncodingModel(_pHandle.value, faceEncodingModel.value);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the face mask detection threshold.
  /// If the detection score is above this value, the person is probably wearing a mask.
  /// Hint: Default value is 35.
  ///
  /// return Face mask detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getFaceMaskThreshold() {
    Pointer<Int> pFaceMaskThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetFaceMaskThreshold(_pHandle.value, pFaceMaskThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vFaceMaskThreshold = pFaceMaskThreshold.value;
      return vFaceMaskThreshold;
    } finally {
      calloc.free(pFaceMaskThreshold);
    }
  }

  /// Sets the face mask detection threshold.
  /// If the detection score is above this value, the person is probably wearing a mask.
  /// Hint: Default value is 35.
  ///
  /// param faceMaskThreshold Face mask detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setFaceMaskThreshold(int faceMaskThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetFaceMaskThreshold(_pHandle.value, faceMaskThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the glasses detection threshold.
  /// If the score is above this value, the person is probably wearing glasses.
  /// Hint: Default value 90.
  ///
  /// return Glasses detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getGlassesThreshold() {
    Pointer<Int> pGlassesThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetGlassesThreshold(_pHandle.value, pGlassesThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vGlassesThreshold = pGlassesThreshold.value;
      return vGlassesThreshold;
    } finally {
      calloc.free(pGlassesThreshold);
    }
  }

  /// Sets the glasses detection threshold.
  /// If the score is above this value, the person is probably wearing glasses.
  /// Hint: Default value 90.
  ///
  /// param glassesThreshold Glasses detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setGlassesThreshold(int glassesThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetGlassesThreshold(_pHandle.value, glassesThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the threshold for confirming that the person is wearing a hat.
  /// Hint: Default value is 98.
  ///
  /// return Threshold for confirming that the person is wearing a hat.
  /// throws FaceException An error has occurred during Face Library execution.
  int getHatThreshold() {
    Pointer<Int> pHatThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetHatThreshold(_pHandle.value, pHatThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vHatThreshold = pHatThreshold.value;
      return vHatThreshold;
    } finally {
      calloc.free(pHatThreshold);
    }
  }

  /// Sets the threshold for confirming that the person is wearing a hat.
  /// Hint: Default value is 98.
  ///
  /// param hatThreshold Threshold for confirming that the person is wearing a hat.
  /// throws FaceException An error has occurred during Face Library execution.
  void setHatThreshold(int hatThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetHatThreshold(_pHandle.value, hatThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the make-up detection threshold.
  /// If the detection score is above this value, the persone is definitely wearing make-up.
  /// Hint: Default value 50.
  ///
  /// return Make-up detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMakeupThreshold() {
    Pointer<Int> pMakeupThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMakeupThreshold(_pHandle.value, pMakeupThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMakeupThreshold = pMakeupThreshold.value;
      return vMakeupThreshold;
    } finally {
      calloc.free(pMakeupThreshold);
    }
  }

  /// Sets the make-up detection threshold.
  /// If the detection score is above this value, the persone is definitely wearing make-up.
  /// Hint: Default value 50.
  ///
  /// param makeupThreshold Make-up detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMakeupThreshold(int makeupThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetMakeupThreshold(_pHandle.value, makeupThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the male gender detection threshold.
  /// If the score is higher than this value, the person is probably male.
  /// Hint: Default value is 50.
  ///
  /// return Male gender detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaleThreshold() {
    Pointer<Int> pMaleThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaleThreshold(_pHandle.value, pMaleThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaleThreshold = pMaleThreshold.value;
      return vMaleThreshold;
    } finally {
      calloc.free(pMaleThreshold);
    }
  }

  /// Sets the male gender detection threshold.
  /// If the score is higher than this value, the person is probably male.
  /// Hint: Default value is 50.
  ///
  /// param maleThreshold Male gender detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaleThreshold(int maleThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaleThreshold(_pHandle.value, maleThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum value of the eye gaze alongside the X axis.
  /// Hint: Default value is 10.
  ///
  /// return Maximum value of the eye gaze alongside the X axis.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaximumEyeGazeX() {
    Pointer<Int> pMaximumEyeGazeX = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumEyeGazeX(_pHandle.value, pMaximumEyeGazeX);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumEyeGazeX = pMaximumEyeGazeX.value;
      return vMaximumEyeGazeX;
    } finally {
      calloc.free(pMaximumEyeGazeX);
    }
  }

  /// Sets the maximum value of the eye gaze alongside the X axis.
  /// Hint: Default value is 10.
  ///
  /// param maximumEyeGazeX Maximum value of the eye gaze alongside the X axis.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumEyeGazeX(int maximumEyeGazeX) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumEyeGazeX(_pHandle.value, maximumEyeGazeX);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum value of the eye gaze alongside the Y axis.
  /// Hint: Default value is 10.
  ///
  /// return Maximum value of the eye gaze alongside the Y axis.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaximumEyeGazeY() {
    Pointer<Int> pMaximumEyeGazeY = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumEyeGazeY(_pHandle.value, pMaximumEyeGazeY);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumEyeGazeY = pMaximumEyeGazeY.value;
      return vMaximumEyeGazeY;
    } finally {
      calloc.free(pMaximumEyeGazeY);
    }
  }

  /// Sets the maximum value of the eye gaze alongside the Y axis.
  /// Hint: Default value is 10.
  ///
  /// param maximumEyeGazeY Maximum value of the eye gaze alongside the Y axis.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumEyeGazeY(int maximumEyeGazeY) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumEyeGazeY(_pHandle.value, maximumEyeGazeY);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 90.
  ///
  /// return Maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaximumHeadHeightRatio() {
    Pointer<Int> pMaximumHeadHeightRatio = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumHeadHeightRatio(_pHandle.value, pMaximumHeadHeightRatio);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumHeadHeightRatio = pMaximumHeadHeightRatio.value;
      return vMaximumHeadHeightRatio;
    } finally {
      calloc.free(pMaximumHeadHeightRatio);
    }
  }

  /// Sets the maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 90.
  ///
  /// param maximumHeadHeightRatio Maximum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumHeadHeightRatio(int maximumHeadHeightRatio) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumHeadHeightRatio(_pHandle.value, maximumHeadHeightRatio);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 75.
  ///
  /// return Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaximumHeadWidthRatio() {
    Pointer<Int> pMaximumHeadWidthRatio = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumHeadWidthRatio(_pHandle.value, pMaximumHeadWidthRatio);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumHeadWidthRatio = pMaximumHeadWidthRatio.value;
      return vMaximumHeadWidthRatio;
    } finally {
      calloc.free(pMaximumHeadWidthRatio);
    }
  }

  /// Sets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 75.
  ///
  /// param maximumHeadWidthRatio Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumHeadWidthRatio(int maximumHeadWidthRatio) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumHeadWidthRatio(_pHandle.value, maximumHeadWidthRatio);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 55.
  ///
  /// return Value indicating if the head is correctly centered horizontally.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaximumHorizontalPosition() {
    Pointer<Int> pMaximumHorizontalPosition = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumHorizontalPosition(_pHandle.value, pMaximumHorizontalPosition);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumHorizontalPosition = pMaximumHorizontalPosition.value;
      return vMaximumHorizontalPosition;
    } finally {
      calloc.free(pMaximumHorizontalPosition);
    }
  }

  /// Sets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 55.
  ///
  /// param maximumHorizontalPosition Value indicating if the head is correctly centered horizontally.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumHorizontalPosition(int maximumHorizontalPosition) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumHorizontalPosition(_pHandle.value, maximumHorizontalPosition);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum interocular distance (IOD), in pixels.
  /// This parameter is used to prevent the subject from being too close to the camera.
  /// Hint: Default value is 512.
  ///
  /// return Maximum interocular distance (IOD), in pixels.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaximumIod() {
    Pointer<Int> pMaximumIod = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumIod(_pHandle.value, pMaximumIod);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumIod = pMaximumIod.value;
      return vMaximumIod;
    } finally {
      calloc.free(pMaximumIod);
    }
  }

  /// Sets the maximum interocular distance (IOD), in pixels.
  /// This parameter is used to prevent the subject from being too close to the camera.
  /// Hint: Default value is 512.
  ///
  /// param maximumIod Maximum interocular distance (IOD), in pixels.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumIod(int maximumIod) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumIod(_pHandle.value, maximumIod);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum head pitch angle, in degrees, for frontal positioning.
  /// Hint: Default value is 20.
  ///
  /// return Maximum head pitch angle, in degrees, for frontal positioning.
  /// throws FaceException An error has occurred during Face Library execution.
  double getMaximumPitchAngle() {
    Pointer<Float> pMaximumPitchAngle = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumPitchAngle(_pHandle.value, pMaximumPitchAngle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumPitchAngle = pMaximumPitchAngle.value;
      return vMaximumPitchAngle;
    } finally {
      calloc.free(pMaximumPitchAngle);
    }
  }

  /// Sets the maximum head pitch angle, in degrees, for frontal positioning.
  /// Hint: Default value is 20.
  ///
  /// param maximumPitchAngle Maximum head pitch angle, in degrees, for frontal positioning.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumPitchAngle(double maximumPitchAngle) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumPitchAngle(_pHandle.value, maximumPitchAngle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum head roll angle, in degrees, for frontal positioning.
  /// Hint: Default value is 15.
  ///
  /// return Maximum head roll angle, in degrees, for frontal positioning.
  /// throws FaceException An error has occurred during Face Library execution.
  double getMaximumRollAngle() {
    Pointer<Float> pMaximumRollAngle = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumRollAngle(_pHandle.value, pMaximumRollAngle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumRollAngle = pMaximumRollAngle.value;
      return vMaximumRollAngle;
    } finally {
      calloc.free(pMaximumRollAngle);
    }
  }

  /// Sets the maximum head roll angle, in degrees, for frontal positioning.
  /// Hint: Default value is 15.
  ///
  /// param maximumRollAngle Maximum head roll angle, in degrees, for frontal positioning.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumRollAngle(double maximumRollAngle) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumRollAngle(_pHandle.value, maximumRollAngle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 50.
  ///
  /// return Maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMaximumVerticalPosition() {
    Pointer<Int> pMaximumVerticalPosition = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumVerticalPosition(_pHandle.value, pMaximumVerticalPosition);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumVerticalPosition = pMaximumVerticalPosition.value;
      return vMaximumVerticalPosition;
    } finally {
      calloc.free(pMaximumVerticalPosition);
    }
  }

  /// Sets the maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 50.
  ///
  /// param maximumVerticalPosition Maximum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumVerticalPosition(int maximumVerticalPosition) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumVerticalPosition(_pHandle.value, maximumVerticalPosition);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum head yaw angle, in degrees, for frontal positioning.
  /// Hint: Default value is 8.
  ///
  /// return Maximum head yaw angle, in degrees, for frontal positioning.
  /// throws FaceException An error has occurred during Face Library execution.
  double getMaximumYawAngle() {
    Pointer<Float> pMaximumYawAngle = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMaximumYawAngle(_pHandle.value, pMaximumYawAngle);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMaximumYawAngle = pMaximumYawAngle.value;
      return vMaximumYawAngle;
    } finally {
      calloc.free(pMaximumYawAngle);
    }
  }

  /// Sets the maximum head yaw angle, in degrees, for frontal positioning.
  /// Hint: Default value is 8.
  ///
  /// param maximumYawAngle Maximum head yaw angle, in degrees, for frontal positioning.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMaximumYawAngle(double maximumYawAngle) {
    var err = faceSDK.id3FacePortraitProcessor_SetMaximumYawAngle(_pHandle.value, maximumYawAngle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 60.
  ///
  /// return Minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMinimumHeadHeightRatio() {
    Pointer<Int> pMinimumHeadHeightRatio = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMinimumHeadHeightRatio(_pHandle.value, pMinimumHeadHeightRatio);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMinimumHeadHeightRatio = pMinimumHeadHeightRatio.value;
      return vMinimumHeadHeightRatio;
    } finally {
      calloc.free(pMinimumHeadHeightRatio);
    }
  }

  /// Sets the minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// For ICAO compliance, this distance must be in the range 60 to 90.
  /// Hint: Default value is 60.
  ///
  /// param minimumHeadHeightRatio Minimum distance between the base of the chin and the crown is less than 80% of the total height of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMinimumHeadHeightRatio(int minimumHeadHeightRatio) {
    var err = faceSDK.id3FacePortraitProcessor_SetMinimumHeadHeightRatio(_pHandle.value, minimumHeadHeightRatio);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 50.
  ///
  /// return Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMinimumHeadWidthRatio() {
    Pointer<Int> pMinimumHeadWidthRatio = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMinimumHeadWidthRatio(_pHandle.value, pMinimumHeadWidthRatio);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMinimumHeadWidthRatio = pMinimumHeadWidthRatio.value;
      return vMinimumHeadWidthRatio;
    } finally {
      calloc.free(pMinimumHeadWidthRatio);
    }
  }

  /// Sets the value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// The head width is defined as the distance between the left and right ears.
  /// For ICAO compliance, the value must be in the range 50 to 75.
  /// Hint: Default value is 50.
  ///
  /// param minimumHeadWidthRatio Value indicating if the image width is conform to the (image width / head width) ratio of 7:5.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMinimumHeadWidthRatio(int minimumHeadWidthRatio) {
    var err = faceSDK.id3FacePortraitProcessor_SetMinimumHeadWidthRatio(_pHandle.value, minimumHeadWidthRatio);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 45.
  ///
  /// return Value indicating if the head is correctly centered horizontally.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMinimumHorizontalPosition() {
    Pointer<Int> pMinimumHorizontalPosition = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMinimumHorizontalPosition(_pHandle.value, pMinimumHorizontalPosition);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMinimumHorizontalPosition = pMinimumHorizontalPosition.value;
      return vMinimumHorizontalPosition;
    } finally {
      calloc.free(pMinimumHorizontalPosition);
    }
  }

  /// Sets the value indicating if the head is correctly centered horizontally.
  /// For ICAO compliance, the value must be in the range 45 to 55.
  /// Hint: Default value is 45.
  ///
  /// param minimumHorizontalPosition Value indicating if the head is correctly centered horizontally.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMinimumHorizontalPosition(int minimumHorizontalPosition) {
    var err = faceSDK.id3FacePortraitProcessor_SetMinimumHorizontalPosition(_pHandle.value, minimumHorizontalPosition);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the minimum intra-occular distance, in pixels.
  /// This parameter is used to the limit the distance from the subject to the camera.
  /// Hint: Default value is 0.
  ///
  /// return Minimum intra-occular distance, in pixels.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMinimumIod() {
    Pointer<Int> pMinimumIod = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMinimumIod(_pHandle.value, pMinimumIod);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMinimumIod = pMinimumIod.value;
      return vMinimumIod;
    } finally {
      calloc.free(pMinimumIod);
    }
  }

  /// Sets the minimum intra-occular distance, in pixels.
  /// This parameter is used to the limit the distance from the subject to the camera.
  /// Hint: Default value is 0.
  ///
  /// param minimumIod Minimum intra-occular distance, in pixels.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMinimumIod(int minimumIod) {
    var err = faceSDK.id3FacePortraitProcessor_SetMinimumIod(_pHandle.value, minimumIod);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 30.
  ///
  /// return Minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMinimumVerticalPosition() {
    Pointer<Int> pMinimumVerticalPosition = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMinimumVerticalPosition(_pHandle.value, pMinimumVerticalPosition);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMinimumVerticalPosition = pMinimumVerticalPosition.value;
      return vMinimumVerticalPosition;
    } finally {
      calloc.free(pMinimumVerticalPosition);
    }
  }

  /// Sets the minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// For ICAO compliance, the value must be in the range 30 to 50.
  /// Hint: Default value is 30.
  ///
  /// param minimumVerticalPosition Minimum distance from the bottom edge of the image to the imaginary line passing through the center of the eyes is between 50% - 70% of the total vertical length of the image.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMinimumVerticalPosition(int minimumVerticalPosition) {
    var err = faceSDK.id3FacePortraitProcessor_SetMinimumVerticalPosition(_pHandle.value, minimumVerticalPosition);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the mouth occlusion threshold. 
  /// If the mouth occlusion score is above this value, the mouth is probably occluded.
  /// Hint: Default value 70.
  ///
  /// return Mouth occlusion threshold. 
  /// throws FaceException An error has occurred during Face Library execution.
  int getMouthOcclusionThreshold() {
    Pointer<Int> pMouthOcclusionThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMouthOcclusionThreshold(_pHandle.value, pMouthOcclusionThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMouthOcclusionThreshold = pMouthOcclusionThreshold.value;
      return vMouthOcclusionThreshold;
    } finally {
      calloc.free(pMouthOcclusionThreshold);
    }
  }

  /// Sets the mouth occlusion threshold. 
  /// If the mouth occlusion score is above this value, the mouth is probably occluded.
  /// Hint: Default value 70.
  ///
  /// param mouthOcclusionThreshold Mouth occlusion threshold. 
  /// throws FaceException An error has occurred during Face Library execution.
  void setMouthOcclusionThreshold(int mouthOcclusionThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetMouthOcclusionThreshold(_pHandle.value, mouthOcclusionThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the mouth opening threshold.
  /// If the mouth opening score is above this value, the mouth of detected face is definitely open.
  /// Hint: Default value is 35.
  ///
  /// return Mouth opening threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getMouthOpenThreshold() {
    Pointer<Int> pMouthOpenThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetMouthOpenThreshold(_pHandle.value, pMouthOpenThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vMouthOpenThreshold = pMouthOpenThreshold.value;
      return vMouthOpenThreshold;
    } finally {
      calloc.free(pMouthOpenThreshold);
    }
  }

  /// Sets the mouth opening threshold.
  /// If the mouth opening score is above this value, the mouth of detected face is definitely open.
  /// Hint: Default value is 35.
  ///
  /// param mouthOpenThreshold Mouth opening threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setMouthOpenThreshold(int mouthOpenThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetMouthOpenThreshold(_pHandle.value, mouthOpenThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the natural skin color threshold.
  /// Above this threshold, th skin of the person looks natural.
  /// Hint: Default value is 5.
  ///
  /// return Natural skin color threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getNaturalSkinColorThreshold() {
    Pointer<Int> pNaturalSkinColorThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetNaturalSkinColorThreshold(_pHandle.value, pNaturalSkinColorThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vNaturalSkinColorThreshold = pNaturalSkinColorThreshold.value;
      return vNaturalSkinColorThreshold;
    } finally {
      calloc.free(pNaturalSkinColorThreshold);
    }
  }

  /// Sets the natural skin color threshold.
  /// Above this threshold, th skin of the person looks natural.
  /// Hint: Default value is 5.
  ///
  /// param naturalSkinColorThreshold Natural skin color threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setNaturalSkinColorThreshold(int naturalSkinColorThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetNaturalSkinColorThreshold(_pHandle.value, naturalSkinColorThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the flash reflexion detection threshold.
  /// Above this threshold, the flash reflexion is probably present on the face.
  /// Hint: Default value is 70.
  ///
  /// return Flash reflexion detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getNoFlashReflectionThreshold() {
    Pointer<Int> pNoFlashReflectionThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetNoFlashReflectionThreshold(_pHandle.value, pNoFlashReflectionThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vNoFlashReflectionThreshold = pNoFlashReflectionThreshold.value;
      return vNoFlashReflectionThreshold;
    } finally {
      calloc.free(pNoFlashReflectionThreshold);
    }
  }

  /// Sets the flash reflexion detection threshold.
  /// Above this threshold, the flash reflexion is probably present on the face.
  /// Hint: Default value is 70.
  ///
  /// param noFlashReflectionThreshold Flash reflexion detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setNoFlashReflectionThreshold(int noFlashReflectionThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetNoFlashReflectionThreshold(_pHandle.value, noFlashReflectionThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the threshold for confirming the presence of noise in the image.
  /// Hint: Default value is 90.
  ///
  /// return Threshold for confirming the presence of noise in the image.
  /// throws FaceException An error has occurred during Face Library execution.
  int getNoiseThreshold() {
    Pointer<Int> pNoiseThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetNoiseThreshold(_pHandle.value, pNoiseThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vNoiseThreshold = pNoiseThreshold.value;
      return vNoiseThreshold;
    } finally {
      calloc.free(pNoiseThreshold);
    }
  }

  /// Sets the threshold for confirming the presence of noise in the image.
  /// Hint: Default value is 90.
  ///
  /// param noiseThreshold Threshold for confirming the presence of noise in the image.
  /// throws FaceException An error has occurred during Face Library execution.
  void setNoiseThreshold(int noiseThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetNoiseThreshold(_pHandle.value, noiseThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the nose occlusion threshold. 
  /// If the score is above this value, the nose is probably occluded.
  /// Hint: Default value 50.
  ///
  /// return Nose occlusion threshold. 
  /// throws FaceException An error has occurred during Face Library execution.
  int getNoseOcclusionThreshold() {
    Pointer<Int> pNoseOcclusionThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetNoseOcclusionThreshold(_pHandle.value, pNoseOcclusionThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vNoseOcclusionThreshold = pNoseOcclusionThreshold.value;
      return vNoseOcclusionThreshold;
    } finally {
      calloc.free(pNoseOcclusionThreshold);
    }
  }

  /// Sets the nose occlusion threshold. 
  /// If the score is above this value, the nose is probably occluded.
  /// Hint: Default value 50.
  ///
  /// param noseOcclusionThreshold Nose occlusion threshold. 
  /// throws FaceException An error has occurred during Face Library execution.
  void setNoseOcclusionThreshold(int noseOcclusionThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetNoseOcclusionThreshold(_pHandle.value, noseOcclusionThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the over exposure threshold.
  /// Above this threshold, the ratio of face pixels are over-exposed. 
  /// Hint: Default value is 50.
  ///
  /// return Over exposure threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getOverExposureThreshold() {
    Pointer<Int> pOverExposureThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetOverExposureThreshold(_pHandle.value, pOverExposureThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vOverExposureThreshold = pOverExposureThreshold.value;
      return vOverExposureThreshold;
    } finally {
      calloc.free(pOverExposureThreshold);
    }
  }

  /// Sets the over exposure threshold.
  /// Above this threshold, the ratio of face pixels are over-exposed. 
  /// Hint: Default value is 50.
  ///
  /// param overExposureThreshold Over exposure threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setOverExposureThreshold(int overExposureThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetOverExposureThreshold(_pHandle.value, overExposureThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the presentation attack detection threshold, from 0 to 100.
  /// Higher values enable more attacks to be detected, but may reduce ease of use.
  /// Hint: Default value 95.
  ///
  /// return Presentation attack detection threshold, from 0 to 100.
  /// throws FaceException An error has occurred during Face Library execution.
  int getPadThreshold() {
    Pointer<Int> pPadThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetPadThreshold(_pHandle.value, pPadThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vPadThreshold = pPadThreshold.value;
      return vPadThreshold;
    } finally {
      calloc.free(pPadThreshold);
    }
  }

  /// Sets the presentation attack detection threshold, from 0 to 100.
  /// Higher values enable more attacks to be detected, but may reduce ease of use.
  /// Hint: Default value 95.
  ///
  /// param padThreshold Presentation attack detection threshold, from 0 to 100.
  /// throws FaceException An error has occurred during Face Library execution.
  void setPadThreshold(int padThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetPadThreshold(_pHandle.value, padThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the pixelation detection threshold.
  /// Above this threshold, the image is probably pixelated.
  /// Hint: Default value is 90.
  ///
  /// return Pixelation detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getPixelationThreshold() {
    Pointer<Int> pPixelationThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetPixelationThreshold(_pHandle.value, pPixelationThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vPixelationThreshold = pPixelationThreshold.value;
      return vPixelationThreshold;
    } finally {
      calloc.free(pPixelationThreshold);
    }
  }

  /// Sets the pixelation detection threshold.
  /// Above this threshold, the image is probably pixelated.
  /// Hint: Default value is 90.
  ///
  /// param pixelationThreshold Pixelation detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setPixelationThreshold(int pixelationThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetPixelationThreshold(_pHandle.value, pixelationThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the threshold for confirming the presence of red eyes.
  /// Hint: Default value is 10.
  ///
  /// return Threshold for confirming the presence of red eyes.
  /// throws FaceException An error has occurred during Face Library execution.
  int getRedEyeThreshold() {
    Pointer<Int> pRedEyeThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetRedEyeThreshold(_pHandle.value, pRedEyeThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vRedEyeThreshold = pRedEyeThreshold.value;
      return vRedEyeThreshold;
    } finally {
      calloc.free(pRedEyeThreshold);
    }
  }

  /// Sets the threshold for confirming the presence of red eyes.
  /// Hint: Default value is 10.
  ///
  /// param redEyeThreshold Threshold for confirming the presence of red eyes.
  /// throws FaceException An error has occurred during Face Library execution.
  void setRedEyeThreshold(int redEyeThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetRedEyeThreshold(_pHandle.value, redEyeThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the threshold indicating whether the image resolution is sufficient.
  /// Hint: Default value is 90.
  ///
  /// return Threshold indicating whether the image resolution is sufficient.
  /// throws FaceException An error has occurred during Face Library execution.
  int getResolutionThreshold() {
    Pointer<Int> pResolutionThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetResolutionThreshold(_pHandle.value, pResolutionThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vResolutionThreshold = pResolutionThreshold.value;
      return vResolutionThreshold;
    } finally {
      calloc.free(pResolutionThreshold);
    }
  }

  /// Sets the threshold indicating whether the image resolution is sufficient.
  /// Hint: Default value is 90.
  ///
  /// param resolutionThreshold Threshold indicating whether the image resolution is sufficient.
  /// throws FaceException An error has occurred during Face Library execution.
  void setResolutionThreshold(int resolutionThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetResolutionThreshold(_pHandle.value, resolutionThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the sharpness threshold. 
  /// If the sharpness score is above this value, the image sharpness is sufficient.
  /// Hint: Default value is 50.
  ///
  /// return Sharpness threshold. 
  /// throws FaceException An error has occurred during Face Library execution.
  int getSharpnessThreshold() {
    Pointer<Int> pSharpnessThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetSharpnessThreshold(_pHandle.value, pSharpnessThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vSharpnessThreshold = pSharpnessThreshold.value;
      return vSharpnessThreshold;
    } finally {
      calloc.free(pSharpnessThreshold);
    }
  }

  /// Sets the sharpness threshold. 
  /// If the sharpness score is above this value, the image sharpness is sufficient.
  /// Hint: Default value is 50.
  ///
  /// param sharpnessThreshold Sharpness threshold. 
  /// throws FaceException An error has occurred during Face Library execution.
  void setSharpnessThreshold(int sharpnessThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetSharpnessThreshold(_pHandle.value, sharpnessThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the smile threshold.
  /// If the Smile score is above this value, the detected face is definitely smiling.
  /// Hint: Default value is 75.
  ///
  /// return Smile threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getSmileThreshold() {
    Pointer<Int> pSmileThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetSmileThreshold(_pHandle.value, pSmileThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vSmileThreshold = pSmileThreshold.value;
      return vSmileThreshold;
    } finally {
      calloc.free(pSmileThreshold);
    }
  }

  /// Sets the smile threshold.
  /// If the Smile score is above this value, the detected face is definitely smiling.
  /// Hint: Default value is 75.
  ///
  /// param smileThreshold Smile threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setSmileThreshold(int smileThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetSmileThreshold(_pHandle.value, smileThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the number of threads to be used for portrait processing.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  ///
  /// return Number of threads to be used for portrait processing.
  /// throws FaceException An error has occurred during Face Library execution.
  int getThreadCount() {
    Pointer<Int> pThreadCount = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetThreadCount(_pHandle.value, pThreadCount);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vThreadCount = pThreadCount.value;
      return vThreadCount;
    } finally {
      calloc.free(pThreadCount);
    }
  }

  /// Sets the number of threads to be used for portrait processing.
  /// Hint: Default value is 1. Allocating more than one thread can increase the speed of the process.
  ///
  /// param threadCount Number of threads to be used for portrait processing.
  /// throws FaceException An error has occurred during Face Library execution.
  void setThreadCount(int threadCount) {
    var err = faceSDK.id3FacePortraitProcessor_SetThreadCount(_pHandle.value, threadCount);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the tinted glass detection threshold.
  /// If the score is above this value, the person is definitely wearing tinted glasses.
  /// Hint: Default value 25.
  ///
  /// return Tinted glass detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getTintedGlassThreshold() {
    Pointer<Int> pTintedGlassThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetTintedGlassThreshold(_pHandle.value, pTintedGlassThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vTintedGlassThreshold = pTintedGlassThreshold.value;
      return vTintedGlassThreshold;
    } finally {
      calloc.free(pTintedGlassThreshold);
    }
  }

  /// Sets the tinted glass detection threshold.
  /// If the score is above this value, the person is definitely wearing tinted glasses.
  /// Hint: Default value 25.
  ///
  /// param tintedGlassThreshold Tinted glass detection threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setTintedGlassThreshold(int tintedGlassThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetTintedGlassThreshold(_pHandle.value, tintedGlassThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// Hint: Default value is 3000 which corresponds to a False Match Rate of 1/1000.
  ///
  /// return Minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// throws FaceException An error has occurred during Face Library execution.
  int getTrackerMatchingThreshold() {
    Pointer<Int> pTrackerMatchingThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetTrackerMatchingThreshold(_pHandle.value, pTrackerMatchingThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vTrackerMatchingThreshold = pTrackerMatchingThreshold.value;
      return vTrackerMatchingThreshold;
    } finally {
      calloc.free(pTrackerMatchingThreshold);
    }
  }

  /// Sets the minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// Hint: Default value is 3000 which corresponds to a False Match Rate of 1/1000.
  ///
  /// param trackerMatchingThreshold Minimum match score to reach to preserve the ID of a tracked face between frame 't-1' and frame 't'.
  /// throws FaceException An error has occurred during Face Library execution.
  void setTrackerMatchingThreshold(int trackerMatchingThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetTrackerMatchingThreshold(_pHandle.value, trackerMatchingThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// Hint: Default value is 2. One must adapt this value to its needs in terms of tracker identity memory (in seconds) and measured frame rate on target platform.
  ///
  /// return Maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// throws FaceException An error has occurred during Face Library execution.
  int getTrackerMaximumFaceAge() {
    Pointer<Int> pTrackerMaximumFaceAge = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetTrackerMaximumFaceAge(_pHandle.value, pTrackerMaximumFaceAge);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vTrackerMaximumFaceAge = pTrackerMaximumFaceAge.value;
      return vTrackerMaximumFaceAge;
    } finally {
      calloc.free(pTrackerMaximumFaceAge);
    }
  }

  /// Sets the maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// Hint: Default value is 2. One must adapt this value to its needs in terms of tracker identity memory (in seconds) and measured frame rate on target platform.
  ///
  /// param trackerMaximumFaceAge Maximum number of consecutive non-detections to be reached before deleting a tracked face.
  /// throws FaceException An error has occurred during Face Library execution.
  void setTrackerMaximumFaceAge(int trackerMaximumFaceAge) {
    var err = faceSDK.id3FacePortraitProcessor_SetTrackerMaximumFaceAge(_pHandle.value, trackerMaximumFaceAge);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the minimum number of consecutive detections to reach before creating a tracked face.
  /// Hint: Default value is 1 for ``FaceDetector4B`` since the false detection rate is low enough. If using a less accurate detector (such as FaceDetector3C) one might consider increasing a bit this value to avoid false tracks. 
  ///
  /// return Minimum number of consecutive detections to reach before creating a tracked face.
  /// throws FaceException An error has occurred during Face Library execution.
  int getTrackerMinimumFaceAge() {
    Pointer<Int> pTrackerMinimumFaceAge = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetTrackerMinimumFaceAge(_pHandle.value, pTrackerMinimumFaceAge);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vTrackerMinimumFaceAge = pTrackerMinimumFaceAge.value;
      return vTrackerMinimumFaceAge;
    } finally {
      calloc.free(pTrackerMinimumFaceAge);
    }
  }

  /// Sets the minimum number of consecutive detections to reach before creating a tracked face.
  /// Hint: Default value is 1 for ``FaceDetector4B`` since the false detection rate is low enough. If using a less accurate detector (such as FaceDetector3C) one might consider increasing a bit this value to avoid false tracks. 
  ///
  /// param trackerMinimumFaceAge Minimum number of consecutive detections to reach before creating a tracked face.
  /// throws FaceException An error has occurred during Face Library execution.
  void setTrackerMinimumFaceAge(int trackerMinimumFaceAge) {
    var err = faceSDK.id3FacePortraitProcessor_SetTrackerMinimumFaceAge(_pHandle.value, trackerMinimumFaceAge);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range (0;100).
  /// Hint: Default value is 0. Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  ///
  /// return Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range (0;100).
  /// throws FaceException An error has occurred during Face Library execution.
  int getTrackerNmsIouThreshold() {
    Pointer<Int> pTrackerNmsIouThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetTrackerNmsIouThreshold(_pHandle.value, pTrackerNmsIouThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vTrackerNmsIouThreshold = pTrackerNmsIouThreshold.value;
      return vTrackerNmsIouThreshold;
    } finally {
      calloc.free(pTrackerNmsIouThreshold);
    }
  }

  /// Sets the non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range (0;100).
  /// Hint: Default value is 0. Setting a high threshold allows to detect more overlapping faces which can be useful in a multi-face scenario. On the contrary, in a portrait scenario, a low NMS IOU threshold should be preferred.
  ///
  /// param trackerNmsIouThreshold Non-maximum suppression (NMS) intersection-over-union (IOU) threshold, in the range (0;100).
  /// throws FaceException An error has occurred during Face Library execution.
  void setTrackerNmsIouThreshold(int trackerNmsIouThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetTrackerNmsIouThreshold(_pHandle.value, trackerNmsIouThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Gets the under exposure threshold.
  /// Above this threshold, the face is probably under-exposed.
  /// Hint: Default value is 50.
  ///
  /// return Under exposure threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  int getUnderExposureThreshold() {
    Pointer<Int> pUnderExposureThreshold = calloc();
    try {
      var err = faceSDK.id3FacePortraitProcessor_GetUnderExposureThreshold(_pHandle.value, pUnderExposureThreshold);
      if (err != FaceError.success.value) {
        throw FaceException(err);
      }
      final vUnderExposureThreshold = pUnderExposureThreshold.value;
      return vUnderExposureThreshold;
    } finally {
      calloc.free(pUnderExposureThreshold);
    }
  }

  /// Sets the under exposure threshold.
  /// Above this threshold, the face is probably under-exposed.
  /// Hint: Default value is 50.
  ///
  /// param underExposureThreshold Under exposure threshold.
  /// throws FaceException An error has occurred during Face Library execution.
  void setUnderExposureThreshold(int underExposureThreshold) {
    var err = faceSDK.id3FacePortraitProcessor_SetUnderExposureThreshold(_pHandle.value, underExposureThreshold);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Analyses an image and creates a portrait with the first detected face or the currently tracked face if the update parameter is activated.
  /// This method performs the following tasks:
  /// - Face detection
  /// - Landmark detection (68 points)
  /// - Head pose estimation
  /// - Verification of subject position
  /// - Geometric attributes computation
  /// - Unified quality score computation
  /// Important: This method requires the ``FaceDetector``, ``FaceLandmarksEstimator`` and ``FacePoseEstimator`` models to be loaded.
  ///
  /// param image Source image.
  /// return The newly created portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  Portrait createPortrait(Image image) {
    Portrait portrait = Portrait();
    var err = faceSDK.id3FacePortraitProcessor_CreatePortrait(_pHandle.value, image.handle, portrait.handle);
    if (err != FaceError.success.value) {
      portrait.dispose();
      throw FaceException(err);
    }
    return portrait;
  }

  /// Creates an ICAO-compliant portrait image by cropping the source image around the detected face.
  /// This method uses the following parameters:
  /// - Portrait aspect ratio
  /// - Portrait eye position ratio
  /// - Portrait IOD ratio
  ///
  /// param portrait Source portrait.
  /// return The output cropped image.
  /// throws FaceException An error has occurred during Face Library execution.
  Image cropIcaoPortrait(Portrait portrait) {
    Image image = Image();
    var err = faceSDK.id3FacePortraitProcessor_CropIcaoPortrait(_pHandle.value, portrait.handle, image.handle);
    if (err != FaceError.success.value) {
      image.dispose();
      throw FaceException(err);
    }
    return image;
  }

  /// Creates a portrait image by cropping the source image around the detected face.
  ///
  /// param portrait The portrait to extract the face from.
  /// return The output cropped image of the face.
  /// throws FaceException An error has occurred during Face Library execution.
  Image cropPortrait(Portrait portrait) {
    Image image = Image();
    var err = faceSDK.id3FacePortraitProcessor_CropPortrait(_pHandle.value, portrait.handle, image.handle);
    if (err != FaceError.success.value) {
      image.dispose();
      throw FaceException(err);
    }
    return image;
  }

  /// Detects occlusions on the subject's face.
  /// Important: This function requires the ``FaceOcclusionDetector2A`` model to be loaded.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void detectOcclusions(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_DetectOcclusions(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Detects a possible presentation attack.
  /// Important: This method requires the ``FaceColorBasedPad`` models to be loaded.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void detectPresentationAttack(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_DetectPresentationAttack(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Estimates the age of the person.
  /// Important: This method requires the ``FaceAgeEstimator1A`` model to be loaded.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void estimateAge(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_EstimateAge(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Checks the background uniformity of the specified portrait.
  /// Important: This method requires the ``FaceBackgroundUniformityEstimator1A`` model to be loaded.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void estimateBackgroundUniformity(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_EstimateBackgroundUniformity(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Estimates the subject's expression on the specified portrait.
  /// Important: This method requires the ``FaceExpressionClassifier1A`` model to be loaded.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void estimateExpression(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_EstimateExpression(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Estimates the face attributes of the specified portrait.
  /// It includes glasses, hat, makeup, mouth opening, gender, smile, eye gaze, eye opening, face mask
  /// Note: The appropriate AI models must be loaded.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void estimateFaceAttributes(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_EstimateFaceAttributes(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Estimates the geometric quality of the specified portrait according to the ICAO portrait parameters.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void estimateGeometryQuality(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_EstimateGeometryQuality(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Etimates the photographic quality of the specified portrait.
  /// It includes image colorization, equal brightness, dynamic range, resolution, natural skin color, flash reflection, noise, over-exposure, under-exposure, pixelation, sharpness.
  ///
  /// param portrait The portrait.
  /// throws FaceException An error has occurred during Face Library execution.
  void estimatePhotographicQuality(Portrait portrait) {
    var err = faceSDK.id3FacePortraitProcessor_EstimatePhotographicQuality(_pHandle.value, portrait.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Removes the background on the specified portrait image.
  /// Important: This method requires the ``FaceBackgroundSegmenter1A`` model to be loaded.
  ///
  /// param image The portrait image.
  /// param red Green channel of the background color. Must be a value from 0 to 255.
  /// param green Red channel of the background color. Must be a value from 0 to 255.
  /// param blue Blue channel of the background color. Must be a value from 0 to 255.
  /// throws FaceException An error has occurred during Face Library execution.
  void removeBackground(Image image, int red, int green, int blue) {
    var err = faceSDK.id3FacePortraitProcessor_RemoveBackground(_pHandle.value, image.handle, red, green, blue);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Resets the face tracker.
  ///
  /// throws FaceException An error has occurred during Face Library execution.
  void reset() {
    var err = faceSDK.id3FacePortraitProcessor_Reset(_pHandle.value);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

  /// Analyses an image and updates the specified portrait with the first detected face or the currently tracked face.
  /// This method performs the following tasks:
  /// - Face detection and tracking with prediction models
  /// - Landmark detection (68 points)
  /// - Head pose estimation
  /// - Verification of subject position
  /// - Template encoding and updating
  /// - Geometric attributes computation
  /// - Unified quality score computation
  /// Important: This method requires the ``FaceDetector``, ``FaceEncoder``, ``FaceLandmarksEstimator`` and ``FacePoseEstimator`` models to be loaded.
  ///
  /// param portrait The portrait to be updated.
  /// param image The source image.
  /// throws FaceException An error has occurred during Face Library execution.
  void updatePortrait(Portrait portrait, Image image) {
    var err = faceSDK.id3FacePortraitProcessor_UpdatePortrait(_pHandle.value, portrait.handle, image.handle);
    if (err != FaceError.success.value) {
      throw FaceException(err);
    }
  }

}

