//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'face_sdk_generated_bindings.dart';

/// Represents the portrait quality check points.
class PortraitQualityCheckpoints {
  final Pointer<id3FacePortraitQualityCheckpoints> _handle;

  static final Finalizer<Pointer<id3FacePortraitQualityCheckpoints>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3FacePortraitQualityCheckpoints> get handle => _handle;

  id3FacePortraitQualityCheckpoints get struct => _handle.ref;

  /// Initializes a new instance of the PortraitQualityCheckpoints class from its members.
  PortraitQualityCheckpoints(this._handle);

  /// Create a new instance of the PortraitQualityCheckpoints.
  PortraitQualityCheckpoints.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the PortraitQualityCheckpoints from the native struct
  PortraitQualityCheckpoints.createFromStruct(id3FacePortraitQualityCheckpoints value) : _handle = calloc() {
    _handle.ref.MouthClosed = value.MouthClosed;
    _handle.ref.ImageColoured = value.ImageColoured;
    _handle.ref.BrightnessBalanced = value.BrightnessBalanced;
    _handle.ref.PoseFrontal = value.PoseFrontal;
    _handle.ref.DynamicRange = value.DynamicRange;
    _handle.ref.HeadHeightCorrect = value.HeadHeightCorrect;
    _handle.ref.HeadWidthCorrect = value.HeadWidthCorrect;
    _handle.ref.HeadHorizontalPositionCorrect = value.HeadHorizontalPositionCorrect;
    _handle.ref.HeadVerticalPositionCorrect = value.HeadVerticalPositionCorrect;
    _handle.ref.ImageResolutionCorrect = value.ImageResolutionCorrect;
    _handle.ref.ImageSharp = value.ImageSharp;
    _handle.ref.SkinColorNatural = value.SkinColorNatural;
    _handle.ref.ExpressionNeutral = value.ExpressionNeutral;
    _handle.ref.NoFlashReflection = value.NoFlashReflection;
    _handle.ref.NoGlasses = value.NoGlasses;
    _handle.ref.NoHat = value.NoHat;
    _handle.ref.NoNoise = value.NoNoise;
    _handle.ref.NoOverExposure = value.NoOverExposure;
    _handle.ref.NoPixelation = value.NoPixelation;
    _handle.ref.NoRedEye = value.NoRedEye;
    _handle.ref.NoSmile = value.NoSmile;
    _handle.ref.NoUnderExposure = value.NoUnderExposure;
    _handle.ref.EyesOpen = value.EyesOpen;
    _handle.ref.LookStraight = value.LookStraight;
    _handle.ref.BackgroundUniform = value.BackgroundUniform;
    _handle.ref.LeftEyeVisible = value.LeftEyeVisible;
    _handle.ref.RightEyeVisible = value.RightEyeVisible;
    _handle.ref.MouthVisible = value.MouthVisible;
    _handle.ref.NoseVisible = value.NoseVisible;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Value indicating whether the mouth is closed.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get mouthClosed => _handle.ref.MouthClosed;
  set mouthClosed(int value) => _handle.ref.MouthClosed = value;

  /// 
  /// Value indicating whether the image is coloured, not grayscale.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get imageColoured => _handle.ref.ImageColoured;
  set imageColoured(int value) => _handle.ref.ImageColoured = value;

  /// 
  /// Value indicating whether lighting is equally distributed on the face, in particular symmetrically, i.e., there is no difference between the brightness of the right and left side of the face.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get brightnessBalanced => _handle.ref.BrightnessBalanced;
  set brightnessBalanced(int value) => _handle.ref.BrightnessBalanced = value;

  /// 
  /// Value indicating whether the subject's face is frontal.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get poseFrontal => _handle.ref.PoseFrontal;
  set poseFrontal(int value) => _handle.ref.PoseFrontal = value;

  /// 
  /// Value indicating whether the dynamic range on the image is sufficient.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get dynamicRange => _handle.ref.DynamicRange;
  set dynamicRange(int value) => _handle.ref.DynamicRange = value;

  /// 
  /// Value indicating whether the height of the head in the image is correct.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get headHeightCorrect => _handle.ref.HeadHeightCorrect;
  set headHeightCorrect(int value) => _handle.ref.HeadHeightCorrect = value;

  /// 
  /// Value indicating whether the width of the head in the image is correct.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get headWidthCorrect => _handle.ref.HeadWidthCorrect;
  set headWidthCorrect(int value) => _handle.ref.HeadWidthCorrect = value;

  /// 
  /// Value indicating whether the horizontal position of the head in the image is correct.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get headHorizontalPositionCorrect => _handle.ref.HeadHorizontalPositionCorrect;
  set headHorizontalPositionCorrect(int value) => _handle.ref.HeadHorizontalPositionCorrect = value;

  /// 
  /// Value indicating whether the vertical position of the head in the image is correct.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get headVerticalPositionCorrect => _handle.ref.HeadVerticalPositionCorrect;
  set headVerticalPositionCorrect(int value) => _handle.ref.HeadVerticalPositionCorrect = value;

  /// 
  /// Value indicating whether the image resolution is correct.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get imageResolutionCorrect => _handle.ref.ImageResolutionCorrect;
  set imageResolutionCorrect(int value) => _handle.ref.ImageResolutionCorrect = value;

  /// 
  /// Value indicating whether the image is sharp.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get imageSharp => _handle.ref.ImageSharp;
  set imageSharp(int value) => _handle.ref.ImageSharp = value;

  /// 
  /// Value indicating whether the skin looks natural.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get skinColorNatural => _handle.ref.SkinColorNatural;
  set skinColorNatural(int value) => _handle.ref.SkinColorNatural = value;

  /// 
  /// Value indicating whether no emotion is visible on the subject's face.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get expressionNeutral => _handle.ref.ExpressionNeutral;
  set expressionNeutral(int value) => _handle.ref.ExpressionNeutral = value;

  /// 
  /// Value indicating whether no flash reflection is visible.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noFlashReflection => _handle.ref.NoFlashReflection;
  set noFlashReflection(int value) => _handle.ref.NoFlashReflection = value;

  /// 
  /// Value indicating whether the subject does not wear glasses.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noGlasses => _handle.ref.NoGlasses;
  set noGlasses(int value) => _handle.ref.NoGlasses = value;

  /// 
  /// Value indicating whether the subject does not wear a hat.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noHat => _handle.ref.NoHat;
  set noHat(int value) => _handle.ref.NoHat = value;

  /// 
  /// Value indicating whether no noise is present in the image.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noNoise => _handle.ref.NoNoise;
  set noNoise(int value) => _handle.ref.NoNoise = value;

  /// 
  /// Value indicating whether the image is not over-exposed.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noOverExposure => _handle.ref.NoOverExposure;
  set noOverExposure(int value) => _handle.ref.NoOverExposure = value;

  /// 
  /// Value indicating whether the image is not pixelated.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noPixelation => _handle.ref.NoPixelation;
  set noPixelation(int value) => _handle.ref.NoPixelation = value;

  /// 
  /// Value indicating whether no red-eye is present.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noRedEye => _handle.ref.NoRedEye;
  set noRedEye(int value) => _handle.ref.NoRedEye = value;

  /// 
  /// Value indicating whether the subject is not smiling.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noSmile => _handle.ref.NoSmile;
  set noSmile(int value) => _handle.ref.NoSmile = value;

  /// 
  /// Value indicating whether the image is not under-exposed.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noUnderExposure => _handle.ref.NoUnderExposure;
  set noUnderExposure(int value) => _handle.ref.NoUnderExposure = value;

  /// 
  /// Value indicating whether the eyes are open.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get eyesOpen => _handle.ref.EyesOpen;
  set eyesOpen(int value) => _handle.ref.EyesOpen = value;

  /// 
  /// Value indicating whether the subject looks straight towards the camera.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get lookStraight => _handle.ref.LookStraight;
  set lookStraight(int value) => _handle.ref.LookStraight = value;

  /// 
  /// Value indicating whether the color of the background is uniform.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get backgroundUniform => _handle.ref.BackgroundUniform;
  set backgroundUniform(int value) => _handle.ref.BackgroundUniform = value;

  /// 
  /// Value indicating whether the left eye is visible.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get leftEyeVisible => _handle.ref.LeftEyeVisible;
  set leftEyeVisible(int value) => _handle.ref.LeftEyeVisible = value;

  /// 
  /// Value indicating whether the right eye is visible.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get rightEyeVisible => _handle.ref.RightEyeVisible;
  set rightEyeVisible(int value) => _handle.ref.RightEyeVisible = value;

  /// 
  /// Value indicating whether the mouth is visible.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get mouthVisible => _handle.ref.MouthVisible;
  set mouthVisible(int value) => _handle.ref.MouthVisible = value;

  /// 
  /// Value indicating whether the nose is visible.
  /// 
  /// throws FaceException An error has occurred during Face Library execution.
  int get noseVisible => _handle.ref.NoseVisible;
  set noseVisible(int value) => _handle.ref.NoseVisible = value;


  Map<String, dynamic> toMap() {
    return {
        'mouthClosed': mouthClosed,
        'imageColoured': imageColoured,
        'brightnessBalanced': brightnessBalanced,
        'poseFrontal': poseFrontal,
        'dynamicRange': dynamicRange,
        'headHeightCorrect': headHeightCorrect,
        'headWidthCorrect': headWidthCorrect,
        'headHorizontalPositionCorrect': headHorizontalPositionCorrect,
        'headVerticalPositionCorrect': headVerticalPositionCorrect,
        'imageResolutionCorrect': imageResolutionCorrect,
        'imageSharp': imageSharp,
        'skinColorNatural': skinColorNatural,
        'expressionNeutral': expressionNeutral,
        'noFlashReflection': noFlashReflection,
        'noGlasses': noGlasses,
        'noHat': noHat,
        'noNoise': noNoise,
        'noOverExposure': noOverExposure,
        'noPixelation': noPixelation,
        'noRedEye': noRedEye,
        'noSmile': noSmile,
        'noUnderExposure': noUnderExposure,
        'eyesOpen': eyesOpen,
        'lookStraight': lookStraight,
        'backgroundUniform': backgroundUniform,
        'leftEyeVisible': leftEyeVisible,
        'rightEyeVisible': rightEyeVisible,
        'mouthVisible': mouthVisible,
        'noseVisible': noseVisible,
    };
  }
}
