//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the possible statuses of a portrait.
enum PortraitStatus {
	/// The status is undefined.
	undefined,
	/// No face has been detected in the provided image.
	noFaceDetected,
	/// A new portrait has been created.
	created,
	/// The portrait has been updated.
	updated,
}

extension PortraitStatusX on PortraitStatus {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created PortraitStatus.
  	static PortraitStatus fromValue(int value) {
    	switch (value) {
      	case 0:
        	return PortraitStatus.undefined;
      	case 1:
        	return PortraitStatus.noFaceDetected;
      	case 2:
        	return PortraitStatus.created;
      	case 3:
        	return PortraitStatus.updated;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case PortraitStatus.undefined:
        	return 0;
      	case PortraitStatus.noFaceDetected:
        	return 1;
      	case PortraitStatus.created:
        	return 2;
      	case PortraitStatus.updated:
        	return 3;
		}
  	}
}
