//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the positions of a subject in an image.
enum SubjectPosition {
	/// The position is undefined.
	undefined,
	/// The position is correct.
	correct,
	/// The subject is too close.
	tooClose,
	/// The subject is too far.
	tooFar,
	/// The subject is too left.
	tooLeft,
	/// The subject is too right.
	tooRight,
	/// The subject is too high.
	tooHigh,
	/// The subject is too low.
	tooLow,
}

extension SubjectPositionX on SubjectPosition {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created SubjectPosition.
  	static SubjectPosition fromValue(int value) {
    	switch (value) {
      	case 0xFF:
        	return SubjectPosition.undefined;
      	case 0x00:
        	return SubjectPosition.correct;
      	case 0x01:
        	return SubjectPosition.tooClose;
      	case 0x02:
        	return SubjectPosition.tooFar;
      	case 0x04:
        	return SubjectPosition.tooLeft;
      	case 0x08:
        	return SubjectPosition.tooRight;
      	case 0x10:
        	return SubjectPosition.tooHigh;
      	case 0x20:
        	return SubjectPosition.tooLow;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case SubjectPosition.undefined:
        	return 0xFF;
      	case SubjectPosition.correct:
        	return 0x00;
      	case SubjectPosition.tooClose:
        	return 0x01;
      	case SubjectPosition.tooFar:
        	return 0x02;
      	case SubjectPosition.tooLeft:
        	return 0x04;
      	case SubjectPosition.tooRight:
        	return 0x08;
      	case SubjectPosition.tooHigh:
        	return 0x10;
      	case SubjectPosition.tooLow:
        	return 0x20;
		}
  	}
}
