var sd_labels_by_text = {};

function ready() {
  const li = document.getElementsByClassName("sd-tab-label");
  const language = window.localStorage.getItem("sphinx-design-last-tab");
  let tabMatched = false; // Flag to check if a match was found

  if (language) {
    for (const label of li) {
      if (label.getAttribute("data-sync-id") === language) {
        label.previousElementSibling.checked = true; // Select the matching tab
        tabMatched = true; // Mark that a match was found
      } else {
        label.previousElementSibling.checked = false; // Ensure others are not selected
      }
    }
  }

  // If no match was found, select the first tab
  if (!tabMatched && li.length > 0) {
    li[0].previousElementSibling.checked = true; // Select the first tab's input
  }
  
  for (const label of li) {
    syncId = label.getAttribute("data-sync-id");
    if (syncId) {
      label.onclick = onLabelClick;
      if (!sd_labels_by_text[syncId]) {
        sd_labels_by_text[syncId] = [];
      }
      sd_labels_by_text[syncId].push(label);
    }
  }
}

function onLabelClick() {
  // Activate other inputs with the same sync id.
  syncId = this.getAttribute("data-sync-id");
  for (label of sd_labels_by_text[syncId]) {
    if (label === this) continue;
    label.previousElementSibling.checked = true;
  }
  window.localStorage.setItem("sphinx-design-last-tab", syncId);
}

document.addEventListener("DOMContentLoaded", ready, false);
