//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceImageError_h
#define _id3FaceImageError_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates possible error codes related to image management.
 */
typedef enum id3FaceImageError {
	/**
	 * No error.
	 */
	id3FaceImageError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3FaceImageError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3FaceImageError_ObjectDoesNotExist = -2,
	/**
	 * Base error code for Image module.
	 */
	id3FaceImageError_Base = -3000,
	/**
	 * Minimum error code for Image module.
	 */
	id3FaceImageError_Minimum = -3999,
	/**
	 * The handle is invalid.
	 */
	id3FaceImageError_InvalidHandle = -3001,
	/**
	 * The parameter is invalid.
	 */
	id3FaceImageError_InvalidParameter = -3002,
	/**
	 * The image sizes are not compatible for the requested operation.
	 */
	id3FaceImageError_ImageSizeMismatch = -3003,
	/**
	 * The pixel formats are not compatible.
	 */
	id3FaceImageError_PixelFormatMismatch = -3004,
	/**
	 * The given key is already used in the dictionary. Multiple values per key is not supported.
	 */
	id3FaceImageError_KeyAlreadyExists = -3005,
	/**
	 * The given key is not present in the dictionary.
	 */
	id3FaceImageError_KeyNotFound = -3006,
	/**
	 * The required pixel format is not correct.
	 */
	id3FaceImageError_InvalidPixelFormat = -3007,
	/**
	 * An error as occured during python module initialization.
	 */
	id3FaceImageError_PythonModule = -3008,
	/**
	 * Function not implemented.
	 */
	id3FaceImageError_FunctionNotImplemented = -3009,
	/**
	 * TODO
	 */
	id3FaceImageError_BackendError = -3010,
} id3FaceImageError;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetImageErrorString(int value);
ID3FACE_C_API const char * ID3_CDECL id3Face_GetImageErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
