//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceLicenseHardwareCodeType_h
#define _id3FaceLicenseHardwareCodeType_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the types of hardware codes.
 */
typedef enum id3FaceLicenseHardwareCodeType {
	/**
	 * License locked on Windows OS.
	 */
	id3FaceLicenseHardwareCodeType_WindowsOs = 1,
	/**
	 * License locked on Linux OS.
	 */
	id3FaceLicenseHardwareCodeType_LinuxOs = 3,
	/**
	 * License locked on Android device.
	 */
	id3FaceLicenseHardwareCodeType_Android = 5,
	/**
	 * License locked on Android application package name.
	 */
	id3FaceLicenseHardwareCodeType_AndroidPackageName = 6,
	/**
	 * License locked on iOS device.
	 */
	id3FaceLicenseHardwareCodeType_Ios = 7,
	/**
	 * License locked on macOS.
	 */
	id3FaceLicenseHardwareCodeType_MacOs = 8,
	/**
	 * License locked on Jetson Nano.
	 */
	id3FaceLicenseHardwareCodeType_JetsonNano = 9,
	/**
	 * License locked on iOS application Bundle ID.
	 */
	id3FaceLicenseHardwareCodeType_IosBundleId = 10,
	/**
	 * License locked on Windows USB stick.
	 */
	id3FaceLicenseHardwareCodeType_WindowsUsb = 11,
	/**
	 * License locked on a smart card.
	 */
	id3FaceLicenseHardwareCodeType_SmartCard = 12,
} id3FaceLicenseHardwareCodeType;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetLicenseHardwareCodeTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
