//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceLicenseType_h
#define _id3FaceLicenseType_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the license types.
 */
typedef enum id3FaceLicenseType {
	/**
	 * Classic id3 license.
	 */
	id3FaceLicenseType_Classic = 1,
	/**
	 * Trial id3 license with a time limitation.
	 */
	id3FaceLicenseType_Trial = 2,
	/**
	 * Online id3 license with an online check.
	 */
	id3FaceLicenseType_Online = 3,
} id3FaceLicenseType;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetLicenseTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
