//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceOcclusionScores_h
#define _id3FaceOcclusionScores_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the result of face occlusion detection.
 */
typedef struct id3FaceOcclusionScores {
	/**
	 * Value, from 0 to 100, indicating whether the left eye is occluded or not.
	 * 100 means that the left eye is definitely occluded.
	 * Hint: The recommended threshold is 50.
	 */
    int LeftEyeOcclusionScore;
	/**
	 * Value, from 0 to 100, indicating whether the mouth is occluded or not.
	 * 100 means that the mouth is definitely occluded.
	 * Hint: The recommended threshold is 30.
	 */
    int MouthOcclusionScore;
	/**
	 * Value, from 0 to 100, indicating whether the nose is occluded or not.
	 * 100 means that the nose is definitely occluded.
	 * Hint: The recommended threshold is 50.
	 */
    int NoseOcclusionScore;
	/**
	 * Value, from 0 to 100, indicating whether the right eye is occluded or not.
	 * 100 means that the right eye is definitely occluded.
	 * Hint: The recommended threshold is 50.
	 */
    int RightEyeOcclusionScore;
} id3FaceOcclusionScores;

#ifdef __cplusplus
}
#endif

#endif
