//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FacePortraitInstruction_h
#define _id3FacePortraitInstruction_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the instructions to be given to the user for effective portrait capture.
 */
typedef enum id3FacePortraitInstruction {
	/**
	 * No instruction given.
	 */
	id3FacePortraitInstruction_None = 0,
	/**
	 * Center your face in the frame.
	 */
	id3FacePortraitInstruction_CenterFace = 1,
	/**
	 * Look directly at the camera.
	 */
	id3FacePortraitInstruction_LookStraight = 2,
	/**
	 * Look away.
	 */
	id3FacePortraitInstruction_LookAway = 3,
	/**
	 * Ensure your face is well-lit.
	 */
	id3FacePortraitInstruction_AdjustLightning = 4,
	/**
	 * The image contrast is too low.
	 */
	id3FacePortraitInstruction_LowContrast = 5,
	/**
	 * Image colors are not balanced correctly.
	 */
	id3FacePortraitInstruction_UnbalancedColors = 6,
	/**
	 * Image is out of focus.
	 */
	id3FacePortraitInstruction_ImageOutOfFocus = 7,
	/**
	 * Move closer to the camera.
	 */
	id3FacePortraitInstruction_MoveCloser = 8,
	/**
	 * Move back from the camera.
	 */
	id3FacePortraitInstruction_MoveBack = 9,
	/**
	 * Move your face lower to align with the camera.
	 */
	id3FacePortraitInstruction_MoveDown = 10,
	/**
	 * Move your face higher to align with the camera.
	 */
	id3FacePortraitInstruction_MoveUp = 11,
	/**
	 * Move your face to the right.
	 */
	id3FacePortraitInstruction_MoveRight = 12,
	/**
	 * Move your face to the left.
	 */
	id3FacePortraitInstruction_MoveLeft = 13,
	/**
	 * Stay still in front of the camera.
	 */
	id3FacePortraitInstruction_StayStill = 14,
	/**
	 * Close your mouth.
	 */
	id3FacePortraitInstruction_CloseMouth = 15,
	/**
	 * Open your mouth.
	 */
	id3FacePortraitInstruction_OpenMouth = 16,
	/**
	 * Smile.
	 */
	id3FacePortraitInstruction_Smile = 17,
	/**
	 * Ensure a neutral expression.
	 */
	id3FacePortraitInstruction_EnsureNeutralExpression = 18,
	/**
	 * Remove any obstacle from your face.
	 */
	id3FacePortraitInstruction_FacePartiallyHidden = 19,
	/**
	 * Turn your head to the left.
	 */
	id3FacePortraitInstruction_TurnHeadLeft = 20,
	/**
	 * Turn your head to the right.
	 */
	id3FacePortraitInstruction_TurnHeadRight = 21,
	/**
	 * Raise your head.
	 */
	id3FacePortraitInstruction_RaiseHead = 22,
	/**
	 * Lower your head.
	 */
	id3FacePortraitInstruction_LowerHead = 23,
	/**
	 * Rotate your head in the specified direction.
	 */
	id3FacePortraitInstruction_RotateHead = 24,
	/**
	 * Turn your head slightly.
	 */
	id3FacePortraitInstruction_TurnHeadSlightly = 25,
	/**
	 * Remove any head coverings.
	 */
	id3FacePortraitInstruction_RemoveHeadCoverings = 26,
	/**
	 * Remove your face mask.
	 */
	id3FacePortraitInstruction_RemoveFaceMask = 27,
	/**
	 * Remove your glasses.
	 */
	id3FacePortraitInstruction_RemoveGlasses = 28,
	/**
	 * Remove your sunglasses.
	 */
	id3FacePortraitInstruction_RemoveSunglasses = 29,
} id3FacePortraitInstruction;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetPortraitInstructionString(int value);

#ifdef __cplusplus
}
#endif

#endif
