//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FacePortraitQualityCheckpoints_h
#define _id3FacePortraitQualityCheckpoints_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the portrait quality check points.
 */
typedef struct id3FacePortraitQualityCheckpoints {
	/**
	 * Value indicating whether the mouth is closed.
	 */
    int MouthClosed;
	/**
	 * Value indicating whether the image is coloured, not grayscale.
	 */
    int ImageColoured;
	/**
	 * Value indicating whether lighting is equally distributed on the face, in particular symmetrically, i.e., there is no difference between the brightness of the right and left side of the face.
	 */
    int BrightnessBalanced;
	/**
	 * Value indicating whether the subject's face is frontal.
	 */
    int PoseFrontal;
	/**
	 * Value indicating whether the dynamic range on the image is sufficient.
	 */
    int DynamicRange;
	/**
	 * Value indicating whether the height of the head in the image is correct.
	 */
    int HeadHeightCorrect;
	/**
	 * Value indicating whether the width of the head in the image is correct.
	 */
    int HeadWidthCorrect;
	/**
	 * Value indicating whether the horizontal position of the head in the image is correct.
	 */
    int HeadHorizontalPositionCorrect;
	/**
	 * Value indicating whether the vertical position of the head in the image is correct.
	 */
    int HeadVerticalPositionCorrect;
	/**
	 * Value indicating whether the image resolution is correct.
	 */
    int ImageResolutionCorrect;
	/**
	 * Value indicating whether the image is sharp.
	 */
    int ImageSharp;
	/**
	 * Value indicating whether the skin looks natural.
	 */
    int SkinColorNatural;
	/**
	 * Value indicating whether no emotion is visible on the subject's face.
	 */
    int ExpressionNeutral;
	/**
	 * Value indicating whether no flash reflection is visible.
	 */
    int NoFlashReflection;
	/**
	 * Value indicating whether the subject does not wear glasses.
	 */
    int NoGlasses;
	/**
	 * Value indicating whether the subject does not wear a hat.
	 */
    int NoHat;
	/**
	 * Value indicating whether no noise is present in the image.
	 */
    int NoNoise;
	/**
	 * Value indicating whether the image is not over-exposed.
	 */
    int NoOverExposure;
	/**
	 * Value indicating whether the image is not pixelated.
	 */
    int NoPixelation;
	/**
	 * Value indicating whether no red-eye is present.
	 */
    int NoRedEye;
	/**
	 * Value indicating whether the subject is not smiling.
	 */
    int NoSmile;
	/**
	 * Value indicating whether the image is not under-exposed.
	 */
    int NoUnderExposure;
	/**
	 * Value indicating whether the eyes are open.
	 */
    int EyesOpen;
	/**
	 * Value indicating whether the subject looks straight towards the camera.
	 */
    int LookStraight;
	/**
	 * Value indicating whether the color of the background is uniform.
	 */
    int BackgroundUniform;
	/**
	 * Value indicating whether the left eye is visible.
	 */
    int LeftEyeVisible;
	/**
	 * Value indicating whether the right eye is visible.
	 */
    int RightEyeVisible;
	/**
	 * Value indicating whether the mouth is visible.
	 */
    int MouthVisible;
	/**
	 * Value indicating whether the nose is visible.
	 */
    int NoseVisible;
} id3FacePortraitQualityCheckpoints;

#ifdef __cplusplus
}
#endif

#endif
