//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FacePortraitStatus_h
#define _id3FacePortraitStatus_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the possible statuses of a portrait.
 */
typedef enum id3FacePortraitStatus {
	/**
	 * The status is undefined.
	 */
	id3FacePortraitStatus_Undefined = 0,
	/**
	 * No face has been detected in the provided image.
	 */
	id3FacePortraitStatus_NoFaceDetected = 1,
	/**
	 * A new portrait has been created.
	 */
	id3FacePortraitStatus_Created = 2,
	/**
	 * The portrait has been updated.
	 */
	id3FacePortraitStatus_Updated = 3,
} id3FacePortraitStatus;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetPortraitStatusString(int value);

#ifdef __cplusplus
}
#endif

#endif
