//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceProcessingUnit_h
#define _id3FaceProcessingUnit_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the processing units for the inference of AI models.
 */
typedef enum id3FaceProcessingUnit {
	/**
	 * CPU.
	 */
	id3FaceProcessingUnit_Cpu = 0,
	/**
	 * GPU (automatic backend selection).
	 */
	id3FaceProcessingUnit_Gpu = 1,
	/**
	 * OpenCL Backend.
	 */
	id3FaceProcessingUnit_Opencl = 2,
	/**
	 * CUDA Backend.
	 */
	id3FaceProcessingUnit_Cuda = 3,
	/**
	 * Metal Backend.
	 */
	id3FaceProcessingUnit_Metal = 4,
	/**
	 * Vulkan Backend.
	 */
	id3FaceProcessingUnit_Vulkan = 5,
} id3FaceProcessingUnit;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetProcessingUnitString(int value);

#ifdef __cplusplus
}
#endif

#endif
