//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceSubjectPosition_h
#define _id3FaceSubjectPosition_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the positions of a subject in an image.
 */
typedef enum id3FaceSubjectPosition {
	/**
	 * The position is undefined.
	 */
	id3FaceSubjectPosition_Undefined = 0xFF,
	/**
	 * The position is correct.
	 */
	id3FaceSubjectPosition_Correct = 0x00,
	/**
	 * The subject is too close.
	 */
	id3FaceSubjectPosition_TooClose = 0x01,
	/**
	 * The subject is too far.
	 */
	id3FaceSubjectPosition_TooFar = 0x02,
	/**
	 * The subject is too left.
	 */
	id3FaceSubjectPosition_TooLeft = 0x04,
	/**
	 * The subject is too right.
	 */
	id3FaceSubjectPosition_TooRight = 0x08,
	/**
	 * The subject is too high.
	 */
	id3FaceSubjectPosition_TooHigh = 0x10,
	/**
	 * The subject is too low.
	 */
	id3FaceSubjectPosition_TooLow = 0x20,
} id3FaceSubjectPosition;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetSubjectPositionString(int value);

#ifdef __cplusplus
}
#endif

#endif
