# id3 Face SDK
Version 9.15.3

(c) Copyright id3 Technologies 2024. All Rights Reserved.

id3 Face SDK is a cross-platform library aimed at system integrators willing to quickly add face detection and recognition capabilities to their products. It is available as a Software Development Kit (SDK) offering a comprehensive interface to simplify integration of the library on servers, PC, mobile devices and edge devices.

## Features
id3 Face SDK offers the following features and benefits:
* Top performance facial biometrics
* Small facial features template
* Robust face detection and tracking
* Face landmarks with 68 features points
* Facial attributes classification for ICAO compliant portraits
* Face image quality check
* Ultra-fast face template matching in one-to-one comparison and one-to-many search modes
* Liveness detection engine to protect against biometric fraud, e.g. presentation attacks with photos and videos
* Compact library designed to run on most hardware configurations, from high-end workstations to low-power edge devices
* Compatible with Windows, Linux, Android, MacOS, iOS
* Simple and comprehensive programming interface (C, C#, Python, Dart, Java, Swift, Kotlin)

## Package content
This SDK is delivered in a package that contains the following directories and files:

    .
    ├── activation                # License activation tools for Windows, Linux and Jetson Nano
    ├── bin                       # C dynamic libraries + benchmark tool
    ├── dart                      # Dart wrapper source code
    ├── docs                      # API reference and Developer Guide
    ├── dotnet                    # .NET dynamic libraries
    ├── include                   # C header files
    ├── java                      # Java jar archives
    ├── CHANGELOG.md
    ├── LICENSE.md
    └── README.md

## Model files
This SDK requires model files to run. There are common to every platform and should be distributed according to the application needs.

The model files can be downloaded at the following URL: https://cloud.id3.eu/index.php/s/y63PysbS3w6NPm6

The model files must not be renamed.

## Recommendations
- Before using this SDK is is *highly* recommended to read the Developer Guide.
- It is recommended as well to read and run the samples to get a first hand on the SDK API. Those samples can be found at the following URL: https://github.com/id3Technologies/face-sdk-samples

## Support
id3 provides customer support for a one-year period.
If you have any questions or suggestions regarding this product during this period, you can contact id3 @ https://id3.eu/contact-us/

## Third party libraries
This software uses open source third party libraries. See docs/3rdParty folder for more details.
