//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceAttackSupport_h
#define _id3FaceAttackSupport_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the types of presentation attack supports.
 */
typedef enum id3FaceAttackSupport {
	/**
	 * No attack support.
	 */
	id3FaceAttackSupport_None = 0,
	/**
	 * ID card support.
	 */
	id3FaceAttackSupport_IdCard = 1,
	/**
	 * Screen support (includes smartphones, tablets, laptops, etc).
	 */
	id3FaceAttackSupport_Screen = 2,
	/**
	 * Printed support.
	 */
	id3FaceAttackSupport_Print = 3,
} id3FaceAttackSupport;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetFaceAttackSupportString(int value);

#ifdef __cplusplus
}
#endif

#endif
