//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceAttributes_h
#define _id3FaceAttributes_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the face attributes.
 */
typedef struct id3FaceAttributes {
	/**
	 * Value, from 0 to 100, indicating whether the subject is wearing glasses or not.
	 * Hint: The recommended threshold is 10.
	 */
    int Glasses;
	/**
	 * Value, from 0 to 100, indicating whether the subject is wearing a hat or not.
	 * Hint: The recommended value is less than 10.
	 */
    int Hat;
	/**
	 * Value, from 0 to 100, indicating whether the subject is wearing makeup or not.
	 * Hint: The recommended value is less than 50.
	 */
    int MakeUp;
	/**
	 * Value, from 0 to 100, indicating the estimated gender of the subject.
	 * A value near 0 suggests that the subject is estimated to be female.
	 * A value near 100 suggests that the subject is estimated to be male.
	 */
    int Male;
	/**
	 * Value, from 0 to 100, indicating whether the subject's mouth is open or not.
	 * Hint: The recommended value is less than 35.
	 */
    int MouthOpen;
	/**
	 * Value, from 0 to 100, indicating whether the subject is smiling or not.
	 * Hint: The recommended value is less than 75.
	 */
    int Smile;
} id3FaceAttributes;

#ifdef __cplusplus
}
#endif

#endif
