//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceColorBasedPadResult_h
#define _id3FaceColorBasedPadResult_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the result of the color-based PAD method.
 */
typedef struct id3FaceColorBasedPadResult {
	/**
	 * Color-based PAD score, in the range [0:100].
	 */
    int Score;
	/**
	 * Confidence score of the color-based PAD algorithm, in the range [0:100].
	 */
    int Confidence;
} id3FaceColorBasedPadResult;

#ifdef __cplusplus
}
#endif

#endif
