//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FacePadStatus_h
#define _id3FacePadStatus_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the statuses of the presentation attack detection (PAD).
 */
typedef enum id3FacePadStatus {
	/**
	 * No decision could be made.
	 */
	id3FacePadStatus_Unknown = 0,
	/**
	 * The detected face is a bonafide (real face).
	 */
	id3FacePadStatus_Bonafide = 1,
	/**
	 * The detected face is an attack (spoof).
	 */
	id3FacePadStatus_Attack = 2,
} id3FacePadStatus;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetPadStatusString(int value);

#ifdef __cplusplus
}
#endif

#endif
