//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FacePhotographicAttributes_h
#define _id3FacePhotographicAttributes_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the photographic attributes of a portrait image.
 */
typedef struct id3FacePhotographicAttributes {
	/**
	 * Value, from 0 to 100, indicating if one side of the face is ligther than the other side.
	 * 0 means that brightness is perfectly equal on both sides of the face.
	 * Hint: The recommended value is over 90.
	 */
    int EqualBrightness;
	/**
	 * Value, from 0 to 255, indicating the dynamic range of the image in the face region.
	 * Hint: The recommended threshold is 110.
	 */
    int FaceDynamicRange;
	/**
	 * Value, from 0 to 100, indicating if a flash reflection is present on the face.
	 * 100 means that there is no flash reflection.
	 * Hint: The recommended threshold is 70.
	 */
    int FlashReflection;
	/**
	 * Value, from 0 to 100, indicating if the skin looks natural.
	 * 0 means that the face does not have a natural skin color at all.
	 * Hint: The recommended threshold is over 5.
	 */
    int NaturalSkinColor;
	/**
	 * Value, from 0 to 100, indicating the ratio of face pixels that are over-exposed.
	 * 0 means that the face is not over-exposed at all.
	 * Hint: The recommended value is under 50.
	 */
    int OverExposure;
	/**
	 * Value, from 0 to 100, indicating if the image is pixelized.
	 * 0 means that there is no pixelation at all.
	 * Hint: The recommended value is under 50.
	 */
    int Pixelation;
	/**
	 * Value, from 0 to 100, indicating if the image sharpness is sufficient.
	 * 0 means that the image is not sharp at all.
	 * Hint: The recommended value is over 40.
	 */
    int Sharpness;
	/**
	 * Value, from 0 to 100, indicating the ratio of face pixels that are under-exposed.
	 * 0 means that the face is not under-exposed at all.
	 * Hint: The recommended value is under 50.
	 */
    int UnderExposure;
} id3FacePhotographicAttributes;

#ifdef __cplusplus
}
#endif

#endif
