//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FacePoolingMethod_h
#define _id3FacePoolingMethod_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the possible pooling methods for template agregration in the FaceTracker module.
 */
typedef enum id3FacePoolingMethod {
	/**
	 * Average pooling method. Merges instances (scores, templates, etc) into one.
	 */
	id3FacePoolingMethod_Average = 0,
	/**
	 * Maximum pooling method. Selects best instance according to a given metric.
	 */
	id3FacePoolingMethod_Maximum = 1,
} id3FacePoolingMethod;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetPoolingMethodString(int value);

#ifdef __cplusplus
}
#endif

#endif
