//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceSegmentationLabel_h
#define _id3FaceSegmentationLabel_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the face segmentation labels
 */
typedef enum id3FaceSegmentationLabel {
	/**
	 * Background label
	 */
	id3FaceSegmentationLabel_Background = 0,
	/**
	 * Cloth label
	 */
	id3FaceSegmentationLabel_Cloth = 1,
	/**
	 * Neck label
	 */
	id3FaceSegmentationLabel_Neck = 2,
	/**
	 * Skin label
	 */
	id3FaceSegmentationLabel_Skin = 3,
	/**
	 * Mouth label
	 */
	id3FaceSegmentationLabel_Mouth = 4,
	/**
	 * Lips label
	 */
	id3FaceSegmentationLabel_Lips = 5,
	/**
	 * Nose label
	 */
	id3FaceSegmentationLabel_Nose = 6,
	/**
	 * Ears label
	 */
	id3FaceSegmentationLabel_Ears = 7,
	/**
	 * Earring label
	 */
	id3FaceSegmentationLabel_Earring = 8,
	/**
	 * Necklace label
	 */
	id3FaceSegmentationLabel_Necklace = 9,
	/**
	 * Eyebrows label
	 */
	id3FaceSegmentationLabel_Eyebrows = 10,
	/**
	 * Hair label
	 */
	id3FaceSegmentationLabel_Hair = 11,
	/**
	 * Glasses label
	 */
	id3FaceSegmentationLabel_Glasses = 12,
	/**
	 * Eyes label
	 */
	id3FaceSegmentationLabel_Eyes = 13,
	/**
	 * Hat label
	 */
	id3FaceSegmentationLabel_Hat = 14,
} id3FaceSegmentationLabel;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetFaceSegmentationLabelString(int value);

#ifdef __cplusplus
}
#endif

#endif
