//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceTemplateFormat_h
#define _id3FaceTemplateFormat_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the face template formats.
 */
typedef enum id3FaceTemplateFormat {
	/**
	 * Undefined template format.
	 */
	id3FaceTemplateFormat_Undefined = 0x0000,
	/**
	 * Template generated with the FaceEncoder8A model.
	 */
	id3FaceTemplateFormat_V8A = 0x218A,
	/**
	 * Template generated with the FaceEncoder8B model.
	 */
	id3FaceTemplateFormat_V8B = 0x218B,
	/**
	 * Template generated with the FaceEncoder9A model.
	 */
	id3FaceTemplateFormat_V9A = 0x219A,
	/**
	 * Template generated with the FaceEncoder9B model.
	 */
	id3FaceTemplateFormat_V9B = 0x219B,
	/**
	 * Template generated with the FaceEncoder9C model.
	 */
	id3FaceTemplateFormat_V9C = 0x219C,
	/**
	 * Template generated with the FacePeriocularEncoder2A model.
	 */
	id3FaceTemplateFormat_PeriocularV2A = 0x222A,
	/**
	 * Template generated with the FacePeriocularEncoder2B model.
	 */
	id3FaceTemplateFormat_PeriocularV2B = 0x222B,
} id3FaceTemplateFormat;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetFaceTemplateFormatString(int value);

#ifdef __cplusplus
}
#endif

#endif
