//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceError_h
#define _id3FaceError_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the possible error codes returned by this SDK.
 */
typedef enum id3FaceError {
	/**
	 * No error.
	 */
	id3FaceError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3FaceError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3FaceError_ObjectDoesNotExist = -2,
	/**
	 * Base error code of the Face module.
	 */
	id3FaceError_Base = -1000,
	/**
	 * Minimum error code of the Face module.
	 */
	id3FaceError_Minimum = -1999,
	/**
	 * The handle is invalid.
	 */
	id3FaceError_InvalidHandle = -1001,
	/**
	 * The parameter is invalid.
	 */
	id3FaceError_InvalidParameter = -1002,
	/**
	 * The image pixel format is invalid.
	 */
	id3FaceError_InvalidPixelFormat = -1004,
	/**
	 * The template format is invalid.
	 */
	id3FaceError_InvalidTemplateFormat = -1005,
	/**
	 * The computed landmarks are invalid and do not allow to process the desired information.
	 */
	id3FaceError_InvalidLandmarks = -1006,
	/**
	 * The computed interocular distance (IOD) is too small to allow to process the desired information.
	 */
	id3FaceError_IodTooSmall = -1007,
	/**
	 * The model could not be found in the given directory path.
	 */
	id3FaceError_InvalidModelPath = -1008,
	/**
	 * The input image size is invalid for this operation.
	 */
	id3FaceError_InvalidImageSize = -1010,
	/**
	 * The model which is required for this operation was not loaded.
	 */
	id3FaceError_UnloadedModel = -1020,
	/**
	 * The inference backend failed to infer, probably due to inconsistent input.
	 */
	id3FaceError_InferenceBackendError = -1040,
	/**
	 * The requested processing unit is not available in this build.
	 */
	id3FaceError_ProcessingUnitUnavailable = -1041,
	/**
	 * The face indexer object is already initialized.
	 */
	id3FaceError_IndexerAlreadyInitialized = -1050,
	/**
	 * The requested id already exists in the Face Indexer object.
	 */
	id3FaceError_IndexerIdAlreadyExists = -1051,
	/**
	 * The data of the template is corrupted and cannot be added to the Face Indexer object.
	 */
	id3FaceError_IndexerInvalidTemplateData = -1052,
	/**
	 * Maximum template number of the Face Indexer object has been reached.
	 */
	id3FaceError_IndexerFull = -1053,
	/**
	 * No template with this id has been found in the Face Indexer object.
	 */
	id3FaceError_IndexerIdNotFound = -1054,
	/**
	 * This index file is not valid and cannot be loaded.
	 */
	id3FaceError_IndexerInvalidIndexFile = -1055,
	/**
	 * This function is not implemented.
	 */
	id3FaceError_FunctionNotImplemented = -1056,
} id3FaceError;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetFaceErrorString(int value);
ID3FACE_C_API const char * ID3_CDECL id3Face_GetFaceErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
