//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceExpression_h
#define _id3FaceExpression_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the possible facial expressions.
 */
typedef enum id3FaceExpression {
	/**
	 * Unknown.
	 */
	id3FaceExpression_Unknown = 0,
	/**
	 * Angriness.
	 */
	id3FaceExpression_Angriness = 1,
	/**
	 * Disgust.
	 */
	id3FaceExpression_Disgust = 2,
	/**
	 * Fear.
	 */
	id3FaceExpression_Fear = 3,
	/**
	 * Happiness.
	 */
	id3FaceExpression_Happiness = 4,
	/**
	 * Neutrality.
	 */
	id3FaceExpression_Neutrality = 5,
	/**
	 * Sadness.
	 */
	id3FaceExpression_Sadness = 6,
	/**
	 * Surprise.
	 */
	id3FaceExpression_Surprise = 7,
} id3FaceExpression;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetFaceExpressionString(int value);

#ifdef __cplusplus
}
#endif

#endif
