//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceEyeGaze_h
#define _id3FaceEyeGaze_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the eye gaze.
 */
typedef struct id3FaceEyeGaze {
	/**
	 * Value indicating the gaze alongside the x-axis of the left eye in degrees.
	 * Values vary in the range [-90, +90].
	 * Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
	 */
    float LeftEyeXGaze;
	/**
	 * Value indicating the gaze alongside the y-axis of the left eye in degrees.
	 * Values vary in the range [-90, +90].
	 * Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
	 */
    float LeftEyeYGaze;
	/**
	 * Value indicating the gaze alongside the x-axis of the right eye in degrees.
	 * Values vary in the range [-90, +90].
	 * Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
	 */
    float RightEyeXGaze;
	/**
	 * Value indicating the gaze alongside the y-axis of the right eye in degrees.
	 * Values vary in the range [-90, +90].
	 * Hint: The maximum recommended value for an ICAO-compliant portrait is +/- 35 degrees.
	 */
    float RightEyeYGaze;
} id3FaceEyeGaze;

#ifdef __cplusplus
}
#endif

#endif
