//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceGlassesAttributes_h
#define _id3FaceGlassesAttributes_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents some glasses attributes.
 */
typedef struct id3FaceGlassesAttributes {
	/**
	 * Value indicating if the glasses frame is not on the eyes.
	 * 0 means that there is no occlusion of the eye by the frame.
	 * Hint: The recommended value is under 10.
	 */
    int FrameOnEye;
	/**
	 * Value, from 0 to 100, indicating if the glasses' frame is too heavy.
	 * 0 means that the frame is super thick.
	 * Hint: The recommended value is over 20.
	 */
    int HeavyFrame;
	/**
	 * Value, from 0 to 100, indicating if the glasses are tinted.
	 * 100 means that the glasses are completely transparent.
	 * Hint: The recommended value is over 25.
	 */
    int TintedGlasses;
} id3FaceGlassesAttributes;

#ifdef __cplusplus
}
#endif

#endif
