//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceLicenseError_h
#define _id3FaceLicenseError_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the error codes related to license management.
 */
typedef enum id3FaceLicenseError {
	/**
	 * No error.
	 */
	id3FaceLicenseError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3FaceLicenseError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3FaceLicenseError_ObjectDoesNotExist = -2,
	/**
	 * Base error code of the License module.
	 */
	id3FaceLicenseError_Base = -100,
	/**
	 * Minimum error code of the License module.
	 */
	id3FaceLicenseError_Minimum = -999,
	/**
	 * The handle is invalid.
	 */
	id3FaceLicenseError_InvalidHandle = -101,
	/**
	 * One of the parameters is incorrect.
	 */
	id3FaceLicenseError_InvalidParameter = -102,
	/**
	 * No license was found.
	 */
	id3FaceLicenseError_LicenseNotFound = -103,
	/**
	 * License is not valid or a required module is not licensed.
	 */
	id3FaceLicenseError_InvalidLicense = -104,
	/**
	 * The license has expired.
	 */
	id3FaceLicenseError_ExpiredLicense = -105,
	/**
	 * Installation code does not match hardware ID.
	 */
	id3FaceLicenseError_InvalidHardwareId = -106,
	/**
	 * The license is already fulfilled by another user (or computer).
	 */
	id3FaceLicenseError_AlreadyFulfilled = -107,
	/**
	 * A required module is not licensed or the usage limit has been reached.
	 */
	id3FaceLicenseError_ModuleError = -108,
	/**
	 * The license file cannot be accessed in write mode.
	 */
	id3FaceLicenseError_WriteError = -109,
	/**
	 * The number of available licenses has been reached. There isn't any available license remaining.
	 */
	id3FaceLicenseError_InsufficientLicenseCredits = -110,
	/**
	 * The serial is invalid.
	 */
	id3FaceLicenseError_InvalidSerial = -111,
	/**
	 * Invalid login or password.
	 */
	id3FaceLicenseError_InvalidCredentials = -112,
	/**
	 * The license is revoked or does not exist anymore.
	 */
	id3FaceLicenseError_RevokedLicense = -113,
	/**
	 * The license is blocked after a predefined period.
	 */
	id3FaceLicenseError_BlockedLicense = -114,
	/**
	 * The license server is currently unreachable.
	 */
	id3FaceLicenseError_UnreachableServer = -115,
	/**
	 * An unexpected error happened.
	 */
	id3FaceLicenseError_LicenseOtherError = -116,
	/**
	 * No license file was provided.
	 */
	id3FaceLicenseError_MissingFile = -117,
	/**
	 * This device is not compatible with id3 licensing system.
	 */
	id3FaceLicenseError_DeviceNotCompatible = -118,
} id3FaceLicenseError;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetLicenseErrorString(int value);
ID3FACE_C_API const char * ID3_CDECL id3Face_GetLicenseErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
