//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3FaceTrackingStatus_h
#define _id3FaceTrackingStatus_h

#include <id3Face/id3FaceExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the possible face-tracking statuses.
 */
typedef enum id3FaceTrackingStatus {
	/**
	 * No status.
	 */
	id3FaceTrackingStatus_None = 0,
	/**
	 * A face was detected and a track is initialized. Once the required number of consecutive detections will be reached (see MinimumTrackedFaceAge in FaceTracker), the track will move on to 'Confirmed' status.
	 */
	id3FaceTrackingStatus_Initialized = 1,
	/**
	 * The face was detected and tracked for the required number of consecutive frames, hence the track is confirmed.
	 */
	id3FaceTrackingStatus_Confirmed = 2,
	/**
	 * The face was missed for at least one frame. It can come back to 'Confirmed' if it is re-detected or move on to 'Deleted' if it keeps being missed for a given number of consecutive frames (see MinimumTrackedFaceAge in FaceTracker).
	 */
	id3FaceTrackingStatus_TemporaryLost = 3,
	/**
	 * The face was missed for too many frames, the track is over. Remark: this state is purely internal.
	 */
	id3FaceTrackingStatus_Deleted = 4,
} id3FaceTrackingStatus;

ID3FACE_C_API const char * ID3_CDECL id3Face_GetTrackingStatusString(int value);

#ifdef __cplusplus
}
#endif

#endif
